/* NVTV data_ch -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This is open software protected by the GPL. See GPL.txt for details.
 *
 * Data tables and setup routines for the Chrontel chip.
 */ 

#include <stddef.h>
#include "nv_type.h"
#include "data_ch.h"

/* -------- CH -------- NTSC -------- */

/* -------- 640x480 -------- */

NVChRegs ch_ntsc_large_a = { /* Mode 16: 640x480 1:1 NormalDot */
  dmr_ir  : 3,
  dmr_vs  : 1,
  dmr_sr  : 1,
  sav     : 154,  /* tvcc: 92  */
  hpr     : 26,   /* tvcc: 31  */
  vpr     : 0,    /* tvcc: 260 */
  pll_m   : 63,
  pll_n   : 110,
  fsci    : 623153737, /* NDC: 623156346 */
  pllcap  : 0,
  dacg    : 0,
  mode    : 16,
};

NVChRegs ch_ntsc_small_a = { /* Mode 17: 640x480 7:8 NormalDot */
  dmr_ir  : 3,
  dmr_vs  : 1,
  dmr_sr  : 2,
  sav     : 160,  /* tvcc: 92  */
  hpr     : 46,   /* tvcc: 47  */
  vpr     : 0,    /* tvcc: 245 */
  pll_m   : 63,
  pll_n   : 126,
  fsci    : 545259520, /* NDC: 545261803 */
  pllcap  : 0,
  dacg    : 0,
  mode    : 17,
};

NVChRegs ch_ntsc_tiny_a = { /* Mode 18: 640x480 5:6 NormalDot */
  dmr_ir  : 3,
  dmr_vs  : 1,
  dmr_sr  : 3,
  sav     : 170,
  hpr     : 54,
  vpr     : 0, 
  pll_m   : 89,
  pll_n   : 190,
  pllcap  : 0,
  dacg    : 0,
  fsci    : 508908885, /* 508911016 */
  mode    : 18,
};

NVCrtRegs ch_crt_ntsc_large_a = { 
  HDisplay    : 640,
  HSyncStart  : 664-8,
  HSyncEnd    : 736-8,
  HTotal      : 784, /* Mode 16 ch: 784 */
  VDisplay    : 480,
  VSyncStart  : 486,
  VSyncEnd    : 488,
  VTotal      : 525, /* Mode 16 ch: 525 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

NVCrtRegs ch_crt_ntsc_small_a = { 
  HDisplay    : 640,
  HSyncStart  : 664-8,
  HSyncEnd    : 736-8,
  HTotal      : 784, /* Mode 17 ch: 784 */
  VDisplay    : 480,
  VSyncStart  : 522,
  VSyncEnd    : 524,
  VTotal      : 600, /* Mode 17 ch: 600 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW | NV_MODE_MACROVIS_OFF,
  Flags	      : 0,
};

NVCrtRegs ch_crt_ntsc_tiny_a = { 
  HDisplay    : 640,
  HSyncStart  : 672-8,
  HSyncEnd    : 744-8,
  HTotal      : 800, /* Mode 18 ch: 800 */
  VDisplay    : 480,
  VSyncStart  : 538,
  VSyncEnd    : 540,
  VTotal      : 630, /* Mode 18 ch: 630 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

/* -------- 800x600 -------- */

NVChRegs ch_ntsc_huge_b = { /* Mode 22: 800x600 5:6 NormalDot */
  dmr_ir  : 4,
  dmr_vs  : 1,
  dmr_sr  : 3,
  sav     : 234,
  hpr     : 32,
  vpr     : 258, 
  pll_m   : 33,
  pll_n   : 94,
  pllcap  : 1,
  dacg    : 0,
  fsci    : 521957831,  /* NDC: 521960016 */
  mode    : 22,
};

NVChRegs ch_ntsc_large_b = { /* Mode 23: 800x600 3:4 NormalDot */
  dmr_ir  : 4,
  dmr_vs  : 1,
  dmr_sr  : 4,
  sav     : 208,  /* tvcc: 140 */
  hpr     : 47,   /* tvcc: 47  */
  vpr     : 0,    /* tvcc: 266 */
  pll_m   : 19,
  pll_n   : 62,
  pllcap  : 1,
  dacg    : 0,
  fsci    : 469762048, /* NDC: 469764015 */
  mode    : 23,
};

NVChRegs ch_ntsc_small_b = { /* Mode 24: 800x600 7:10 NormalDot */
  dmr_ir  : 4,
  dmr_vs  : 1,
  dmr_sr  : 5,
  sav     : 216,  /* tvcc: 140 */
  hpr     : 60,   /* tvcc: 61  */
  vpr     : 0,    /* tvcc: 257 */
  pll_m   : 89,
  pll_n   : 302,
  pllcap  : 0,
  dacg    : 0,
  fsci    : 428554851, /* NDC: 428556645 */
  mode    : 24,
};

NVCrtRegs ch_crt_ntsc_huge_b = { 
  HDisplay    : 800,
  HSyncStart  : 856-8,
  HSyncEnd    : 920-8,
  HTotal      : 1040, /* Mode 22 ch: 1040 */
  VDisplay    : 600,
  VSyncStart  : 600,
  VSyncEnd    : 602,
  VTotal      : 630,  /* Mode 22 ch: 630 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

NVCrtRegs ch_crt_ntsc_large_b = { 
  HDisplay    : 800,
  HSyncStart  : 880-8,
  HSyncEnd    : 968-8,
  HTotal      : 1040, /* Mode 23 ch: 1040 */
  VDisplay    : 600,
  VSyncStart  : 626,
  VSyncEnd    : 628,
  VTotal      : 700,  /* Mode 23 ch: 700 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

NVCrtRegs ch_crt_ntsc_small_b = { 
  HDisplay    : 800,
  HSyncStart  : 896-8,
  HSyncEnd    : 960-8,
  HTotal      : 1064, /* Mode 24 ch: 1064 */
  VDisplay    : 600,
  VSyncStart  : 652,
  VSyncEnd    : 654,
  VTotal      : 750,  /* Mode 24 ch: 750 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW | NV_MODE_MACROVIS_OFF,
  Flags	      : 0,
};

/* -------- 640x400 -------- */

NVChRegs ch_ntsc_large_c = { /* Mode 10: 640x400 5:4 NormalDot */
  dmr_ir  : 2,
  dmr_vs  : 1,
  dmr_sr  : 0,
  sav     : 150,
  hpr     : 90,
  vpr     : 0, 
  pll_m   : 63,
  pll_n   : 94,
  pllcap  : 1,
  dacg    : 0,
  fsci    : 646233505, /* NDC: 646236211 */
  mode    : 10,
};

NVChRegs ch_ntsc_small_c = { /* Mode 11: 640x400 1:1 NormalDot */
  dmr_ir  : 2,
  dmr_vs  : 1,
  dmr_sr  : 1,
  sav     : 194,
  hpr     : 53,
  vpr     : 0, 
  pll_m   : 11,
  pll_n   : 22,
  pllcap  : 1,
  dacg    : 0,
  fsci    : 516986804,  /* NDC: 516988968 */
  mode    : 11,
};

NVChRegs ch_ntsc_tiny_c = { /* Mode 12: 640x400 7:8 NormalDot */
  dmr_ir  : 2,
  dmr_vs  : 1,
  dmr_sr  : 3,
  sav     : 194,
  hpr     : 68,
  vpr     : 0, 
  pll_m   : 89,
  pll_n   : 190,
  pllcap  : 0,
  dacg    : 0,
  fsci    : 452363454,  /* NDC: 452365347 */
  mode    : 12,
};

NVCrtRegs ch_crt_ntsc_large_c = { /* FIXME: Doesn't work */
  HDisplay    : 640,
  HSyncStart  : 704-8,
  HSyncEnd    : 768-8,
  HTotal      : 840, /* Mode 10 ch: 840 */
  VDisplay    : 400,
  VSyncStart  : 410,
  VSyncEnd    : 411,
  VTotal      : 420, /* Mode 10 ch: 420 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

NVCrtRegs ch_crt_ntsc_small_c = { 
  HDisplay    : 640,
  HSyncStart  : 696-8,
  HSyncEnd    : 760-8,
  HTotal      : 840, /* Mode 11 ch: 840 */
  VDisplay    : 400,
  VSyncStart  : 444,
  VSyncEnd    : 446,
  VTotal      : 525, /* Mode 11 ch: 525 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW | NV_MODE_MACROVIS_OFF,
  Flags	      : 0,
};

NVCrtRegs ch_crt_ntsc_tiny_c = { 
  HDisplay    : 640,
  HSyncStart  : 696-8,
  HSyncEnd    : 768-8,
  HTotal      : 840, /* Mode 12 ch: 840 */
  VDisplay    : 400,
  VSyncStart  : 480,
  VSyncEnd    : 482,
  VTotal      : 600, /* Mode 12 ch: 600 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

/* -------- 720x400 -------- */

NVChRegs ch_ntsc_large_d = { /* Mode 6: 720x400 5:4 NormalDot */
  dmr_ir  : 1,
  dmr_vs  : 1,
  dmr_sr  : 0,
  sav     : 210,
  hpr     : 26,
  vpr     : 256, 
  pll_m   : 63,
  pll_n   : 106,
  pllcap  : 1,
  dacg    : 0,
  fsci    : 574429782, /* NDC: 574432187 */
  mode    : 6,
};

NVChRegs ch_ntsc_small_d = { /* Mode 7: 720x400 1:1 NormalDot */
  dmr_ir  : 1,
  dmr_vs  : 1,
  dmr_sr  : 1,
  sav     : 208,
  hpr     : 59,
  vpr     : 260, 
  pll_m   : 33,
  pll_n   : 70,
  pllcap  : 1,
  dacg    : 0,
  fsci    : 463962517, /* NDC: 463964459 */
  mode    : 7,
};

NVCrtRegs ch_crt_ntsc_large_d = { 
  HDisplay    : 720,
  HSyncStart  : 784-8,
  HSyncEnd    : 864-8,
  HTotal      : 945, /* Mode 6 ch: 945 */
  VDisplay    : 400,
  VSyncStart  : 404,
  VSyncEnd    : 405,
  VTotal      : 420, /* Mode 6 ch: 420 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW, /* FIXME: No Dualview yet */
  Flags	      : 0,
};

NVCrtRegs ch_crt_ntsc_small_d = { 
  HDisplay    : 720,
  HSyncStart  : 784-8,
  HSyncEnd    : 864-8,
  HTotal      : 936, /* Mode 7 ch: 936 */
  VDisplay    : 400,
  VSyncStart  : 450,
  VSyncEnd    : 452,
  VTotal      : 525, /* Mode 7 ch: 525 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

/* -------- 512x384 -------- */

NVChRegs ch_ntsc_large_e = { /* Mode 2: 512x384 5:4 NormalDot */
  dmr_ir  : 0,
  dmr_vs  : 1,
  dmr_sr  : 0,
  sav     : 240,
  hpr     : 27,
  vpr     : 256, 
  pll_m   : 89,
  pll_n   : 126,
  pllcap  : 1,
  dacg    : 0,
  fsci    : 763363328, /* NDC: 763366524 */
  mode    : 2,
};

NVChRegs ch_ntsc_small_e = { /* Mode 3: 512x384 1:1 NormalDot */
  dmr_ir  : 0,
  dmr_vs  : 1,
  dmr_sr  : 1,
  sav     : 226,
  hpr     : 47,
  vpr     : 0, 
  pll_m   : 63,
  pll_n   : 110,
  pllcap  : 0,
  dacg    : 0,
  fsci    : 623153737, /* NDC: 623156346 */
  mode    : 3,
};

NVCrtRegs ch_crt_ntsc_large_e = { 
  HDisplay    : 512,
  HSyncStart  : 616-8,
  HSyncEnd    : 688-8,
  HTotal      : 800, /* Mode 2 ch: 800 */
  VDisplay    : 384,
  VSyncStart  : 396,
  VSyncEnd    : 398,
  VTotal      : 420, /* Mode 2 ch: 420 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW, /* FIXME: No Dualview */
  Flags	      : 0,
};

NVCrtRegs ch_crt_ntsc_small_e = { 
  HDisplay    : 512,
  HSyncStart  : 608-8,
  HSyncEnd    : 672-8,
  HTotal      : 784, /* Mode 3 ch: 784 */
  VDisplay    : 384,
  VSyncStart  : 434,
  VSyncEnd    : 436,
  VTotal      : 525, /* Mode 3 ch: 525 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW | NV_MODE_MACROVIS_OFF, 
  Flags	      : 0,
};

/* -------- DVD convenience modes -------- */

/* For use with video scaler, 768x576 for 4:3, 800x450 for 16:9,
   if DVD is in 720x576. For 720x480, use 640x480 modes.

   Based on 800x600 NTSC Large (Mode 23)
*/

NVChRegs ch_ntsc_large_f = { /* Mode 23: 800x600 3:4 NormalDot */
  dmr_ir  : 4,
  dmr_vs  : 1,
  dmr_sr  : 4,
  sav     : 208,
  hpr     : 43,
  vpr     : 260,
  pll_m   : 19,
  pll_n   : 62,
  pllcap  : 1,
  dacg    : 0,
  fsci    : 469762048, /* NDC: 469764015 */
  mode    : 23,
};

NVChRegs ch_ntsc_large_g = { /* Mode 23: 800x600 3:4 NormalDot */
  dmr_ir  : 4,
  dmr_vs  : 1,
  dmr_sr  : 4,
  sav     : 208,
  hpr     : 45,
  vpr     : 262,
  pll_m   : 19,
  pll_n   : 62,
  pllcap  : 1,
  dacg    : 0,
  fsci    : 469762048, /* NDC: 469764015 */
  mode    : 23,
};

NVCrtRegs ch_crt_ntsc_large_f = { /* test */
  HDisplay    : 768,
  HSyncStart  : 856-8,
  HSyncEnd    : 952-8,
  HTotal      : 1040, /* Mode 23 ch: 1040 */
  VDisplay    : 576,
  VSyncStart  : 618,
  VSyncEnd    : 620,
  VTotal      : 700,  /* Mode 23 ch: 700 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

NVCrtRegs ch_crt_ntsc_large_g = { /* test */
  HDisplay    : 800,
  HSyncStart  : 880-8,
  HSyncEnd    : 968-8,
  HTotal      : 1040, /* Mode 23 ch: 1040 */
  VDisplay    : 450,
  VSyncStart  : 550,
  VSyncEnd    : 552,
  VTotal      : 700,  /* Mode 23 ch: 700 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

/* -------- 720x{576,480} DVD -------- */

/* Note: Not used yet, crt values not tested */

NVChRegs ch_ntsc_interl_dvd = { /* Mode 26: 720x480 IL NormalDot */
  dmr_ir  : 5,
  dmr_vs  : 1,
  dmr_sr  : 1,
  sav     : 142,
  hpr     : 60,
  vpr     : 0,
  pll_m   : 33,
  pll_n   : 31,
  pllcap  : 1,
  dacg    : 0,
  fsci    : 569408543, /* NDC: 569410927 */
  mode    : 26,
};
/* Note: Mode 26 must use 2X XClk. So need to program that. For
   CRT, need to use double hscan, and interlace. */

NVCrtRegs ch_crt_ntsc_interl_dvd = { 
  HDisplay    : 720,
  HSyncStart  : 752-8,
  HSyncEnd    : 768-8,
  HTotal      : 858, /* Mode 26 ch: 858 */
  VDisplay    : 480,
  VSyncStart  : 500,
  VSyncEnd    : 501,
  VTotal      : 525, /* Mode 26 ch: 525 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW, 
  Flags	      : 0,
};

/* -------- CH -------- PAL -------- */

/* -------- 640x480 -------- */

NVChRegs ch_pal_large_a = { /* Mode 13: 640x480 5:4 NormalDot */
  dmr_ir  : 3,
  dmr_vs  : 0,
  dmr_sr  : 0,
  sav     : 142, 
  hpr     : 37, 
  vpr     : 308, 
  pll_m   : 13,
  pll_n   : 20,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 806021060, 
  mode    : 13,
};

NVChRegs ch_pal_x_large_a = { /* Mode 13: Like above, with different FSCI */
  dmr_ir  : 3,
  dmr_vs  : 0,
  dmr_sr  : 0,
  sav     : 142, 
  hpr     : 37, 
  vpr     : 308, 
  pll_m   : 13,
  pll_n   : 20,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 806120400, /* PAL: 806021060, */
  mode    : 13,
};

NVChRegs ch_pal_small_a = { /* Mode 14: 640x480 1:1 NormalDot */
  dmr_ir  : 3,
  dmr_vs  : 0,
  dmr_sr  : 1,
  sav     : 110, /* tvcc: 100 */
  hpr     : 52,  /* tvcc: 53  */
  vpr     : 289, /* tvcc: 291 */
  pll_m   : 4,
  pll_n   : 9,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 644816848, 
  mode    : 14,
};

NVChRegs ch_pal_x_small_a = { /* Mode 14: Like above, with different FSCI */
  dmr_ir  : 3,
  dmr_vs  : 0,
  dmr_sr  : 1,
  sav     : 110, /* tvcc: 100 */
  hpr     : 52,  /* tvcc: 53  */
  vpr     : 289, /* tvcc: 291 */
  pll_m   : 4,
  pll_n   : 9,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 644862000, /* PAL: 644816848, */
  mode    : 14,
};

NVChRegs ch_pal_tiny_a = { /* Mode 15: 640x480 5:6 NormalDot */
  dmr_ir  : 3,
  dmr_vs  : 0,
  dmr_sr  : 3,
  sav     : 110, 
  hpr     : 78,  
  vpr     : 4, 
  pll_m   : 3,
  pll_n   : 9,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 537347373,
  mode    : 15,
};

NVChRegs ch_pal_x_tiny_a = { /* Mode 15: Like above, with different FSCI */
  dmr_ir  : 3,
  dmr_vs  : 0,
  dmr_sr  : 3,
  sav     : 110, 
  hpr     : 78,  
  vpr     : 4, 
  pll_m   : 3,
  pll_n   : 9,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 537430027, /* PAL: 537347373, */
  mode    : 15,
};

/* FIXME: crt_pal_large_a -- no dualview, not in tvcc either */

NVCrtRegs ch_crt_pal_large_a = { 
  HDisplay    : 640,
  HSyncStart  : 688-8,
  HSyncEnd    : 760-8,
  HTotal      : 760, /* Mode 13 ch: 840 */
  VDisplay    : 480,
  VSyncStart  : 532,
  VSyncEnd    : 534,
  VTotal      : 574, /* Mode 13 ch: 500 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

NVCrtRegs ch_crt_pal_small_a = { 
  HDisplay    : 640,
  HSyncStart  : 688-8,
  HSyncEnd    : 760-8,
  HTotal      : 760, /* Mode 14 ch: 840 */
  VDisplay    : 480,
  VSyncStart  : 532,
  VSyncEnd    : 534,
  VTotal      : 574, /* Mode 14 ch: 625 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW | NV_MODE_MACROVIS_OFF,
  Flags	      : 0,
};

NVCrtRegs ch_crt_pal_tiny_a = { 
  HDisplay    : 640,
  HSyncStart  : 688-8,
  HSyncEnd    : 760-8,
  HTotal      : 760, /* Mode 15 ch: 840 */
  VDisplay    : 480,
  VSyncStart  : 590,
  VSyncEnd    : 592,
  VTotal      : 750, /* Mode 15 ch: 750 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

/* -------- 800x600 -------- */

/* FIXME: large has significant distortion on right hand side */

NVChRegs ch_pal_large_b = { /* Mode 19: 800x600 1:1 NormalDot */
  dmr_ir  : 4,
  dmr_vs  : 0,
  dmr_sr  : 1,
  sav     : 176, /* tvcc: 122 */
  hpr     : 31,  /* tvcc: 33 */
  vpr     : 0,   /* tvcc: 308 */
  pll_m   : 313,
  pll_n   : 647,
  pllcap  : 0,
  dacg    : 1,
  fsci    : 645499916,
  mode    : 19,
};

NVChRegs ch_pal_x_large_b = { /* Mode 19: Like above, with different FSCI*/
  dmr_ir  : 4,
  dmr_vs  : 0,
  dmr_sr  : 1,
  sav     : 176, /* tvcc: 122 */
  hpr     : 31,  /* tvcc: 33 */
  vpr     : 0,   /* tvcc: 308 */
  pll_m   : 313,
  pll_n   : 647,
  pllcap  : 0,
  dacg    : 1,
  fsci    : 645527100, /* PAL: 645499916, */
  mode    : 19,
};

NVChRegs ch_pal_small_b = { /* Mode 20: 800x600 5:6 NormalDot */
  dmr_ir  : 4,
  dmr_vs  : 0,
  dmr_sr  : 3,
  sav     : 166, /* tvcc: 124 */
  hpr     : 60,  /* tvcc: 73 */
  vpr     : 0,   /* tvcc: 296 */
  pll_m   : 33,
  pll_n   : 86,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 528951320, 
  mode    : 20,
};

NVChRegs ch_pal_x_small_b = { /* Mode 20: Like above, with different FSCI */
  dmr_ir  : 4,
  dmr_vs  : 0,
  dmr_sr  : 3,
  sav     : 166, /* tvcc: 124 */
  hpr     : 60,  /* tvcc: 73 */
  vpr     : 0,   /* tvcc: 296 */
  pll_m   : 33,
  pll_n   : 86,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 529002000, /* PAL: 528951320, */
  mode    : 20,
};

NVChRegs ch_pal_tiny_b = { /* Mode 21: 800x600 3:4 NormalDot */
  dmr_ir  : 4,
  dmr_vs  : 0,
  dmr_sr  : 4,
  sav     : 90,
  hpr     : 70,
  vpr     : 0, 
  pll_m   : 103,
  pll_n   : 284,
  pllcap  : 0,
  dacg    : 1,
  fsci    : 488262757, /* can use 488265597 with CFRB=0 and ACIV=0 */
  mode    : 21,
};

NVChRegs ch_pal_x_tiny_b = { /* Mode 21: Like above, with different FSCI */
  dmr_ir  : 4,
  dmr_vs  : 0,
  dmr_sr  : 4,
  sav     : 90,
  hpr     : 70,
  vpr     : 0, 
  pll_m   : 103,
  pll_n   : 284,
  pllcap  : 0,
  dacg    : 1,
  fsci    : 488330000, /* PAL: 488262757, */
  mode    : 21,
};

/* Note: Mode 21 has 627 PAL lines instead of 625 */

NVCrtRegs ch_crt_pal_large_b = { 
  HDisplay    : 800,
  HSyncStart  : 808-8,
  HSyncEnd    : 872-8,
  HTotal      : 944, /* Mode 19 ch: 944 */
  VDisplay    : 600,
  VSyncStart  : 600,
  VSyncEnd    : 601,
  VTotal      : 635, /* Mode 19 ch: 625 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

NVCrtRegs ch_crt_pal_small_b = { 
  HDisplay    : 800,
  HSyncStart  : 824-8,
  HSyncEnd    : 888-8,
  HTotal      : 960, /* Mode 20 ch: 960 */
  VDisplay    : 600,
  VSyncStart  : 656,
  VSyncEnd    : 658,
  VTotal      : 750, /* Mode 20 ch: 750 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW | NV_MODE_MACROVIS_OFF,
  Flags	      : 0,
};

NVCrtRegs ch_crt_pal_tiny_b = { 
  HDisplay    : 800,
  HSyncStart  : 840-8,
  HSyncEnd    : 904-8,
  HTotal      : 936, /* Mode 21 ch: 936 */
  VDisplay    : 600,
  VSyncStart  : 709,
  VSyncEnd    : 711,
  VTotal      : 836, /* Mode 21 ch: 836 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

/* -------- 640x400 -------- */

NVChRegs ch_pal_small_c = { /* Mode 8: 640x400 5:4 NormalDot */
  dmr_ir  : 2,
  dmr_vs  : 0,
  dmr_sr  : 0,
  sav     : 226, 
  hpr     : 47,  
  vpr     : 0,   
  pll_m   : 61,
  pll_n   : 108,
  pllcap  : 0,
  dacg    : 1,
  fsci    : 677057690, 
  mode    : 8,
};

NVChRegs ch_pal_x_small_c = { /* Mode 8: Like above, with different FSCI */
  dmr_ir  : 2,
  dmr_vs  : 0,
  dmr_sr  : 0,
  sav     : 226, 
  hpr     : 47,  
  vpr     : 0,   
  pll_m   : 61,
  pll_n   : 108,
  pllcap  : 0,
  dacg    : 1,
  fsci    : 677157690, /* PAL: 677057690, */
  mode    : 8,
};

NVChRegs ch_pal_tiny_c = { /* Mode 9: 640x400 1:1 NormalDot */
  dmr_ir  : 2,
  dmr_vs  : 0,
  dmr_sr  : 1,
  sav     : 230,
  hpr     : 80,
  vpr     : 0, 
  pll_m   : 3,
  pll_n   : 9,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 537347373, 
  mode    : 9,
};

NVChRegs ch_pal_x_tiny_c = { /* Mode 9: Like above, with different FSCI */
  dmr_ir  : 2,
  dmr_vs  : 0,
  dmr_sr  : 1,
  sav     : 230,
  hpr     : 80,
  vpr     : 0, 
  pll_m   : 3,
  pll_n   : 9,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 537447373, /* PAL: 537347373, */
  mode    : 9,
};

NVCrtRegs ch_crt_pal_small_c = { 
  HDisplay    : 640,
  HSyncStart  : 824-8,
  HSyncEnd    : 888-8,
  HTotal      : 1000, /* Mode 8 ch: 1000 */
  VDisplay    : 400,
  VSyncStart  : 440,
  VSyncEnd    : 442,
  VTotal      : 500,  /* Mode 8 ch: 500 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW | NV_MODE_MACROVIS_OFF, 
                  /* FIXME: No Dual view yet */
  Flags	      : 0,
};

NVCrtRegs ch_crt_pal_tiny_c = { 
  HDisplay    : 640,
  HSyncStart  : 760-8,
  HSyncEnd    : 824-8,
  HTotal      : 936, /* Mode 9 ch: 1008 */
  VDisplay    : 400,
  VSyncStart  : 496,
  VSyncEnd    : 498,
  VTotal      : 625, /* Mode 9 ch: 625 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW, 
  Flags	      : 0,
};

/* -------- 720x400 -------- */

NVChRegs ch_pal_small_d = { /* Mode 4: 720x400 5:4 NormalDot */
  dmr_ir  : 1,
  dmr_vs  : 0,
  dmr_sr  : 0,
  sav     : 346, 
  hpr     : 53,  
  vpr     : 0,   
  pll_m   : 26,
  pll_n   : 53,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 601829058, 
  mode    : 4,
};

NVChRegs ch_pal_x_small_d = { /* Mode 4: Like above, with different FSCI */
  dmr_ir  : 1,
  dmr_vs  : 0,
  dmr_sr  : 0,
  sav     : 346, 
  hpr     : 53,  
  vpr     : 0,   
  pll_m   : 26,
  pll_n   : 53,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 601879058, /* PAL: 601829058, */
  mode    : 4,
};

NVChRegs ch_pal_tiny_d = { /* Mode 5: 720x400 1:1 NormalDot */
  dmr_ir  : 1,
  dmr_vs  : 0,
  dmr_sr  : 1,
  sav     : 322,
  hpr     : 86,
  vpr     : 0, 
  pll_m   : 138,
  pll_n   : 339,
  pllcap  : 0,
  dacg    : 1,
  fsci    : 485346014, 
  mode    : 5,
};

NVChRegs ch_pal_x_tiny_d = { /* Mode 5: Like above, with different FSCI */
  dmr_ir  : 1,
  dmr_vs  : 0,
  dmr_sr  : 1,
  sav     : 322,
  hpr     : 86,
  vpr     : 0, 
  pll_m   : 138,
  pll_n   : 339,
  pllcap  : 0,
  dacg    : 1,
  fsci    : 485446014, /* PAL: 485346014, */
  mode    : 5,
};

NVCrtRegs ch_crt_pal_small_d = { 
  HDisplay    : 720,
  HSyncStart  : 824-8,
  HSyncEnd    : 888-8,
  HTotal      : 1125, /* Mode 4 ch: 1125 */
  VDisplay    : 400,
  VSyncStart  : 437,
  VSyncEnd    : 439,
  VTotal      : 500,  /* Mode 4 ch: 500 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW, /* FIXME: No Dualview yet */
  Flags	      : 0,
};

NVCrtRegs ch_crt_pal_tiny_d = { 
  HDisplay    : 720,
  HSyncStart  : 840-8,
  HSyncEnd    : 904-8,
  HTotal      : 1116, /* Mode 5 ch: 1116 */
  VDisplay    : 400,
  VSyncStart  : 498,
  VSyncEnd    : 500,
  VTotal      : 625,  /* Mode 5 ch: 625 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

/* -------- 512x384 -------- */

NVChRegs ch_pal_small_e = { /* Mode 0: 512x384 5:4 NormalDot */
  dmr_ir  : 0,
  dmr_vs  : 0,
  dmr_sr  : 0,
  sav     : 256,
  hpr     : 43,
  vpr     : 0,
  pll_m   : 13,
  pll_n   : 20,
  pllcap  : 1,
  dacg    : 1, 
  fsci    : 806021060, 
  mode    : 0,
};

NVChRegs ch_pal_x_small_e = { /* Mode 0: Like above, with different FSCI */
  dmr_ir  : 0,
  dmr_vs  : 0,
  dmr_sr  : 0,
  sav     : 256,
  hpr     : 43,
  vpr     : 0,
  pll_m   : 13,
  pll_n   : 20,
  pllcap  : 1,
  dacg    : 1, 
  fsci    : 806121060, /* PAL: 806021060, */
  mode    : 0,
};

NVChRegs ch_pal_tiny_e = { /* Mode 1: 512x384 1:1 NormalDot */
  dmr_ir  : 0,
  dmr_vs  : 0,
  dmr_sr  : 1,
  sav     : 266,
  hpr     : 69,
  vpr     : 0,
  pll_m   : 4,
  pll_n   : 9,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 644816848,
  mode    : 1,
};

NVChRegs ch_pal_x_tiny_e = { /* Mode 1: Like above, with different FSCI */
  dmr_ir  : 0,
  dmr_vs  : 0,
  dmr_sr  : 1,
  sav     : 266,
  hpr     : 69,
  vpr     : 0,
  pll_m   : 4,
  pll_n   : 9,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 644916848, /* PAL: 644816848, */
  mode    : 1,
};

NVCrtRegs ch_crt_pal_small_e = { 
  HDisplay    : 512,
  HSyncStart  : 640-8,
  HSyncEnd    : 704-8,
  HTotal      : 840,  /* Mode 0 ch: 840 */
  VDisplay    : 384,
  VSyncStart  : 428,
  VSyncEnd    : 430,
  VTotal      : 500,  /* Mode 0 ch: 500 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW | NV_MODE_MACROVIS_OFF, 
  Flags	      : 0,
};

NVCrtRegs ch_crt_pal_tiny_e = { 
  HDisplay    : 512,
  HSyncStart  : 624-8,
  HSyncEnd    : 704-8,
  HTotal      : 840,  /* Mode 1 ch: 840 */
  VDisplay    : 384,
  VSyncStart  : 498,
  VSyncEnd    : 500,
  VTotal      : 625,  /* Mode 1 ch: 625 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

/* -------- DVD convenience modes -------- */

/* For use with video scaler, 768x576 for 4:3, 800x450 for 16:9,
   if DVD is in 720x576. For 720x480, use 640x480 modes.

   Based on 800x600 PAL Large (Mode 19) and Small (Mode 20), as
   the large mode is buggy (color flickers).
*/

NVChRegs ch_pal_large_f = { /* Mode 19: 800x600 1:1 NormalDot */
  dmr_ir  : 4,
  dmr_vs  : 0,
  dmr_sr  : 1,
  sav     : 176,
  hpr     : 34,
  vpr     : 311,
  pll_m   : 313,
  pll_n   : 647,
  pllcap  : 0,
  dacg    : 1,
  fsci    : 645499916,
  mode    : 19,
};

NVChRegs ch_pal_large_g = { /* Mode 19: 800x600 1:1 NormalDot */
  dmr_ir  : 4,
  dmr_vs  : 0,
  dmr_sr  : 1,
  sav     : 176,
  hpr     : 31,
  vpr     : 312,
  pll_m   : 313,
  pll_n   : 647,
  pllcap  : 0,
  dacg    : 1,
  fsci    : 645499916,
  mode    : 19,
};

NVCrtRegs ch_crt_pal_large_f = { /* test FIXME: SyncStart ok ?? */
  HDisplay    : 768,
  HSyncStart  : 800-8,
  HSyncEnd    : 872-8,
  HTotal      : 944, /* Mode 19 ch: 944 */
  VDisplay    : 576,
  VSyncStart  : 592,
  VSyncEnd    : 594,
  VTotal      : 635, /* Mode 19 ch: 625 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

NVCrtRegs ch_crt_pal_large_g = { /* test */
  HDisplay    : 800,
  HSyncStart  : 808-8,
  HSyncEnd    : 872-8,
  HTotal      : 944, /* Mode 19 ch: 944 */
  VDisplay    : 450,
  VSyncStart  : 530,
  VSyncEnd    : 532,
  VTotal      : 635, /* Mode 19 ch: 625 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

NVChRegs ch_pal_small_f = { /* Mode 20: 800x600 5:6 NormalDot */
  dmr_ir  : 4,
  dmr_vs  : 0,
  dmr_sr  : 3,
  sav     : 210, 
  hpr     : 68,  
  vpr     : 312,
  pll_m   : 33,
  pll_n   : 86,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 528951320, 
  mode    : 20,
};

NVChRegs ch_pal_small_g = { /* Mode 20: 800x600 5:6 NormalDot */
  dmr_ir  : 4,
  dmr_vs  : 0,
  dmr_sr  : 3,
  sav     : 188, 
  hpr     : 64,  
  vpr     : 312,
  pll_m   : 33,
  pll_n   : 86,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 528951320, 
  mode    : 20,
};

NVCrtRegs ch_crt_pal_small_f = { /* test */
  HDisplay    : 768,
  HSyncStart  : 808-8,
  HSyncEnd    : 880-8,
  HTotal      : 960, /* Mode 20 ch: 960 */
  VDisplay    : 576,
  VSyncStart  : 642,
  VSyncEnd    : 644,
  VTotal      : 750, /* Mode 20 ch: 750 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW | NV_MODE_MACROVIS_OFF,
  Flags	      : 0,
};

NVCrtRegs ch_crt_pal_small_g = { /* test */
  HDisplay    : 800,
  HSyncStart  : 824-8,
  HSyncEnd    : 888-8,
  HTotal      : 960, /* Mode 20 ch: 960 */
  VDisplay    : 450,
  VSyncStart  : 582,
  VSyncEnd    : 584,
  VTotal      : 750, /* Mode 20 ch: 750 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW | NV_MODE_MACROVIS_OFF,
  Flags	      : 0,
};

/* -------- 720x{576,480} DVD -------- */

NVChRegs ch_pal_interl_dvd = { /* Mode 25: 720x576 IL NormalDot */
  dmr_ir  : 5,
  dmr_vs  : 0,
  dmr_sr  : 1,
  sav     : 142,
  hpr     : 60,
  vpr     : 0,
  pll_m   : 33,
  pll_n   : 31,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 705268427,
  mode    : 25,
};
/* Note: Mode 25 must use 2X XClk. So need to program that. For
   CRT, need to use double hscan, and interlace. */

NVCrtRegs ch_crt_pal_interl_dvd = { 
  HDisplay    : 720,
  HSyncStart  : 752-8,
  HSyncEnd    : 768-8,
  HTotal      : 864, /* Mode 25 ch: 864 */
  VDisplay    : 576,
  VSyncStart  : 600,
  VSyncEnd    : 602,
  VTotal      : 625, /* Mode 25 ch: 625 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW, 
  Flags	      : 0,
};

/* -------- Notes -------- NV DVD Modes -------- */

/* Not used, crtc values not adjusted */

#if 0
NVChRegs ch_ntsc_normal_dvd = { /* NV Mode: 720x480 (Mode 24: 800x600) */
  dmr_ir  : 4,
  dmr_vs  : 1,
  dmr_sr  : 5,
  sav     : 142,
  hpr     : 60,
  vpr     : 0, 
  pll_m   : 89,
  pll_n   : 302,
  pllcap  : 0,
  dacg    : 0,
  fsci    : 428554851,  /* NDC: 428556645 */
  mode    : 100,
};

NVChRegs ch_ntsc_altern_dvd = { /* NV Mode: 720x576 (Mode 22: 800x600) */
  dmr_ir  : 4,
  dmr_vs  : 1,
  dmr_sr  : 3,
  sav     : 124,
  hpr     : 41,
  vpr     : 244, 
  pll_m   : 33,
  pll_n   : 94,
  pllcap  : 0,
  dacg    : 0,
  fsci    : 521957831, /* NDC: 521960016 */
  mode    : 101,
};

NVCrtRegs ch_crt_ntsc_normal_dvd = { 
  HDisplay    : 720,
  HSyncStart  : 864-8,
  HSyncEnd    : 928-8,
  HTotal      : 1064, /* Mode 24 ch: 1064 */
  VDisplay    : 480,
  VSyncStart  : 600,
  VSyncEnd    : 602,
  VTotal      : 750,  /* Mode 24 ch: 750 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW, 
  Flags	      : 0,
};

NVCrtRegs ch_crt_ntsc_altern_dvd = { /* FIXME: SyncStart ok ?? */ 
  HDisplay    : 720,
  HSyncStart  : 800-8,
  HSyncEnd    : 864-8,
  HTotal      : 1040, /* Mode 22 ch: 1040 */
  VDisplay    : 576,
  VSyncStart  : 600,
  VSyncEnd    : 602,
  VTotal      : 630,  /* Mode 22 ch: 630 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW, 
  Flags	      : 0,
};

NVChRegs ch_pal_normal_dvd = { /* NV Mode: 720x576 (Mode 19: 800x600) */
  dmr_ir  : 4,
  dmr_vs  : 0,
  dmr_sr  : 1,
  sav     : 132,
  hpr     : 45,
  vpr     : 0, 
  pll_m   : 313,
  pll_n   : 647,
  pllcap  : 0,
  dacg    : 1,
  fsci    : 645499916, 
  mode    : 19,
};

NVChRegs ch_pal_altern_dvd = { /* NV Mode: 720x480 (Mode 20: 800x600) */
  dmr_ir  : 4,
  dmr_vs  : 0,
  dmr_sr  : 3,
  sav     : 126,
  hpr     : 65,
  vpr     : 0, 
  pll_m   : 33,
  pll_n   : 86,
  pllcap  : 1,
  dacg    : 1,
  fsci    : 528951320, 
  mode    : 20,
};

NVCrtRegs ch_crt_pal_normal_dvd = { 
  HDisplay    : 720,
  HSyncStart  : 864-8,
  HSyncEnd    : 928-8,
  HTotal      : 944, /* Mode 19 ch: 944 */
  VDisplay    : 576,
  VSyncStart  : 600,
  VSyncEnd    : 601,
  VTotal      : 625, /* Mode 19 ch: 625 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW, 
  Flags	      : 0,
};

NVCrtRegs ch_crt_pal_altern_dvd = { /* FIXME: SyncStart ok ?? */
  HDisplay    : 720,
  HSyncStart  : 800-8,
  HSyncEnd    : 864-8,
  HTotal      : 960,  /* Mode 20 ch: 960 */
  VDisplay    : 480,
  VSyncStart  : 650,
  VSyncEnd    : 652,
  VTotal      : 750,  /* Mode 20 ch: 750 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW, 
  Flags	      : 0,
};

#endif

/* -------- Notes -------- Test -------- */

#if 0
NVChRegs ch_pal_test = {  /* Mode 14: PAL 640x480 1:1 */
  dmr_ir  : 3,
  dmr_vs  : 0,
  dmr_sr  : 1,
  sav     : 110, 
  hpr     : 52, 
  vpr     : 0,   /* nv */
  pll_m   : 4,
  pll_n   : 9,
  pllcap  : 0,
  fsci    : 644816848, /* ? 545259520, */ /* PAL 644816848, */
  blr     : 105, 
  dacg    : 1,
};

NVCrtRegs ch_crt_pal_test = { 
  HDisplay    : 640,
  HSyncStart  : 688-8,
  HSyncEnd    : 760-8,
  HTotal      : 760, /* Mode14 ch: 840 */
  VDisplay    : 480,
  VSyncStart  : 485,
  VSyncEnd    : 492,
  VTotal      : 574, /* Mode14 ch: 625 */
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

NVChRegs ch_ntsc_test = {  /* Mode 17: NTSC 640x480 7:8 */
  dmr_ir  : 3,
  dmr_vs  : 1,
  dmr_sr  : 2,
  sav     : 0,
  hpr     : 0,
  vpr     : 0,
  pll_m   : 63,
  pll_n   : 126,
  pllcap  : 0,
  fsci    : 545259520,
  blr     : 127,
  dacg    : 0,
};

NVCrtRegs ch_crt_ntsc_test = { /* Chrontel 7007A NTSC */ 
  HDisplay    : 640,
  HSyncStart  : 648-8,
  HSyncEnd    : 792-8,
  HTotal      : 800,
  VDisplay    : 400,
  VSyncStart  : 407,
  VSyncEnd    : 442,
  VTotal      : 449,
  PrivFlags   : NV_MODE_TVMODE | NV_MODE_DUALVIEW,
  Flags	      : 0,
};

#endif

/* -------- All modes -------- */

/* No Dualview for:

PAL  640x400 T  Mode 9
PAL  720x400 T  Mode 5

NTSC 720x400 L  Mode 6
NTSC 512x384 L  Mode 2

*/

/* FIXME: Calculate correct voc and hoc values. At the moment, hoc = voc,
   and the voc values seem way off for some reason. */

NVMode ch_modes [] = {
  {TV_SYSTEM_PAL,  800, 600, "Tiny",  21.875, 21.875,   /* Mode 21 */
   &ch_crt_pal_tiny_b, (NVTvRegs *) &ch_pal_tiny_b},
  {TV_SYSTEM_PAL,  800, 600, "Small", 13.194, 13.194,   /* Mode 20 */
   &ch_crt_pal_small_b, (NVTvRegs *) &ch_pal_small_b},
  {TV_SYSTEM_PAL,  800, 600, "Large", -4.167, -4.167,   /* Mode 19 */
   &ch_crt_pal_large_b, (NVTvRegs *) &ch_pal_large_b},
  {TV_SYSTEM_PAL,  640, 480, "Tiny",  30.556, 30.556,   /* Mode 15 */
   &ch_crt_pal_tiny_a, (NVTvRegs *) &ch_pal_tiny_a},
  {TV_SYSTEM_PAL,  640, 480, "Small", 16.667, 16.667,   /* Mode 14 */
   &ch_crt_pal_small_a, (NVTvRegs *) &ch_pal_small_a},
  {TV_SYSTEM_PAL,  640, 480, "Large", -4.167, -4.167,   /* Mode 13 */
   &ch_crt_pal_large_a, (NVTvRegs *) &ch_pal_large_a}, 
  {TV_SYSTEM_PAL,  640, 400, "Tiny",  30.556, 30.556,   /* Mode 9 */
   &ch_crt_pal_tiny_c, (NVTvRegs *) &ch_pal_tiny_c}, 
  {TV_SYSTEM_PAL,  640, 400, "Small", 13.194, 13.194,   /* Mode 8 */
   &ch_crt_pal_small_c, (NVTvRegs *) &ch_pal_small_c},
  {TV_SYSTEM_PAL,  720, 400, "Tiny",  30.556, 30.556,   /* Mode 5 */
   &ch_crt_pal_tiny_d, (NVTvRegs *) &ch_pal_tiny_d}, 
  {TV_SYSTEM_PAL,  720, 400, "Small", 13.194, 13.194,   /* Mode 4 */
   &ch_crt_pal_small_d, (NVTvRegs *) &ch_pal_small_d},
  {TV_SYSTEM_PAL,  512, 384, "Tiny",  33.333, 33.333,   /* Mode 1 */
   &ch_crt_pal_tiny_e, (NVTvRegs *) &ch_pal_tiny_e}, 
  {TV_SYSTEM_PAL,  512, 384, "Small", 16.667, 16.667,   /* Mode 0 */
   &ch_crt_pal_small_e, (NVTvRegs *) &ch_pal_small_e},

  {TV_SYSTEM_PAL,  768, 576, "Small", 0.000,  0.000,    /* Mode 20' */
   &ch_crt_pal_small_f, (NVTvRegs *) &ch_pal_small_f},
  {TV_SYSTEM_PAL,  768, 576, "Large", 0.000,  0.000,    /* Mode 19' */
   &ch_crt_pal_large_f, (NVTvRegs *) &ch_pal_large_f},
  {TV_SYSTEM_PAL,  800, 450, "Small", 0.000,  0.000,    /* Mode 20" */
   &ch_crt_pal_small_g, (NVTvRegs *) &ch_pal_small_g},
  {TV_SYSTEM_PAL,  800, 450, "Large", 0.000,  0.000,    /* Mode 19" */
   &ch_crt_pal_large_g, (NVTvRegs *) &ch_pal_large_g},

#if 0 /* not yet supported */
  {TV_SYSTEM_PAL,  720, 576, "Interl", 0.000,  0.000,   /* Mode 25 */
   &ch_crt_pal_interl_dvd, (NVTvRegs *) &ch_pal_interl_dvd},
#endif

  /* Fake PAL System for corrected FSCI color carrier values */

  {TV_SYSTEM_PAL_X,  800, 600, "Tiny",  21.875, 21.875,   /* Mode 21 */
   &ch_crt_pal_tiny_b, (NVTvRegs *) &ch_pal_x_tiny_b},
  {TV_SYSTEM_PAL_X,  800, 600, "Small", 13.194, 13.194,   /* Mode 20 */
   &ch_crt_pal_small_b, (NVTvRegs *) &ch_pal_x_small_b},
  {TV_SYSTEM_PAL_X,  800, 600, "Large", -4.167, -4.167,   /* Mode 19 */
   &ch_crt_pal_large_b, (NVTvRegs *) &ch_pal_x_large_b},
  {TV_SYSTEM_PAL_X,  640, 480, "Tiny",  30.556, 30.556,   /* Mode 15 */
   &ch_crt_pal_tiny_a, (NVTvRegs *) &ch_pal_x_tiny_a},
  {TV_SYSTEM_PAL_X,  640, 480, "Small", 16.667, 16.667,   /* Mode 14 */
   &ch_crt_pal_small_a, (NVTvRegs *) &ch_pal_x_small_a},
  {TV_SYSTEM_PAL_X,  640, 480, "Large", -4.167, -4.167,   /* Mode 13 */
   &ch_crt_pal_large_a, (NVTvRegs *) &ch_pal_x_large_a}, 
  {TV_SYSTEM_PAL_X,  640, 400, "Tiny",  30.556, 30.556,   /* Mode 9 */
   &ch_crt_pal_tiny_c, (NVTvRegs *) &ch_pal_x_tiny_c}, 
  {TV_SYSTEM_PAL_X,  640, 400, "Small", 13.194, 13.194,   /* Mode 8 */
   &ch_crt_pal_small_c, (NVTvRegs *) &ch_pal_x_small_c},
  {TV_SYSTEM_PAL_X,  720, 400, "Tiny",  30.556, 30.556,   /* Mode 5 */
   &ch_crt_pal_tiny_d, (NVTvRegs *) &ch_pal_x_tiny_d}, 
  {TV_SYSTEM_PAL_X,  720, 400, "Small", 13.194, 13.194,   /* Mode 4 */
   &ch_crt_pal_small_d, (NVTvRegs *) &ch_pal_x_small_d},
  {TV_SYSTEM_PAL_X,  512, 384, "Tiny",  33.333, 33.333,   /* Mode 1 */
   &ch_crt_pal_tiny_e, (NVTvRegs *) &ch_pal_x_tiny_e}, 
  {TV_SYSTEM_PAL_X,  512, 384, "Small", 16.667, 16.667,   /* Mode 0 */
   &ch_crt_pal_small_e, (NVTvRegs *) &ch_pal_x_small_e},

  /* For the PAL-X convenience mode, FSCI is the same?? */
  {TV_SYSTEM_PAL_X,  768, 576, "Small", 0.000,  0.000,    /* Mode 20' */
   &ch_crt_pal_small_f, (NVTvRegs *) &ch_pal_small_f},
  {TV_SYSTEM_PAL_X,  768, 576, "Large", 0.000,  0.000,    /* Mode 19' */
   &ch_crt_pal_large_f, (NVTvRegs *) &ch_pal_large_f},
  {TV_SYSTEM_PAL_X,  800, 450, "Small", 0.000,  0.000,    /* Mode 20" */
   &ch_crt_pal_small_g, (NVTvRegs *) &ch_pal_small_g},
  {TV_SYSTEM_PAL_X,  800, 450, "Large", 0.000,  0.000,    /* Mode 19" */
   &ch_crt_pal_large_g, (NVTvRegs *) &ch_pal_large_g},

  {TV_SYSTEM_NTSC, 800, 600, "Small",12.500, 12.500,    /* Mode 24 */
   &ch_crt_ntsc_small_b, (NVTvRegs *) &ch_ntsc_small_b},
  {TV_SYSTEM_NTSC, 800, 600, "Large",  6.250,  6.250,   /* Mode 23 */
   &ch_crt_ntsc_large_b, (NVTvRegs *) &ch_ntsc_large_b},
  {TV_SYSTEM_NTSC, 800, 600, "Huge", -4.167, -4.167,    /* Mode 22 */
   &ch_crt_ntsc_huge_b, (NVTvRegs *) &ch_ntsc_huge_b},
  {TV_SYSTEM_NTSC, 640, 480, "Tiny", 16.667, 16.667,    /* Mode 18 */
   &ch_crt_ntsc_tiny_a, (NVTvRegs *) &ch_ntsc_tiny_a},
  {TV_SYSTEM_NTSC, 640, 480, "Small", 12.500, 12.500,   /* Mode 17 */
   &ch_crt_ntsc_small_a, (NVTvRegs *) &ch_ntsc_small_a},
  {TV_SYSTEM_NTSC, 640, 480, "Large",  0.000,  0.000,   /* Mode 16 */
   &ch_crt_ntsc_large_a, (NVTvRegs *) &ch_ntsc_large_a}, 
  {TV_SYSTEM_NTSC, 640, 400, "Tiny", 27.083, 27.083,    /* Mode 12 */
   &ch_crt_ntsc_tiny_c, (NVTvRegs *) &ch_ntsc_tiny_c},
  {TV_SYSTEM_NTSC, 640, 400, "Small", 16.667, 16.667,   /* Mode 11 */
   &ch_crt_ntsc_small_c, (NVTvRegs *) &ch_ntsc_small_c},
  {TV_SYSTEM_NTSC, 640, 400, "Large", -4.167, -4.167,   /* Mode 10 */
   &ch_crt_ntsc_large_c, (NVTvRegs *) &ch_ntsc_large_c},
  {TV_SYSTEM_NTSC, 720, 400, "Small", 16.667, 16.667,   /* Mode 7 */
   &ch_crt_ntsc_small_d, (NVTvRegs *) &ch_ntsc_small_d},
  {TV_SYSTEM_NTSC, 720, 400, "Large", -4.167, -4.167,   /* Mode 6 */
   &ch_crt_ntsc_large_d, (NVTvRegs *) &ch_ntsc_large_d},
  {TV_SYSTEM_NTSC, 512, 384, "Small", 20.000, 20.000,   /* Mode 3 */
   &ch_crt_ntsc_small_e, (NVTvRegs *) &ch_ntsc_small_e},
  {TV_SYSTEM_NTSC, 512, 384, "Large",  0.000,  0.000,   /* Mode 2 */
   &ch_crt_ntsc_large_e, (NVTvRegs *) &ch_ntsc_large_e},

  {TV_SYSTEM_NTSC,  768, 576, "Large", 0.000,  0.000,   /* Mode 23' */
   &ch_crt_ntsc_large_f, (NVTvRegs *) &ch_ntsc_large_f},
  {TV_SYSTEM_NTSC,  800, 450, "Large", 0.000,  0.000,   /* Mode 23" */
   &ch_crt_ntsc_large_g, (NVTvRegs *) &ch_ntsc_large_g},

#if 0 /* not yet supported, maybe never will */
  {TV_SYSTEM_NTSC,  720, 480, "Interl", 0.000,  0.000,  /* Mode 26 */
   &ch_crt_ntsc_interl_dvd, (NVTvRegs *) &ch_ntsc_interl_dvd},
#endif

  {TV_SYSTEM_NONE, 0, 0, NULL, 0.0, 0.0, NULL, NULL}
};

/* -------- -------- */

static int clamp_contrast[8]  = {25, 50, 75, 100, 125, 150, 175, 200};
static int clamp_flicker[5]   = {0, 25, 50, 75, 100};
static int clamp_sharpness[3] = {0, 50, 100};
static int clamp_bandwidth[8]   = {0, 50, 75, 100, 125, 150, 175, 200};

void data_init_ch (NVSystem system, NVTvRegs *r)
{
  r->ch.ffr_fc = 2;
  r->ch.ffr_fy = 1; 
  r->ch.ffr_ft = 2; 
  r->ch.vbw_flff = 0;
  r->ch.vbw_cvbw = 0;
  r->ch.vbw_cbw = 0;   /* low bandwidth */
  r->ch.vbw_ypeak = 0; /* disabled */
  r->ch.vbw_ysv = 0;   /* low bandwidth */
  r->ch.vbw_ycv = 0;    /* low bandwidth */
  r->ch.aciv = 0;      /* no auto civ */
  r->ch.civh = 0;      /* civ hysterisis mode = 0 */
  r->ch.ce = 3;        /* normal contrast */
  switch (system) {
    case TV_SYSTEM_NTSC: /* additional fsci values for NDC (no dot crawl) */
      r->ch.dmr_vs = 1;
      r->ch.dacg = 0;
      r->ch.blr = 127;
      break;
    case TV_SYSTEM_NTSC_J:
      r->ch.dmr_vs = 3;
      r->ch.dacg = 1;
      r->ch.blr = 100;
      break;
    case TV_SYSTEM_NONE: /* to have a default */
    case TV_SYSTEM_PAL:
    case TV_SYSTEM_PAL_X:
    case TV_SYSTEM_PAL_60: /* guess */
    case TV_SYSTEM_PAL_N:  /* guess */ /* PAL-N has different fsci values */
    case TV_SYSTEM_PAL_NC: /* guess */
      r->ch.dmr_vs = 0;
      r->ch.dacg = 1;
      r->ch.blr = 105;
      break;
    case TV_SYSTEM_PAL_M:   /* needs different fsci values */
    case TV_SYSTEM_PAL_M60: /* guess */
      r->ch.dmr_vs = 2;
      r->ch.dacg = 0;
      r->ch.blr = 127;
      break;
  }
  r->ch.flags = CH_FLAG_BOTH;
}

void data_default_ch (NVSettings *s)
{
  s->tv_hoffset = s->mon_hoffset = 0;
  s->tv_voffset = s->mon_voffset = 0;
  s->brightness = 100;
  s->color = 100;
  s->contrast = 100;
  s->saturation = 100;
  s->flicker = 75;
  s->bandwidth = 0;
  s->sharpness = 50;
  s->macrovision = 0;
  s->monochrome = 0;
}

void data_setup_ch (NVSettings *s, NVCrtRegs *c, NVTvRegs *r)
{
  float f;
  int vmax;

  /* FIXME: Pure monitor movement */
  c->VSyncStart -= s->mon_voffset;
  c->VSyncEnd   -= s->mon_voffset;
  c->HSyncStart -= s->mon_hoffset * 8;
  c->HSyncEnd   -= s->mon_hoffset * 8;
  if (r->ch.dmr_vs & 0x01) vmax = 262; else vmax = 312;
  r->ch.hpr += s->tv_hoffset;
  if (r->ch.hpr <   0) r->ch.hpr = 0;
  if (r->ch.hpr > 511) r->ch.hpr = 511;
  r->ch.vpr -= s->tv_voffset;
  while (r->ch.vpr <    0) r->ch.vpr += vmax;
  while (r->ch.vpr > vmax) r->ch.vpr -= vmax;
  f = 0.01 * s->brightness * r->ch.blr;
  if (f < 0.0) f = 0.0;
  if (f > 255.0) f = 255.0;
  r->ch.blr = (int) f;
  r->ch.ce = data_pick (s->contrast, 8, clamp_contrast); 
  switch (data_pick (s->flicker, 5, clamp_flicker)) {
    case 0: r->ch.ffr_fy = 0; r->ch.ffr_fc = 0; break;
    case 1: r->ch.ffr_fy = 1; r->ch.ffr_fc = 0; break;
    case 2: r->ch.ffr_fy = 1; r->ch.ffr_fc = 1; break;
    case 3: r->ch.ffr_fy = 2; r->ch.ffr_fc = 1; break;
    case 4: r->ch.ffr_fy = 2; r->ch.ffr_fc = 2; break;
  }
  switch (data_pick (s->bandwidth, 8, clamp_bandwidth)) {
    case 0: r->ch.vbw_ycv = 0; r->ch.vbw_ysv = 0; r->ch.vbw_ypeak = 0; 
            r->ch.vbw_cbw = 0; break;
    case 1: r->ch.vbw_ycv = 0; r->ch.vbw_ysv = 0; r->ch.vbw_ypeak = 0; 
            r->ch.vbw_cbw = 1; break;
    case 2: r->ch.vbw_ycv = 0; r->ch.vbw_ysv = 0; r->ch.vbw_ypeak = 0; 
            r->ch.vbw_cbw = 2; break;
    case 3: r->ch.vbw_ycv = 0; r->ch.vbw_ysv = 0; r->ch.vbw_ypeak = 0; 
            r->ch.vbw_cbw = 3; break;
    case 4: r->ch.vbw_ycv = 0; r->ch.vbw_ysv = 0; r->ch.vbw_ypeak = 1; 
            r->ch.vbw_cbw = 3; break;
    case 5: r->ch.vbw_ycv = 1; r->ch.vbw_ysv = 1; r->ch.vbw_ypeak = 0; 
            r->ch.vbw_cbw = 3; break;
    case 6: r->ch.vbw_ycv = 1; r->ch.vbw_ysv = 1; r->ch.vbw_ypeak = 1; 
            r->ch.vbw_cbw = 3; break;
    case 7: r->ch.vbw_ycv = 1; r->ch.vbw_ysv = 2; r->ch.vbw_ypeak = 0; 
            r->ch.vbw_cbw = 3; break;
  }
  /* FIXME Chroma dot crawl in fc */
  /* FIXME vbw_flff=1 for 5 line in 7/10 */
  r->ch.ffr_ft = 2 - data_pick (s->sharpness, 3, clamp_sharpness); 
  r->ch.vbw_cvbw = (s->monochrome) ? 1 : 0;
  r->ch.macro = (s->macrovision) ? 1 : 0;
  r->ch.flags &= ~CH_FLAG_DAC_MASK; 
  switch (s->connector) 
  {
    case CONNECT_FBAS: 
      r->ch.flags |= CH_FLAG_FBAS; 
      break;
    case CONNECT_CONVERT:
    case CONNECT_SVHS: 
      r->ch.flags |= CH_FLAG_SVHS;
      break;
    case CONNECT_BOTH: 
    default:
      r->ch.flags |= CH_FLAG_BOTH;
      break;
  }
}

void data_clamp_ch (NVSettings *s)
{
  if (s->tv_hoffset <= -100) s->tv_hoffset = -100;
  if (s->tv_hoffset >=  100) s->tv_hoffset =  100;
  if (s->tv_voffset <= -100) s->tv_voffset = -100;
  if (s->tv_voffset >=  100) s->tv_voffset =  100;
  if (s->mon_hoffset <= -100) s->mon_hoffset = -100;
  if (s->mon_hoffset >=  100) s->mon_hoffset =  100;
  if (s->mon_voffset <= -100) s->mon_voffset = -100;
  if (s->mon_voffset >=  100) s->mon_voffset =  100;
  if (s->brightness <   0) s->brightness = 0;
  if (s->brightness > 200) s->brightness = 200;
  s->color = 100;
  s->contrast   = data_clamp (s->contrast, 8, clamp_contrast); 
  s->saturation = 100;
  s->sharpness = data_clamp (s->sharpness, 3, clamp_sharpness); 
  s->flicker = data_clamp (s->flicker, 5, clamp_flicker); 
  s->bandwidth = data_clamp (s->bandwidth, 8, clamp_bandwidth); 
  /* FIXME: Operate on mode flags */
}

DataFunc ch_func = {
  modes: ch_modes,
  init: data_init_ch, 
  defaults: data_default_ch,
  setup: data_setup_ch, 
  clamp: data_clamp_ch
};

/* 

4:3 * 4:3 -> 16:9

 4/3 = 1.333
16/9 = 1.777

720 / 576 = 1.25 = 5/4    * 4/3 = 5/3 = 1.66
720 / 480 = 1.5  = 3/2    * 4/3 = 2   

 768 / 576 = 4:3 (800/600, use scaler)
1024 / 576 = 16:9 (only on monitor)
 720 / 540 = 4:3
 720 / 405 = 16:9 
 800 / 450 = 16:9 (800/600, use scaler)


800 / 600 = 1.33 = 4/3 
640 / 480 = 1.33 = 4/3 
640 / 400 = 1.6  = 8/5
720 / 400 = 1.8  = 9/5
512 / 384 = 1.33 = 4/3

Can display more lines by changing CRT, but the ___x400 modes have
wrong aspect.

So we have to change the aspect for those modes. Changing the PLL
coeff's doesn't work.

*/

/* Special FCSI values (different crystal?)

Resolution    Tiny;           Small;          Large;
	      		      	 	 
512x384  (1)  644916848  (0)  806121060	 
640x400  (9)  537447373  (8)  677157690	 
640x480  (15) 537430027  (14) 644862000  (13) 806120400
720x400  (5)  485446014  (4)  601879058	 	 
768x576                  (20) 529051320  (19) 645599916
800x450                  (20) 529051320  (19) 645599916
800x600  (21) 488330000  (20) 529002000  (19) 645527100

Differences:

PAL-X                                   n   m               MHz   kHz

13: 806120400/806021060: 1.000123247   20/ 13 = 1.466666  21.00 25.00
14: 644862000/644816848: 1.000070022    9/  4 = 1.833333  26.25 31.25
19: 645527100/645499916: 1.000042113  647/313 = 2.060317  29.50 31.25
20: 529002000/528951320: 1.000095812   86/ 33 = 2.514285  36.00 37.50

Is not linear...

*/
