/* NVTV debug -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This is open software protected by the GPL. See GPL.txt for details.
 *
 * Debug definitions.
 */

#ifndef _DEBUG_H
#define _DEBUG_H

/* -------- Debugging defines -------- */

/* Enable DPRINTF messages */
/* #define NVTV_DEBUG */

/* Disable timeout procs */
/* #define DISABLE_TIMEOUT */

/* Scan all unknown chips of no known tv chip is found (nv_tv.c) */
#define PROBE_ALL_UNKNOWN

/* Fake successful probing of all tv chips (nv_tv.c) */
/* #define FAKE_PROBE_ALL */

/* Fake successful probing of this addr on all busses (nv_tv.c) */
/* #define FAKE_PROBE_ADDR 0xEA */

/* Fake I2C Bus reads and writes (nv_tv.c) */
/* #define FAKE_I2C */

/* Fake CRTC register writes (nv_tv.c) */
/* #define FAKE_CRTC */

/* Fake NV mmapped register writes (nv_tv.c) */
/* #define FAKE_NV_REGS */

/* Fake Chrontel chip (Meta) */
/* #define FAKE_CHRONTEL */

/* Fake TV mode (Meta) */
/* #define FAKE_TV */

/* -------- */

#ifdef FAKE_CHRONTEL
#define FAKE_NV_REGS
#define FAKE_CRTC
#define FAKE_I2C
#define FAKE_PROBE_ADDR 0xEA
#endif

#ifdef FAKE_TV
#define FAKE_NV_REGS
#define FAKE_CRTC
#endif

#define ERROR(X...) fprintf(stderr, X)

/* Fake output */
#define FPRINTF(X...) fprintf(stderr, X)

#ifdef NVTV_DEBUG
#define DPRINTF(X...) fprintf(stderr, X)
#define NO_TIMEOUT
#else
#define DPRINTF(X...) /* */
#endif

#endif
