/* $Id: nws_daemon.h,v 1.3 2005/06/06 18:17:41 graziano Exp $ */

#ifndef NWS_DAEMON_H
#define NWS_DAEMON_H

#include "config_nws.h"

#include <stdio.h>

#include "register.h"

/**
 * Create a nws_daemon structure. #type# is the kind of NWS host we are
 * creating, and #exitFunction# is the function to call when exiting and
 * #switches# are the local switches (the one this daemon doesn't
 * recognize). 
 * Return the structure on success, NULL otherwise.
 */
int
InitializeDaemonStructure(	HostTypes type,
				const char *switches,
				int (*exitFunction)(void));

/** 
 * small function which returns the switches that getopt should get
 */
const char *
DaemonAllSwitches(int ind);
				
/**
 * These are the switches that nws_daemon recognizes (we use getopt). IN
 * brief they are
 * -e	error file
 * -l	log file
 * -i   write pid to file
 * -p   port to listen to
 * -P   password
 * -a   assume this address to be mine
 * -n   assume this name is mine
 * -v   set the verbosity level
 * -V   print version
 * -h	help
 * -N   use this nameserver
 * -M	use this memory
 */
#define DAEMON_SWITCHES "e:l:i:p:a:n:v:VN:M:h"

/**
 * This recognize the switch and set #state#. The idea is that the caller
 * has something like
 * 	while(c = getopt()) {
 * 		if (DaemonSwitch(c, state)) {
 * 			// we recognized the switch
 * 			continue;
 * 		}
 * 	}
 *
 * returns 1 if the switch has been recognized, 0 otherwise.
 */
int
DaemonSwitch(	int opt,
		const char *arg,
		int ind);

/**
 * Initialize the daemon (open the listening socket etc ...).
 * When #local# is 1, it means this is no really a NWS host
 * so a lot of steps are not taken (for example the registraion with
 * nameserver aren't enable etc ...). #check_ns# and #check_mem# checks
 * respectively the nameserver and/or memory and print error messages if
 * aren't reachable.
 * Returns 1 on success, 0 otherwise.
 */
int
InitializeDaemon(	short local,
			int check_ns,
			int check_mem,
			int ind);


/**
 * Print the usage help. #exe# is the name of the executable, and #name#
 * is the name of the service. It prints only for the switches it takes
 * care of: anything else will need to be added by the caller.
 */
void
DaemonUsage(	const char *exe,
		const char *name);
#endif

