(* ocamlgsl - OCaml interface to GSL                        *)
(* Copyright () 2002 - Olivier Andrieu                     *)
(* distributed under the terms of the GPL version 2         *)

open Gsl_vectmat

type symm_ws

external _symm_alloc : int -> symm_ws
    = "ml_gsl_eigen_symm_alloc"
external _symm_free : symm_ws -> unit
    = "ml_gsl_eigen_symm_free"

external _symm : mat -> vec -> symm_ws -> unit
    = "ml_gsl_eigen_symm"

val symm : 
  ?protect:bool ->
  [< `M of Gsl_matrix.matrix
   | `MF of Gsl_matrix_flat.matrix
   | `A of float array * int * int
   | `AA of float array array] ->
  Gsl_vector.vector

type symmv_ws
external _symmv_alloc_v : int -> symmv_ws
    = "ml_gsl_eigen_symmv_alloc"
external _symmv_free_v : symmv_ws -> unit
    = "ml_gsl_eigen_symmv_free"

external _symmv : mat -> vec -> mat -> symmv_ws -> unit
    = "ml_gsl_eigen_symmv"

val symmv : 
  ?protect:bool ->
  [< `M of Gsl_matrix.matrix
   | `MF of Gsl_matrix_flat.matrix
   | `A of float array * int * int
   | `AA of float array array] ->
  Gsl_vector.vector * Gsl_matrix.matrix


type sort =
  | VAL_ASC
  | VAL_DESC
  | ABS_ASC
  | ABS_DESC

external symmv_sort : Gsl_vector.vector * Gsl_matrix.matrix -> sort -> unit
    = "ml_gsl_eigen_symmv_sort"


type herm_ws

external _herm_alloc : int -> herm_ws
    = "ml_gsl_eigen_herm_alloc"
external _herm_free : herm_ws -> unit
    = "ml_gsl_eigen_herm_free"

external _herm : cmat -> vec -> herm_ws -> unit
    = "ml_gsl_eigen_herm"

val herm : 
  ?protect:bool ->
  [< `CM of Gsl_matrix_complex.matrix
   | `CMF of Gsl_matrix_complex_flat.matrix
   | `CA of Gsl_complex.complex_array * int * int ] -> 
  Gsl_vector.vector

type hermv_ws
external _hermv_alloc_v : int -> hermv_ws
    = "ml_gsl_eigen_hermv_alloc"
external _hermv_free_v : hermv_ws -> unit
    = "ml_gsl_eigen_hermv_free"

external _hermv : cmat -> vec -> cmat -> hermv_ws -> unit
    = "ml_gsl_eigen_hermv"

val hermv : 
  ?protect:bool ->
  [< `CM of Gsl_matrix_complex.matrix
   | `CMF of Gsl_matrix_complex_flat.matrix
   | `CA of Gsl_complex.complex_array * int * int ] -> 
  Gsl_vector.vector * Gsl_matrix_complex.matrix

external hermv_sort : 
  Gsl_vector.vector * Gsl_matrix_complex.matrix -> 
    sort -> unit
    = "ml_gsl_eigen_hermv_sort"

