eopen('demo3.eps');
eglobpar;                     % get access to global parameters
eWinGridVisible=1;
esavpar;    % save default parameter

%title
etext('Multi Plot',50,eWinHeight-15,8,0,1)

% set tics like Matlab
eAxesValueSpace=3;
eAxesTicLongLength=-1;
eAxesTicShortLength=0;

% simple plot
ePlotAreaPos=[20 150];
ePlotAreaHeight=50;
ePlotAreaWidth=50;
eYAxisWestLabelText='f(x)';
eXAxisSouthLabelText='x [rad]';
ePlotTitleDistance=10;
ePlotTitleText='Simple Plot (like MATLAB(R))';
xData=0:0.1:2*pi;
eplot(xData,sin(xData),'sine',0,[1 0 0]);
eplot(xData,cos(xData),'cosine',2,[0 0 1]);
eplot;

% polar plot
erespar; % set default parameter
eAxesColor=[1 0 1];
ePolarPlotAreaCenterPos=[135 200];
ePolarPlotAreaRadMin=10;
ePolarPlotAreaRadMax=25;
ePolarAxisRadValueVisible=0;
ePlotTitleDistance=15;
ePlotTitleText='Polar Plot';
xData=0:0.01:2*pi;
ePolarAxisRadScale=[0 0.3 1];
epolar(xData,cos(xData*7)*0.2,'cosine filled',-1,[1 1 0]);
epolar(xData,sin(xData*4),'sine',0,[1 0 0]);
epolar(xData,cos(xData*5),'cosine',2,[0 0 1],1);
epolar;

%  cross axes plot
erespar; % set default parameter
eAxesColor=[0 0.5 0.5];
ePlotAreaPos=[110 80];
ePlotAreaHeight=50;
ePlotAreaWidth=50;
ePlotTitleDistance=5;
ePlotTitleText='Cross Axes';
eAxesCrossOrigin=1;
edsymbol('arrow','spire.psd',0.2,0.3);
esymbol(ePlotAreaPos(1)+ePlotAreaWidth,...
        ePlotAreaPos(2)+ePlotAreaHeight/2,'arrow');
esymbol(ePlotAreaPos(1)+ePlotAreaWidth/2,...
        ePlotAreaPos(2)+ePlotAreaHeight,'arrow',1,1,90);
eaxes([-3.4 0 3.4],[-1.2 0 1.2]);
xData=-3.2:0.1:3.2;
eplot(xData,sin(xData),'',0,[1 0 0]);
eplot(xData,cos(xData),'',0,[0 0 1]);
eplot

% random image
erespar; % set default parameter
ePlotAreaPos=[20 50];
ePlotAreaHeight=50;
ePlotAreaWidth=50;
eYAxisWestLabelText='Rows of Matrix';
eXAxisSouthLabelText='Columns of Matrix';
eImageLegendPos=[0 -5];
ePlotTitleDistance=5;
ePlotTitleText='Random Image';
eXAxisNorthVisible=0;
eYAxisEastVisible=0;
matrix=rand(30,30);
eimagesc(matrix,ecolors(3),'e'); % print scaled image

% photo 
erespar; % set default parameter
ePlotAreaPos=[110 10];
ePlotAreaHeight=50;
ePlotAreaWidth=50;
ePlotTitleDistance=5;
ePlotTitleText='photo';
eImageLegendVisible=0;
%stdImage=eimage;  % print image
photo=eimage;  % print default image

% shadow photo 
erespar; % set default parameter
ePlotAreaPos=[80 10];
ePlotAreaHeight=25;
ePlotAreaWidth=25;
ePlotTitleDistance=5;
ePlotTitleText='shadow photo';
eshadoi(photo); % print shadow image

eclose;
eview;
