## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {@var{f} =} vtk_figure(@var{n})
## Creates a vtk figure window and returns its information in the octave
## structure variable @var{f}.  For figures that already exist, the
## figure structure for the specified figure number is returned.  To get
## the current figure, use @var{f} = vtk_figure(0).
## @end deftypefn
## @seealso{vtk_close}

## Author: Dragan Tubic


function f = vtk_figure( arg1 )
  static vtk_figures;
  static vtk_active_figure = -1;
  
  vtk_init;
  
  if ( exist( "vtk_figures" ) )
    no_figures = length( vtk_figures );
  else
    no_figures = 0;
  end
  
	no_args = nargin;
	
	% Not really a good way to do this but...
	% close figure using pointer to window
	if ( strcmp( typeinfo( arg1 ), 'matrix') )
		fig_no = 0;
		ptr = abs( arg1(1) );
		for i = 1:no_figures
			if ( strcmp( typeinfo( vtk_figures(i).window ), 'vtk_object') )
				ptr2 = vtk_get_pointer( vtk_figures(i).window );
				if ( ptr == ptr2 )
					fig_no = -i; 
					break;
				end
			end
		end
		if ( fig_no == 0 )
			return;
		end
	else
		fig_no = arg1;
	end

  new_figure = 0;
  %% Check if we already have this figure
  if ( no_args == 1 )
    %% the argument has to be greater or equal to one
    if ( fig_no < 0 )
      if ( no_figures < abs(fig_no) )
	error('figure does not exist');
	return;
      end
      %% here we delete the figure
      fig = abs(fig_no);
      if ( ~strcmp( typeinfo( vtk_figures(fig).renderer ), 'vtk_object') )
         error('Figure does not exist.');
         return;
      end
      vtk_figures(fig).renderer = 0;
      vtk_figures(fig).window.Finalize();
      vtk_figures(fig).window = 0;
      vtk_figures(fig).interactor = 0;
      vtk_figures(fig).outline = 0;
      vtk_figures(fig).outline_actor = 0;
      vtk_figures(fig).axes = 0;
      vtk_figures(fig).axes_on = 1;
      vtk_figures(fig);
    end
    if ( fig_no == 0 )
      %% return active figure or create one
      if ( no_figures == 0 )
	%% if there is no figures, make it number one
	new_figure = 1;
      else
	if ( ~strcmp( typeinfo( vtk_figures(vtk_active_figure).renderer ), 'vtk_object') )
	  %% If it is an erased figure, remake it
	  new_figure = vtk_active_figure;
	else
	  %% The figure is there all right
	  f = vtk_figures(vtk_active_figure);
	  return;
	end			
      end				
    end
    if ( fig_no > 0 )
      if ( no_figures < fig_no )
	%% create a new figure with number fig_no
	%%disp('figure does not exist, will create one');
	new_figure = fig_no;
      else
	if ( ~strcmp( typeinfo( vtk_figures(fig_no).renderer ), 'vtk_object') )
	  %% disp('figure in array but does not exist, will create it');
	  new_figure = fig_no;
	else
	  %% disp('there is such a figure, will make it active');
	  vtk_active_figure = fig_no;
	  f = vtk_figures(vtk_active_figure);
	  return;
	end
      end	
    end
  end
  %% if no arguments are given create a figure
  if ( no_args == 0 )
    %% disp('No arguments, make next figure');
    if ( no_figures == 0 )
      %% if there is no figures, make it number one
      new_figure = 1;
    else
      %% Check if there is unoccupied space in array
      for i = 1:no_figures
	if ( ~strcmp( typeinfo( vtk_figures(fig_no).renderer ), 'vtk_object') )
	  new_figure = i;
	  break;
	end
      end
    end
    if ( new_figure == 0 )
      %% There is no space in the array, append new figure
      new_figure = no_figures + 1;
    end
  end
  
  if ( new_figure > 0 )
    %%disp(strcat('creating new figure: ',int2str(new_figure)));
    
    renderer = vtkRenderer;
    
    %% Make the bounding box
    outline = vtkOutlineSource;
    outline_mapper = vtkPolyDataMapper;
    outline_mapper.SetInput( outline.GetOutput() );
    outline_actor = vtkActor;
    outline_actor.SetMapper(outline_mapper);
    outline_actor.VisibilityOn();
    renderer.AddActor(outline_actor);
    
    %% Make axes
    tprop = vtkTextProperty("New");
    tprop.SetColor(1, 1, 1);
    tprop.ShadowOn();
    
    axes = vtkCubeAxesActor2D;
    axes.SetCamera(renderer.GetActiveCamera());
    axes.SetLabelFormat("%4.2g");
    axes.SetFlyModeToOuterEdges();
    axes.SetFontFactor(1.0);
    axes.SetNumberOfLabels(5);
    axes.SetAxisTitleTextProperty(tprop);
    axes.SetAxisLabelTextProperty(tprop);
    axes.SetProp( outline_actor );
    renderer.AddProp(axes);
    
    ren_win = vtkRenderWindow;
    ren_win.AddRenderer(renderer);
    iren = vtkXRenderWindowInteractor;
    iren.SetRenderWindow(ren_win);
    vtkInitializeInteractor(iren);
    
    ## my display preferences; JJS 9/25/04
    ## certainly could create functions later to allow users to easily change them
    renderer.SetBackground( 0.4, 0.4, 0.4 );
    axes.SetFontFactor(1.2);
    ren_win.SetSize(400,400);
    iren.SetInteractorStyle(vtkInteractorStyleTrackballCamera());
    
    vtk_figures(new_figure).renderer = renderer;
    vtk_figures(new_figure).window = ren_win;
    vtk_figures(new_figure).interactor = iren;
    vtk_figures(new_figure).outline = outline;
    vtk_figures(new_figure).outline_actor = outline_actor;
    vtk_figures(new_figure).axes = axes;
    vtk_figures(new_figure).axes_on = 1;
    
    vtk_active_figure = new_figure;
    f = vtk_figures(new_figure);
  end
  
  vtk_figures;
endfunction
