## Copyright (C) 2004  Dragan Tubic
## 
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2, or (at your option)
## any later version.
## 
## This program is distributed in the hope that it will be useful, but
## WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
## General Public License for more details. 
## 
## You should have received a copy of the GNU General Public License
## along with this file.  If not, write to the Free Software Foundation,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

## -*- texinfo -*-
## @deftypefn {Function File} {} vtk_title(@var{string})
## Adds a title to a vtk figure.
## @end deftypefn
## @seealso{vtk_scalarbar,vtk_clear}

## Author: Jonathan Stickel

function vtk_title(titlename)

  f=vtk_figure(0);
  
  ## clear existing title, if it exists
  ## assume there is no other "vtkTextActor" in the renderer
  nprops = f.renderer.GetProps().GetNumberOfItems();
  for i = 0:nprops-1;
    if ( f.renderer.GetProps().GetItemAsObject(i).IsA("vtkTextActor") )
      f.renderer.RemoveProp( f.renderer.GetProps().GetItemAsObject(i) );
      break
    endif
  endfor 
  
  textActor = vtkTextActor();
  textActor.ScaledTextOn();
  textActor.GetPositionCoordinate().SetCoordinateSystemToNormalizedViewport();
  textActor.GetPositionCoordinate().SetValue(0.25,0.90);
  textActor.SetHeight(0.05);
  textActor.SetInput( titlename );
  f.renderer.AddProp(textActor);

  vtk_update(f);

endfunction
