

%  This example shows how to extract a piece of a dataset using an
%  implicit function. In this case the implicit function is formed by
%  the boolean combination of two ellipsoids.

vtk_init;

%  Here we create two ellipsoidal implicit functions and boolean them
%  together tto form a "cross" shaped implicit function.
quadric = vtkQuadric();
quadric.SetCoefficients(.5, 1, .2, 0, .1, 0, 0, .2, 0, 0);
sample = vtkSampleFunction();
sample.SetSampleDimensions(50, 50, 50);
sample.SetImplicitFunction(quadric);
sample.ComputeNormalsOff();
trans = vtkTransform();
trans.Scale(1, .5, .333);
sphere = vtkSphere();
sphere.SetRadius(0.25);
sphere.SetTransform(trans);
trans2 = vtkTransform();
trans2.Scale(.25, .5, 1.0);
sphere2 = vtkSphere();
sphere2.SetRadius(0.25);
sphere2.SetTransform(trans2);
union = vtkImplicitBoolean();
union.AddFunction(sphere);
union.AddFunction(sphere2);
% union

%  Here is where it gets interesting. The implicit function is used to
%  extract those cells completely inside the function. They are then 
%  shrunk to help show what was extracted.
extract = vtkExtractGeometry();
extract.SetInput(sample.GetOutput());
extract.SetImplicitFunction(union);
shrink = vtkShrinkFilter();
shrink.SetInput(extract.GetOutput());
shrink.SetShrinkFactor(0.5);
dataMapper = vtkDataSetMapper();
dataMapper.SetInput(shrink.GetOutput());
dataActor = vtkActor();
dataActor.SetMapper(dataMapper);

%  The outline gives context to the original data.
outline = vtkOutlineFilter();
outline.SetInput(sample.GetOutput());
outlineMapper = vtkPolyDataMapper();
outlineMapper.SetInput(outline.GetOutput());
outlineActor = vtkActor();
outlineActor.SetMapper(outlineMapper);
outlineProp = outlineActor.GetProperty();
outlineProp.SetColor(0, 0, 0);

%  The usual rendering stuff is created.
ren = vtkRenderer();
renWin = vtkRenderWindow();
renWin.AddRenderer(ren);
iren = vtkRenderWindowInteractor();
iren.SetRenderWindow(renWin);

%  Add the actors to the renderer, set the background and size
ren.AddActor(outlineActor);
ren.AddActor(dataActor);
ren.SetBackground(1, 1, 1);
renWin.SetSize(500, 500);
ren.GetActiveCamera().Zoom(1.5);


% renWin.Render();
vtkInitializeInteractor(iren);
