#include "fileio.h"

#ifdef VTKSUPPORT

#include <vtkStructuredPoints.h>
#include <vtkStructuredPointsWriter.h>

//////////////////////////////////////////////////////////////

struct VtkFormat : public FileFormat {
  STD_string description() const {return "Visualization Toolkit";}
  svector suffix() const  {
    svector result; result.resize(1);
    result[0]="vtk";
    return result;
  }
  svector dialects() const {return svector();}

  int read(Data<float,4>& data, const STD_string& filename, const FileReadOpts& opts, Protocol& prot) {
    Log<FileIO> odinlog("VtkFormat","read");
    ODINLOG(odinlog,errorLog) << "Implement me" << STD_endl;
    return -1;
  }

  int write(const Data<float,4>& data, const STD_string& filename, const FileWriteOpts& opts, const Protocol& prot) {
    Log<FileIO> odinlog("VtkFormat","write");

    vtkStructuredPointsWriter *out_write=vtkStructuredPointsWriter::New();
    vtkStructuredPoints *out=vtkStructuredPoints::New();

    // setting format
    STD_string datatype=selectDataType(prot,opts);
    if(datatype==TypeTraits::type2label((float)0))  out->SetScalarTypeToFloat ();
    if(datatype==TypeTraits::type2label((double)0)) out->SetScalarTypeToDouble ();
    if(datatype==TypeTraits::type2label((s32bit)0)) out->SetScalarTypeToInt ();
    if(datatype==TypeTraits::type2label((u32bit)0)) out->SetScalarTypeToUnsignedInt ();
    if(datatype==TypeTraits::type2label((s16bit)0)) out->SetScalarTypeToShort ();
    if(datatype==TypeTraits::type2label((u16bit)0)) out->SetScalarTypeToUnsignedShort ();
    if(datatype==TypeTraits::type2label((s8bit)0))  out->SetScalarTypeToChar ();
    if(datatype==TypeTraits::type2label((u8bit)0))  out->SetScalarTypeToUnsignedChar ();

    Data<float,3> data3d;

    const STD_string type(prot.system.get_data_type());
    if(type!="float" && type!="double")data.convert_to(data3d,noupscale);
    else data.convert_to(data3d);

    // setting vtk parameters
    out->SetDimensions(data3d.extent(2),data3d.extent(1),data3d.extent(0));
    out->SetSpacing(1,1,1);
    out->SetOrigin(0,0,0);
    out->SetNumberOfScalarComponents(1);

    // assign data to vtk array
    for(int i=0;i<data3d.extent(2);i++)
      for(int j=0;j<data3d.extent(1);j++)
        for(int k=0;k<data3d.extent(0);k++)
          out->SetScalarComponentFromDouble(i,j,k,0,data3d(i,j,k));

    out_write->SetFileName(filename.c_str());
    out_write->SetInput(out);
    out_write->SetScalarsName(filename.c_str());
//    if(ascii) out_write->SetFileTypeToASCII();
//    else out_write->SetFileTypeToBinary();
    ostream *fp=out_write->OpenVTKFile();
    out_write->Write();
    out_write->CloseVTKFile(fp);


    out->Delete();
    out_write->Delete();
    return data3d.extent(0);
  }

};

#endif

//////////////////////////////////////////////////////////////

void register_vtk_format() {
#ifdef VTKSUPPORT
 static VtkFormat vf;
 vf.register_format();
#endif
}

