#ifndef COUNTRY_H
#define COUNTRY_H

extern "C" {
#include <ogle/dvd.h>
}

#include <qstring.h>
#include <qstringlist.h>
#include <qptrlist.h>

class CountryCode
{
public:
 CountryCode(const QString& /*name*/,const QString& /*code*/);
 QString name;
 QString code;
};
 
class Country
{
public:
 static void init(); // this MUST be called before using the methods below!
 static QString name(DVDLangID_t /*langid*/);
 static QString code(DVDLangID_t /*langid*/);
 static QStringList allNames();
 static QStringList allCodes();
 static DVDLangID_t id(const QString& /*code_639_1*/);
private:
 static QPtrList<CountryCode> countries;
};

#endif // COUNTRY_H
