/*
// $Id: MdxParserFactory.java 229 2009-05-08 19:11:29Z jhyde $
// This software is subject to the terms of the Eclipse Public License v1.0
// Agreement, available at the following URL:
// http://www.eclipse.org/legal/epl-v10.html.
// Copyright (C) 2006-2008 Julian Hyde
// All Rights Reserved.
// You must accept the terms of that agreement to use this software.
*/
package org.olap4j.mdx.parser;

import org.olap4j.OlapConnection;

/**
 * Factory for MDX parsers.
 *
 * @author jhyde
 * @version $Id: MdxParserFactory.java 229 2009-05-08 19:11:29Z jhyde $
 * @since Aug 22, 2006
 */
public interface MdxParserFactory {
    /**
     * Creates an MDX parser.
     *
     * @param connection Connection in which to resolve identifiers
     * @return MDX parser
     */
    MdxParser createMdxParser(OlapConnection connection);

    /**
     * Creates an MDX validator.
     *
     * @param connection Connection in which to resolve identifiers
     * @return MDX validator
     */
    MdxValidator createMdxValidator(OlapConnection connection);
}

// End MdxParserFactory.java
