/*
 * Copyright (c) OSGi Alliance (2001, 2009). All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package java.sql;
public interface DatabaseMetaData extends java.sql.Wrapper {
	public final static short attributeNoNulls = 0;
	public final static short attributeNullable = 1;
	public final static short attributeNullableUnknown = 2;
	public final static int bestRowNotPseudo = 1;
	public final static int bestRowPseudo = 2;
	public final static int bestRowSession = 2;
	public final static int bestRowTemporary = 0;
	public final static int bestRowTransaction = 1;
	public final static int bestRowUnknown = 0;
	public final static int columnNoNulls = 0;
	public final static int columnNullable = 1;
	public final static int columnNullableUnknown = 2;
	public final static int functionColumnIn = 1;
	public final static int functionColumnInOut = 2;
	public final static int functionColumnOut = 3;
	public final static int functionColumnResult = 5;
	public final static int functionColumnUnknown = 0;
	public final static int functionNoNulls = 0;
	public final static int functionNoTable = 1;
	public final static int functionNullable = 1;
	public final static int functionNullableUnknown = 2;
	public final static int functionResultUnknown = 0;
	public final static int functionReturn = 4;
	public final static int functionReturnsTable = 2;
	public final static int importedKeyCascade = 0;
	public final static int importedKeyInitiallyDeferred = 5;
	public final static int importedKeyInitiallyImmediate = 6;
	public final static int importedKeyNoAction = 3;
	public final static int importedKeyNotDeferrable = 7;
	public final static int importedKeyRestrict = 1;
	public final static int importedKeySetDefault = 4;
	public final static int importedKeySetNull = 2;
	public final static int procedureColumnIn = 1;
	public final static int procedureColumnInOut = 2;
	public final static int procedureColumnOut = 4;
	public final static int procedureColumnResult = 3;
	public final static int procedureColumnReturn = 5;
	public final static int procedureColumnUnknown = 0;
	public final static int procedureNoNulls = 0;
	public final static int procedureNoResult = 1;
	public final static int procedureNullable = 1;
	public final static int procedureNullableUnknown = 2;
	public final static int procedureResultUnknown = 0;
	public final static int procedureReturnsResult = 2;
	public final static int sqlStateSQL = 2;
	public final static int sqlStateSQL99 = 2;
	public final static int sqlStateXOpen = 1;
	public final static short tableIndexClustered = 1;
	public final static short tableIndexHashed = 2;
	public final static short tableIndexOther = 3;
	public final static short tableIndexStatistic = 0;
	public final static int typeNoNulls = 0;
	public final static int typeNullable = 1;
	public final static int typeNullableUnknown = 2;
	public final static int typePredBasic = 2;
	public final static int typePredChar = 1;
	public final static int typePredNone = 0;
	public final static int typeSearchable = 3;
	public final static int versionColumnNotPseudo = 1;
	public final static int versionColumnPseudo = 2;
	public final static int versionColumnUnknown = 0;
	boolean allProceduresAreCallable() throws java.sql.SQLException;
	boolean allTablesAreSelectable() throws java.sql.SQLException;
	boolean autoCommitFailureClosesAllResultSets() throws java.sql.SQLException;
	boolean dataDefinitionCausesTransactionCommit() throws java.sql.SQLException;
	boolean dataDefinitionIgnoredInTransactions() throws java.sql.SQLException;
	boolean deletesAreDetected(int var0) throws java.sql.SQLException;
	boolean doesMaxRowSizeIncludeBlobs() throws java.sql.SQLException;
	java.sql.ResultSet getAttributes(java.lang.String var0, java.lang.String var1, java.lang.String var2, java.lang.String var3) throws java.sql.SQLException;
	java.sql.ResultSet getBestRowIdentifier(java.lang.String var0, java.lang.String var1, java.lang.String var2, int var3, boolean var4) throws java.sql.SQLException;
	java.lang.String getCatalogSeparator() throws java.sql.SQLException;
	java.lang.String getCatalogTerm() throws java.sql.SQLException;
	java.sql.ResultSet getCatalogs() throws java.sql.SQLException;
	java.sql.ResultSet getClientInfoProperties() throws java.sql.SQLException;
	java.sql.ResultSet getColumnPrivileges(java.lang.String var0, java.lang.String var1, java.lang.String var2, java.lang.String var3) throws java.sql.SQLException;
	java.sql.ResultSet getColumns(java.lang.String var0, java.lang.String var1, java.lang.String var2, java.lang.String var3) throws java.sql.SQLException;
	java.sql.Connection getConnection() throws java.sql.SQLException;
	java.sql.ResultSet getCrossReference(java.lang.String var0, java.lang.String var1, java.lang.String var2, java.lang.String var3, java.lang.String var4, java.lang.String var5) throws java.sql.SQLException;
	int getDatabaseMajorVersion() throws java.sql.SQLException;
	int getDatabaseMinorVersion() throws java.sql.SQLException;
	java.lang.String getDatabaseProductName() throws java.sql.SQLException;
	java.lang.String getDatabaseProductVersion() throws java.sql.SQLException;
	int getDefaultTransactionIsolation() throws java.sql.SQLException;
	int getDriverMajorVersion();
	int getDriverMinorVersion();
	java.lang.String getDriverName() throws java.sql.SQLException;
	java.lang.String getDriverVersion() throws java.sql.SQLException;
	java.sql.ResultSet getExportedKeys(java.lang.String var0, java.lang.String var1, java.lang.String var2) throws java.sql.SQLException;
	java.lang.String getExtraNameCharacters() throws java.sql.SQLException;
	java.sql.ResultSet getFunctionColumns(java.lang.String var0, java.lang.String var1, java.lang.String var2, java.lang.String var3) throws java.sql.SQLException;
	java.sql.ResultSet getFunctions(java.lang.String var0, java.lang.String var1, java.lang.String var2) throws java.sql.SQLException;
	java.lang.String getIdentifierQuoteString() throws java.sql.SQLException;
	java.sql.ResultSet getImportedKeys(java.lang.String var0, java.lang.String var1, java.lang.String var2) throws java.sql.SQLException;
	java.sql.ResultSet getIndexInfo(java.lang.String var0, java.lang.String var1, java.lang.String var2, boolean var3, boolean var4) throws java.sql.SQLException;
	int getJDBCMajorVersion() throws java.sql.SQLException;
	int getJDBCMinorVersion() throws java.sql.SQLException;
	int getMaxBinaryLiteralLength() throws java.sql.SQLException;
	int getMaxCatalogNameLength() throws java.sql.SQLException;
	int getMaxCharLiteralLength() throws java.sql.SQLException;
	int getMaxColumnNameLength() throws java.sql.SQLException;
	int getMaxColumnsInGroupBy() throws java.sql.SQLException;
	int getMaxColumnsInIndex() throws java.sql.SQLException;
	int getMaxColumnsInOrderBy() throws java.sql.SQLException;
	int getMaxColumnsInSelect() throws java.sql.SQLException;
	int getMaxColumnsInTable() throws java.sql.SQLException;
	int getMaxConnections() throws java.sql.SQLException;
	int getMaxCursorNameLength() throws java.sql.SQLException;
	int getMaxIndexLength() throws java.sql.SQLException;
	int getMaxProcedureNameLength() throws java.sql.SQLException;
	int getMaxRowSize() throws java.sql.SQLException;
	int getMaxSchemaNameLength() throws java.sql.SQLException;
	int getMaxStatementLength() throws java.sql.SQLException;
	int getMaxStatements() throws java.sql.SQLException;
	int getMaxTableNameLength() throws java.sql.SQLException;
	int getMaxTablesInSelect() throws java.sql.SQLException;
	int getMaxUserNameLength() throws java.sql.SQLException;
	java.lang.String getNumericFunctions() throws java.sql.SQLException;
	java.sql.ResultSet getPrimaryKeys(java.lang.String var0, java.lang.String var1, java.lang.String var2) throws java.sql.SQLException;
	java.sql.ResultSet getProcedureColumns(java.lang.String var0, java.lang.String var1, java.lang.String var2, java.lang.String var3) throws java.sql.SQLException;
	java.lang.String getProcedureTerm() throws java.sql.SQLException;
	java.sql.ResultSet getProcedures(java.lang.String var0, java.lang.String var1, java.lang.String var2) throws java.sql.SQLException;
	int getResultSetHoldability() throws java.sql.SQLException;
	java.sql.RowIdLifetime getRowIdLifetime() throws java.sql.SQLException;
	java.lang.String getSQLKeywords() throws java.sql.SQLException;
	int getSQLStateType() throws java.sql.SQLException;
	java.lang.String getSchemaTerm() throws java.sql.SQLException;
	java.sql.ResultSet getSchemas() throws java.sql.SQLException;
	java.sql.ResultSet getSchemas(java.lang.String var0, java.lang.String var1) throws java.sql.SQLException;
	java.lang.String getSearchStringEscape() throws java.sql.SQLException;
	java.lang.String getStringFunctions() throws java.sql.SQLException;
	java.sql.ResultSet getSuperTables(java.lang.String var0, java.lang.String var1, java.lang.String var2) throws java.sql.SQLException;
	java.sql.ResultSet getSuperTypes(java.lang.String var0, java.lang.String var1, java.lang.String var2) throws java.sql.SQLException;
	java.lang.String getSystemFunctions() throws java.sql.SQLException;
	java.sql.ResultSet getTablePrivileges(java.lang.String var0, java.lang.String var1, java.lang.String var2) throws java.sql.SQLException;
	java.sql.ResultSet getTableTypes() throws java.sql.SQLException;
	java.sql.ResultSet getTables(java.lang.String var0, java.lang.String var1, java.lang.String var2, java.lang.String[] var3) throws java.sql.SQLException;
	java.lang.String getTimeDateFunctions() throws java.sql.SQLException;
	java.sql.ResultSet getTypeInfo() throws java.sql.SQLException;
	java.sql.ResultSet getUDTs(java.lang.String var0, java.lang.String var1, java.lang.String var2, int[] var3) throws java.sql.SQLException;
	java.lang.String getURL() throws java.sql.SQLException;
	java.lang.String getUserName() throws java.sql.SQLException;
	java.sql.ResultSet getVersionColumns(java.lang.String var0, java.lang.String var1, java.lang.String var2) throws java.sql.SQLException;
	boolean insertsAreDetected(int var0) throws java.sql.SQLException;
	boolean isCatalogAtStart() throws java.sql.SQLException;
	boolean isReadOnly() throws java.sql.SQLException;
	boolean locatorsUpdateCopy() throws java.sql.SQLException;
	boolean nullPlusNonNullIsNull() throws java.sql.SQLException;
	boolean nullsAreSortedAtEnd() throws java.sql.SQLException;
	boolean nullsAreSortedAtStart() throws java.sql.SQLException;
	boolean nullsAreSortedHigh() throws java.sql.SQLException;
	boolean nullsAreSortedLow() throws java.sql.SQLException;
	boolean othersDeletesAreVisible(int var0) throws java.sql.SQLException;
	boolean othersInsertsAreVisible(int var0) throws java.sql.SQLException;
	boolean othersUpdatesAreVisible(int var0) throws java.sql.SQLException;
	boolean ownDeletesAreVisible(int var0) throws java.sql.SQLException;
	boolean ownInsertsAreVisible(int var0) throws java.sql.SQLException;
	boolean ownUpdatesAreVisible(int var0) throws java.sql.SQLException;
	boolean storesLowerCaseIdentifiers() throws java.sql.SQLException;
	boolean storesLowerCaseQuotedIdentifiers() throws java.sql.SQLException;
	boolean storesMixedCaseIdentifiers() throws java.sql.SQLException;
	boolean storesMixedCaseQuotedIdentifiers() throws java.sql.SQLException;
	boolean storesUpperCaseIdentifiers() throws java.sql.SQLException;
	boolean storesUpperCaseQuotedIdentifiers() throws java.sql.SQLException;
	boolean supportsANSI92EntryLevelSQL() throws java.sql.SQLException;
	boolean supportsANSI92FullSQL() throws java.sql.SQLException;
	boolean supportsANSI92IntermediateSQL() throws java.sql.SQLException;
	boolean supportsAlterTableWithAddColumn() throws java.sql.SQLException;
	boolean supportsAlterTableWithDropColumn() throws java.sql.SQLException;
	boolean supportsBatchUpdates() throws java.sql.SQLException;
	boolean supportsCatalogsInDataManipulation() throws java.sql.SQLException;
	boolean supportsCatalogsInIndexDefinitions() throws java.sql.SQLException;
	boolean supportsCatalogsInPrivilegeDefinitions() throws java.sql.SQLException;
	boolean supportsCatalogsInProcedureCalls() throws java.sql.SQLException;
	boolean supportsCatalogsInTableDefinitions() throws java.sql.SQLException;
	boolean supportsColumnAliasing() throws java.sql.SQLException;
	boolean supportsConvert() throws java.sql.SQLException;
	boolean supportsConvert(int var0, int var1) throws java.sql.SQLException;
	boolean supportsCoreSQLGrammar() throws java.sql.SQLException;
	boolean supportsCorrelatedSubqueries() throws java.sql.SQLException;
	boolean supportsDataDefinitionAndDataManipulationTransactions() throws java.sql.SQLException;
	boolean supportsDataManipulationTransactionsOnly() throws java.sql.SQLException;
	boolean supportsDifferentTableCorrelationNames() throws java.sql.SQLException;
	boolean supportsExpressionsInOrderBy() throws java.sql.SQLException;
	boolean supportsExtendedSQLGrammar() throws java.sql.SQLException;
	boolean supportsFullOuterJoins() throws java.sql.SQLException;
	boolean supportsGetGeneratedKeys() throws java.sql.SQLException;
	boolean supportsGroupBy() throws java.sql.SQLException;
	boolean supportsGroupByBeyondSelect() throws java.sql.SQLException;
	boolean supportsGroupByUnrelated() throws java.sql.SQLException;
	boolean supportsIntegrityEnhancementFacility() throws java.sql.SQLException;
	boolean supportsLikeEscapeClause() throws java.sql.SQLException;
	boolean supportsLimitedOuterJoins() throws java.sql.SQLException;
	boolean supportsMinimumSQLGrammar() throws java.sql.SQLException;
	boolean supportsMixedCaseIdentifiers() throws java.sql.SQLException;
	boolean supportsMixedCaseQuotedIdentifiers() throws java.sql.SQLException;
	boolean supportsMultipleOpenResults() throws java.sql.SQLException;
	boolean supportsMultipleResultSets() throws java.sql.SQLException;
	boolean supportsMultipleTransactions() throws java.sql.SQLException;
	boolean supportsNamedParameters() throws java.sql.SQLException;
	boolean supportsNonNullableColumns() throws java.sql.SQLException;
	boolean supportsOpenCursorsAcrossCommit() throws java.sql.SQLException;
	boolean supportsOpenCursorsAcrossRollback() throws java.sql.SQLException;
	boolean supportsOpenStatementsAcrossCommit() throws java.sql.SQLException;
	boolean supportsOpenStatementsAcrossRollback() throws java.sql.SQLException;
	boolean supportsOrderByUnrelated() throws java.sql.SQLException;
	boolean supportsOuterJoins() throws java.sql.SQLException;
	boolean supportsPositionedDelete() throws java.sql.SQLException;
	boolean supportsPositionedUpdate() throws java.sql.SQLException;
	boolean supportsResultSetConcurrency(int var0, int var1) throws java.sql.SQLException;
	boolean supportsResultSetHoldability(int var0) throws java.sql.SQLException;
	boolean supportsResultSetType(int var0) throws java.sql.SQLException;
	boolean supportsSavepoints() throws java.sql.SQLException;
	boolean supportsSchemasInDataManipulation() throws java.sql.SQLException;
	boolean supportsSchemasInIndexDefinitions() throws java.sql.SQLException;
	boolean supportsSchemasInPrivilegeDefinitions() throws java.sql.SQLException;
	boolean supportsSchemasInProcedureCalls() throws java.sql.SQLException;
	boolean supportsSchemasInTableDefinitions() throws java.sql.SQLException;
	boolean supportsSelectForUpdate() throws java.sql.SQLException;
	boolean supportsStatementPooling() throws java.sql.SQLException;
	boolean supportsStoredFunctionsUsingCallSyntax() throws java.sql.SQLException;
	boolean supportsStoredProcedures() throws java.sql.SQLException;
	boolean supportsSubqueriesInComparisons() throws java.sql.SQLException;
	boolean supportsSubqueriesInExists() throws java.sql.SQLException;
	boolean supportsSubqueriesInIns() throws java.sql.SQLException;
	boolean supportsSubqueriesInQuantifieds() throws java.sql.SQLException;
	boolean supportsTableCorrelationNames() throws java.sql.SQLException;
	boolean supportsTransactionIsolationLevel(int var0) throws java.sql.SQLException;
	boolean supportsTransactions() throws java.sql.SQLException;
	boolean supportsUnion() throws java.sql.SQLException;
	boolean supportsUnionAll() throws java.sql.SQLException;
	boolean updatesAreDetected(int var0) throws java.sql.SQLException;
	boolean usesLocalFilePerTable() throws java.sql.SQLException;
	boolean usesLocalFiles() throws java.sql.SQLException;
}

