/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef NODECONTROLWINDOW_H
#define NODECONTROLWINDOW_H

#include <vector>
#include <string>
#include <gtkmm.h>
#include <libglademm.h>
#include <sigc++/sigc++.h>
#include "ControlPanel.h"
using std::string; using std::vector;


namespace LibOmClient {
class NodeModel;
}
using namespace LibOmClient;

namespace OmGtk {
	
class PatchController;
class ControlGroup;


/** Window with controls (sliders) for all control-rate ports on a Node.
 *
 * \ingroup OmGtk
 */
class NodeControlWindow : public Gtk::Window
{
public:
	//NodeControlWindow(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& glade_xml);
	
	NodeControlWindow(PatchController* patch_controller, NodeModel* node_model);
	virtual ~NodeControlWindow();

	ControlPanel* control_panel() { return m_control_panel; }
	
	void resize();

private:
	PatchController* m_patch_controller;
	NodeModel*       m_node_model;

	ControlPanel*         m_control_panel;
	bool                  m_callback_enabled;
};


} // namespace OmGtk

#endif // NODECONTROLWINDOW_H
