/* This file is part of Om.  Copyright (C) 2005 Dave Robillard.
 * 
 * Om is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * Om is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef REMOVENODEEVENT_H
#define REMOVENODEEVENT_H

#include "SlowEvent.h"
#include <string>
#include "List.h"

using std::string;

namespace Om {

class Patch;
class Node;
class TreeNode;
class Plugin;
class DisconnectNodeEvent;
class DisconnectPortEvent;


/** An event to remove and delete a Node.
 *
 * \ingroup engine
 */
class RemoveNodeEvent : public SlowEvent
{
public:
	RemoveNodeEvent(Request* request, const string& path, bool lock_mutex = true);
	~RemoveNodeEvent();

	void prepare();
	void execute(uint sample_offset);
	void post_process();

private:
	string               m_path;
	Patch*               m_patch;
	TreeNode*            m_treenode;
	TreeNode*            m_delete_treenode;
	List<Node*>*         m_process_order; // Patch's new process order
	ListNode<Node*>*     m_delete_listnode;
	DisconnectNodeEvent* m_disconnect_event;
	DisconnectPortEvent* m_parent_disconnect_event; // used for input/output nodes
	bool                 m_lock_mutex;
	bool                 m_acquired_mutex;
};


} // namespace Om

#endif // REMOVENODEEVENT_H
