#
# common-funcs.pl
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# $Id: common-funcs.pl,v 1.24 2001/08/29 22:23:03 adam Exp $

require 'etc/timesheet.conf';

use CGI qw(:standard);
use CGI::Carp;
use ADB;
use Time::localtime;


sub time_head {
    my $title = shift @_;
    print header,
    start_html('-title'      =>$title,
	       '-BACKGROUND' => $Conf::BACKGROUND,
	       '-script'     =>$Conf::JAVA_HELP,     
	       '-BGCOLOR'    => $Conf::BGCOLOR,
	       );
}


sub date_download {
    my $mday = localtime(time)->mday();
    my $year = localtime(time)->year();
    my $mon = localtime(time)->mon();
    $mon++;
    if ( length($mon) == 1 ) {
	$mon = '0' . $mon;
    }
    if ( length($mday) == 1 ) {
	$mday = '0' . $mday;
    }

    $year += 1900; 

    my $date =  "$year-$mon-$mday";
}

sub date_today {
    my $mday = localtime(time)->mday();
    my $year = localtime(time)->year();
    my $mon = localtime(time)->mon();
    $mon++;
    if ( length($mon) == 1 ) {
	$mon = '0' . $mon;
    }
    if ( length($mday) == 1 ) {
	$mday = '0' . $mday;
    }

    if ( $year > 99  ) { 
	$year -= 100; 
    } 
    if ( length($year) == 1 ) {
	$year = '0' . $year;
    } 
    
    my $date =  "$mon/$mday/$year";

}

sub dbdate_today {
    my $mday = localtime(time)->mday();
    my $mon = localtime(time)->mon();
    my $year = localtime(time)->year() + 1900; 
    $mon++;
    if ( length($mon) == 1 ) {
	$mon = '0' . $mon;
    }
    if ( length($mday) == 1 ) {
	$mday = '0' . $mday;
    }
    my $date =  "$mon-$mday-$year";
    return $date;
}

# conditions the date for the database
sub dbdate {
    my $olddate = shift;
    my($mon, $day, $year);

    $olddate || return undef;

    #DEBUG
    $Conf::DEBUG > 2 && warn("dbdate: incoming date is $olddate\n");

    # remove whitespace
    $olddate =~ s/\s+//g;

    if ( $olddate =~ m!(\d+)[-/|](\d+)(?:[-/|](\d+))?! ) {
	($mon, $day, $year) = ($1, $2, $3);
    } else {
	&user_error("Can't recognize date '$olddate'");
	exit 1;
    }

    # deal with 2-digit years, windowing technology (watch-out around 2070)
    if ( length($year) > 3 ) { 
	#year is absolute, leave year alone
    }
    elsif ( $year < 70 ) {
	$year += 2000; 
    }
    elsif ( ! $year ) {		# tolerate empty year, as current year
	$year = (localtime())[5] + 1900;
    }
    else { 
	$year += 1900;
    }

    if (length($mon) == 1){
	$mon = "0$mon";
    } elsif (length($mon) > 2){
	return 0;
    }

    if ( length($day) == 1 ) {
	$day = "0$day";
    } elsif ( length($day) > 2 ) {
	return 0;
    }

    my $newdate = "$mon-$day-$year";

    #DEBUG
    $Conf::DEBUG > 2 && warn("dbdate: returning $newdate\n");
    return $newdate;
}


# FIXME: deprecate
sub formdate
{
    my $olddate = shift;
    if ( ! $olddate ) {
        return '';
    }
    if ( $olddate =~ /(\d+)\/(\d+)\/(\d+)/ ) {
	return $olddate;
    }
    $olddate =~ /(\d\d)-(\d\d)-\d\d(\d\d)/;
    my($year,$mon,$day) = ($3,$1,$2);
    my $newdate = "$mon/$day/$year";
    return $newdate;
}



sub help_button_big {
    my $item = shift @_;
    my $align = shift @_;
    if ( ! $align ) {
	$align = RIGHT;
    }

    print <<EOT;
    <a href="JavaScript:get_help('-$item')"
	OnMouseOver="window.status= 'Online Help';return true" 
	    OnMouseOut="window.status= '';return true"
		><IMG SRC="images/question-big.gif" BORDER=0 ALT=[?] ALIGN=$align></A> 
EOT
}


sub help_button {
    my $item = shift @_;
    print <<EOT;
    <a href="JavaScript:get_help('$item')"
	OnMouseOver="window.status= 'Online Help';return true" 
	    OnMouseOut="window.status= '';return true"
		><IMG SRC="images/question.gif" BORDER=0 ALT=[?]></A> 
EOT
}

###########################################################
###########################################################
# ARGV[0] = Variable to check
# ARGV[1] = English name of the variable (for error notification)
# ARGV[2] = if this is true, then does not allow ARGV[1] to be null.
sub check_alnum {
    my $var = shift @_;
    my $ident = shift @_;
    my $no_null = shift @_;
    my $return = '';
    if ( $var =~ /[^a-zA-Z0-9]+/) {
	$return = "'$ident' may only contain alphanumeric characters.\n";
    }
    elsif (($var eq '') || ($var =~ /\s+/)) {
	if ($no_null) {
	    $return = "'$var' is not a valid entry. You must fill out '$ident'.\n";
	}

    }
    return $return;
}

sub is_superuser {
    my $user = shift;
    my $dbconn = shift;
    my $owndb = 0;

    $user || &error("Empty client ID");

    unless ($dbconn) {
	$owndb = 1;
	$dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
	if ( ! $dbconn->is_ok ) {
	    my $oops = $dbconn->errorstring;
	    &error("Cannot connect to backend: $oops");
	}
    }
    my $rec = '';
    unless ( $rec = $dbconn->get_record($Conf::USER_DB_KEY,$user,$Conf::USER_DB) ) {
	my $oops = $dbconn->errorstring;
	&error("Error selecting record \"$Conf::USER_DB_KEY\" for user \"$user\" in table \"$Conf::USER_DB\": $oops");
    }
    if ( $owndb ) {
	$dbconn->close;
    }
    if ( $$rec{'super_user'} ) {
	return 1;
    }
    return 0;
}

sub client_id_to_name {
    my $client = shift;
    my $dbconn = shift;
    my $owndb = 0;

    $client || &error("Empty client ID");

    unless ( $dbconn ) {
	$owndb = 1;
	$dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
	if ( ! $dbconn->is_ok ) {
	    my $oops = $dbconn->errorstring;
	    &error("Cannot connect to backend: $oops");
	}
    }
    my $rec = '';
    unless ( $rec = $dbconn->get_record($Conf::CLIENT_DB_KEY,
					$client,$Conf::CLIENT_DB) ) {
	my $oops = $dbconn->errorstring;
	&error("Error selecting record: $oops");
    }
    if ( $owndb ) {
	$dbconn->close;
    }
    return $$rec{'client_name'};
}

sub list_supervisors {
    my $dbconn = shift;
    my $owndb = 0;
    unless ( $dbconn ) {
	$owndb = 1;
	$dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
	if ( ! $dbconn->is_ok ) {
	    my $oops = $dbconn->errorstring;
	    &error("Cannot connect to backend: $oops");
	}
    }
    my @sups = $dbconn->list('personnel_id',
			     $Conf::USER_DB,"super_user = '1'");
    if ( $owndb ) {
	$dbconn->close;
    }
    return @sups;
} 

sub list_notifiers {
    my $dbconn = shift;
    my $owndb = 0;
    unless ( $dbconn ) {
	$owndb = 1;
	$dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
	if ( ! $dbconn->is_ok ) {
	    my $oops = $dbconn->errorstring;
	    &error("Cannot connect to backend: $oops");
	}
    }
    my @sups = $dbconn->list('personnel_id', $Conf::USER_DB);
    if ( $owndb ) {
	$dbconn->close;
    }
    return @sups;
}



sub get_box_size {
    $num = shift @_;
    if ( $num >= 5 ) {
	$num = int(sqrt($num) + 1);
	return $num;
    }
    return $num;
}

###########################################################
###########################################################
# ARGV[0] =
# ARGV[1] =
sub CLEANUP {
    print h1("Program Aborted by SIGNAL\n"), hr ;
    exit 1;
}

# these are user errors, not system or logic errors
sub user_error {
    my $error = shift @_;
    my $stmt = shift @_;

    # FIXME: ugh... sometimes this is called even after the header has been emitted
#    print header,
#    start_html('-title'      => "User Error",
#	       '-BACKGROUND' => $Conf::BACKGROUND,
#	       '-BGCOLOR'    => $Conf::BGCOLOR,
#	       );
    print p, h1("User Error"), "<UL>\n", li($error), "\n";
    if ( $Conf::DEBUG > 2 && $stmt ) {
	print li("Error statement: $stmt\n");
    }
    print "</UL>\n";

    if ( $Conf::DEBUG ) {
	croak("user violation: " . $error .  
	      @{[ $Conf::DEBUG > 1 ? $stmt : '']} );
    }
}


sub error {
    my $error = shift @_;
    my $stmt = shift @_;
    print p,
    h2('Sorry, I cannot complete your request:'), "<UL>\n", li($error), "\n";
    if ( $Conf::DEBUG > 2 && $stmt ) {
	print li("Error statement: $stmt\n");
    }
    print "</UL>\n", 
    b("If you feel that this is a bug, please report it.\n"), p;
    croak($error . @{[ $Conf::DEBUG > 1 ? $stmt : '']} );
}


sub numerically { $a <=> $b; }

sub print_record_nav {
    my %args = @_;
    print br,"<TABLE BORDER=0>",
    "<TR><TD>";
    if ( ! $args{'prevrecord'} ) {
	print "<IMG SRC=\"images/left_arrow_grey.gif\" BORDER=\"0\">";
    } else {
	print '<INPUT NAME="prevrecord" TYPE="image" SRC="images/left_arrow.gif"',
	'BORDER=0 ALT="[Previous Record]">',"\n";

    }
    print "</TD><TD>",
    "Record ",
    
    textfield('-name'=>'record_number',
	      '-default'=>"$args{'recordnumber'}",
	      '-size'=>3,
	      '-override'=>1,
	      '-maxlength'=>3,
	      '-onChange'=>'jump_cut();',
	      ),
    
    " of $args{'totalrecords'}";
    print "</TD><TD>";
    if ( ! $args{'nextrecord'} ) {
	print "<IMG SRC=\"images/right_arrow_grey.gif\" BORDER=\"0\">";
    } else {
	print '<INPUT NAME="nextrecord" TYPE="image" SRC="images/right_arrow.gif"',
	' BORDER=0 ALT="[Next Record]">',"\n";

    }
    print "</TD></TR></TABLE>";
}

sub initialize_state
{
    my $st = shift;
    my $dbconn = shift;
    my $owndb = 0;
    unless ( $dbconn ) {
	$owndb = 1;
        $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
        if ( ! $dbconn->is_ok ) {
            my $oops = $dbconn->errorstring;
            &error("cannot connect to backend: $oops");
        }
    }
    $$st{'remote_user'} = remote_user();
    $$st{'super'} = &is_superuser($$st{'remote_user'}, $dbconn);
    $$st{'client_id'} = param('client_id');
    if ( $$st{'client_id'} ) {
	$$st{'client_name'} = &client_id_to_name($$st{'client_id'}, $dbconn);
    }
    # FIXME: abstraction needed, i.e., $st = params_to_hash(<key>, ...)
    $$st{'nextrecord'} = param('nextrecord');
    $$st{'prevrecord'} = param('prevrecord');
    $$st{'totalrecords'} = param('totalrecords');
    $$st{'recordnumber'} = param('recordnumber');
    $$st{'searchtable'} = param('searchtable');
    if ( $owndb ) {
	$dbconn->close;
    }
}

sub write_state(\%state)
{
    my %state = @_;
    my $var;
    foreach $var ('client_id', 'nextrecord', 'prevrecord',
		  'recordnumber', 'totalrecords', 'searchtable') {
	print "<INPUT TYPE=\"HIDDEN\"",
	"NAME=\"$var\" VALUE=\"$state{$var}\">\n";
    }

}

sub scrub_hash(\%hash)
{
    my $hashref = shift;
    my $clean;
    foreach $clean (keys %$hashref) {
	$$hashref{$clean} =~ s/\'/\\\'/g;
	$$hashref{$clean} =~ s/\"/\\\"/g;
#	$$hashref{$clean} =~ s/\n/ /g;
#	$$hashref{$clean} =~ s/\r/ /g;
#	$$hashref{$clean} =~ s/  / /g;
	$$hashref{$clean} =~ s/\t/     /g;
    }
}

sub clean_hash_for_dl
{
    my $hashref = shift;
    my $clean;
    foreach $clean (keys %$hashref) {
	$$hashref{$clean} =~ s/\'/\\\'/g;
	$$hashref{$clean} =~ s/\"/\\\"/g;
	$$hashref{$clean} =~ s/\n/ /g;
	$$hashref{$clean} =~ s/\r/ /g;
	$$hashref{$clean} =~ s/  / /g;
	$$hashref{$clean} =~ s/\t/     /g;
    }
}

# subprint_file takes on argument a file which it will read and
# substitute any perl variables in it and print's it to stdout;

sub subprint_file {
    local($filename) = shift;
    my $varref = shift;
    my %vars = %$varref;
    open(INFILE, "$filename") || 
	&error("Cannot open file '$filename': $!");
    while (<INFILE>) {
	s/"/\\"/g;
	$output = eval qq/"$_"/;
	print $output;
    }
}        


sub comma_unpack_vals { 
  my $csl=shift;
  my @addrs=split (/,/, $csl); 
  return @addrs; 
}

sub comma_pack_vals { 
  my $i; 
  my @vals=@_; 
  for ( $i=0; $i < $#vals; $i++ ) { 
    $pack .= $vals[$i] . ","; 
  }
  $pack .= $vals[$#vals]; 
  return $pack; 
}


1;



    
  
