#
# hours-funcs.pl
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software  under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# $Id: hours-funcs.pl,v 1.22 2001/08/29 22:23:03 adam Exp $

require 'etc/timesheet.conf';
require 'lib/common-funcs.pl';
use CGI qw(:standard);
use ADB;


###########################################################
###########################################################
sub log_hours {	
    my $session = $_[0];
    my $hours_id = $_[1];
    my $userid = remote_user;

    if (!$userid) {
	&error("Cannot determine what user you are, make sure that " .
	       "password authentication is enabled for this page.");
    }

    my $superuser = &is_superuser($userid);
    my $error = '';
    my $client_name = '';
    my $client_id;
    my $default_approved = '';
    

    # GOTTA make sure they've chosen a client first.
    if (!param('client_id')) {
	$error .= li("You must choose a client first!");
    }
    else {
	$client_id = param('client_id');
    }
    if ($error ne '') {
	&user_error($error);
    }  
    my %yes_no_labels = ('y',' yes','n',' no',); 
   
    # make a new connection to the SQL backendg    
    my $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
    if (!$dbconn->is_ok) {
	my $oops = $dbconn->errorstring;
	&error("Cannot connect to backend: $oops");
    }
    unless (my $user = $dbconn->get_record($Conf::USER_DB_KEY,$userid,$Conf::USER_DB)) {
	my $oops = $dbconn->errorstring;
	&error("Backend error getting record: $oops");
    }
   # get Client Name for client_name
    my $clientrec = $dbconn->get_record($Conf::CLIENT_DB_KEY,$client_id,$Conf::CLIENT_DB);
    if (!$clientrec) {
	my $oops = $dbconn->errorstring;
	&error("Unable to get client name from client '$client_id': $oops");
    }
    $client_name = $$clientrec{'client_name'};
    $default_approved = $$clientrec{'default_approved'};
    my $username = $$user{'first_name'} . " " . $$user{'last_name'};
   
    print hidden(-name=>'client_name',
		 -default=>"$client_name");
    # start building our widgets
    my %widgets;

    $widgets{'heading'} = strong("Logging hours for $client_name");
   
    # generate the job list 
    my $result = $dbconn->query("SELECT job_id, job_description, category FROM " .
				"$Conf::JOB_DB WHERE open = 1 AND fkclient_id = $client_id;");
    if (!$result) {
	my $oops = $dbconn->errorstring;
	&error("Unable to get job list: $oops");
    }
    my $rows = $result->get_num_rows;
    my $i = 0;
    my @jobs;
    my %joblabels;
    my $jobnumber = 0;
    while ($i < $rows) {
	my $jid = $result->get_value($i, 'job_id');
	my $jdesc = $result->get_value($i, 'job_description');
	my $jcat = $result->get_value($i, 'category');
	$jcat =~ /^(...)/;
	$jcat = $1;
	$joblabels{$jid} = "$jid($jcat) $jdesc";
	$i++;
	$jobnumber++;
    }
    @jobs = sort keys %joblabels;
    $jobnumber = &get_box_size($jobnumber);
    if (!$jobnumber) {
	&user_error("There are no jobs open for this client; please contact your manager.");
    }
    else {
	my $label = '';
	foreach $label (keys %joblabels) {
	    $joblabels{$label} = substr($joblabels{$label},0,52);
	    if (length($joblabels{$label}) == 52) {
		substr($joblabels{$label}, -3, 3) = '...'; 
	    }
	}
	
	$widgets{'jobs'} = scrolling_list(-name=>'job_id',
					  -values=>\@jobs,
					  -size=>"$jobnumber",
					  '-onChange'=>'validate(this.form,this);',
					  -default=>'',
					  -labels=>\%joblabels);
    }				
   
    $widgets{'date_entered'} = textfield('-name'=>'date_entered',
					 '-default'=>&date_today,
					 '-onChange'=>'validate(this.form,this);',
					 '-size'=>10,
					 '-maxlength'=>10);
   
    $widgets{'time_in'} = textfield('-name'=>'time_in',
				    '-default'=>"",
				    '-size'=>7,
				    '-onChange'=>'validate(this.form,this);',
				    '-maxlength'=>7,
				    '-default'=>'');
   
    $widgets{'time_out'} = textfield('-name'=>'time_out',
				     '-default'=>"",
				     '-size'=>7,
				     '-onChange'=>'validate(this.form,this);',
				     '-maxlength'=>7,
				     '-default'=>'');
   
    $widgets{'total_hours'} = textfield('-name'=>'total_hours',
					'-default'=>"",
					'-size'=>4,
					'-onChange'=>'validate(this.form,this);',
					'-maxlength'=>4);
    
    $widgets{'parking'} = textfield('-name'=>'parking',
				    '-default'=>"",
				    '-onChange'=>'validate(this.form,this);',
				    '-size'=>5,
				    '-maxlength'=>5);
    
    $widgets{'hours_description'} = textarea('-name'=>'hours_description',
					     '-default'=>"",
					     '-onChange'=>'validate(this.form,this);',
					     '-rows'=>3,
					     '-maxlength'=>126,
					     '-columns'=>50);
    
    $widgets{'comment'} =    textarea('-name'=>'comment',
				      '-default'=>"",
				      '-onChange'=>'validate(this.form,this);',
				      '-rows'=>2,
				      '-maxlength'=>126,
				      '-columns'=>50);
    
    $widgets{'billable'} = popup_menu('-name'=>'billable',
				      '-values'=>['y','n'],
				      '-default'=>'y',
				      '-linebreak' =>'true',
				      '-labels'=>\%yes_no_labels);
    
    
    $widgets{'submit'} = '<INPUT NAME="log" TYPE="image" SRC="images/post-hours.gif" ALT="[Log Hours]" BORDER=0 action="submitForm(this.form)">';
   
    &subprint_file("$Conf::LOG_HOURS_TMPL", \%widgets);
}



sub reset_all_params {
    # gonna need to reset approved to the client default!
    param('job_id'            ,'');
    param('date_entered'      ,&date_today);
    param('time_in'           ,'');
    param('time_out'          ,'');
    param('total_hours'       ,'');
    param('parking'           ,'');
    param('hours_description' ,'');
    param('comment'           ,'');
    param('billable'          ,'y');
    param('approved'          ,'n');
}


sub hours_log_data {
    my %newhour;
    my $error = '';
    my %yes_no_labels = ('y',' Yes','n',' No','any',' Any');	
    if (param('date_entered') eq '') {
	$error .= "You must fill in the <TT>Date</TT> field";
    }
    if (param('job_id') eq '') {
	$error .= "You must select a <TT>Job Number</TT>";
    }
    if (param('total_hours') eq '') {
	$error .= "You must fill in the <TT>Hours</TT> field";
    }
    if (param('hours_description') eq '') {
	$error .= "You must fill in the <TT>Hours Description</TT> field";
    }
    # if any errors so far, tell the user	
    if ($error) {
	&user_error($error);
    }

    my $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if (!$dbconn->is_ok) {
	my $oops = $dbconn->errorstring;
	&error("Failed to connect to backend: $oops");
    }

    $newhour{'fkjob_id'} = param('job_id');

    my $jobrecord = $dbconn->get_record($Conf::JOB_DB_KEY,$newhour{'fkjob_id'},$Conf::JOB_DB);

    if (!$jobrecord) {
	my $oops = $dbconn->errorstring;
	&error("Failed to get record for $newhours{'fkjob_id'}: $oops");
    }

    $newhour{'downloaded'} = 'n';
    $newhour{'del'} = 'n';

    $newhour{'fkclient_id'} = param('client_id');
    $newhour{'fkpersonnel_id'} = remote_user;
    $newhour{'date_entered'} = param('date_entered');
    $newhour{'date_entered'} = &dbdate($newhour{'date_entered'});
    $newhour{'time_in'} = param('time_in');
    $newhour{'time_out'} = param('time_out');
    $newhour{'total_hours'} = param('total_hours');
    if (param('billable') eq 'y') {
	$newhour{'billable'} = 1;
    } else {
	$newhour{'billable'} = 0;
    }
    if (!param('parking')) {
	$newhour{'parking'} = 0;
    } else {
	$newhour{'parking'} = param('parking');
    }
    $newhour{'hours_description'} = param('hours_description');
    if (param('comment')) {
	$newhour{'comment'} = param('comment');
    } else {
	$newhour{'comment'} = "";
    }
    my $todays_date = &dbdate_today;
    my($sec,$min,$hour) = localtime(time);
    my $time = "$hour:$min";
    $newhour{'intime'} = "$time:$todays_date";

    # we don't play with approval yet
    if ($$jobrecord{'default_approved'} == 1) {
	$newhour{'approval_date'} = $todays_date;
	$newhour{'fkapprover_id'} = $$jobrecord{'fksupervisor_id'};
    } else {
	$newhour{'approval_date'} = "$Conf::DUMMY_APPROVAL_DATE";
    }

    # We omit category for now
    $newhour{'category'} = "";

    &scrub_hash(\%newhour);

    my $result = $dbconn->insert_record_seq($Conf::HOURS_DB_KEY, $Conf::HOURS_DB, \%newhour);

    my $LOCK_EX = 2;
    my $LOCK_UN = 8;
    my $iterator;
    my $first;
    $first = 0;
    open(FILE, ">>$Conf::LOGHOURS_LOG");
    flock(FILE,$LOCK_EX);
    seek(FILE, 0, 2);
    foreach $iterator (keys %newhour) {
	if ($first = 0) {
	    print FILE "$newhour{$iterator}";
	} else {
	    print FILE "\t$newhour{$iterator}";
	}
    }
    print FILE "\n";
    flock(FILE, $LOCK_UN);	

    if (!$result) {
	my $oops = $dbconn->errorstring;
	&error("Failed to insert the new hours: $oops");
    }
######
###
###  This will cause a message to be sent to the notify list whenever
###  hours are logged. 
###
#    if ($$jobrecord{'fknotify_id'}) { 
#      my @addrs; 
#      my @names=&comma_unpack_vals($$jobrecord{'fknotify_id'}); 
#      foreach my $name (@names) { 
#	my $address = $dbconn->get_record($Conf::USER_DB_KEY,$name,$Conf::USER_DB);
#	&mail_notify(\%newhour, $$address{email}); 
#      }
#    }    
    print "<H2>Hours Successfully Logged</H2>";
}

#############
# admin_search_hours_form takes a hash with the following values
#
# remote_user is the user from the REMOTE_USER ENV var
# client_name is the name of the currently selected client, NOT ID
# client_id is the unique ID for the client
# today is today's date in dd/mm/yy format
# supers = reference to list of superusers
sub admin_search_hours_form {
    my %args = @_;
    my $superref = $args{'supers'};
    my @supers = @$superref;
    my %yes_no_labels = ('y',' Yes','n',' No', 'any', 'Any');
    my %client_labels = ($args{'client_id'}, $args{'client_name'},'any','Any Client');
    # push something onto supers to give them the "any" option
    push @supers, "any";

    # generate some widgets
    my %widgets;
    $widgets{'fkpersonnel_id'} = textfield('-name'=>'fkpersonnel_id',
					   '-default'=>"",
					   '-size'=>12);

    $widgets{'fkjob_id'} = textfield('-name'=>'fkjob_id',
				     '-default'=>'',
				     '-override'=>1,
				     '-size'=>8);
  
    $widgets{'fkclient_id'} = popup_menu('-name'=>'fkclient_id',
					 '-values'=>[$args{'client_id'},'any'],
					 '-size'=>2,
					 '-default'=>"any",
					 '-override'=>1,
					 '-labels'=>\%client_labels);

    $widgets{'from_date'} = textfield('-name'=>'from_date',
				      '-size'=>10,
				      '-override'=>1,
				      '-value'=>'',
				      '-maxlength'=>10);

    $widgets{'to_date'} = textfield('-name'=>'to_date',
				    '-size'=>10,
				    'value'=>'',
				    '-override'=>1,
				    '-maxlength'=>10);
			
    $widgets{'billable'} = popup_menu('-name'=>'billable',
				      '-values'=>['y','n', 'any'],
				      '-default'=>'any',
				      '-override'=>1,
				      '-linebreak'=>'true',
				      '-labels'=>\%yes_no_labels);

    $widgets{'fksupervisor_id'} =  popup_menu('-name'=>'fksupervisor_id',
					      '-values'=>\@supers,
					      '-override'=>1,
					      '-default'=>"$args{'remote_user'}");

    $widgets{'output'} =  popup_menu('-name'=>'output',
				     '-values'=>['long', 'short'],
				     'defailt'=>'long',
				     '-override'=>1,
				     '-linebreak'=>'true');

    $widgets{'approved'} =  popup_menu('-name'=>'approved',
				       '-values'=>['y','n','any'],
				       '-default'=>'n',
				       '-override'=>1,
				       '-linebreak'=>'true',
				       '-labels'=>\%yes_no_labels),
  
    $widgets{'downloaded'} =  popup_menu('-name'=>'downloaded',
					 '-values'=>['y','n','any'],
					 '-default'=>'any',
					 '-override'=>1,
					 '-linebreak'=>'y',
					 '-labels'=>\%yes_no_labels),

    &subprint_file("$Conf::ADMIN_SEARCH_HOURS_TMPL", \%widgets);

}

sub user_search_hours_form {
    my %args = @_;
    my $superref = $args{'supers'};
    my @supers = @$superref;
    my %yes_no_labels = ('y',' Yes','n',' No', 'any', 'Any');
    my %client_labels = ($args{'client_id'}, $args{'client_name'},'any','Any Client');
    # push something onto supers to give them the "any" option
    push @supers, "any";
    
    # make widgets
    my %widgets;
    
    $widgets{'name'} = strong("$args{'remote_user'}");
    $widgets{'fkpersonnel_id'} = hidden('-name'=>'fkpersonnel_id',
					'-value'=>"$args{'remote_user'}",
					'-override'=>1);

    $widgets{'fkjob_id'} =  textfield('-name'=>'fkjob_id',
				      '-default'=>'',
				      '-override'=>1,
				      '-size'=>5);
    
    $widgets{'fkclient_id'} =  popup_menu('-name'=>'fkclient_id',
					  '-values'=>[$args{'client_id'},'any'],
					  '-size'=>2,	
					  '-default'=>"any",
					  '-labels'=>\%client_labels);

    $widgets{'from_date'} =  textfield('-name'=>'from_date',
				       '-size'=>8,
				       '-value'=>'',
				       '-maxlength'=>8);

    $widgets{'to_date'} =  textfield('-name'=>'to_date',
				     '-size'=>8,
				     '-value'=>'',
				     '-maxlength'=>8);
		    
    
    $widgets{'billable'} = popup_menu('-name'=>'billable',
				      '-values'=>['y','n', 'any'],
				      '-default'=>'any',
				      '-linebreak'=>'true',
				      '-labels'=>\%yes_no_labels);

    $widgets{'fksupervisor_id'} =  popup_menu('-name'=>'fksupervisor_id',
					      '-values'=>\@supers,
					      '-default'=>"any");

    $widgets{'approved'} =  popup_menu('-name'=>'approved',
				       '-values'=>['y','n','any'],
				       '-default'=>'n',
				       '-linebreak'=>'true',
				       '-labels'=>\%yes_no_labels);
    
    $widgets{'downloaded'} =  popup_menu('-name'=>'downloaded',
					 '-values'=>['y','n','any'],
					 '-default'=>'n',
					 '-linebreak'=>'y',
					 '-labels'=>\%yes_no_labels);
    
    $widgets{'output'} =  popup_menu('-name'=>'output',
				     '-values'=>['long', 'short'],
				     'defailt'=>'long',
				     '-linebreak'=>'true');

    &subprint_file("$Conf::USER_SEARCH_HOURS_TMPL", \%widgets);
}

#######################
# search_hours
#
# takes a hash containing any variables to search on and their value
# and returns the name of the temporary table the search return is
# stored in.
# it searched for:
# (fkclient_id, fkpersonnel_id, fkapprover_id,
#  fkjob_id, date, billable, approved,
#  downloaded)
#
# If any are blank it assumes a * match.
#
# the hash also contains:
# remote_user
#
sub search_hours {
    my %args = @_;
    my $sql;
    my $dbconn;
    my $oops;
    my $result;
    my $table;
    my @predicates;

    if (!$args{'remote_user'}) {
	&error("Web server problem: remote_user not passed to search_hours.");
    }
    $table = "h_s_$args{'remote_user'}";
    $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
    if (!$dbconn->is_ok) {
	$oops = $dbconn->errorstring;
	&error("Failed to perform search: $oops");
    }
    $dbconn->query("drop table $table;"); # tolerate errors

    $sql = "SELECT hours_id INTO table $table FROM hours, job WHERE ";

    #
    # construct our query WHERE clause into the @predicates list
    #

    # join
    push(@predicates, "hours.fkjob_id = job.job_id");
    # not deleted (all searches)
    push(@predicates, "del !~* 'y'");

    $args{'fkclient_id'} &&
	push(@predicates, "hours.fkclient_id = $args{'fkclient_id'}");

    if ($args{'fkpersonnel_id'}) {
	if ( $args{'super'} ) {
	    push(@predicates, "hours.fkpersonnel_id = '$args{'fkpersonnel_id'}'");
	} else {
	    push(@predicates, "hours.fkpersonnel_id = '$args{'fkpersonnel_id'}'");
	}
    }

    ($args{'fkapprover_id'}) &&
	push(@predicates, "hours.fkapprover_id ~* '$args{'fkapprover_id'}'");
    ($args{'hours_id'}) &&
	push(@predicates, "hours.hours_id = $args{'hours_id'}");
    ($args{'fksupervisor_id'}) &&
	push(@predicates, "job.fksupervisor_id ~* '$args{'fksupervisor_id'}'");
    ($args{'fkjob_id'}) &&
	push(@predicates, "hours.fkjob_id = $args{'fkjob_id'}");
    ($args{'from_date'}) &&
	push(@predicates, "hours.date_entered >= '$args{'from_date'}'");
    ($args{'to_date'}) &&
	push(@predicates, "hours.date_entered <= '$args{'to_date'}'");
    ($args{'billable'} eq "y") &&
	push(@predicates, "hours.billable = 1");
    ($args{'billable'} eq "n") &&
	push(@predicates, "hours.billable = 0");
    ($args{'downloaded'} eq "y") &&
	push(@predicates, "hours.downloaded = 'y'");
    ($args{'downloaded'} eq "n") &&
	push(@predicates, "hours.downloaded = 'n'");
    ($args{'approved'} eq "y") &&
	push(@predicates, "hours.approval_date > '$Conf::DUMMY_APPROVAL_DATE'");
    ($args{'approved'} eq "n") &&
	push(@predicates, "hours.approval_date = '$Conf::DUMMY_APPROVAL_DATE'");

    $sql .= join(' AND ', @predicates);

    $sql .= " ORDER BY hours.date_entered;";

    #DEBUG
    $Conf::DEBUG > 2 && warn("search_hours: $sql\n");

    $result = $dbconn->query("$sql");
    if (!$result) {
	$oops = $dbconn->errorstring;
	&error("Error doing search query: $oops", $sql);
    }
    return $table;
}

###############
# returns a indexed hash from the supplied temporary result table using 
# the supplied dbconn object.
#
# &get_hours_search_result($dbconn, $table);
sub get_hours_search_result {
    my $dbconn = shift;
    my $table = shift;
    my %results;
    my $i = 0;

    my @list = $dbconn->list('hours_id',$table);

    while ($i <= $#list) {
	my $temphours_id = $list[$i];
	$i++;
	$results{$i} = $temphours_id;
    }
    return %results;
}

##############
# returns the hours_id for the next hours record in the dataset
# &get_next_hours($hours_id, \%results)
sub get_next_hours {
    my $hours_id = shift;
    my $resultsref = shift;
    my $results = %$resultsref; 
    my $i = 1;
    while($results[$i]) {
	if ($results[$i] eq "$hours_id") {
	    return $results{$i + 1} if ($results{$i + 1});
	    return $results{$i};
	}
	$i++;
    }
    return 0;
}

##############
# same as get_next_hours but returns the previous one
sub get_prev_hours {
    my $hours_id = shift;
    my $hashref = shift;
    my %results = %$hashref;
    my $i = 1;
    while($results{$i}) {
	if ($$results{$i} eq "$hours_id") {
	    return $results{$i - 1} if ($results{$i - 1});
	    return $results{$i};
	}
	$i++;
    }
    return 0;
}


#######################
# &admin_show_hours_form(%hash)
#
# hash should contain all the information for the vars for the hours record
# including: fkclient_id, fkjob_id etc....
# also: 
#       hours_client_name (the client name for the hours entry)
#       hours_job_description (description of job_id this entry is for)
#       user_first_name
#       user_last_name
#       approved ="y' or "n" depending on wether or not it's approved
# if hours_id is not set in the hash, it defaults to printing a form
# for entry

sub admin_show_hours_form {
    my %args = @_;
    foreach $var ('remote_user','fkjob_id', 'hours_client_name',
		  'user_first_name', 'user_last_name','approved') {
	if (!$args{$var}) {
	    &error("Variable $var not passed to admin_show_hours_form");
	}
    }
    my $username = "$args{'user_first_name'} $args{'user_last_name'}";
    my %yes_no_labels = ('y',' Yes','n',' No',); 

    if ($args{'downloaded'} eq 'y') {
	$args{'dled'} = 'Downloaded';
    } else {
	$args{'dled'} = 'Not Downloaded';
    }

    # widget clobberin' time
    my %widgets;
    # first we print out our heading like a good little proggie
    print "User: ", strong($username), 
    " logged hours ($args{'hours_id'}) for client ",
    strong($args{'hours_client_name'}), p;
    

    my $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
    my $result = $dbconn->query("SELECT job_id, job_description, category FROM $Conf::JOB_DB WHERE open = 1 AND fkclient_id = $args{'fkclient_id'};");
    if (!$result) {
	my $oops = $dbconn->errorstring;
	&error("Unable to get job list: $oops");
    }
    my $rows = $result->get_num_rows;
    my $i = 0;
    my @jobs;
    my %joblabels;
    my $jobnumber = 0;
    while($i < $rows) {
	my $jid = $result->get_value($i, 'job_id');
	my $jdesc = $result->get_value($i, 'job_description');
	my $jcat = $result->get_value($i, 'category');
	$jcat =~ /^(...)/;
	$jcat = $1;
	$joblabels{$jid} = "$jid($jcat) $jdesc";
	$i++;
	$jobnumber++;
    }
    @jobs = sort keys %joblabels;
    $jobnumber = &get_box_size($jobnumber);
    my $label = '';
    foreach $label( keys %joblabels) {
	$joblabels{$label} = substr $joblabels{$label},0,47;
	if (length($joblabels{$label}) == 47) {
	    substr($joblabels{$label}, -3, 3) = '...'; 
	}
    }
      
    $widgets{'fkjob_id'} = popup_menu('-name'=>'fkjob_id',
				      '-values'=>\@jobs,
				      '-override'=>1,
				      '-default'=>"$args{'fkjob_id'}",
				      '-labels'=>\%joblabels);
    
    $widgets{'head'} = "($args{'fkjob_id'})$args{'hours_job_description'}($args{'dled'})";
    
    $widgets{'date_entered'} = textfield('-name'=>'date_entered',
					 '-default'=>"$args{'date_entered'}",
					 '-size'=>10,
					 '-override'=>1,
					 '-maxlength'=>10);
    
    $widgets{'time_in'} = textfield('-name'=>'time_in',
				    '-default'=>"",
				    '-size'=>7,
				    '-override'=>1,
				    '-maxlength'=>7,
				    '-default'=>"$args{'time_in'}");
    
    $widgets{'time_out'} = textfield('-name'=>'time_out',
				     '-default'=>"",
				     '-size'=>7,
				     '-override'=>1,
				     '-maxlength'=>7,
				     '-default'=>"$args{'time_out'}");
    
    $widgets{'total_hours'} = textfield('-name'=>'total_hours',
					'-default'=>"$args{'total_hours'}",
					'-size'=>4,
					'-override'=>1,
					'-maxlength'=>4);
    
    $widgets{'parking'} = textfield('-name'=>'parking',
				    '-default'=>"$args{'parking'}",
				    '-size'=>5,
				    '-override'=>1,
				    '-maxlength'=>5);

    $widgets{'billable'} = popup_menu('-name'=>'billable',
				      '-values'=>['y','n'],
				      '-default'=>"$args{'billable'}",
				      '-linebreak'=>'true',
				      '-override'=>1,
				      '-labels'=>\%yes_no_labels);
    
    $widgets{'approved'} = popup_menu('-name'=>'approved',
				      '-values'=>['y','n'],
				      '-default'=>"$args{'approved'}",
				      '-linebreak'=>'true',
				      '-override'=>1,
				      '-labels'=>\%yes_no_labels);
    
    $widgets{'hours_description'} = textarea('-name'=>'hours_description',
					     '-default'=>"$args{'hours_description'}",
					     '-rows'=>3,
					     '-override'=>1,
					     '-columns'=>50);
    
    $widgets{'comment'} = textarea('-name'=>'comment',
				   '-default'=>"$args{'comment'}",
				   '-override'=>1,
				   '-rows'=>3,
				   '-columns'=>50);

    &subprint_file("$Conf::ADMIN_SHOW_HOURS_TMPL", \%widgets);
}  


#############
sub user_show_hours_form {
    my %args = @_;
    foreach $var ('remote_user','hours_client_name',
		     'user_first_name',
		     'user_last_name','approved') {
	if (!$args{$var}) {
	    &error("Variable $var not passed to show_hours");
	}
    }
    my $username = "$args{'user_first_name'} $args{'user_last_name'}";
    my %yes_no_labels = ('y',' Yes','n',' No',); 
    
    if ($args{'downloaded'} eq 'y') {
	$args{'dled'} = 'Downloaded';
    } else {
	$args{'dled'} = 'Not Downloaded';
    }
    
    print "User: ", strong($username), 
    " logged hours ($args{'hours_id'}) for client ",
    strong($args{'hours_client_name'}), p;
    
    # make some widgets
    my %widgets;

    my $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
    my $result = $dbconn->query("SELECT job_id, job_description, category FROM $Conf::JOB_DB WHERE open = 1 AND fkclient_id = $args{'fkclient_id'};");
    if (!$result) {
	my $oops = $dbconn->errorstring;
	&error("Unable to get job list: $oops");
    }
    my $rows = $result->get_num_rows;
    my $i = 0;
    my @jobs;
    my %joblabels;
    my $jobnumber = 0;
    while($i < $rows) {
	my $jid = $result->get_value($i, 'job_id');
	my $jdesc = $result->get_value($i, 'job_description');
	my $jcat = $result->get_value($i, 'category');
	$jcat =~ /^(...)/;
	$jcat = $1;
	$joblabels{$jid} = "$jid($jcat) $jdesc";
	$i++;
	$jobnumber++;
    }
    @jobs = sort keys %joblabels;
    $jobnumber = &get_box_size($jobnumber);
    my $label = '';
    foreach $label( keys %joblabels) {
	$joblabels{$label} = substr $joblabels{$label},0,47;
	if (length($joblabels{$label}) == 47) {
	    substr($joblabels{$label}, -3, 3) = '...'; 
	}
    }
      
    $widgets{'fkjob_id'} = popup_menu('-name'=>'job_id',
				      '-values'=>\@jobs,
				      '-default'=>"$args{'fkjob_id'}",
				      '-override'=>1,
				      '-labels'=>\%joblabels);
    
    $widgets{'head'} = "$args{'hours_job_description'} $args{'dled'}",

    $widgets{'date_entered'} = textfield('-name'=>'date_entered',
					 '-default'=>"$args{'date_entered'}",
					 '-size'=>10,
					 '-override'=>1,
					 '-maxlength'=>10);
    
    $widgets{'time_in'} = textfield('-name'=>'time_in',
				    '-default'=>"",
				    '-size'=>7,
				    '-override'=>1,
				    '-maxlength'=>7,
				    '-default'=>"$args{'time_in'}");
    
    $widgets{'time_out'} = textfield('-name'=>'time_out',
				     '-default'=>"",
				     '-size'=>7,
				     '-override'=>1,
				     '-maxlength'=>7,
				     '-default'=>"$args{'time_out'}");
    
    $widgets{'total_hours'} = textfield('-name'=>'total_hours',
					'-default'=>"$args{'total_hours'}",
					'-size'=>4,
					'-override'=>1,
					'-maxlength'=>4);
    
    $widgets{'parking'} = textfield('-name'=>'parking',
				    '-default'=>"$args{'parking'}",
				    '-size'=>5,
				    '-override'=>1,
				    '-maxlength'=>5);

    $widgets{'billable'} = popup_menu('-name'=>'billable',
				      '-values'=>['y','n'],
				      '-default'=>"$args{'billable'}",
				      '-linebreak'=>'true',
				      '-override'=>1,
				      '-labels'=>\%yes_no_labels);
    
    $widgets{'approved'} = popup_menu('-name'=>'approved',
				      '-values'=>['y','n'],
				      '-default'=>"$args{'approved'}",
				      '-linebreak'=>'true',
				      '-override'=>1,
				      '-labels'=>\%yes_no_labels);
    
    $widgets{'hours_description'} = textarea('-name'=>'hours_description',
					     '-default'=>"$args{'hours_description'}",
					     '-rows'=>3,
					     '-override'=>1,
					     '-columns'=>50);
    
    $widgets{'comment'} = textarea('-name'=>'comment',
				   '-default'=>"$args{'comment'}",
				   '-override'=>1,
				   '-rows'=>3,
				   '-columns'=>50);
    
    if ($args{'approved'} eq 'y') {
	$widgets{'approved'} = strong("Yes");
    } else {
	$widgets{'approved'} = strong("No");
    }
    
    &subprint_file("$Conf::USER_SHOW_HOURS_TMPL", \%widgets);
}

 
#######################
# &approve_hours($dbconn, $hours_id, $approver_id) approves the hours_id passed to it
#
sub approve_hours {
    my $dbconn = shift;
    my $hours_id = shift;
    my $approver = shift;
    &error("approve_hours: hours_id not passed") if (!$hours_id);
    &error("approve_hours: dbconn not passed") if (!$dbconn);
    my $result;
    my $oops;
    my $approval_date = &dbdate_today;
    $result = $dbconn->query("Update $Conf::HOURS_DB SET approval_date = '$approval_date', fkapprover_id = '$approver' WHERE hours_id = $hours_id;");
    if (!$result) {
	$oops = $dbconn->errorstring;
	&error("Failure to approve hours: $oops");
    }
    return 1;
}

sub hours_join {
    my $dbconn = shift;
    my $hours_entry = shift;
    if (!$hours_entry) {
	&error("Hours_join not passed hours_id for requested record");
    }
    my $sql = "SELECT HR.*, U.last_name as user_last_name," .
	"U.first_name as user_first_name," .
        "JB.job_description as hours_job_description," .
	"CL.client_name as hours_client_name FROM $Conf::HOURS_DB HR," .
	"$Conf::USER_DB U, $Conf::JOB_DB JB," .
	"$Conf::CLIENT_DB CL WHERE HR.hours_id = $hours_entry " .
	"AND CL.client_id = JB.fkclient_id " .
        "AND JB.job_id = HR.fkjob_id " .
	"AND U.personnel_id = HR.fkpersonnel_id;";
    my $sqlresult = $dbconn->query($sql);
    if (!$sqlresult) {
	my $oops = $dbconn->errorstring;
	&error("Error getting hours $hours_entry join: $oops", $sql);
    }
    my $numrows = $sqlresult->get_num_rows;
    if (!$numrows) {
	&user_error("Empty Hours Entry Query");
    }
    my %hours_info = $sqlresult->get_row(0);
    return %hours_info;
}


sub print_hours_commands {
    my %state = @_;
    print "<TABLE BORDER=0>",
    "<tr valign=\"top\">\n";
    # Print APPROVE button if it's not already approved
    # not already downloaded and if we're a supuser
    if (($state{'approved'} eq 'y') ||
	(!$state{'super'}) ||
	($state{'downloaded'} eq 'y')) {
	print "<TD>";
	print "<IMG SRC=\"images/approve_grey.gif\" BORDER=\"0\">";
	print "</TD>\n";
    } else {
	print"<TD>",
	"<INPUT TYPE=\"image\" NAME=\"approve\" SRC=\"images/approve.gif\" BORDER=0>\n",
	"</TD>\n";
    }
    # print our seperator
    print "<TD><IMG SRC=\"images/star.gif\" BORDER=\"0\"></TD>\n";
    
    # print the the APPLY button or greyed out if downloaded
    if (($state{'downloaded'} eq 'n')) {
	print "<TD>",
	"<INPUT TYPE=\"image\" NAME=\"apply\" SRC=\"images/apply.gif\" BORDER=0>\n",
	"</TD>";
    } else {
	print "<TD><IMG SRC=\"images/apply_grey.gif\" BORDER=\"0\"></TD>\n";
    }
    # print seperator
    print "<TD><IMG SRC=\"images/star.gif\" BORDER=\"0\"></TD>\n";
    
    # print delete button if it's not downloaded and
    # either we're a super, or we're user and it's not approved
    
    if (($state{'downloaded'} eq 'y') ||
	($state{'approved'} eq 'y' && !$state{'super'})) { 
	print "<TD><IMG SRC=\"images/delete_grey.gif\" BORDER=\"0\"></TD>\n";
    } else {
	print "<TD>\n",
	"<INPUT TYPE=\"image\" NAME=\"delete\" SRC=\"images/delete.gif\" BORDER=0>\n",
	"</TD>\n";
    }

    # print seperator
    print "<TD><IMG SRC=\"images/star.gif\" BORDER=\"0\"></TD>\n";
    print "<TD>";
    print "<INPUT TYPE=\"image\" NAME=\"search\" SRC=\"images/search.gif\" BORDER=0>\n",
    "</TD></TR>\n",
    "</TABLE>\n";
}

sub mail_notify { 
  my $href=shift; 
  my %info=%$href;
  my $to=shift; 
  open (MAIL, "| /usr/lib/sendmail $to") or die "Can't execute /usr/lib/sendmail\n"; 
  print MAIL "Subject: Hours logged for " . $info{fkclient_id} . "\n\n"; 
  print MAIL "Client: " . $info{fkclient_id} . "\n"; 
  print MAIL "Job: " . $info{fkjob_id} . "\n"; 
  print MAIL "Logged by: " . $info{fkpersonnel_id} . "\n"; 
  print MAIL "Date: " . $info{date_entered} . "\n"; 
  print MAIL "Time in: " . $info{time_in} . "\n"; 
  print MAIL "Time out: " . $info{time_out} . "\n"; 
  print MAIL "Parking: " . $info{parking} . "\n" if $info{parking}; 
  print MAIL "Total Hours: " . $info{total_hours} . "\n"; 
  print MAIL "Billable: "; 
  if ($info{billable} ) { 
    print MAIL "Y\n"; 
  } else { 
    print MAIL "N\n";
  }
  print MAIL "Description\n===========\n" . $info{hours_description} . "\n"; 
  print MAIL "Comment\n=======\n" . $info{comment} . "\n" if ($info{comment}); 
  close MAIL; 
}
  

1; 
