#
# user-funcs.pl
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# 
# $Id: user-funcs.pl,v 1.18 2001/08/29 22:23:03 adam Exp $
#

use CGI qw(:standard);
use ADB;

###########################################################
###########################################################
# ARGV[0] = true for edit, false for new.
sub add_user_entry {
    my $edit = shift @_;
    my $add_button = shift @_;
    my $edit_button = shift @_;
    my $del_button = shift @_;

    my $super = 'n';
    if ( $edit ) {
	my $personnel_id = param('personnel_id');
	if ( ! $personnel_id && ! $edit ) {
	    &user_error("You did not choose a user to modify!");
	}
	my $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
	if ( ! $dbconn->is_ok ) {
	    my $oops = $dbconn->errorstring;
	    &error("Cannot connect to backend: $oops");
	}
	my $user_rec;
	my $result;
	if ( $personnel_id && param('editor') ) {
	    $result = $dbconn->query("Select personnel_id, first_name, last_name from $Conf::USER_DB WHERE $Conf::USER_DB_KEY = '$personnel_id';");
	}
	elsif ( $personnel_id ) {
	    $result = $dbconn->query("Select personnel_id, first_name, last_name from $Conf::USER_DB WHERE $Conf::USER_DB_KEY ~* '$personnel_id';");
	}
	else {
	    $result = $dbconn->query("Select personnel_id, first_name, last_name from $Conf::USER_DB");
	}
	if ( ! $result ) {
	    my $oops = $dbconn->errorstring;
	    &error("error in add_user_entry selecting records: $oops");
	}
	my $rows = $result->get_num_rows;
	if ( ! $rows ) {
	    &error("no user found with the name $personnel_id");
	}
	if ( $rows > 1 ) {
	    print "<INPUT TYPE=\"hidden\" NAME=\"list\" VALUE=\"1\">\n";
	    print "<H2>Select a User:</H2>\n";
	    my $i = 0;
	    my $id;
	    my $lab;
	    my %labels;
	    my @named;
	    while ( $i < $rows ) {
		$id = $result->get_value($i, 'personnel_id');
		$lab = "$id: ";
		$lab .= $result->get_value($i, 'first_name');
		$lab .= $result->get_value($i, 'last_name');
		$labels{$id} = $lab;
		$i++;
	    }
	    @names = keys %labels;

	    print scrolling_list('-name'=>'personnel_id',
				 '-values'=>\@names,
				 '-default'=>"$personnel_id",
				 '-size'=>'5',
				 '-multiple'=>'',
				 '-labels'=>\%labels);

	    if ( $edit_button ) {
		print '<INPUT TYPE="hidden" NAME="editor" value="editlist">';
		print '<P><INPUT NAME="choose" VALUE="Select User" TYPE="image" SRC="images/edituser.gif" BORDER=0 ALT="[Edit User]">',"\n";	
	    }
	    elsif ( $del_button ) {
		print '<INPUT TYPE="hidden" NAME="deleter" value="dellist">';
		print '<INPUT TYPE="hidden" NAME="delme" value="askfirst">';
		print '<P><INPUT NAME="choose" VALUE="Select User" TYPE="image" SRC="images/deleteuser.gif" BORDER=0 ALT="[Delete User]">',"\n";	
	    }
	    return;
	}

	if ( (param('delme') eq 'askfirst') && ! $add_button && 
	     ! $edit_button ) {
	    print "<HR SIZE=3>";
	    print "<H2>Are you sure that you want to delete $personnel_id?</H2>";
	    print "<HR SIZE=3>";
	}

	$personnel_id = $result->get_value(0, 'personnel_id');	
	unless ( $user_rec = $dbconn->get_record($Conf::USER_DB_KEY, $personnel_id,
					       $Conf::USER_DB) ) {
	    my $oops = $dbconn->errorstring;
	    &error("add_user_entry: getting mod_user record: $oops");
	}
	my %mod_user = %$user_rec;
	foreach (keys %mod_user) {
	    unless ( $_ eq 'super_user' ) {
		param($_, $mod_user{$_});
	    }
	}
	# gotta set superuser radio here and in else
	$super = $mod_user{'super_user'} eq '0' ? 'n' : 'y';
	# and toss in a radio button to see if they want to change the password.
    }
    else {
	$super = 'n';
    }

    my %yes_no_labels = ('y',' yes','n',' no',);      
    print "\n", 
    "<TABLE BORDER=0>\n<TR WIDTH=640>\n",
    "<TD WIDTH=50%>\n",
    strong("User Name"),
    "</TD>\n<TD WIDTH=50%>\n",
    strong("Email Address"), br, "\n",
    "</TD>\n</TR>\n<TR>\n<TD>\n";
    
    if ( $edit ) {
	print "\n",
	"<TABLE BORDER=0>\n<TR>\n<TD>\n",
	"<FONT SIZE=+2><TT>", param('personnel_id'), "</TT></FONT>\n";
	print hidden(-name=>'personnel_id',
		     -default=>param('personnel_id'));
	print "</TD>\n<TD>\n";
	&help_button('username');
	print "</TD>\n</TR>\n</TABLE>\n";

	print "</TD>\n";
	print "<TD>\n",
	"<TABLE BORDER=0>\n<TR>\n<TD>\n",
	"\n",
	textfield(-name=>'email',
		  -default=>param('email'),
		  '-size'=>25,
		  '-maxlength'=>70),
	"</TD>\n<TD>\n";
	&help_button('useremail');
	print "</TD>\n</TR>\n</TABLE>\n";
	print "</TD>\n</TR>\n</TABLE>\n";
    }
    else {
	print "\n",
	"<TABLE BORDER=0>\n<TR>\n<TD>\n",
	textfield('-name'=>'personnel_id',
		  '-default'=>"",
		  '-size'=>12,
		  '-maxlength'=>12), "\n",      
	"</TD>\n<TD>\n";
	&help_button('username');
	print "</TD>\n</TR>\n</TABLE>\n";

	print "</TD>\n";
	print "<TD>\n",
	"<TABLE BORDER=0>\n<TR>\n<TD>\n",
	"\n",
	textfield(-name=>'email',
		  -default=>"",
		  '-size'=>25,
		  '-maxlength'=>70),
	"</TD>\n<TD>\n";
	&help_button('useremail');
	print "</TD>\n</TR>\n";
	print "</TABLE>\n";
	print "</TD>\n</TR>\n";
	print "</TABLE>\n";
    }

    print "\n", "<TABLE BORDER=0>\n<TR>\n<TD>\n",
    strong("First Name"),
    "\n", 
    "</TD>\n<TD>\n",                                         
    strong("Middle Name"),
    "\n", 
    "</TD>\n<TD>\n",
    strong("Last Name"),
    "\n", 
    "</TD>\n</TR>\n",
    br, "\n",
    "<TD>\n",
    textfield('-name'=>'first_name',
	      '-default'=>"$mod_user{'first_name'}",
	      '-size'=>15,
	      '-maxlength'=>15),
    "\n</TD>\n<TD>\n",

    textfield('-name'=>'middle_name',
	      '-default'=>"$mod_user{'middle_name'}",
	      '-size'=>12,
	      '-maxlength'=>12),
    "\n</TD>\n<TD>\n",

    textfield('-name'=>'last_name',
	      '-default'=>"$mod_user{'last_name'}",
	      '-size'=>15,
	      '-maxlength'=>15),
    "</TD>\n<TD>\n";
    &help_button('userfullname');

    print "\n</TD>\n</TR>\n</TABLE>\n<P>";

    print strong("Administrator"),
    br, "\n",
    "<TABLE BORDER=0>\n<TR>\n<TD>\n",
    radio_group('-name'=>'super_user',
		'-values'=>['y','n'],
		'-default'=>$super,
		'-linebreak'=>'0',
		'-labels'=>\%yes_no_labels),
    "</TD><TD>";
    &help_button('admin');
    print "</TD>\n</TABLE>\n",
    "\n", p, "\n";


    if ( $edit && $edit_button ) {
	print strong("Do you want to change this user's password?\n"),
	br, 
	"The old password is not printed because it is stored in encrypted form. You ",
	i("must"),
	" choose 'yes' if you wish to change the user's password.\n",
	br,
	radio_group('-name'=>'change_pass',
		    '-values'=>['y','n'],
		    '-default'=>'n',
		    '-linebreak'=>'true',
		    '-labels'=>\%yes_no_labels), p,
	strong("New Password");
    }
    elsif ( $edit_button || $add_button ) {
	print strong("Password for new user");
    }
    
    if ( $edit_button || $add_button ) {
	print br, "\n",
	"<TABLE BORDER=0><TR><TD>\n",
	password_field('-name'=>'password1',
		       '-value'=>'',
		       '-size'=>12),
	"\n</TD><TD>\n",
	password_field('-name'=>'password2',
		       '-value'=>'',
		       '-size'=>12),
	"\n</TD><TD>";
	&help_button('password');

	print "</TD></TR></TABLE>\n<P>\n";
    }
    if ( $add_button ) {
	print '<INPUT NAME="create" TYPE="image" SRC="images/createnewuser.gif"',
	'BORDER=0 ALT="[Create New User]">', "\n";
    }

    print end_form;                                                    
}

###########################################################
###########################################################
# ARGV[0] = 
# ARGV[1] = 
sub add_user_data {
    my $edit = shift @_;
    # Make sure that the user does not already exist
    # Confirm that Data is OK.
    # stuff database.
    # stuff .htpasswd file
    # Notify that all went well.
    my $error = '';
    
    # 1. make sure user doesn't already exist;  won't hurt to check the database too

    # downcase and normalize the userid
    my $userid = param('personnel_id');
    $userid =~ tr/A-Z/a-z/;
    $userid =~ s/^\s+//;
    $userid =~ s/\s+$//;
    if ( ! $edit ) {
	if ( &isa_ht_user($userid) || &isa_db_user($userid) ) {
	    $error .= li("User " . $userid . " already exists!");
	}
    }

    # 2. confirm that data is OK.
    $error .= li(&check_alnum($userid, "Username", 1))
	if &check_alnum($userid, "Username", 1);

    if ( param('email') eq '' ) {
	$error .= li("You must fill out the 'Email Address' field");
    }
    if ( param('first_name') eq '' ) {
	$error .= li("You must fill out the 'First Name' field");
    }
    if ( param('last_name') eq '' ) {
	$error .= li("You must fill out the 'Last Name' field");
    }
    unless ( param('super_user') eq 'y' || param('super_user') eq 'n' ) {
	$error .= li("You must check 'yes' or 'no' for the 'Superuser' field");
    }

    # lets be good and strip leading/trailing whitespace
    my $var = '';
    foreach $var ('email', 'first_name','middle_name','last_name','password1','password2') {
	my $tmp = '';
	$tmp = param($var);
	$tmp =~ s/^\s+//;
	$tmp =~ s/\s+$//;
	param($var,$tmp);# = $tmp;
    }

    # check password
    if ( ! $edit || (param('change_pass') eq 'y') ) {
	if ( param('password1') ne param('password2') ) {
	    $error .= li("Passwords do not match!");
	}
	else {
	    $error .= &check_pass(param('password1'));
	}
    }
    if ( $error ne '' ) {
	&user_error($error);
    }        
    
    # 3. stuff the database entry.
    my $err = '';
    my $superbool = param('super_user') eq 'n' ? '0' : '1';
    
    # stuff an assoc array first
    my %new = ();
    # make a new connection to the SQL backend 
    $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
	my $oops = $dbconn->errorstring;
	&error("Cannot connect to backend: $oops");
    }
    if ( $edit ) {
	if ( %new = $dbconn->get_record($Conf::USER_DB_KEY,$userid,$Conf::USER_DB) ) {
	    $new{'first_name'}	= param('first_name');
	    $new{'middle_name'}	= param('middle_name');
	    $new{'last_name'}	= param('last_name');
	    $new{'email'}	= param('email');
	    $new{'super_user'}	= $superbool;
	} else {
	    my $oops = $dbconn->errorstring;
	    &error("backend error getting record: $oops");
	}

    }
    else {
	$new{'personnel_id'} = $userid;
	$new{'first_name'} = param('first_name');
	$new{'middle_name'} = param('middle_name');
	$new{'last_name'} = param('last_name');
	$new{'email'} = param('email');
	$new{'super_user'} = $superbool;
    }

    #escape it all
    &scrub_hash(\%new);

    my $result;
    # BEWARE THE UNHOLY unless()
    if ( $edit ) {
	unless ( $result = $dbconn->query("UPDATE $Conf::USER_DB set first_name = '$new{'first_name'}', middle_name = '$new{'middle_name'}', last_name = '$new{'last_name'}', email = '$new{'email'}', super_user = '$new{'super_user'}' WHERE personnel_id = '$userid';") )
	{
	    my $oops = $dbconn->errorstring;
	    &error("Update error: $oops");
	}
    } else {
	$result = 0;
	unless ( $result = $dbconn->insert_record($Conf::USER_DB_KEY,$Conf::USER_DB,\%new))
	{
	    my $oops = $dbconn->errorstring;
	    &error("Error inserting record: $oops", join(', ', %new));
	}
    }
    $dbconn->close;

    # 4. stuff .htpasswd
    if ( $edit ) {
	if ( param('change_pass') eq 'y' ) {
	    &mod_ht_user($userid, param('password1'));
	}
    }
    else {
	&add_ht_user($userid,param('password1'));
    }

    # 5. notify that all went well
    if ( $edit ) {
	print "<H2>User $userid Edited</H2>\n";
    } else {
	print "<H2>User $userid Added</H2>\n";
    }
    print "<HR SIZE=3>";
}

###########################################################
###########################################################
sub del_user_pick {
    my @users = ();
    my $count_user = 0;
    my %userlabels = ();
#   my $userlist = Timesheet->new;
#   $userlist->grab_all($Conf::USER_DB);
#   print h2("Please check the client(s) that you wish to delete, or the "), p;
#   foreach $keys  (keys %{$userlist}) {
#     $count_user++;
#      $userlabels{$userlist->{$keys}->{'userkey'}} = 
#	  " " . $userlist->{$keys}->{'namefirst'} . " " .
#	      $userlist->{$keys}->{'namemiddle'} . " " . 
#		  $userlist->{$keys}->{'namelast'} . " (userid: " . 
#		      $userlist->{$keys}->{'userkey'} . ")\n";
#     push @users, $userlist->{$keys}->{'userkey'};
#   }
#   @users = sort @users;
#   $count_user = &get_box_size($count_user);
#   print scrolling_list('-name'=>'user_list',
#			'-values'=>\@users,
#			'-default'=>'',
#			'-size'=>$count_user,
#			'-multiple'=>1,
#			'-labels'=>\%userlabels,
#		       );
    print p,
    "\n", p, "\n",                             
    submit('-name'=>'action',
	   '-value'=>$Conf::DEL_USER_SUBMIT),
    submit('-name'=>'action',
	   '-value'=>$Conf::EDIT_USER),
    end_form;                                                    
}

###########################################################
###########################################################
sub del_user_submit {
    my $del_user = param('personnel_id');
    my $userdel = ();
    my $var = '';
    unless ( $del_user ) {
	&user_error("You did not choose any users to delete");;
	exit 0;
    }
    my $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
	my $oops = $dbconn->errorstring;
	&error("Cannot connect to backend: $oops");
    }
    if ( my $result = $dbconn->query("DELETE from $Conf::USER_DB where $Conf::USER_DB_KEY = '$del_user';" ) )
    {
	&del_ht_user($del_user);
	print h2("User $del_user successfully deleted");
	print "<HR SIZE=3>";
    }
    else {
	my $oops = $dbconn->errorstring;
	&error("Error deleting record for $del_user: $oops");
    }
}

###########################################################
###########################################################
sub reset_all_params {
    param('personnel_id', '');
    param('email'       , '');
    param('first_name'  , '');
    param('middle_name' , '');
    param('namemiddle'  , '');
    param('last_name'   , '');
    param('password1'   , '');
    param('password2'   , '');
    param('super_user'  , 'n');
}

#############
# admin_search_jobs_form takes a hash with the following values
#
# remote_user is the user from the REMOTE_USER ENV var
# client_name is the name of the currently selected client, NOT ID
# client_id is the unique ID for the client
# today is today's date in dd/mm/yy format
# supers = reference to list of superusers
sub admin_search_user_form
{
    my %args = @_;
    my %yes_no_labels = ('y',' Yes','n',' No', 'any', 'Any');
    my %vars;

    $vars{'user_name_widget'} = textfield('-name'=>'personnel_id',
					  '-size'=>'10',
					  '-override'=>'1');

    $vars{'first_name_widget'} = textfield('-name'=>'first_name',
					   '-default'=>"",
					   '-override'=>'1',
					   '-size'=>'15');
    
    $vars{'middle_name_widget'} = textfield('-name'=>'middle_name',
					    '-default'=>"",
					    '-override'=>'1',
					    '-size'=>'12');

    $vars{'last_name_widget'} = textfield('-name'=>'last_name',
					  '-default'=>"",
					  '-override'=>'1',
					  '-size'=>'15');

    $vars{'email_widget'} = textfield('-name'=>'email',
				      '-default'=>"",
				      '-override'=>'1',
				      '-size'=>'25');
    
    $vars{'change_pass_widget'} = popup_menu('-name'=>'change_pass',
					     '-values'=>['y','n'],
					     '-default'=>'n',
					     '-override'=>'1',
					     '-labels'=>('y','Yes','n','No'));
    

    $vars{'super_user_widget'} = popup_menu('-name'=>'super_user',
					    '-values'=>['y','n','any'],
					    '-default'=>'any',
					    '-override'=>'1',
					    '-linebreak'=>'true',
					    '-labels'=>\%yes_no_labels);
    
    &subprint_file("$Conf::USER_SEARCH_TMPL", \%vars);
}

sub search_user {
    my %args = @_;
    my $sql;
    my $dbconn;
    my $oops;
    my $result;
    my $table;
    my $notfirst = 0;

    $table = "u_s_$args{'remote_user'}";
    $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
	$oops = $dbconn->errorstring;
	&error("Failed to perform search: $oops");
    }
    $dbconn->query("DROP TABLE $table;");
    $dbconn->query("create table $table (personnel_id text);");
    $sql = "insert into $table select personnel_id FROM $Conf::USER_DB ";


    if ( $args{'first_name'} ) {
	if ( $notfirst == 0 ) {
	    $notfirst = 1;
	    $sql .= "WHERE first_name ~* '$args{'first_name'}' ";
	} else {
	    $sql .= "AND first_name ~* '$args{'first_name'}' ";
	}
    }
    if ( $args{'personnel_id'} ) {
	if ( $notfirst == 0 ) {
	    $notfirst = 1;
	    $sql .= "WHERE personnel_id ~* '$args{'personnel_id'}' ";
	} else {
	    $sql .= "AND personnel_id ~* '$args{'personnel_id'}' ";
	}
    }

    if ( $args{'last_name'} ) {
	if ( $notfirst == 0 ){
	    $notfirst = 1;
	    $sql .= "WHERE last_name ~* '$args{'last_name'}' ";
	} else {
	    $sql .= "AND last_name ~* '$args{'last_name'}' ";
	}
    }

    if ( $args{'middle_name'} ) {
	if ( $notfirst == 0 ) {
	    $notfirst = 1;
	    $sql .= "WHERE middle_name ~* '$args{'middle_name'}' ";
	} else {
	    $sql .= "AND middle_name ~* '$args{'middle_name'}' ";
	}
    }

    if ( $args{'email'} ) {
	if ( $notfirst == 0 ) {
	    $notfirst = 1;
	    $sql .= "WHERE email ~* '$args{'email'}' ";
	} else {
	    $sql .= "AND email ~* '$args{'email'}' ";
	}
    }

    if ( $args{'super_user'} eq "y" ) {
	if ( $notfirst == 0 ) {
	    $notfirst = 1;
	    $sql .= "WHERE super_user = '1' ";
	} else {
	    $sql .= "AND super_user = '1' ";
	}
    }
    if ( $args{'super_user'} eq "n" ) {
	if ( $notfirst == 0 ) {
	    $notfirst = 1;
	    $sql .= "WHERE super_user = '0' ";
	} else {
	    $sql .= "AND super_user = '0' ";
	}
    }

    $sql .= ";";
    $result = $dbconn->query("$sql");
    if ( ! $result ) {
	$oops = $dbconn->errorstring;
	&error("Error doing search query: $oops", $sql);
    }

    return $table;
}

###############
# returns a indexed hash from the supplied temporary result table using 
# the supplied dbconn object.
#
# &get_job_search_result($dbconn, $table);
sub get_user_search_result {
    my $dbconn = shift;
    my $table = shift;
    my %results;
    my $i = 0;

    my @list = $dbconn->list('personnel_id',$table);

    while ( $i <= $#list ) {
	my $tempjob_id = $list[$i];
	$i++;
	$results{$i} = $tempjob_id;
    }
    return %results;
}



sub admin_show_user_form {
    my %args = @_;
    my %yes_no_labels = ('y',' Yes','n',' No'); 
    my %vars;
    $vars{'user_name_widget'} = "$args{'personnel_id'}";
    
    $vars{'first_name_widget'} = textfield('-name'=>'first_name',
					   '-default'=>"$args{'first_name'}",
					   '-override'=>'1',
					   '-size'=>'15');
    
    $vars{'middle_name_widget'} = textfield('-name'=>'middle_name',
					    '-default'=>"$args{'middle_name'}",
					    '-override'=>'1',
					    '-size'=>'12');
    
    $vars{'last_name_widget'} = textfield('-name'=>'last_name',
					  '-default'=>"$args{'last_name'}",
					  '-override'=>'1',
					  '-size'=>'15');
    
    $vars{'email_widget'} = textfield('-name'=>'email',
				      '-default'=>"$args{'email'}",
				      '-override'=>'1',
				      '-size'=>'25');
    
    $vars{'change_pass_widget'} = popup_menu('-name'=>'change_pass',
					     '-values'=>['y','n'],
					     '-default'=>'n',
					     '-override'=>'1',
					     '-labels'=>('y','Yes','n','No'));
    
    $vars{'super_user_widget'} = popup_menu('-name'=>'super_user',
					    '-values'=>['y','n'],
					    '-default'=>"$args{'super_user'}",
					    '-override'=>'1',
					    '-linebreak'=>'true',
					    '-labels'=>\%yes_no_labels);
    
    &subprint_file("$Conf::USER_EDIT_TMPL", \%vars);
}  


sub user_join {
    my $dbconn = shift;
    my $personnel_entry = shift;
    
    my $sql = "SELECT *";
    $sql .= " FROM $Conf::USER_DB WHERE ";
    $sql .= " personnel_id = '$personnel_entry'; ";
    
    my $sqlresult = $dbconn->query($sql);
    if ( ! $sqlresult ) {
	my $oops = $dbconn->errorstring;
	&error("Error getting user $personnel_entry in user_join: $oops", $sql);
    }
    my %personnel_info = $sqlresult->get_row(0);
    return %personnel_info;
}



sub print_user_commands {
    my %state = @_;
    print "<TABLE BORDER=0>",
    "<tr valign=\"top\">\n";
    print "<TD>",
    "<INPUT TYPE=\"image\" NAME=\"apply\" SRC=\"images/apply.gif\" BORDER=0>\n",
    "</TD>";
    
    # Print seperator
    print "<TD><IMG SRC=\"images/star.gif\" BORDER=\"0\"></TD>\n";
    
    print "<TD>\n",
    "<INPUT TYPE=\"image\" NAME=\"delete\" SRC=\"images/delete.gif\" BORDER=0>\n",
    "</TD>\n";

    # Print seperator
    print "<TD><IMG SRC=\"images/star.gif\" BORDER=\"0\"></TD>\n";
    print "<TD>";
    print "<INPUT TYPE=\"image\" NAME=\"search\" SRC=\"images/search.gif\" BORDER=0>\n",
    "</TD></TR>\n",
    "</TABLE>\n";
}




###########################################################
###########################################################
# ARGV[0] = plaintext passwd
sub check_pass {
    my $passwd = shift @_;
    my $err = '';
    $passwd = substr($passwd,0,8);
    if ( $passwd !~ /.{6,12}/ ) {
	$err .= li("Your password MUST be at LEAST 6 characters long.\n");
    }
    if ( $passwd !~ /(\W|[0-9])/ ) {
	$err .= li("Your password MUST contain a non-alphabetic character.\n");
    }
    return $err;
}

###########################################################
###########################################################
# ARGV[0] = username/userid
# ARGV[1] = plaintext passwd
sub crypt_pass {
    my ($username, $passwd) = @_;
    my $now = time;
    my ($p1,$p2) = unpack("C2", $username);
    srand();
    my $pepper = rand(65536);
    my $salt = (($pepper * $p1) - $p2) + $$;
    return crypt($passwd,$salt);
}



###########################################################
###########################################################
# ARGV[0] = username/userid
# ARGV[1] = plaintext passwd
sub add_ht_user {
    my ($user,$pass) = @_;
    my $cryptpass = &crypt_pass($user,$pass);
    open (PASS, ">> $Conf::PASSFILE") ||
	&error("Cannot open $Conf::PASSFILE for writing: $!");
    print PASS "$user:$cryptpass\n";
    close(PASS);
    return 1;
}

###########################################################
###########################################################
# ARGV[0] = username/userid
sub del_ht_user {
    my $user = shift @_;
    if ( ! $user || ($user =~ /^\s+$/) ) {
	&error("Attempt to delete invalid username");
    }
    my @all_users = ();
    open (OLDPASS, "$Conf::PASSFILE") ||
	&error("Cannot open $Conf::PASSFILE for writing: $!");
    while (<OLDPASS>) {
	push @all_users, $_;
    }
    close(OLDPASS);
    open (NEWPASS, "> $Conf::PASSFILE") ||
	&error("Cannot open $Conf::PASSFILE for writing: $!");
    foreach $pair (@all_users) {
	unless ($pair =~ /^$user/) {
	    print NEWPASS $pair;
	}
    }
    close (NEWPASS);
    return 1;
}

###########################################################
###########################################################
# ARGV[0] = username/userid
sub mod_ht_user {
  my $found=0; 
  my ($user,$pass) = @_;
  if ( !$user || ($user =~ /^\s+$/) ) {
    &error("Attempt to modify invalid username: $user");
  }
  my @all_users = ();
  open (OLDPASS, "$Conf::PASSFILE") ||
    &error("Cannot open $Conf::PASSFILE for writing: $!");
  while (<OLDPASS>) {
    push @all_users, $_;
  }
  close(OLDPASS);
  my $cryptpass = &crypt_pass($user,$pass);
  
  open (NEWPASS, "> $Conf::PASSFILE") ||
    &error("Cannot open $Conf::PASSFILE for writing: $!");
  foreach $pair (@all_users) {
    if ($pair =~ /^$user:/) {
      print NEWPASS "$user:$cryptpass\n";
      $found=1;
    }
    else {
      # we do this in case there's no trailing newline 
      my ($name, $pass)=split(/:/, $pair); 
      chomp $pass; 
      print NEWPASS "$name:$pass\n";
    }
    unless ($found) { 
      print NEWPASS "$user:$cryptpass\n";
    }
  }
  close (NEWPASS);
  return 1;
}

sub isa_ht_user {
    my $user = shift @_;
    my ($passuser, $passwd) = '';
    open (PASS, $Conf::PASSFILE) || &error("Cannot open $Conf::PASSFILE: $!");
    while (<PASS>) {
	($passuser,$passwd) = split(/:/, $_);
	if ($passuser eq $user) {
	    close(PASS);
	    return 1;
	}
    }
    close(PASS);
    return 0;
}

sub isa_db_user {
    my $newuser = shift @_;
    my $result;
    my $db = new ADB($Conf::DBADDR, $Conf::SQLDB);
    if ( ! $db->is_ok ) {
	my $oops = $db->errorstring;
	&error("Cannot connect to backend: $oops");
    }
    # note that a zero return value is just a no-match (not necessarily an error)
    $result = $db->get_record($Conf::USER_DB_KEY, $newuser, $Conf::USER_DB);
    $db->close;

    if ( $$result{$Conf::USER_DB_KEY} eq $newuser ) {	
	return 1;
    }
    return 0;
}


1;
