#!/usr/bin/perl
#
# popup-users.cgi
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# $Id: popup-users.cgi,v 1.8 2001/08/29 22:22:45 adam Exp $ 
# 
#use strict qw(refs vars);
use CGI qw(:standard);
require 'etc/timesheet.conf';
require 'lib/common-funcs.pl';


&time_head("User Functions");

my $do_client = $ENV{'QUERY_STRING'};

my $dbconn = new ADB($Conf::DBADDR, $Conf::SQLDB);

if ( ! $do_client ) {
    print <<EOT;
<CENTER>
<FORM NAME="userpop" METHOD="POST" ACTION="userreport.cgi" TARGET="se">
EOT
    print "<H2>Select a User</H2>\n";   
   
    my $user_rec;
    my $result;
    my $sql = "select personnel_id, first_name, last_name from $Conf::USER_DB";
    $result = $dbconn->query($sql);
    if ( ! $result ) {
	my $oops = $dbconn->errorstring;
	&error("Error selecting user records: $oops", $sql);
    }
    my $rows = $result->get_num_rows;
    if ( ! $rows ) {
	&user_error("No users matched your query", $sql);
    }
    print "<INPUT TYPE=\"hidden\" NAME=\"list\" VALUE=\"1\">\n";	
    my $i = 0;
    my $id;
    my $lab;
    my %labels;
    my @names;
    while ( $i < $rows ) {
	$id = $result->get_value($i, 'personnel_id');
	$lab = "$id: ";
	$lab .= $result->get_value($i, 'first_name');
        $lab .= " ";
	$lab .= $result->get_value($i, 'last_name');
	$labels{$id} = $lab;
	$i++;
    }
    @names = sort { $a cmp $b; } keys %labels;
    print popup_menu('-name'=>'personnel_id',
		     '-values'=>\@names,
		     '-default'=>"",
		     '-labels'=>\%labels);
}
else {
    print <<EOT;
<CENTER>
<FORM NAME="userpop" METHOD="POST" ACTION="jobnumreport.cgi" TARGET="se">
EOT
    print "<H2>Select a Job Number from Client $do_client</H2>\n";      
    my $client = $do_client;
    
    if ( $client ) {
	my $user_rec;
	my $result;
	my $sql = "select job_id, job_description, category from $Conf::JOB_DB WHERE fkclient_id = $client";
	$result = $dbconn->query($sql);
	if ( ! $result ) {
	    my $oops = $dbconn->errorstring;
	    &error("Error selecting job records: $oops", $sql);
	}
	my $rows = $result->get_num_rows;
	if ( ! $rows ) {
	    &user_error("No Jobs matched your query", $sql);
	}
	print "<INPUT TYPE=\"hidden\" NAME=\"list\" VALUE=\"1\">\n";	
	my $i = 0;
	my $id;
	my $lab;
	my %labels;
	my @names;
	while ( $i < $rows ) {
	    $id = $result->get_value($i, 'job_id');
	    $lab = "$id: ";
	    $lab .= $result->get_value($i, 'job_description');
	    $labels{$id} = $lab;
	    $i++;
	}
	@names = sort { $a <=> $b; } keys %labels;
	my $label = '';
	foreach $label( keys %labels ) {
	    $labels{$label} = substr $labels{$label},0,35;
	    if ( length($labels{$label}) == 35 ) {
		substr($labels{$label}, -3, 3) = '...'; 
	    }
	}
	print popup_menu('-name'=>'job_id',
			 '-values'=>\@names,
			 '-default'=>"",
			 '-labels'=>\%labels);
    }
    else {
	&user_erro("No clients selected; you must first select a client");
    }
}



print <<EOT;

<INPUT TYPE=SUBMIT NAME="Go" VALUE="Go!">

EOT

