#!/usr/bin/perl
#
# vieweditusers.cgi
#
# Copyright 1999 -- 2001, onShore Development Inc. <URL:http://www.onshore-devel.com/>
#
#
# This program is free software under the terms of the GNU General Public
# License (GPL). A copy of the GPL, "COPYING", should have been made
# available with this software.  If not, a copy may be obtained at 
# http://www.fsf.org/copyleft/gpl.html
#
# $Id: vieweditusers.cgi,v 1.8 2001/08/29 22:22:45 adam Exp $


require 'etc/timesheet.conf';
require 'lib/user-funcs.pl';
require 'lib/common-funcs.pl';
use CGI qw(:standard);
use ADB;

my $dead = '';
my $function;
my $dummy;

my $javave =<<EOT;

function jump_cut () {
   myrec = eval(parent.right.document.loghours.record_number.value);
   totrec = eval(parent.right.document.loghours.totalrecords.value);
   if (isNaN(myrec)) {
      alert("The record number must be a number!");
   }

   if ( (myrec > totrec) || (myrec <= 0)) {
       alert("Hmmm. Can't find record number " +  myrec + " because there are only " + totrec + " records!" );
       parent.right.document.loghours.record_number.value = eval(parent.right.document.loghours.recordnumber.value);
   }
   else {
      document.loghours.submit();
   }
}

EOT

print header,
    start_html('-title'      =>$Conf::VIEWEDIT_USERS,
	       '-BACKGROUND' => $Conf::BACKGROUND,
	       '-script'     =>$Conf::JAVA_HELP . $javave,     
	       '-BGCOLOR'    => $Conf::BGCOLOR,
	       );

&help_button_big('VIEWEDIT_USERS');

if ( param('recordnumber') != param('record_number') ) {
    my %state;
    my $dbconn;
    my $oops;
    my %users;
    my %user_info;
    my $var;
    &print_form_head;

    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);

    $state{'record_number'} = param('record_number');
    # let's get our record-keeping straight
    $state{'nextrecord'} = $state{'record_number'} + 1;
    $state{'prevrecord'} = ($state{'record_number'} - 1);
    $state{'recordnumber'} = $state{'record_number'};
    if ( $state{'nextrecord'} > $state{'totalrecords'} ) {
	$state{'nextrecord'} = 0;
    }

    %users = &get_user_search_result($dbconn, $state{'searchtable'});
    $state{'personnel_id'} = $users{$state{'recordnumber'}};
    %user_info = &user_join($dbconn, $state{'user_id'});
    
    &add_user_to_state(\%state, \%user_info, $dbconn);
    
    &reset_all_params;

    &admin_show_user_form(%state);

    &write_state(%state);
    &print_user_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";
}
elsif ( param('apply.x') ) {
    my %state;
    my $dbconn;
    my $oops;
    my %users;
    my %user_info;
    my $var;
    my $reply;
    my $sql;
    my $current_user_id;
    &print_form_head;
    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);
    my $current_user = $state{'recordnumber'};

    %users = &get_user_search_result($dbconn, $state{'searchtable'});
    $current_user_id = $users{$current_user};
    %user_info = &user_join($dbconn, $current_user_id);
    
    $state{'change_pass'} = param('change_pass');
    if ( ($state{'change_pass'} eq 'y') && (param('password1') eq param('password2')) ) {
	&mod_ht_user($current_user_id, param('password1'));
	print "<H2>User Password Changed</H2><br>";
    }
	
    $user_info{'email'} = param('email') if param('email');
    $user_info{'first_name'} = param('first_name') if param('first_name');
    $user_info{'middle_name'} = param('middle_name') if param('middle_name');
    $user_info{'last_name'} = param('last_name') if param('last_name');
    $user_info{'super_user'} = 0 if param('super_user') eq 'n';
    $user_info{'super_user'} = 1 if param('super_user') eq 'y';

    &scrub_hash(\%user_info);

    # Make our SQL
    $sql = "UPDATE $Conf::USER_DB SET ";
    $sql .= "first_name = '$user_info{'first_name'}', ";
    $sql .= "last_name = '$user_info{'last_name'}', ";
    $sql .= "middle_name = '$user_info{'middle_name'}', ";
    $sql .= "email = '$user_info{'email'}', ";
    $sql .= "super_user = '$user_info{'super_user'}' ";
    $sql .= "where personnel_id = '$current_user_id';";

    $reply = $dbconn->query($sql);
    if ( ! $reply ) {
	$oops = $dbconn->errorstring;
	&error("Update error for $current_user_id: $oops", $sql);
    }
    
    $state{'personnel_id'} = $users{$state{'recordnumber'}};
    %user_info = &user_join($dbconn, $state{'personnel_id'});

    &add_user_to_state(\%state, \%user_info, $dbconn);

    &reset_all_params;

    &admin_show_user_form(%state);

    &write_state(%state);
    &print_user_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";

}
elsif ( param('delete.x') ) {
    my %state;
    my $dbconn;
    my $oops;
    my %user;
    my %user_info;
    my $var;

    my $current_user_id;
    &print_form_head;

    # if we came here via approve, we don't change anything
    # otherwise, we properly change recordnumber, nextrec, etc...
    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);
    my $current_user = $state{'recordnumber'};

    %user = &get_user_search_result($dbconn, $state{'searchtable'});
    
    $current_user_id = $user{$current_user};
    
    my $reply = $dbconn->query("DELETE from $state{'searchtable'} where personnel_id = '$current_user_id';");
    if ( ! $reply ) {
	$oops = $dbconn->errorstring;
	&error("Delete error for $current_user_id: $oops");
    }
    $reply = $dbconn->query("DELETE from $Conf::USER_DB where personnel_id = '$current_user_id';");
    if ( ! $reply ) {
	$oops = $dbconn->errorstring;
	&error("Delete error for $current_user_id: $oops");
    }
    $reply = $dbconn->query("UPDATE $Conf::HOURS_DB set del = 'y' where fkpersonnel_id = '$current_user_id';");
    if ( ! $reply ) {
	$oops = $dbconn->errorstring;
	&error("Delete error for $current_user_id deleting hours: $oops");
    }
    $reply = $dbconn->query("UPDATE $Conf::JOB_DB set fksupervisor_id = '$state{'remote_user'}' where fksupervisor_id = '$current_user_id';");
    if ( ! $reply ) {
        $oops = $dbconn->errorstring;
        &error("Delete Error for $current_user_id assigning jobs: $oops");
    }

    &del_ht_user($current_user_id);

    $state{'totalrecords'}--;
    if ( $state{'totalrecords'} == 0 ) {
	&admin_search_user_form(%state);
	&searchbutton;
	&write_state(%state);
	print "</FORM>";
	exit;
    }
    if ( $state{'totalrecords'} < $state{'recordnumber'} ) {
	$state{'recordnumber'} = $state{'totalrecords'};
	$state{'nextrecord'} = 0;
	$state{'prevrecord'} = ($state{'totalrecords'} - 1);
    }

    %user = &get_user_search_result($dbconn, $state{'searchtable'});
    $state{'personnel_id'} = $user{$state{'recordnumber'}};
    if ( ! $state{'personnel_id'} ) {
	&error("Next record not found, please use your back button");
    }
    %user_info = &user_join($dbconn, $state{'personnel_id'});

    &add_user_to_state(\%state, \%user_info, $dbconn);

    &reset_all_params;

    &admin_show_user_form(%state);

    &write_state(%state);
    &print_user_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";

    exit;
} elsif ( param('prevrecord.x') ) {
    my %state;
    my $dbconn;
    my $oops;
    my %user;
    my %user_info;
    my $var;
    &print_form_head;
    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);

    # let's get our recordkeeping straight
    $state{'nextrecord'} = $state{'recordnumber'};
    $state{'recordnumber'} = $state{'prevrecord'};    
    $state{'prevrecord'} = ($state{'recordnumber'} - 1);

    %user = &get_user_search_result($dbconn, $state{'searchtable'});
    $state{'personnel_id'} = $user{$state{'recordnumber'}};
    %user_info = &user_join($dbconn, $state{'personnel_id'});

    &add_user_to_state(\%state, \%user_info, $dbconn);
    &reset_all_params;
    
    &admin_show_user_form(%state);

    &write_state(%state);
    &print_user_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";
}
elsif ( param('nextrecord.x') || param('approve.x') ) {
    my %state;
    my $dbconn;
    my $oops;
    my %user;
    my %user_info;
    my $var;

    # OK, if we are doing an Approve, we basically perform a
    # next record with one itnermediate step  So we just set a var
    # here to use in some conditionals later on

    &print_form_head;
    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);

    $state{'prevrecord'} = $state{'recordnumber'};
    $state{'recordnumber'} = $state{'nextrecord'};    
    $state{'nextrecord'} = ($state{'recordnumber'} + 1);
    if ( $state{'nextrecord'} > $state{'totalrecords'} ) {
	$state{'nextrecord'} = 0;
    }

    %user = &get_user_search_result($dbconn, $state{'searchtable'});

    $state{'personnel_id'} = $user{$state{'recordnumber'}};

    %user_info = &user_join($dbconn, $state{'personnel_id'});

    &add_user_to_state(\%state, \%user_info, $dbconn);

    &admin_show_user_form(%state);

    &write_state(%state);
    &print_user_commands(%state);
    &print_record_nav('totalrecords'=>"$state{'totalrecords'}",
		      'recordnumber'=>"$state{'recordnumber'}",
		      'prevrecord'=>"$state{'prevrecord'}",
                      'nextrecord'=>"$state{'nextrecord'}");
    print "</FORM>";

}
elsif ( param('searchsubmit.x') ) {
    my %state;
    my $searchtable;
    my $dbconn;
    my $result;
    my $oops;
    my %user;
    my $var;
    &print_form_head;

    $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
	$oops = $dbconn->errorstring;
	&error("Failed connection to backend: $oops");
    }
    &initialize_state(\%state, $dbconn);

    # Drop any old searches from temp storage in the DB
    $result = $dbconn->query("DROP TABLE temp_user_search_$state{'remote_user'};");
    
    # Get all the state variables in shape for the search
    $state{'super_user'} = 0 if ( param('super_user') eq "n");
    $state{'super_user'} = 1 if ( param('super_user') eq "y");
    
    $state{'personnel_id'} = param('personnel_id') if param('personnel_id');
    $state{'first_name'} = param('first_name') if param('first_name');
    $state{'middle_name'} = param('middle_name') if param('middle_name');
    $state{'last_name'} = param('last_name') if param('last_name');
    $state{'email'} = param('email') if param('email');

    &scrub_hash(\%state);
    # Run the search and get our temp storage table in return
    $state{'searchtable'} = &search_user(%state);
    
    # fill up a hash with our results
    %user = &get_user_search_result($dbconn, $state{'searchtable'});
    
    if ( ! $user{'1'} ) {
	print "<H1>No Matches Found</H1>";
	&admin_search_user_form(%state);
	&searchbutton;
	print "</FORM>";
	exit;
    } else {
	$state{'personnel_id'} = $user{'1'};
    }
    
    # if we want the short listing do this
    if ( param('output') eq "short" ) {
	my $key;
	my %short_job;
	my $sq = "Select * from $state{'searchtable'}, $Conf::USER_DB WHERE ";
	$sq .= "$state{'searchtable'}.personnel_id ";
	$sq .= "= $Conf::USER_DB.personnel_id;";
	my $user_munge = $dbconn->query("$sq");
	if ( ! $user_munge ) {
	    my $oops = $dbconn->errorstring;
	    &error("Error getting user munge: $oops", $sq);
	}
	print "<H3 align=center>Short Listing</H3><br>";
	print "<TABLE BORDER=1>";
	print "<TR><TH>First Name</TH><TH>Last Name</TH><TH>Email</TH><TH>Super User</TH></TR>\n";
	my $numlines = $user_munge->get_num_rows;
	my $i;
	my %chash;
	$i = 0;
	while ( $i < $numlines ) {
	    %chash = $user_munge->get_row($i);
	    print "<TR><TD>$chash{'first_name'}</TD><TD>$chash{'last_name'}</TD><TD>$chash{'email'}</TD><TD>";
	    if ( $chash{'super_user'} ) {
		print "Yes";
	    } else {
		print "No";
	    }
	    print "</TD></TR>\n";
	    $i++;
	}
	
	print "</TABLE>";
	&write_state(%state);
	print '<INPUT TYPE="image" NAME="search" SRC="images/search.gif" BORDER=0>';
    }
    else {     # otherwise we do long output
	# Some wooparse SQL to get all the info for our first record
	my %user_info = &user_join($dbconn, $state{'personnel_id'});
	
	# Add these to our state hash
	&add_user_to_state(\%state, \%user_info, $dbconn);
	
	$state{'recordnumber'} = 1;
	my @recs = keys %user;
	$state{'totalrecords'} = $#recs + 1;
	if ( $state{'totalrecords'} == $state{'recordnumber'} ) {
	    $state{'nextrecord'} = 0;
	} else {
	    $state{'nextrecord'} = ($state{'recordnumber'} +1);
	}
	
	&admin_show_user_form(%state);
	
	&write_state(%state);
	
	&print_user_commands(%state);
	&print_record_nav('totalrecords'=>"$state{'totalrecords'}",
			  'recordnumber'=>"$state{'recordnumber'}",
			  'nextrecord'=>"$state{'nextrecord'}");
	print "</FORM>";
    }
    
} else {			# The bottom of the basket, print new form
    my %state;
    my $oops;
    my $dbconn = new ADB($Conf::DBADDR,$Conf::SQLDB);
    if ( ! $dbconn->is_ok ) {
        $oops = $dbconn->errorstring;
        &error("Failed connection to backend: $oops");
    }
    $state{'client_id'} = param('client_id');
#    $state{'client_name'} = &client_id_to_name($state{'client_id'});
    $state{'remote_user'} = remote_user;

    &print_form_head;
    
    &reset_all_params;

    param('super_user','any');
    &admin_search_user_form();
    
    &searchbutton;
    &write_state(%state);
    print "</FORM>";
}

sub print_form_head {
    print <<EOT;
<P ALIGN="center">
<IMG SRC="images/vieweditusers-big.gif" BORDER=0 ALT="[View/Edit User]">
</P>
<FORM NAME="loghours" METHOD="POST" ACTION="vieweditusers.cgi" TARGET="right">
EOT
}

sub searchbutton {
    print "<INPUT TYPE=\"image\" NAME=\"searchsubmit\" SRC=\"images/search.gif\" BORDER=\"0\">";
}


sub add_user_to_state {
    my $st = shift;
    my $jb = shift;
    my $dbconn = shift;
    my $var;
    foreach $var (keys %$jb ) {
	$$st{$var} = $$jb{$var};
    }
    
    if ( $$st{'super_user'} == 1 ) {
        $$st{'super_user'} = "y";
    } else {
        $$st{'super_user'} = "n";
    }
}

