///////////////////////////////////////////////////////////////////////////////
// $Id: DealCardsCommand.hxx,v 1.1 1995/01/08 06:41:27 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// DealCardsCommand.hxx - Command to deal cards
//
//
// Bradford W. Mott
// Copyright (C) 1994
// December 12,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: DealCardsCommand.hxx,v $
// Revision 1.1  1995/01/08  06:41:27  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef DEALCARDSCOMMAND_HXX
#define DEALCARDSCOMMAND_HXX

#include "Command.hxx"
#include "Engine.hxx"

class DealCardsCommand : public Command {
  private:
    Engine* myEngine;

  public:
    // Protected constructor to prevent instantiation
    DealCardsCommand(Engine* engine) { myEngine = engine; }

    // Destructor
    virtual ~DealCardsCommand() { }

    // All I do is tell the engine to deal some cards
    virtual void execute(void* argument)
    {
      (application->soundSystem())->playSample("TypeSpace");
      myEngine->dealCards(FaceUp);
    }
};

#endif

