///////////////////////////////////////////////////////////////////////////////
// $Id: Engine.hxx,v 1.1 1995/01/08 06:43:56 bmott Exp $
///////////////////////////////////////////////////////////////////////////////
//
// Engine.hxx - Oonsoo game engine class
//
//
// Bradford W. Mott
// Copyright (C) 1994
// November 3,1994
//
///////////////////////////////////////////////////////////////////////////////
// $Log: Engine.hxx,v $
// Revision 1.1  1995/01/08  06:43:56  bmott
// Initial revision
//
///////////////////////////////////////////////////////////////////////////////

#ifndef ENGINE_HXX
#define ENGINE_HXX

#include "Card.hxx"
#include "MainDeck.hxx"
#include "PlayingDeck.hxx"

#include "SpriteCollection.hxx"
#include "Frame.hxx"

class Engine {
  private:
    SpriteCollection* mySpriteCollection;
    Frame* myCardTable;
    MainDeck* myMainDeck;
    PlayingDeck* myPlayingDeck[12];
    DrawingArea* myTitle;
    DrawingArea* myCongratulation;

  public:
    // Constructor
    Engine(SpriteCollection* sprites);

    // Destructor
    ~Engine();

    // Setup a new game
    void newGame();

    // Deal twelve cards from the main deck to the playing deck
    void dealCards(CardOrientation orientation);

    // Handle moving cards from one deck to somewhere else
    void moveCards(Deck* from, Deck* moved);

    // Check to see if the game has been finished
    void CheckAndHandleFinished();
};
#endif

