/* ************************************************************* *
 *   The Amulet User Interface Development Environment           *
 * ************************************************************* *
 *   Created automatically by the Gilt program in Amulet.        *
 *   Do not edit this file directly.                             *
 *   For more information on Amulet, contact amulet@cs.cmu.edu   *
 * ************************************************************* *
 *   Generated on Mon Jun  9 09:18:07 1997

 *   Amulet version 3.0 Beta
 * ************************************************************* */

#include <amulet.h>
// #include SCRIPTING__H
#include SCRIPTING_ADVANCED__H

#include WIDGETS_ADVANCED__H  //for Am_Check_Accelerator_Char_For_Window
#include INTER_ADVANCED__H  //for Am_Execute_Command


Am_Object am_invoke_window;

Am_Object Am_Before_After_Match_Command;


Am_Slot_Key Am_WHICH_APPL_MENU = Am_Register_Slot_Name ("Am_WHICH_APPL_MENU");
Am_Slot_Key Am_WHICH_APPL_SUB_MENU = Am_Register_Slot_Name ("Am_WHICH_APPL_SUB_MENU");
Am_Slot_Key Am_BEFORE_OR_AFTER = Am_Register_Slot_Name ("Am_BEFORE_OR_AFTER");
Am_Slot_Key Am_BEFORE_OR_AFTER_COMMAND =
	 Am_Register_Slot_Name ("Am_BEFORE_OR_AFTER_COMMAND");
Am_Slot_Key Am_DO_ACCELERATOR = Am_Register_Slot_Name ("Am_DO_ACCELERATOR");
Am_Slot_Key Am_DO_MENU = Am_Register_Slot_Name ("Am_DO_MENU");
Am_Slot_Key Am_COMMAND_GENERALIZE_BUTTON = Am_Register_Slot_Name ("Am_COMMAND_GENERALIZE_BUTTON");

// match_commands correspond to execute_command's and have the command
// to be matched in it.

Am_Slot_Key Am_INVOKE_MATCH_COMMAND =
		Am_Register_Slot_Name ("Am_INVOKE_MATCH_COMMAND");
Am_Slot_Key Am_REAL_DO_METHOD = Am_Register_Slot_Name ("Am_REAL_DO_METHOD");
Am_Slot_Key Am_ORIG_COMMAND = Am_Register_Slot_Name ("Am_ORIG_COMMAND");
Am_Slot_Key Am_INSTALLED_ON_COMMAND = Am_Register_Slot_Name ("Am_INSTALLED_ON_COMMAND");
Am_Slot_Key Am_WIDGET_FOR_COMMAND =
	Am_Register_Slot_Name ("Am_WIDGET_FOR_COMMAND");

/////////////////////////////////////////////////////////////////////////
// Value Match Generalizers
/////////////////////////////////////////////////////////////////////////

Am_Value_List valinvokegen_windows;
int num_vis_valinvokegen_windows = 0;

Am_Object get_valinvokegen_window() {
  Am_Object w = am_get_db_from_list(am_valinvokegen, valinvokegen_windows,
				    num_vis_valinvokegen_windows);
  return w;
}
void done_with_valinvokegen_window(Am_Object sw) {
  sw.Set(Am_VISIBLE, false);
  valinvokegen_windows.Add(sw);
  num_vis_valinvokegen_windows--;
}

void gen_any_value_header(Am_Value &old_val, Am_Value_List &part_chain, Am_Slot_Key slot) {
    if (slot == Am_REGISTER_COMMAND) //then is the command part
      part_chain.Add("Any_Command_");
    else if (old_val.type == Am_OBJECT)
      part_chain.Add("Any_Object_");
    else if (Am_Inter_Location::Test(old_val))
      part_chain.Add("Any_Location_");
    else part_chain.Add("Any_Value_"); //hack
}


void internal_invokegen_ok(Am_Object &valinvokegen_window) {
  Am_Object match_command = valinvokegen_window.Get(Am_INVOKE_MATCH_COMMAND);
  Am_Object invoke_window = valinvokegen_window.Get(Am_SCRIPT_WINDOW);
  Am_Object script_window = invoke_window.Get(Am_SCRIPT_WINDOW);
  Am_Value_List sel_list = valinvokegen_window.Get(Am_COMMAND);
  Am_Slot_Key slot = (Am_Slot_Key)(int)valinvokegen_window
    .Get(Am_SLOTS_TO_SAVE);
  Am_Object execute_command = script_window.Get(Am_SCRIPT_EXECUTE_COMMAND);
  int how_gen = valinvokegen_window.Get_Object(Am_UNDO_OPTIONS).Get(Am_VALUE);
  Am_Value_List part_chain;
  Am_Object proto;
  Am_Object script_line = sel_list.Get_First();
  Am_Object create_cmd = script_line.Get(Am_COMMAND);
  Am_Value old_val = valinvokegen_window.Get_Object(Am_CONSTANT_OBJECTS_WIDGET)
      .Get(Am_VALUES);

  Am_Value_List placeholder_list = execute_command.Get(Am_PLACEHOLDER_LIST);
  int placeholder_cnt = execute_command.Get(Am_PLACEHOLDER_COUNT);
  switch (how_gen) {
  case am_constant_generalize:
    proto = Am_Constant_Placeholder;
    break;
  case am_type_generalize: 
    part_chain.Add(valinvokegen_window.Get_Object(Am_TYPE_OBJECTS_WIDGET)
	   .Get(Am_VALUE))
      .Add(valinvokegen_window.Get_Object(Am_TYPE_OBJECTS_WIDGET)
	   .Get(Am_VALUES));
    proto = Am_Type_Match_Placeholder;
    break;
  case am_any_value_generalize:
	gen_any_value_header(old_val, part_chain, slot);
    proto = Am_Any_Value_Placeholder;
    break;
  case am_all_values_generalize:
    create_cmd = valinvokegen_window.Get_Object(Am_ALL_FROM_COMMAND_WIDGET)
      .Get(Am_VALUES, Am_RETURN_ZERO_ON_ERROR);
    if (!create_cmd.Valid()) {
      Am_POP_UP_ERROR_WINDOW("Command not filled in.");
      return; //don't finish with this window
    }
    proto = Am_All_Values_From_Command_Placeholder;
    break;
  case am_custom_generalize: {
    Am_Error("Custom not yet implemented");
    break;
  }
  default: Am_ERROR("Bad type " << how_gen);
  } //end switch

  Am_Object new_ph = am_call_create_placeholder (proto,
				   old_val, create_cmd, placeholder_list,
				   part_chain, placeholder_cnt, slot);
  //needed if placeholder for location
  new_ph.Set(Am_LOCATION_PLACEHOLDER,
     valinvokegen_window.Get(Am_LOCATION_PLACEHOLDER, Am_RETURN_ZERO_ON_ERROR),
	     Am_OK_IF_NOT_THERE);
  if (am_sdebug)
   std::cout << "valinvokegen: New placeholder is " << new_ph <<std::endl <<std::flush;
  execute_command.Set(Am_PLACEHOLDER_LIST, placeholder_list);
  execute_command.Set(Am_PLACEHOLDER_COUNT, placeholder_cnt);
  Am_Value new_value;
  new_value = new_ph;
  am_script_replace_all(sel_list, new_value, invoke_window,
			slot, match_command);
}

Am_Define_Method(Am_Object_Method, void, am_valinvokegen_ok,
		 (Am_Object cmd)) {
  Am_Object valinvokegen_window = cmd.Get_Object(Am_SAVED_OLD_OWNER)
    .Get_Owner();
  internal_invokegen_ok(valinvokegen_window);
  done_with_valinvokegen_window(valinvokegen_window);  
}

Am_Define_Method(Am_Object_Method, void, am_valinvokegen_cancel,
		 (Am_Object cmd)) {
  Am_Object valinvokegen_window = cmd.Get_Object(Am_SAVED_OLD_OWNER)
    .Get_Owner();
  done_with_valinvokegen_window(valinvokegen_window);
}

////////////////////////////////////////////////////////////////////////
// Command Match Generalizers
/////////////////////////////////////////////////////////////////////////

Am_Value_List commandinvokegen_windows;
int num_vis_commandinvokegen_windows = 0;

Am_Object get_commandinvokegen_window() {
  Am_Object w = am_get_db_from_list(am_commandinvokegen, commandinvokegen_windows,
				    num_vis_commandinvokegen_windows);
  return w;
}
void done_with_commandinvokegen_window(Am_Object sw) {
  sw.Set(Am_VISIBLE, false);
  commandinvokegen_windows.Add(sw);
  num_vis_commandinvokegen_windows--;
}


Am_Define_Method(Am_Object_Method, void, am_commandinvokegen_ok,
		 (Am_Object cmd)) {
  Am_Object commandinvokegen_window = cmd.Get_Object(Am_SAVED_OLD_OWNER)
    .Get_Owner();
  internal_invokegen_ok(commandinvokegen_window);
  done_with_commandinvokegen_window(commandinvokegen_window);  
}

Am_Define_Method(Am_Object_Method, void, am_commandinvokegen_cancel,
		 (Am_Object cmd)) {
  Am_Object commandinvokegen_window = cmd.Get_Object(Am_SAVED_OLD_OWNER).Get_Owner();
  done_with_commandinvokegen_window(commandinvokegen_window);
}

//////////////////////////////////////////////////////////////////////

Am_Define_Formula(bool, am_before_or_after_picked) {
	Am_Object before_after = self.Get_Sibling(Am_BEFORE_OR_AFTER);
	return (before_after.Get(Am_VALUE).Valid());
}

Am_Define_Formula(bool, menu_vis_if_before_after) {
  Am_Object before_after = self.Get_Owner().Get_Sibling(Am_BEFORE_OR_AFTER);
  return (before_after.Get(Am_VALUE).Valid());
}

Am_Object gen_match_command_for(Am_Object &sel_cmd, Am_Value_List &menu_commands) {
  Am_Object match_command = Am_Before_After_Match_Command.Create()
	.Set(Am_COMMANDS_PROTOTYPES, menu_commands)
    .Set(Am_COMMAND, sel_cmd);
  return match_command;
}

//replace all the values with any_value placeholders except the command itself
void replace_all_with_placeholders(Am_Object &invoke_window,
				   Am_Object &script_window) {
  Am_Value_List sel_list = invoke_window.Get_Object(Am_UNDO_SCROLL_GROUP)
    .Get(Am_ITEMS);
  Am_Object sel_cmd = sel_list.Get_First();
  Am_Value_List parts = sel_cmd.Get(Am_GRAPHICAL_PARTS);
  Am_Object script_part;
  Am_Value value;
  Am_Object execute_command = script_window.Get(Am_SCRIPT_EXECUTE_COMMAND);
  Am_Value new_value;
  int placeholder_cnt = execute_command.Get(Am_PLACEHOLDER_COUNT);
  Am_Value_List placeholder_list = execute_command.Get(Am_PLACEHOLDER_LIST);
  for (parts.Start(); !parts.Last(); parts.Next()) {
    script_part = parts.Get();
    if (script_part.Is_Instance_Of(Am_Script_Line_Selectable)) {
      Am_Object create_cmd = script_part.Get(Am_COMMAND);
      Am_Value old_val = script_part.Get(Am_VALUE);
      Am_Am_Slot_Key slot = script_part.Get(Am_SLOTS_TO_SAVE);
     std::cout << "Replacing part " << script_part << " slot " << slot
	   <<std::endl <<std::flush;
      Am_Value_List part_chain;
      gen_any_value_header(old_val, part_chain, slot);
      Am_Value_List placeholder_list =execute_command.Get(Am_PLACEHOLDER_LIST);
      Am_Object new_ph = am_call_create_placeholder (Am_Any_Value_Placeholder,
				   old_val, create_cmd, placeholder_list,
				   part_chain, placeholder_cnt, slot);
      new_ph.Set(Am_LOCATION_PLACEHOLDER,
	 script_part.Get(Am_LOCATION_PLACEHOLDER, Am_RETURN_ZERO_ON_ERROR),
		 Am_OK_IF_NOT_THERE);
      if (am_sdebug)
std::cout << "replace_all: New placeholder is " << new_ph <<std::endl <<std::flush;
      new_value = new_ph;
      am_script_replace_all(sel_list, new_value, Am_No_Object,
			    slot, Am_No_Object);
    }
  }
  execute_command.Set(Am_PLACEHOLDER_LIST, placeholder_list);
  execute_command.Set(Am_PLACEHOLDER_COUNT, placeholder_cnt);
}

Am_Define_Method(Am_Object_Method, void, am_load_current_command_from_main,
		 (Am_Object cmd)) {
  Am_Object invoke_window = cmd.Get_Object(Am_SAVED_OLD_OWNER).Get_Owner();
  Am_Object script_window = invoke_window.Get(Am_SCRIPT_WINDOW);
  Am_Object undo_db = script_window.Get(Am_UNDO_MENU_OF_COMMANDS);
  Am_Value_List new_cmds = undo_db.Get_Object(Am_UNDO_SCROLL_GROUP)
    .Get(Am_VALUE);
  if (new_cmds.Length() != 1) {
    Am_POP_UP_ERROR_WINDOW("Select exactly one command in the main undo dialog box");
    return;
  }
  Am_Object sel_cmd = new_cmds.Get_First();
  sel_cmd = sel_cmd.Copy(); //will modify it, so make a copy

  Am_Value_List cmd_list;
  cmd_list.Add(sel_cmd);
  Am_Object match_command =
    invoke_window.Peek(Am_INVOKE_MATCH_COMMAND);
 std::cout << "\nLoad current on " << invoke_window << " old match command " 
       << match_command <<std::endl <<std::flush;
  if (match_command.Valid())
    am_remove_match_command(match_command);
  match_command = gen_match_command_for(sel_cmd, cmd_list);
  invoke_window.Set(Am_INVOKE_MATCH_COMMAND, match_command);

  //replace_all needs the command to be in the script window, but it
  //changes the command, so then have to re-load it
  am_set_commands_into_script_window(invoke_window, match_command);
  replace_all_with_placeholders(invoke_window, script_window);
  am_set_commands_into_script_window(invoke_window, match_command);
}

Am_Define_Method(Am_Object_Method, void, do_top_menu_selected,
		 (Am_Object /*cmd*/)) {
 std::cout << "*** do_menu_selected\n" <<std::flush;
}


Am_Define_Method(Am_Object_Method, void, clear_accel, (Am_Object cmd)) {
  Am_Object accel_widget = cmd.Get_Object(Am_SAVED_OLD_OWNER)
    .Get_Sibling(Am_ACCELERATOR);
  accel_widget.Set(Am_VALUE, "");
  Am_Object do_accel = accel_widget.Get_Sibling(Am_DO_ACCELERATOR);
  do_accel.Set(Am_VALUE, false);
}

///////////////////////////////////////////////////////////////////////

Am_Value_List invoke_windows;
int num_vis_invoke_windows = 0;

Am_Object get_invoke_window() {
  Am_Object w = am_get_db_from_list(am_invoke_window, invoke_windows,
				    num_vis_invoke_windows);
  return w;
}
void done_with_invoke_window(Am_Object sw) {
  sw.Set(Am_VISIBLE, false);
  invoke_windows.Add(sw);
  num_vis_invoke_windows--;
}

void copy_values_to_match_command(Am_Object &match_command, 
				  const Am_Value& items_value) {
  Am_Value_List items = items_value;
  Am_Object script_group = items.Get_First();
  Am_Object main_cmd = script_group.Get(Am_COMMAND);
  //only used in create cmds
  Am_Object start_object = main_cmd.Peek(Am_START_OBJECT);
  Am_Value_List parts = script_group.Get(Am_GRAPHICAL_PARTS);
  Am_Am_Slot_Key slot;
  Am_Object script_part;
  Am_Value value;
  Am_Value_List slots_to_save;
  for (parts.Start(); !parts.Last(); parts.Next()) {
    script_part = parts.Get();
    slot = Am_Am_Slot_Key(script_part.Get(Am_SLOTS_TO_SAVE,
					  Am_RETURN_ZERO_ON_ERROR));
    if ((int)slot != 0) {
      slots_to_save.Add(static_cast<int>(slot));
      value = main_cmd.Peek(slot);
      if (!value.Valid()) {
	if (start_object.Valid())
	  value = start_object.Peek(slot);
      }
      if (value.Valid())
	match_command.Set(slot, value, Am_OK_IF_NOT_THERE);
    }
  }
  match_command.Set(Am_SLOTS_TO_SAVE, slots_to_save);
}

Am_Define_Method(Am_Object_Method, void, am_invoke_ok, (Am_Object cmd)) {
  Am_Object invoke_window = cmd.Get_Object(Am_SAVED_OLD_OWNER).Get_Owner();
  Am_Object script_window = invoke_window.Get(Am_SCRIPT_WINDOW);
  Am_Object undo_db = script_window.Get(Am_UNDO_MENU_OF_COMMANDS);
  Am_Object sel_widget = undo_db.Get(Am_SELECTION_WIDGET);
  Am_Object window = sel_widget.Get(Am_WINDOW);
  Am_Object script_execute_command = script_window
    .Get(Am_SCRIPT_EXECUTE_COMMAND);

  // deal with accelerator char
  Am_String accel_string = invoke_window.Get_Object(Am_ACCELERATOR)
    .Get(Am_VALUE);
  Am_Input_Char accel_char;
  if (invoke_window.Get_Object(Am_DO_ACCELERATOR).Get(Am_VALUE).Valid()) {
    if (accel_string != "") {
      accel_char = Am_Input_Char(accel_string, false);
      // check if this accelerator already in use
      Am_Object other_cmd =
	Am_Check_Accelerator_Char_For_Window(accel_char, window);
      if (other_cmd.Valid() && other_cmd != script_execute_command) {
	Am_POP_UP_ERROR_WINDOW("Accelerator " << accel_char
			       << " already in use by " << other_cmd);
	return; //don't make the window invisible if invalid
      }
    }
    else {
      Am_POP_UP_ERROR_WINDOW("To attach to accelerator, need to fill in key");
      return; //don't make the window invisible if invalid
    }
  }
  script_execute_command.Set(Am_ACCELERATOR, accel_char);
  
  // deal with before/after commands
  Am_Value before_after = invoke_window.Get_Object(Am_BEFORE_OR_AFTER)
    .Get(Am_VALUE);
  Am_Object match_command = invoke_window.Get(Am_INVOKE_MATCH_COMMAND);
  if (before_after.Valid()) {
    if (!match_command.Valid()) {
      Am_POP_UP_ERROR_WINDOW(
	     "For before/after command, need to use \"Load\" button.");
      return; //don't make the window invisible if invalid
    }
    match_command.Set(Am_BEFORE_OR_AFTER, before_after, Am_OK_IF_NOT_THERE);
    copy_values_to_match_command(match_command,
				 invoke_window.Get_Object(Am_UNDO_SCROLL_GROUP)
				 .Get(Am_ITEMS));
    script_execute_command.Set(Am_BEFORE_OR_AFTER, before_after);
    script_execute_command.Set(Am_BEFORE_OR_AFTER_COMMAND, match_command);
  }
  else if (match_command.Valid()) {
    am_remove_match_command(match_command);
    script_execute_command.Set(Am_BEFORE_OR_AFTER, 0);
    script_execute_command.Set(Am_BEFORE_OR_AFTER_COMMAND, Am_No_Object);
  }
  done_with_invoke_window(invoke_window);  
}

Am_Define_Method(Am_Object_Method, void, am_invoke_cancel,
		 (Am_Object cmd)) {
  Am_Object invoke_window = cmd.Get_Object(Am_SAVED_OLD_OWNER).Get_Owner();
  done_with_invoke_window(invoke_window);  
}

Am_Define_Method(Am_Text_Edit_Method, void, single_char_method,
		 (Am_Object text, Am_Input_Char ic, Am_Object inter )) {
  if (ic.click_count == Am_NOT_MOUSE) {
    char s[Am_LONGEST_CHAR_STRING];
    ic.As_Short_String(s);
    text.Set(Am_TEXT, s);
    text.Set(Am_CURSOR_INDEX, 0);
    Am_Object do_accel = inter.Get_Owner().Get_Sibling(Am_DO_ACCELERATOR);
    do_accel.Set(Am_VALUE, true);
    Am_Stop_Interactor(inter);
  }
}

Am_Define_Method(Am_Where_Method, Am_Object, am_on_selectable_match_line_part,
		 (Am_Object inter, Am_Object /* object */,
		  Am_Object event_window, int x, int y)) {
  Am_Object scroll_menu = inter.Get_Owner ();
  Am_Object ret = Am_Point_In_Leaf(scroll_menu, x, y, event_window,
				   false, false);
  if (ret.Valid() && (ret.Is_Instance_Of(Am_Script_Line_Selectable) ||
					  ret.Is_Instance_Of(Am_Script_Line_Command)))
    return ret;
  else return Am_No_Object;
}

void Am_Pop_Up_Generalize_Match_DB(Am_Object &invoke_window,
			     Am_Value_List &sel_list) {
  Am_Object main_script_line_part = sel_list.Get_First();
  if (am_sdebug)
   std::cout << "sel " << main_script_line_part <<std::endl<<std::flush;
  Am_Object gen_window;
  bool command_type = false;
  if (main_script_line_part.Is_Instance_Of(Am_Script_Line_Command)) {
	 gen_window = get_commandinvokegen_window();
	 command_type = true;
  }
  else {
	 gen_window = get_valinvokegen_window();
  }
  Am_Object main_cmd = main_script_line_part.Get(Am_COMMAND);
  Am_Object ph;
  Am_Value current_val = main_script_line_part.Get(Am_VALUE);
  bool ok = am_get_placeholder_from(current_val, ph);
  if (!ok) return;

  gen_window.Set(Am_SCRIPT_WINDOW, invoke_window)
    .Set(Am_COMMAND, sel_list)
    .Set(Am_SLOTS_TO_SAVE,
	 main_script_line_part.Get(Am_SLOTS_TO_SAVE, Am_RETURN_ZERO_ON_ERROR))
    .Set(Am_INVOKE_MATCH_COMMAND, invoke_window.Get(Am_INVOKE_MATCH_COMMAND))
    .Set(Am_LOCATION_PLACEHOLDER,  //in case is for location
	 main_script_line_part.Get(Am_LOCATION_PLACEHOLDER,
				   Am_RETURN_ZERO_ON_ERROR),
	 Am_OK_IF_NOT_THERE)
    ;
  if (am_sdebug)
   std::cout << "Popup win " << gen_window << " for val " << current_val
	 << " from command " << main_cmd <<std::endl <<std::flush;
  if (ph.Valid()) {
    current_val = ph.Get(Am_VALUE);
    if (am_sdebug)
     std::cout << "val found placeholder " << ph <<std::endl <<std::flush;
    gen_window.Set(Am_PLACEHOLDERS_SET_BY_THIS_COMMAND, ph);
    if (ph.Is_Instance_Of(Am_Constant_Placeholder)) {
      gen_window.Get_Object(Am_UNDO_OPTIONS).Set(Am_VALUE, am_constant_generalize);
    }
    else if (ph.Is_Instance_Of(Am_All_Values_From_Command_Placeholder)) {
      gen_window.Get_Object(Am_UNDO_OPTIONS)
				.Set(Am_VALUE, am_all_values_generalize);
      Am_Object for_cmd = ph.Get(Am_COMMAND);
      Am_String cmd_label = am_gen_command_label(for_cmd);
      gen_window.Get_Object(Am_ALL_FROM_COMMAND_WIDGET)
			.Set(Am_VALUES, for_cmd, Am_OK_IF_NOT_THERE)
			.Set(Am_VALUE, cmd_label);
    }
    else if (ph.Is_Instance_Of(Am_Any_Value_Placeholder)) {
      gen_window.Get_Object(Am_UNDO_OPTIONS)
				.Set(Am_VALUE, am_any_value_generalize);
	}
	else if (ph.Is_Instance_Of(Am_Type_Match_Placeholder)) {
      gen_window.Get_Object(Am_UNDO_OPTIONS)
				.Set(Am_VALUE, am_type_generalize);
    }
    else Am_ERROR("Haven't handled placeholder type " << ph);
  }
  else {
    gen_window.Get_Object(Am_UNDO_OPTIONS)
      .Set(Am_VALUE, am_constant_generalize);
    if (am_sdebug)
     std::cout << "No placeholder; setting value " << current_val << " type "
	   << current_val.type <<std::endl <<std::flush;
  }
  gen_window.Set(Am_VALUE, current_val);
  gen_window.Get_Object(Am_CONSTANT_OBJECTS_WIDGET)
    .Set(Am_VALUES, current_val)
    .Set(Am_VALUE, current_val);
  if (!command_type) {
    if (current_val.type == Am_OBJECT) {
      Am_Object obj = current_val;
      Am_Assoc as;
      if (!am_find_proto_and_name(obj, as))
	     Am_ERROR("obj " << obj << " not found in proto list");
      Am_Object proto = as.Value_2();
	  Am_String name = as.Value_1();
      gen_window.Get_Object(Am_TYPE_OBJECTS_WIDGET)
	     .Set(Am_VALUES, proto)
	     .Set(Am_VALUE, name);
    }
    else
      gen_window.Get_Object(Am_TYPE_OBJECTS_WIDGET).Set(Am_VALUES, (0L))
	      	     .Set(Am_VALUE, "");
  }
  gen_window.Set(Am_VISIBLE, true);
}

Am_Define_Method(Am_Object_Method, void, am_generalize_match_double_click,
		 (Am_Object cmd)) {
  //cmd in inter on scroll_menu on invoke_window
  Am_Object scroll_menu = cmd.Get_Object(Am_SAVED_OLD_OWNER).Get_Owner();
  Am_Object invoke_window = scroll_menu.Get_Owner();
  Am_Value_List sel_list = scroll_menu.Get(Am_SAVED_OLD_OBJECT_OWNER,
					   Am_RETURN_ZERO_ON_ERROR);
  if (sel_list.Valid()) {
   std::cout << " POP UP GENERALIZE MATCH DB\n" <<std::flush;
    Am_Pop_Up_Generalize_Match_DB(invoke_window, sel_list);
  }
}

Am_Define_Method(Am_Object_Method, void, am_pop_up_generalize_from_button,
		 (Am_Object cmd)) {
  //cmd in button in invoke_window
  Am_Object invoke_window = cmd.Get_Object(Am_SAVED_OLD_OWNER).Get_Owner();
  Am_Object scroll_menu = invoke_window.Get(Am_UNDO_SCROLL_GROUP);
  Am_Value_List sel_list = scroll_menu.Get(Am_SAVED_OLD_OBJECT_OWNER,
					   Am_RETURN_ZERO_ON_ERROR);
  if (sel_list.Valid()) {
    Am_Pop_Up_Generalize_Match_DB(invoke_window, sel_list);
	}

}

///////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////



//  This method is called from the main script window commands.
Am_Define_Method(Am_Object_Method, void, pop_up_invoke_options,
		 (Am_Object cmd)) {
  Am_Object script_window =
    cmd.Get_Object(Am_SAVED_OLD_OWNER).Get_Owner();
  Am_Object invoke_window = get_invoke_window();
  invoke_window.Set(Am_SCRIPT_WINDOW, script_window);

  Am_Object script_execute_command =
       script_window.Get(Am_SCRIPT_EXECUTE_COMMAND);
  invoke_window.Set(Am_INVOKE_MATCH_COMMAND, 
		    script_execute_command.Get(Am_BEFORE_OR_AFTER_COMMAND));

  //deal with accel chars
  Am_Input_Char accel_char = script_execute_command.Get(Am_ACCELERATOR); 
  char accel_string[Am_LONGEST_CHAR_STRING];
  if (accel_char.Valid())
    accel_char.As_Short_String(accel_string);
  else accel_string[0] = 0; //zero length string;
  invoke_window.Get_Object(Am_DO_ACCELERATOR)
    .Set(Am_VALUE, accel_char.Valid());
  invoke_window.Get_Object(Am_ACCELERATOR)
    .Set(Am_VALUE, accel_string);

  // deal with before/after commands
  int before_after = script_execute_command.Get(Am_BEFORE_OR_AFTER);
  invoke_window.Get_Object(Am_BEFORE_OR_AFTER)
    .Set(Am_VALUE, before_after);
  if (before_after != 0) {
    Am_Object match_command =
     script_execute_command.Get(Am_BEFORE_OR_AFTER_COMMAND);
    am_set_commands_into_script_window(invoke_window, match_command);
  }
  else invoke_window.Get_Object(Am_UNDO_SCROLL_GROUP)
    .Set(Am_ITEMS, (0L));
  invoke_window.Set(Am_VISIBLE, true);
}

//////////////////////////////////////////////////////////////////////////
// Matching and invoking from commands
//////////////////////////////////////////////////////////////////////////


// need to find the last-most source_of_copy with the widget as its saved_old_owner because that
// is likely to be the one that is going to be invoked next time.
Am_Object find_widget_for(Am_Object &cmd, Am_Object &orig_cmd) {
  orig_cmd = cmd;
  Am_Object this_widget, found_widget, this_cmd;
  while (true) {
    this_widget = orig_cmd.Get(Am_SAVED_OLD_OWNER,
				    Am_RETURN_ZERO_ON_ERROR);
    if (this_widget.Valid()) {
		if (found_widget.Valid()) {
		   if (found_widget != this_widget)
			   Am_ERROR("former widget " << found_widget << " different from current "
			            << this_widget);
		}
		else found_widget = this_widget;
	}
	else if (found_widget.Valid()) {
	std::cout << "found last cmd " << orig_cmd << " for widget " << found_widget <<std::endl <<std::flush;
		return found_widget;
	}
    this_cmd = orig_cmd.Peek(Am_SOURCE_OF_COPY);
    if (!this_cmd.Valid()) {
	  if (found_widget.Valid())
		  return found_widget;
      else Am_ERROR("Can't find widget for " << cmd);
    }
	else orig_cmd = this_cmd;
  }
  return Am_No_Object;
}

bool match_place_holder(Am_Value &placeholder_value, Am_Value &current_value) {
	Am_Object placeholder = placeholder_value;
std::cout << "  Matching placeholder " << placeholder <<std::endl <<std::flush;
	Am_Placeholder_Replace_Method method = placeholder.Get(Am_PLACEHOLDER_MATCH_METHOD);
	if (!method.Valid())
		Am_ERROR("Placeholder " << placeholder << " has no match method.");
	bool match = method.Call(placeholder, current_value, Am_No_Object);
std::cout << "  method " << method << " returned " << match <<std::endl <<std::flush;
	return match;
}

bool match_one_ph(Am_Value &target_value, Am_Value &current_value) {
	if (target_value.type == Am_OBJECT &&
		Am_Object(target_value).Is_Instance_Of(Am_A_Placeholder)) {
		if (!match_place_holder(target_value, current_value)) {
		std::cout << "  Placeholder Doesn't match\n" <<std::flush;
			return false;  // doesn't match
		}	
	}
	else if (target_value != current_value) {
	std::cout << "  Doesn't match\n" <<std::flush;
		return false;  // doesn't match
	}
	return true;
}

bool match_value_or_list(Am_Value &target_value, Am_Value &current_value) {
	if (Am_Value_List::Test(target_value) && 
        Am_Value_List::Test(current_value)) {
	  Am_Value_List t_list = target_value;
	  Am_Value_List c_list = current_value;
	  if (t_list.Length() != c_list.Length()) {
		 std::cout << "Lists not equal\n" <<std::flush;
		  return false;
	  }
      Am_Value tval, cval;
	  for (t_list.Start(), c_list.Start(); !t_list.Last(); t_list.Next(),c_list.Next()) {
		tval = t_list.Get();
		cval = c_list.Get();
		if (!match_one_ph(tval, cval))
			return false;
	  }
	}
	else {  //not both lists
		return match_one_ph(target_value, current_value);
	}
	return true;
}

void match_and_run(Am_Object& cmd_or_inter, Am_Object& match_command) {
  Am_Object orig_command = match_command.Get(Am_ORIG_COMMAND);
 std::cout << "Match command " << match_command << " cmd_or_inter "
       << cmd_or_inter << " orig_command " << orig_command <<std::endl <<std::flush;
  //check for recursive call
  if (match_command.Peek(Am_RUNNING).Valid()) {
   std::cout << "Exiting because recursive\n" <<std::flush;
    return;
  }
  Am_Value_List slots_to_match = match_command.Get(Am_SLOTS_TO_SAVE);
  Am_Object start_object = cmd_or_inter.Peek(Am_START_OBJECT);
  Am_Am_Slot_Key slot;
  Am_Value target_value, current_value, cmd_value;
  for (slots_to_match.Start(); !slots_to_match.Last(); slots_to_match.Next()) {
    slot = slots_to_match.Get();
    target_value = match_command.Peek(slot);
    current_value = Am_No_Value;
    if (target_value.Valid()) {
      if (start_object.Valid()) {
	if (slot == Am_LOCATION_PLACEHOLDER) {
	  Am_Inter_Location loc(start_object);
	  current_value = loc;
	}
	else current_value = start_object.Peek(slot);
      }
      if (!current_value.Valid())
	current_value = orig_command.Peek(slot);
    }
   std::cout << "  Matching slot " << slot << " target `" << target_value
	 << "' cmd value `" << current_value << "'\n" <<std::flush;
    if (target_value.Valid() && current_value.Valid()) {
      if (!match_value_or_list(target_value, current_value))
	return; //doesn't match
    }
  }

  // if get here, then matches, so execute the script
  match_command.Set(Am_RUNNING, true, Am_OK_IF_NOT_THERE);
  Am_Object script_execute_command =
    match_command.Get(Am_SCRIPT_EXECUTE_COMMAND);
  Am_Object widget = match_command.Get(Am_WIDGET_FOR_COMMAND);
 std::cout << "%% Calling " << script_execute_command << " for widget "
       << widget <<std::endl <<std::flush;
  Am_Execute_Command(script_execute_command, widget);
  match_command.Set(Am_RUNNING, false);
}

Am_Define_Method(Am_Object_Method, void, am_before_match_do_method,
		 (Am_Object cmd_or_inter)) {
  Am_Object match_command = cmd_or_inter.Get(Am_INVOKE_MATCH_COMMAND);
  match_and_run(cmd_or_inter, match_command);
  Am_Object_Method do_method = cmd_or_inter.Get(Am_REAL_DO_METHOD);
  if (do_method.Valid()) {
std::cout << "%% Calling " << do_method << " of " << cmd_or_inter <<std::endl <<std::flush;
	do_method.Call(cmd_or_inter);  
  }
}

Am_Define_Method(Am_Object_Method, void, am_after_match_do_method,
		 (Am_Object cmd)) {
  Am_Object_Method do_method = cmd.Get(Am_REAL_DO_METHOD);
  if (do_method.Valid()) {
std::cout << "%% Calling " << do_method << " from cmd " << cmd <<std::endl <<std::flush;
	do_method.Call(cmd);  
  }
  Am_Object match_command = cmd.Get(Am_INVOKE_MATCH_COMMAND);
  match_and_run(cmd, match_command);
}

//find the child-most command that has a DO_Method
Am_Object find_top_of_impl_chain(Am_Object &orig_command) {
	Am_Object cmd = orig_command;
	Am_Object last_with_do = cmd;
	Am_Object next;
	while (true) {
		next = cmd.Get(Am_IMPLEMENTATION_CHILD);
		if (next.Valid()) {
			cmd = next;
			if (cmd.Peek(Am_DO_METHOD).Valid())
				last_with_do = cmd;
		}
		else return last_with_do;
	}
}

bool am_install_match_command(Am_Object &match_command,
			      Am_Object &script_execute_command) {
 std::cout << "\nInstalling match command " << match_command << " for "
       << script_execute_command <<std::endl <<std::flush;
  Am_Object command = match_command.Get(Am_COMMAND);
  Am_Object orig_command, installed_on_command;
  Am_Object widget = find_widget_for(command, orig_command);
 std::cout << "Found widget " << widget << " for " << orig_command
       <<std::endl <<std::flush;
  if (command.Peek(Am_REGISTER_COMMAND).Valid()) {
    Am_POP_UP_ERROR_WINDOW("Sorry, invoking on ANY command not implemented");
    return false;
  }
  match_command.Set(Am_WIDGET_FOR_COMMAND, widget);
  match_command.Set(Am_SCRIPT_EXECUTE_COMMAND, script_execute_command);
  Am_Object_Method new_method;
  int before_after = match_command.Get(Am_BEFORE_OR_AFTER);
  if (before_after == am_after_command) {
    new_method = am_after_match_do_method;
    installed_on_command = orig_command;
  }
  else {
    if (widget.Is_Instance_Of(Am_Interactor)) {
      //interactors do the work in the do method of the interactor,
      // instead of in the do method of the command object in the
      // interactor, so have to replace the do method of the interactor itself
      installed_on_command = widget;
    }
    else installed_on_command = find_top_of_impl_chain(orig_command);
    new_method = am_before_match_do_method;
  }
  if (!installed_on_command.Peek(Am_REAL_DO_METHOD).Valid()) {
    Am_Object_Method do_method = installed_on_command.Get(Am_DO_METHOD);
    if (do_method != am_after_match_do_method &&
	do_method != am_before_match_do_method)
      installed_on_command.Set(Am_REAL_DO_METHOD, do_method,
			       Am_OK_IF_NOT_THERE);
  }
 std::cout << "Setting DO_method of " << orig_command << " to "
       << new_method <<std::endl <<std::flush;
  installed_on_command.Set(Am_DO_METHOD, new_method);
  installed_on_command.Set(Am_INVOKE_MATCH_COMMAND, match_command,
			   Am_OK_IF_NOT_THERE);
  match_command.Set(Am_ORIG_COMMAND, orig_command);
  match_command.Set(Am_INSTALLED_ON_COMMAND, installed_on_command);
  return true;
}

bool am_remove_match_command(Am_Object &match_command) {
  Am_Object installed_on_command = match_command.Get(Am_INSTALLED_ON_COMMAND);
 std::cout << "*Removing match_command " << match_command << " for "
	   << installed_on_command <<std::endl <<std::flush;
  Am_Object_Method do_method = installed_on_command.Get(Am_REAL_DO_METHOD,
						Am_RETURN_ZERO_ON_ERROR);
  installed_on_command.Set(Am_DO_METHOD, do_method);
  installed_on_command.Set(Am_INVOKE_MATCH_COMMAND, (0L));
  return true;
}



//////////////////////////////////////////////////////////////////////////

Am_Object am_invoke_window_Initialize () {
  
  Am_Before_After_Match_Command = 
                Am_Command.Create(DSTR("Am_Before_After_Match_Command"))
    .Set(Am_LABEL, "Before_After_Match")
    .Add(Am_SHOW_SCRIPT_COMMAND, (0L))
    .Add(Am_COMMANDS_IN_SCRIPT, (0L))
    .Add(Am_COMMANDS_PROTOTYPES, (0L))
	.Add(Am_COMMAND, (0L))
    .Add(Am_ORIGINAL_COMMAND_LIST, (0L))
    .Add(Am_PLACEHOLDER_LIST, (0L))
    .Add(Am_PLACEHOLDER_COUNT, (0L))
   
    .Add(Am_BEFORE_OR_AFTER, (0L))
    .Add(Am_BEFORE_OR_AFTER_COMMAND, (0L))
	.Add(Am_ORIG_COMMAND, (0L))
	.Add(Am_INSTALLED_ON_COMMAND, (0L))
	.Add(Am_WIDGET_FOR_COMMAND, (0L))
	.Add(Am_SCRIPT_EXECUTE_COMMAND, (0L))
	.Add(Am_SLOTS_TO_SAVE, (0L))
	;
  am_invoke_window = Am_Window.Create(DSTR("script_invoke"))
    .Set(Am_DESTROY_WINDOW_METHOD, Am_Default_Pop_Up_Window_Destroy_Method)
    .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
    .Set(Am_TITLE, "How To Invoke Script")
    .Set(Am_WIDTH, 470)
    .Set(Am_HEIGHT, 350)

	.Add(Am_INVOKE_MATCH_COMMAND, (0L))
	.Add(Am_SCRIPT_WINDOW, (0L))
    ;
am_invoke_window
    .Add_Part(Am_Text.Create(DSTR("main_title"))
      .Set(Am_LEFT, 6)
      .Set(Am_TOP, 11)
      .Set(Am_TEXT, "Specify how to invoke the script:")
      .Set(Am_FONT, Am_Font(Am_FONT_FIXED, true, false, false, Am_FONT_LARGE))
      .Set(Am_LINE_STYLE, Am_Black)
      .Set(Am_FILL_STYLE, Am_No_Style)
    );
am_invoke_window
    .Add_Part(Am_DO_ACCELERATOR, Am_Checkbox.Create(DSTR("Am_DO_ACCEL"))
      .Set(Am_LEFT, 15)
      .Set(Am_TOP, 42)
      .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
		.Set(Am_FONT, Am_Font(Am_FONT_FIXED, true))
      .Get_Object(Am_COMMAND)
			.Set(Am_LABEL, "Accelerator Key:")
			.Set(Am_ID, true)
        .Get_Owner()
    )
    .Add_Part(Am_ACCELERATOR, Am_Text_Input_Widget.Create(DSTR("accel_string"))
      .Set(Am_LEFT, Am_Right_Of_Sibling(Am_DO_ACCELERATOR, 5))
      .Set(Am_TOP, 40)
      .Set(Am_WIDTH, 100)
      .Set(Am_HEIGHT, 25)
      .Get_Object(Am_COMMAND)
        .Set(Am_LABEL, "")
        .Get_Owner()
      .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
    );
am_invoke_window
	.Add_Part(Am_Button.Create(DSTR("no_accel"))
	   .Set(Am_LEFT, Am_Right_Of_Sibling(Am_ACCELERATOR, 5))
	   .Set(Am_TOP, 40)
	      .Set(Am_LEAVE_ROOM_FOR_FRINGE, false)
       .Get_Object(Am_COMMAND)
        .Set(Am_LABEL, "None")
		.Set(Am_DO_METHOD, clear_accel)
        .Get_Owner()
      .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
    );
am_invoke_window
    .Add_Part(Am_DO_MENU, Am_Checkbox.Create(DSTR("Am_DO_MENU"))
      .Set(Am_LEFT, 15)
      .Set(Am_TOP, 80)
		.Set(Am_FONT, Am_Font(Am_FONT_FIXED, true))
      .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
	     .Set(Am_ACTIVE_2, false) //NIY ***
      .Get_Object(Am_COMMAND)
			.Set(Am_LABEL, "In Application Menu:")
			.Set(Am_ID, true)
        .Get_Owner()
    );
am_invoke_window
  .Add_Part(Am_WHICH_APPL_MENU, Am_Option_Button.Create(DSTR("which_menu"))
	    .Set(Am_LEFT, 180)
		.Set(Am_TOP, 75)
	     .Set(Am_ACTIVE_2, false) //NIY ***
		.Set(Am_ITEMS, //**** TEMP
		    Am_Value_List().Add("File").Add("Edit")

		)
      .Get_Object(Am_COMMAND)
	    .Set(Am_DO_METHOD, do_top_menu_selected)
        .Get_Owner()
    .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
	);
am_invoke_window
	.Add_Part(Am_Text.Create(DSTR("before_item_text"))
	    .Set(Am_LEFT, 45)
		.Set(Am_TOP, 115)
		.Set(Am_FONT, Am_Font(Am_FONT_FIXED, true))
	   .Set(Am_TEXT, "Before Sub-Menu Item:")
	);
am_invoke_window
	.Add_Part(Am_WHICH_APPL_SUB_MENU, Am_Option_Button.Create(DSTR("which_sub_menu"))
	    .Set(Am_LEFT, 195)
		.Set(Am_TOP, 110)
	     .Set(Am_ACTIVE_2, false) //NIY ***
		.Set(Am_ITEMS, //**** TEMP
		    Am_Value_List()
		      .Add("<At end>").Add("<At top>").Add("Open").Add("Close")
		)
      .Get_Object(Am_COMMAND)
        .Get_Owner()
    .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
	);
 am_invoke_window
  .Add_Part(Am_Checkbox.Create(DSTR("time"))
	    .Set(Am_LEFT, 15)
	    .Set(Am_TOP, 140)
	    .Set(Am_FONT, Am_Font(Am_FONT_FIXED, true))
	    .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
	    .Set(Am_ACTIVE, false) //NIY ***
	    .Get_Object(Am_COMMAND)
	      .Set(Am_LABEL, "At time...")
	      .Set(Am_ID, true)
	      .Get_Owner()
    );
 am_invoke_window
   .Add_Part(Am_BEFORE_OR_AFTER, Am_Checkbox_Panel.Create(DSTR("BEFORE_OR_AFTER"))
      .Set(Am_LEFT, 15)
      .Set(Am_TOP, 170)
		.Set(Am_FONT, Am_Font(Am_FONT_FIXED, true))
      .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
      .Set(Am_ITEMS, Am_Value_List()
        .Add(Am_Command.Create()
             .Set(Am_LABEL, "After Command")
             .Set(Am_ID, am_after_command))
        .Add(Am_Command.Create()
             .Set(Am_LABEL, "Before Command")
             .Set(Am_ID, am_before_command))
        )
      .Set(Am_LAYOUT, Am_Vertical_Layout)
	  .Set(Am_HOW_SET, Am_CHOICE_TOGGLE)
      .Set(Am_H_SPACING, 0)
      .Set(Am_V_SPACING, 0)
      .Set(Am_MAX_RANK, 0)
    );
  am_invoke_window
    .Add_Part(Am_COMMAND_LOAD_BUTTON, Am_Button.Create(DSTR("Am_LOAD_BUTTON"))
      .Set(Am_LEFT, 145)
      .Set(Am_TOP, 185)
      .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
	      .Set(Am_LEAVE_ROOM_FOR_FRINGE, false)
	      .Set(Am_ACTIVE, am_before_or_after_picked)
	      .Get_Object(Am_COMMAND)
	        .Set(Am_LABEL, "Load")
	        .Set(Am_DO_METHOD, am_load_current_command_from_main)
	        .Get_Owner()
    );
  am_invoke_window
    .Add_Part(Am_COMMAND_GENERALIZE_BUTTON, Am_Button.Create(DSTR("Am_COMMAND_GENERALIZE_BUTTON"))
      .Set(Am_LEFT, 290)
      .Set(Am_TOP, 190)
      .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
	      .Set(Am_LEAVE_ROOM_FOR_FRINGE, false)
	      .Get_Object(Am_COMMAND)
	        .Set(Am_LABEL, "Generalize")
	        .Set(Am_DO_METHOD, am_pop_up_generalize_from_button)
	        .Set(Am_ACTIVE, am_generalize_script_active)
	        .Get_Owner()
    );
   Am_Object sg;
   am_invoke_window
     .Add_Part(Am_UNDO_SCROLL_GROUP,
	      sg = Am_Scrolling_Menu.Create(DSTR("cmds_in_script"))
      .Set(Am_LEFT, 15)
      .Set(Am_TOP, Am_Bottom_Of_Sibling(Am_BEFORE_OR_AFTER, 5))
      .Set(Am_WIDTH, Am_From_Owner(Am_WIDTH, -34))
      .Set(Am_HEIGHT, Am_Rest_Of_Height_Above(Am_UNDO_OPTIONS, 15))
      .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
	      .Set(Am_H_SCROLL_BAR, true)
      .Add_Part(Am_INTERACTOR,Am_One_Shot_Interactor.Create(DSTR("select_line_part"))
		.Set(Am_START_WHEN, Am_Input_Char("left_down"))
		.Set(Am_PRIORITY, 10.0)
		.Set (Am_START_WHERE_TEST, am_on_selectable_match_line_part)
		.Get_Object(Am_COMMAND)
		  .Set (Am_DO_METHOD, am_select_line_part)
		  .Set (Am_IMPLEMENTATION_PARENT, Am_NOT_USUALLY_UNDONE)
		  .Get_Owner()
		)
      .Add_Part(Am_ARROW_INTERACTOR,Am_One_Shot_Interactor.Create(DSTR("double_clk"))
		.Set(Am_START_WHEN, Am_Input_Char("double_left_down"))
		.Set(Am_PRIORITY, 10.0)
		.Set (Am_START_WHERE_TEST, am_on_selectable_match_line_part)
		.Get_Object(Am_COMMAND)
		  .Set (Am_DO_METHOD, am_generalize_match_double_click)
		  .Set (Am_IMPLEMENTATION_PARENT, Am_NOT_USUALLY_UNDONE)
		  .Get_Owner()
		)
      ) ;
  sg.Get_Object(Am_SUB_MENU)
    .Set(Am_V_SPACING, -4)
	.Set(Am_VISIBLE, menu_vis_if_before_after)
	.Set(Am_ACTIVE_2, false) //don't need to select the item in the menu
    .Get_Object(Am_ITEM_PROTOTYPE)
       .Set(Am_PRETEND_TO_BE_LEAF, false);
  sg.Get_Object(Am_COMMAND)
    .Set(Am_DO_METHOD, am_clear_select_line_part);

  am_invoke_window
    .Add_Part(Am_UNDO_OPTIONS, Am_Button_Panel.Create(DSTR("OK-cancel"))
      .Set(Am_LEFT, Am_Center_X_Is_Center_Of_Owner)
      .Set(Am_BOTTOM_OFFSET, 10)
      .Set(Am_TOP, Am_Bottom_Is_Bottom_Of_Owner)
      .Set(Am_FILL_STYLE, Am_Motif_Light_Green)
      .Set(Am_LAYOUT, Am_Horizontal_Layout)
      .Set(Am_H_SPACING, 20)
      .Set(Am_V_SPACING, 0)
      .Set(Am_MAX_RANK, 0)
      .Set(Am_ITEMS, Am_Value_List()
        .Add(Am_Standard_OK_Command.Create()
	      .Set(Am_DO_METHOD, am_invoke_ok)
	     )
        .Add(Am_Standard_Cancel_Command.Create()
	      .Set(Am_DO_METHOD, am_invoke_cancel)
	     )
        )
    );

am_invoke_window
      .Add_Part(Am_Tab_To_Next_Widget_Interactor.Create())
  ;


  Am_Object accel_input_widget = am_invoke_window.Get_Object(Am_ACCELERATOR);
  accel_input_widget.Get_Object(Am_INTERACTOR)
    .Set_Name(DSTR("Get_Accel_Key_Inter"))
    .Set(Am_STOP_WHEN, (0L)) //stopped by single_char_method
    .Set(Am_TEXT_EDIT_METHOD, single_char_method)
    ;

  return am_invoke_window;
}

/* BUGS:
**** Can't invoke before because the command sets up the values, so
the matches don't work.
**** AFTER scripts are still registered BEFORE the regular command,
     since the real command isn't finished yet.

 * Check out infinite loop when create does a create, or when change the start for a script
    between before and after
 * Check out bug that if script on text_edit, doesn't start because strings are not == 
 * Add a create_text_and_edit_it command so creating a signle action taht can start on
*/
