<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/function.php");
include_once("./functions/http.php");
include_once("./functions/patchutils.php");
include_once("./functions/SniffBrowser.php");

function get_patch_title($from, $type)
{
	global $CONFIG_VARS;

	if($type == "install")
		return "Install";
	else if($type == "optional")
		return "Optional Update";
	else//($type == "patch")
    	return "Upgrade ($from to ".$CONFIG_VARS['site.version'].")";
}

function print_header($from, $type)
{
	global $CONFIG_VARS;

	echo("<html>");
	echo("\n<head>");
	echo("\n<title>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version']." ".get_patch_title($from, $type)."</title>");

	if(file_exists('theme/default/style.css'))	
		echo("\n<link rel=stylesheet type=\"text/css\" href=\"theme/default/style.css\">");
	echo("\n<style type=\"text/css\">");
	echo ("\n.upgrade_success { background-color:#99FF99 }".
		"\n.upgrade_failure { background-color:#FF6666; font-weight: bold; font-family: courier,sans-serif }".
		"\n.upgrade_warning { background-color:orange; font-weight: bold; font-family: courier,sans-serif }".
		"\n.querytitle 		{ color: #6D78AB; font-family:Verdana, Arial; font-weight:bold  }".
		"\n.code 			{ color: black; font-family:Courier; font-weight:normal }");
	echo("\n</style>");
	echo("\n</head>");
}

/**
	Now we should be able to encapsulate a browser check, to see if DISABLED is supported.
*/
function print_button($name, $value, $disabled)
{
	// Is get_browser array.
	global $browser;

	if($browser && $browser['type'] == "Netscape" && substr($browser['version'],0,1) == "4")
	{
		if($disabled)
			echo("<input type=\"button\" name=\"$name\" value=\"$value (DISABLED)\">");
		else
			echo("<input type=\"submit\" name=\"$name\" value=\"$value\">");
	}
	else// For now this is all we are supporting.
		echo("<input type=\"submit\" name=\"$name\" value=\"$value\"".($disabled?" DISABLED":"").">");
}

// Override the patch.enable value, if a admin user is logged in.
if($CONFIG_VARS['patch.enable']!==TRUE && 
			$CONFIG_VARS['patch.allow_admin_override']===TRUE && 
			is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
{
	$CONFIG_VARS['patch.enable'] = TRUE;
}

session_start();
if($CONFIG_VARS['patch.enable']===TRUE)
{
	if(strlen($HTTP_VARS['from'])>0)
	{
		// no operation specified - set up frames.
		if(strlen($HTTP_VARS['op'])==0)
		{
			print_header($HTTP_VARS['from'], $HTTP_VARS['type']);

			// Notice no $op defined!
			$url = get_url_string($HTTP_VARS);
			?>	

			<frameset scrolling="yes" rows="50%,*" border="1" frameborder="1">
				<frame name="menu" src="<?php echo("$PHP_SELF?$url&op=menu"); ?>">
				<frame name="main" src="<?php echo("$PHP_SELF?$url&op=main"); ?>">

			   <noframes>
					<body>
        				<p>This page uses frames, but your browser doesn't support them.
						Please upgrade your browser to one that does!</p>
					</body>
				</noframes>
			</frameset>

			<?php
		}
		else//op specified.
		{
			print_header($HTTP_VARS['from'], $HTTP_VARS['type']);

			if($HTTP_VARS['op'] == "menu")
			{
				echo("<div align=right><h1>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version']."</h1>");
				echo ("<font class=\"footer\">Finish applying the patch? [<a href=\"$PHP_SELF\" target=\"_parent\">Apply another patch</a>] or [<a href=\"index.php\" target=\"_parent\">Login to OpenDb</a>]</font></div>");
				
		    	echo ("<h2>OpenDb Patch facility ".get_patch_title($HTTP_VARS['from'], $HTTP_VARS['type'])."</h2>");
				echo("<h3>".$HTTP_VARS['title']."</h3>");
			}
			else if($HTTP_VARS['op'] == "result")
			{
				echo ("<h3>Results...</h3>");	
			}

			// Ignore any errors.
			$browser = @SniffBrowser();

			// Set a time limit of a good value, because some of the patches do a lot of work.
			@set_time_limit(600);

			if(file_exists("./patch/".$HTTP_VARS['from']."/index.php"))
			{
				include("./patch/".$HTTP_VARS['from']."/index.php");
			}
			else//Default
			{
				if($HTTP_VARS['op'] == "menu")
				{
					echo("<div align=\"center\">");
					$files = get_patch_file_list($HTTP_VARS['from'],"sql");
					if(is_not_empty_array($files))
					{
						echo("<form action=\"$PHP_SELF\" method=\"get\" target=\"main\">");
						while (list(,$file) = each($files))
						{
							print_button("sqlfile", "$file", FALSE);
							echo("&nbsp;");
						}
						echo("<br>");
						echo("Preview SQL only<input type=\"checkbox\" name=\"preview\" value=\"true\">");
						echo("<input type=\"hidden\" name=\"op\" value=\"result\">");
						echo("<input type=\"hidden\" name=\"from\" value=\"".$HTTP_VARS['from']."\">");
						echo("</form>");
					}
					else
					{
						echo("<div class=\"error\">- No Files Found -</div>");
					}
					echo("</div>");
				}
				else
				{
					if($HTTP_VARS['preview'] == "true")
						echo_patch_sql_file($HTTP_VARS['from'], $HTTP_VARS['sqlfile']);
					else if(isset($HTTP_VARS['sqlfile']))
						exec_patch_sql_file($HTTP_VARS['from'], $HTTP_VARS['sqlfile']);
				}
			}
			if ($HTTP_VARS['op']=="result")//refresh menu for result.
				echo( "<script language=\"javascript\"><!-- //hide\nparent.frames[0].location.reload();\n// -->\n</script>");

			echo("</body>");
		}
	}
	else
	{
		print_header($HTTP_VARS['from'], $HTTP_VARS['type']);
		echo("<div align=right><h1>".$CONFIG_VARS['site.title']." ".$CONFIG_VARS['site.version']."</h1>");
		echo ("<font class=\"footer\">[<a href=\"index.php\" target=\"_parent\">Login to OpenDb</a>]</font></div>");
		?>
		<h2>OpenDb Patch facility</h2>

	<h3>Upgrade:</h3>

  	<p><div class="help">
    <b>Notes: </b>
    <ul>
   	<li>If you are upgrading from OpenDb versions between 0.30 and 0.38 you will need to upgrade to 0.50, then upgrade <i>' 0.50, 0.51, 0.52 or 0.53 to 0.54'</i>, and finally
    run the <i>'0.54 to <?php echo $CONFIG_VARS['site.version']; ?>'</i> patch.</li>
    <li>If you are upgrading from OpenDb versions between 0.50 and 0.53, you will need to run the <i>' 0.50, 0.51, 0.52 or 0.53 to 0.54'</i> patch prior to
	running the <i>'0.54 to <?php echo $CONFIG_VARS['site.version']; ?>'</i> patch.</li>
    <li>Upgrading <i>'DVDDBp 1.45 to <?php echo $CONFIG_VARS['site.version']; ?>'</i> will <u>not</u> populate a prefixed table structure.  The include/config.php
    variable $CONFIG_VARS['db_server.table_prefix'], should be disabled.</li>
    </ul>
    </div></p>

    <!-------------------------------------Custom Section -------------------------------->
 	<ul>
    <li><a href="<?php echo $PHP_SELF; ?>?from=install&type=install">New <?php echo $CONFIG_VARS['site.version']; ?> Installation</a></li>
	<li><a href="<?php echo $PHP_SELF; ?>?from=0.61&type=patch">Upgrade from OpenDb 0.61 to <?php echo $CONFIG_VARS['site.version']; ?></a></li>
	<li><a href="<?php echo $PHP_SELF; ?>?from=0.60&type=patch">Upgrade from OpenDb 0.60 to <?php echo $CONFIG_VARS['site.version']; ?></a></li>
	<li><a href="<?php echo $PHP_SELF; ?>?from=0.54&type=patch">Upgrade from OpenDb 0.54 to <?php echo $CONFIG_VARS['site.version']; ?></a></li>
	<li><a href="<?php echo $PHP_SELF; ?>?from=0.50&type=patch&title=Upgrade+from+OpenDb+0.50,+0.51,+0.52+or+0.53">Upgrade from OpenDb 0.50, 0.51, 0.52 or 0.53 to 0.54</a></li>
	<li><a href="<?php echo $PHP_SELF; ?>?from=dvddbp&type=patch">Upgrade from DVDDBp 1.45 to <?php echo $CONFIG_VARS['site.version']; ?></a></li>
	</ul>
 
	<ul>
	<li><a href="<?php echo $PHP_SELF; ?>?from=0.38&type=patch">Upgrade from OpenDb 0.38 to 0.50</a></li>
	<li><a href="<?php echo $PHP_SELF; ?>?from=0.37&type=patch">Upgrade from OpenDb 0.37 to 0.50</a></li>
	<li><a href="<?php echo $PHP_SELF; ?>?from=0.36&type=patch">Upgrade from OpenDb 0.36 to 0.50</a></li>
	<li><a href="<?php echo $PHP_SELF; ?>?from=0.35p2&type=patch">Upgrade from OpenDb 0.35p2 to 0.50</a></li>
	<li><a href="<?php echo $PHP_SELF; ?>?from=0.34p2&type=patch">Upgrade from OpenDb 0.34p2 to 0.50</a></li>
	<li><a href="<?php echo $PHP_SELF; ?>?from=0.33-dev3&type=patch">Upgrade from OpenDb 0.33-dev3 to 0.50</a></li>
	<li><a href="<?php echo $PHP_SELF; ?>?from=0.30&type=patch">Upgrade from OpenDb 0.30rc5 to 0.50</a></li>
	</ul>

    <!-------------------------------------Custom Section -------------------------------->
	<h3>Optional:</h3>
	<ul>
		<li>
			<a href="<?php echo $PHP_SELF; ?>?from=prefix&type=optional&title=Prefix+Tables">Prefix tables</a>
			<br>Add/Remove OpenDb table prefixes.  The $CONFIG_VARS['db_server.table_prefix'] variable must be set to
			the correct value (Especially important for removing the prefix!)
		</li>

		<li>
			<a href="<?php echo $PHP_SELF; ?>?from=session&type=optional&title=Database+Session+Handler">Database Session Handler</a>
			<br>Add/Remove Session table.  You should have the $CONFIG_VARS['session_handler.?????'] options configured correctly,
			to ensure the table is inserted into the correct database, with the right name.  As a minimum you should define
			a $CONFIG_VARS['session_handler.session_table'], otherwise <b><i>php_session</i></b> will be used for the table name.
		</li>

		<li><a href="<?php echo $PHP_SELF; ?>?from=site&type=optional&title=Site+Plugins">Site Plugins</a>
			<br>Administer site plugin configuration and links to item types.
		</li>

		<li><a href="<?php echo $PHP_SELF; ?>?from=item_types&type=optional&title=Custom+Item+Types">Custom Item Types</a>
			<br>Book, Game, DIVX, etc
		</li>
		
		<li><a href="<?php echo $PHP_SELF; ?>?from=extras&type=optional&title=Extra+Stuff">Extra stuff</a>
			<br>Extras such as Alternate title configuration, Extra Subtitles, etc.
		</li>

		<li><a href="<?php echo $PHP_SELF; ?>?from=lang&type=optional&title=International+Language+Support">International Language</a>
			<br>Configure OpenDb for a particular language.  You will still have to modify the
			include/config.php $CONFIG_VARS['site.language'] variable.
		</li>

		<li><a href="<?php echo $PHP_SELF; ?>?from=country&type=optional&title=Customise+for+Country">Customise for Country</a>
			<br>Age Recommendations, DVD Region, etc.
		</li>
	</ul>
	<!------------------------------------------------------------------------------------------->

	<br><br><hr>
	<div class="help">
	<b>Notes:</b>
	<ul>
	<li>Please make sure that the MySQL user has sufficient permissions to perform the necessary update
	operations.  The permissions should include {Select, Insert, Update, Delete, Create, Drop, Index, Alter}
	for the current database.  You can remove these permissions once the patch has been performed.</li>
	<br><br>
	<li>Ensure that you choose the right patch.  For the Upgrade patches be aware that even though it specifies
	a certain version, if another patch for an earlier version includes your version, use
	that one instead.  For example 'OpenDb 0.33-dev3', will not upgrade from 'OpenDb 0.30rc5' because
	there is another patch for that.  So 'OpenDb 0.33-dev3' is actually anything between OpenDb 0.33-dev3
	and the current release.  By the same token, don't use 'OpenDb 0.33-dev3', if you are already at 'OpenDb 0.39',
	for instance, because it will try to upgrade features of OpenDb that have already been updated.</li>

	</ul>
	</div>

	</body>
	<?php
	}
}
else
{
	echo _theme_header("Patch facility is not available.");
	echo _theme_error("Patch facility is not available.");
	echo _theme_footer();
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
</html>
