#
# Upgrade from 0.36
#

#
# Update all IMAGEURL item_attributes to include 'http://' prefix!
# This is required for the new support for locally stored Cover images.  We need to be able to check for 
# the existence of 'http://' at the start of IMAGEURL attribute_val, to work out whether they are relative
# or not.
#
UPDATE item_attribute SET attribute_val = CONCAT('http://',attribute_val) WHERE s_attribute_type = 'IMAGEURL' AND attribute_val NOT LIKE 'http://%' AND LENGTH(TRIM(attribute_val)) > 0;

#
# Ordering of s_item_type's in Lists of Values, etc.
# The tinyint(2) unsigned limits the number of order_no to 100 (including 0)
#
ALTER TABLE s_item_type ADD order_no tinyint(2) unsigned AFTER default_site_type;

#
# Default order for all system item types.
#
UPDATE s_item_type set order_no = 0 where s_item_type = 'DVD';
UPDATE s_item_type set order_no = 1 where s_item_type = 'VHS';
UPDATE s_item_type set order_no = 2 where s_item_type = 'CD';
UPDATE s_item_type set order_no = 3 where s_item_type = 'DIVX';
UPDATE s_item_type set order_no = 4 where s_item_type = 'VCD';
UPDATE s_item_type set order_no = 5 where s_item_type = 'LD';

#
# Replace category_ind/image_ind and now duration_ind with a new s_field_type, which
# will have values like 'CATEGORY', 'IMAGE', 'DURATION'
#
ALTER TABLE s_item_attribute_type ADD s_field_type varchar(10) AFTER prompt;

UPDATE s_item_attribute_type SET s_field_type = 'CATEGORY' where UPPER(category_ind) = 'Y';
UPDATE s_item_attribute_type SET s_field_type = 'IMAGE' where UPPER(image_ind) = 'Y';

ALTER TABLE s_item_attribute_type DROP category_ind;
ALTER TABLE s_item_attribute_type DROP image_ind;

#
# By default the display_type of all input_type = 'hidden', should also be
# hidden, but only if display_type does not already have a value.
#
UPDATE s_attribute_type SET display_type = 'hidden' WHERE input_type = 'hidden' AND LENGTH(TRIM(display_type)) = 0;

# All the prompts here are the same as that defined in s_attribute_type for 'MOVIEGENRE'
update s_item_attribute_type set prompt = NULL
where s_attribute_type = 'MOVIEGENRE';

# Reduce s_attribute_type_lookup value column size
ALTER TABLE s_attribute_type_lookup CHANGE value value varchar(100) NOT NULL;

#
# Borrow Duration.  A maximum of 999 days is all that is allowed for borrow_duration/total values.
#
ALTER TABLE item_instance ADD borrow_duration smallint(3) unsigned AFTER owner_id;
ALTER TABLE borrowed_item ADD borrow_duration smallint(3) unsigned AFTER borrower_id;
ALTER TABLE borrowed_item ADD total_duration smallint(3) unsigned AFTER borrow_duration;

#
# This attribute is reserved for use in Borrow Duration functionality.  Please do not use it for your own s_item_attribute_type structures.
# If you want you could run this update to change the input type for S_DURATION a numeric input field instead:
# UPDATE s_attribute_type SET input_type = 'number(3, %field% <i>days</i>)' WHERE s_attribute_type = 'S_DURATION'
#
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'S_DURATION', 'Borrow Duration', 'Borrow Duration', 'single_select(%display%)', NULL, NULL);

INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '0', '', 'Undefined', NULL, 'Y');
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '1', '1', 'One Day', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '2', '3', 'Three Days', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '3', '7', 'One Week', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '4', '14', 'Two Weeks', NULL, NULL);
INSERT INTO s_attribute_type_lookup (s_attribute_type, order_no, value, display, img, checked_ind) VALUES ('S_DURATION', '5', '28', 'One Month', NULL, NULL);

#
# Now link it in.
#
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'S_DURATION', '200', NULL, 'DURATION', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'S_DURATION', '200', NULL, 'DURATION', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'S_DURATION', '200', NULL, 'DURATION', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'S_DURATION', '200', NULL, 'DURATION', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'S_DURATION', '200', NULL, 'DURATION', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'S_DURATION', '200', NULL, 'DURATION', NULL);

#
# For performance reasons you should explicity set the display_type of any attributes where no comparison
# to lookup values is required.
#
UPDATE s_attribute_type SET display_type = '%value%' WHERE s_attribute_type IN('ALT_TITLE','COMMENTS','MOVIE_PLOT','CDTRACK','CDTIME');

#
# List Link functionality
#
UPDATE s_attribute_type SET display_type = 'display(%value%, list-link)' where s_attribute_type IN('YEAR','VID_FORMAT','DVD_REGION');
UPDATE s_attribute_type SET display_type = 'display(%display%, list-link)' where s_attribute_type IN('VIDQUALITY','VHS_TYPE','DIVXVIDVER','DIVXAUDVER','DIVXQUALIT');
UPDATE s_attribute_type SET display_type = 'display(%img% %display%, list-link)' where s_attribute_type IN('AUDIO_LANG', 'SUBTITLES');

# Do it for Director as well in case there is dual directorship!
UPDATE s_attribute_type SET display_type = 'list(plain, " ", list-link)' where s_attribute_type IN('DIRECTOR','ACTORS','ARTIST');
# The display(%value%, list-link) widget does not work for attributes which have more than one %value%.
UPDATE s_attribute_type SET display_type = 'list(plain, " ", list-link)' where s_attribute_type IN('RATIO');
UPDATE s_attribute_type SET display_type = 'display(%img%, list-link)' where s_attribute_type  = 'AGE_RATING';
UPDATE s_attribute_type SET display_type = 'category(%display%, list-link)' where s_attribute_type IN('MOVIEGENRE','MUSICGENRE');

#
# Save Covers locally functionality.
#
UPDATE s_attribute_type SET input_type = 'upload_or_saveurl(50,*,"gif,jpg,png")', display_type = 'hidden' WHERE s_attribute_type = 'IMAGEURL';

#
# Used to display item.id in item_display.php script.
#
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'S_ITEM_ID', 'OpenDb Item ID', 'ID#', 'hidden', '%value%', NULL);

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'S_ITEM_ID', '0', NULL, 'ITEM_ID', NULL);

# Amazon dummy attribute - may never be used to populate records, but will allow addition of links to particular items.
INSERT INTO s_attribute_type (s_attribute_type, description, prompt, input_type, display_type, site_type) VALUES ( 'AMAZONASIN', 'Amazon Standard Item Number', 'Amazon ASIN', 'hidden', 'hidden', 'amazon');

INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DVD', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'LD', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VHS', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'VCD', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'DIVX', 'AMAZONASIN', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'AMAZONASIN', '0', NULL, NULL, NULL);
