<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
function check_if_installed()
{
	global $CONFIG_VARS;

	return check_table($CONFIG_VARS['session_handler.session_table'],
						FALSE,
						'session_handler');
}

if($CONFIG_VARS['patch.enable']===TRUE)
{
	if($HTTP_VARS['op'] == "menu")
	{
		if($CONFIG_VARS['session_handler.enable'] === TRUE)
		{
			// We only want to run the check_table query once!
			$table_installed = check_if_installed();
	
			echo("<div align=\"center\">");
			echo("<form action=\"$PHP_SELF\" method=\"get\" target=\"main\">");
			print_button("add", "Add ".strtoupper($CONFIG_VARS['session_handler.session_table'])." Table", $table_installed);
			echo("&nbsp;");
			print_button("remove", "Remove ".strtoupper($CONFIG_VARS['session_handler.session_table'])." Table", !$table_installed);
			echo("<br>");
			echo("<input type=\"hidden\" name=\"op\" value=\"result\">");
			echo("<input type=\"hidden\" name=\"from\" value=\"".$HTTP_VARS['from']."\">");
			echo("</form>");
			echo("</div>");
		}
		else
		{
			echo("<div class=\"error\">The <b>\$CONFIG_VARS['session_handler.enable']</b> variable must be TRUE.</div>");
		}			
	}
	else
	{
		if($CONFIG_VARS['session_handler.enable'] === TRUE)
		{
			// We only want to run the check_table query once!
			$table_installed = check_if_installed();
			
			if(isset($HTTP_VARS['add']))
			{
				if(!$table_installed)
				{
					$sql_command =
						"CREATE TABLE ".$CONFIG_VARS['session_handler.session_table'].
						"\n(".
						"\n\tSID char(32) NOT NULL,".
						"\n\texpiration INT NOT NULL,".
			  			"\n\tvalue TEXT NOT NULL,".
						"\n\tPRIMARY KEY(SID)".
						"\n)";

					echo("<div class=\"code\"><pre>$sql_command;</pre></div>\n");
					if(run_opendb_query($sql_command, FALSE, 'session_handler'))
						echo("<div class=\"upgrade_success\">SQL query evaluated successfully.</div>\n");
					else
						echo("<div class=\"upgrade_failure\">SQL query evaluation failed. (".mysql_error().")</div>\n");
				}
				else
					echo("<div class=\"upgrade_warning\">Table ".$CONFIG_VARS['session_handler.session_table']." exists.</div>\n");
			}
			else if(isset($HTTP_VARS['remove']))
			{
				if($table_installed)
				{
					$sql_command = "DROP TABLE ".$CONFIG_VARS['session_handler.session_table'];
				
					echo("<div class=\"code\"><pre>$sql_command;</pre></div>\n");
					if(run_opendb_query($sql_command, FALSE, 'session_handler'))
						echo("<div class=\"upgrade_success\">SQL query evaluated successfully.</div>\n");
					else
						echo("<div class=\"upgrade_failure\">SQL query evaluation failed. (".mysql_error().")</div>\n");
				}
				else
					echo("<div class=\"upgrade_warning\">Table ".$CONFIG_VARS['session_handler.session_table']." not found.</div>\n");
			}
		}//if($CONFIG_VARS['session_handler.enable'] === TRUE)		
	}
}
?>
