<?php
//
// Config file for IMDB site
//

$site_title = "Imdb";

// Specifies any mappings between what is passed from the site plugin, and what
// the item_input script expects to receive.  Format is site variable=>s_attribute_type.
// If they are the same, then do not bother including them.
$site_attribute_map = array("genre"=>"category", "plot"=>"movie_plot");

// If you want to insert the 'title' into an attribute as well as the title specify it here.
$title_attribute = "alt_title";

// Relative link to image_icon
$site_image_icon = "imdb.gif";

// So we can link off here.
$site_external_link = "http://www.imdb.com";

// Define the fields that should be included in the input form for the add_item page.
// The field prompt is defined in $LANG_VARS['site']['$site']['input_fields']['?????']
$site_input_fields = array(
						array(field=>"title", type=>"", value=>"", refresh_mask=>"{ifdef(alt_title,'{alt_title}','{title}')}{ifdef(year,' ({year})')}"),
						array(field=>"imdb_id", type=>"hidden", value=>"", refresh_mask=>"{imdb_id}"));


//---------------------------------------------------------------------------------
// AGE CERTIFICATION CONFIGURATION
//---------------------------------------------------------------------------------
// What to search for in IMDB Certification section.  Include "USA" as last rating
// to use this as a default.
$age_certification_codes = array("Australia","USA");

//
// Map 'USA' IMDB age certification values to local equivalents in use within OpenDb.
// The mapped to value should be the same as the value for AGE_RATING in 
// s_attribute_type_lookup table.
//
// NOTE: This will be ignored if you have defined $age_certification_codes and have not
// included a 'USA' entry.
//
// USA -> AUSTRALIAN (approx) conversions.
//
$usa_age_certification_map = array("PG-13"=>"PG", "R"=>"MA", "NC-17"=>"MA", "X"=>"R");

//---------------------------------------------------------------------------------
// ITEM_DISPLAY LINKS
//---------------------------------------------------------------------------------
// Define structure of link block, but only if $item_r is defined.
if(is_array($item_r))
{
	$imdb_id = fetch_attribute_val($item_r['item_id'], "IMDB_ID", NULL);
	if(strlen($imdb_id)>0)
	{
		$site_item_link_rs[] = array(link=>$LANG_VARS['more_info'],url=>"http://www.imdb.com/Title?$imdb_id");
		$site_item_link_rs[] = array(link=>"Trailer",url=>"http://www.imdb.com/Trailers?$imdb_id");
	}
	else
	{
		$year = trim(fetch_attribute_val($item_r['item_id'], "YEAR", NULL));
		$site_item_link_rs[] = array(link=>$LANG_VARS['more_info'],url=>"http://www.imdb.com/Tsearch?title=".rawurlencode($item_r['title'])."&type=substring&year=$year");
	}
}
?>
