<?php
/* 	OpenDb - Open Lending Database Project
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

// This must be first - includes config.php
require_once("./include/begin.inc.php");

include_once("./include/language.php");
include_once("./include/theme.php");

include_once("./functions/function.php");
include_once("./functions/user.php");
include_once("./functions/datetime.php");
include_once("./functions/borrowed_item.php");
include_once("./functions/listings.php");
include_once("./functions/Listing.class.inc");

session_start();
if (is_opendb_valid_session())
{ 
	echo _theme_header($LANG_VARS['user_list']);
	echo("<h2>".$LANG_VARS['user_list']."</h2>");

	if (is_user_admin($HTTP_SESSION_VARS['user_id'], $HTTP_SESSION_VARS['user_type']))
	{
		$redirectUrl = get_url_string(
									$HTTP_VARS,
									NULL, //extra
									array('internal_link', 'redirect_url', 'redirect_link', 'subject', 'user_id_rs', 'checked_user_id_rs', 'checked_user_id_rs_list'));//exclude
									
		if(strlen($redirectUrl)>0)
			$HTTP_VARS['redirect_url'] = urlencode("$PHP_SELF?$redirectUrl");
		else
			$HTTP_VARS['redirect_url'] = urlencode($PHP_SELF);
		
		$HTTP_VARS['redirect_link'] = $LANG_VARS['back_to_user_listing'];
		$HTTP_VARS['subject'] = 'No Subject';
		
		$listingObject = new Listing($HTTP_VARS['mode'], $CONFIG_VARS['user_admin.navigation_form_method']);
		$listingObject->setItemsPerPage($CONFIG_VARS['listings.items_per_page']);
		$listingObject->setCheckBoxColumn('user_id_rs', $CONFIG_VARS['email.use_php_mail']!==FALSE, $LANG_VARS['no_users_checked']);
		$listingObject->setCheckedList(NULL, $HTTP_VARS);
		$listingObject->setTotalItems(fetch_user_cnt(NULL, TRUE));
		$listingObject->initListing($HTTP_VARS);
	
		$listingObject->startListing($PHP_SELF, $HTTP_VARS);

		$listingObject->startHeaderRow();
		$listingObject->writeHeaderColumn($LANG_VARS['user'], "user_id");
		$listingObject->writeHeaderColumn($LANG_VARS['action']);
		$listingObject->writeHeaderColumn($LANG_VARS['user_type'], "type");
		$listingObject->writeHeaderColumn($LANG_VARS['location'], "location");
		$listingObject->writeHeaderColumn($LANG_VARS['email'], "email");
		$listingObject->writeHeaderColumn($LANG_VARS['last_visit'], "lastvisit");
		$listingObject->endHeaderRow();

		$result = fetch_user_rs(
						NULL, //$user_types
						$HTTP_VARS['order_by'],
						$HTTP_VARS['sortorder'], 
						TRUE, //$include_deactivated_users
						NULL, //$exclude_user
						$listingObject->getStartIndex(),
						$listingObject->getItemsPerPage());
		if($result)
		{
			while ($user_r = mysql_fetch_array($result))
			{
				$listingObject->startRow();

				// checkbox
				if($listingObject->isCheckBoxColumn())
				{
					$listingObject->writeColumn($user_r['user_id']);
				}
				
				$user_name = replace_lang_vars(
								array('fullname'=>str_replace(" ", "&nbsp;", $user_r['fullname']), 'user_id'=>$user_r['user_id']), 
								$LANG_VARS['user_name']);
					
				// This item count, is all 'visible' items.  Some may not be visible even to the Administrator!!!
				// Because of the min_display_user_type being set to a non existent user type!!!
				if(is_user_active($user_r['user_id']) && fetch_owner_item_cnt($user_r['user_id'])>0)
					$listingObject->writeColumn("<a href=\"listings.php?owner_id=".$user_r['user_id']."&s_status_type=ALL&order_by=title&sortorder=ASC\">".$user_name."</a>");
				else
					$listingObject->writeColumn($user_name);

				$action_links_rs = NULL;
				$action_links_rs[] = array(url=>'user_admin.php?op=edit&uid='.$user_r['user_id'],img=>'edit.gif',text=>$LANG_VARS['edit']);

				if(is_user_active($user_r['user_id']) && $user_r['user_id'] != $HTTP_SESSION_VARS['user_id'])
				{
					if($CONFIG_VARS['user_admin.user_delete_support'] === TRUE)
						$action_links_rs[] = array(url=>'user_admin.php?op=delete&uid='.$user_r['user_id'],img=>'delete.gif',text=>$LANG_VARS['delete_user']);
					else if($CONFIG_VARS['user_admin.user_delete_support'] === 'deactivate')
						$action_links_rs[] = array(url=>'user_admin.php?op=deactivate&uid='.$user_r['user_id'],img=>'delete.gif',text=>$LANG_VARS['deactivate_user']);
				}
				$action_links_rs[] = array(url=>'email.php?op=send_to_uid&uid='.$user_r['user_id'].'&subject='.urlencode($LANG_VARS['no_subject']).'&redirect_link='.urlencode($LANG_VARS['back_to_user_listing']).'&redirect_url='.urlencode($PHP_SELF.'?'.get_url_string($HTTP_VARS)),img=>'email.gif',text=>$LANG_VARS['send_email']);
					
				$listingObject->writeColumn(
							NULL,
							$action_links_rs);
				
				$listingObject->writeColumn(
						(is_user_active($user_r['user_id'])?get_usertype_description($user_r['type']):$LANG_VARS['deactivated']));
						
				$listingObject->writeColumn($user_r['location']);
				$listingObject->writeColumn($user_r['email']);
				$listingObject->writeColumn(
						(strlen($user_r['lastvisit'])>0?get_localised_timestamp($CONFIG_VARS['user_admin.datetime_mask'],$user_r['lastvisit']):$LANG_VARS['never_logged_in']));
				
				$listingObject->endRow();
			}
			mysql_free_result($result);
		} //if($result)
			
		if($CONFIG_VARS['email.use_php_mail']!==FALSE)
		{
			$listingObject->addListOpAction(
								$LANG_VARS['email_users'], 
								'email.php', 
								'send_to_uids', 
								$listingObject->getCheckedListCount() == 0);
		}
		
		$listingObject->endListing();
		
		echo(format_help_block($LANG_VARS['user_listing_help']));
	}//not an administrator or own user.
	else
	{
		echo _theme_header($LANG_VARS['not_authorized_to_page']);
		echo _theme_error($LANG_VARS['not_authorized_to_page']);
	}	
	echo _theme_footer();
}
else
{
	include("./include/invalidsession.php");
}

// Cleanup after begin.inc.php
require_once("./include/end.inc.php");
?>
