<?php
/* 	OpenDb - Open Media Lending Database
	Copyright (C) 2001,2002 by Jason Pell

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

include_once("./functions/utils.php");
include_once("./functions/http.php");

define('OPENDB_LOG_ERROR', 'E');
define('OPENDB_LOG_WARN', 'W');
define('OPENDB_LOG_INFO', 'I');

/**
	Appends the given text to the logfile

	This function does some checking to make sure the entry does not
	go over 4000 characters, so as not to confuse the logfile.php
	script.
	
	sequence_number		INTEGER(20) UNSIGNED NOT NULL auto_increment,
	msgtype			VARCHAR(1) NOT NULL,
	scriptname		VARCHAR(255),
	functionname	VARCHAR(255),
	msg_detail		VARCHAR(255) NOT NULL,
	er_details		VARCHAR(255),		
	parameters		TEXT,
	remote_addr		VARCHAR(15) NOT NULL,
	user_id			VARCHAR(20) NOT NULL,	
	create_dt		
	
	@param $location - location where error occurred.  This should
	be the script.function or script.class.function.  The last period
	will be used to split the name into scriptname / script.class and
	function.
*/
function opendb_logger($msgtype, $scriptname, $functionname, $msg_detail, $err_details, $params_r)
{
	global $HTTP_SESSION_VARS;
	global $CONFIG_VARS;
	
	if($CONFIG_VARS['logging.enable']) // only log if enabled in config.php
	{
		$msgtype = strtoupper($msgtype);
		if(!in_array($msgtype, array('E','I','W')))
			$msgtype = 'E';
		
		$parameters = '';
		if(is_array($params_r))
		{
			$parameters = '';
			reset($params_r);
			while(list($key, $value) = each($params_r))
			{
				if(strlen($parameters)>0)
					$parameters .= ', ';
				
				// might not provide named key values, as for example insert statements its assumed parameters are listed in order
				// passed into the function.
				if(!is_numeric($key))
					$parameters .= $key .'='. $value;
				else
					$parameters .= $value;
			}
		}
		
		//$remote_addr = ifempty(get_http_env("REMOTE_ADDR"),"0.0.0.0");
		
		//for now we are still going to write to a file, but will eventually
		//replace with database table.
		
		// temp bit here!
		switch($msgtype)
		{
			case 'E':
				$message = '[error] ';
				break;
			case 'W':
				$message = '[warn] ';
				break;
			case 'I':
				$message = '[info] ';
				break;
		}
		
		if(strlen($scriptname)>0)
			$message .= $scriptname.'.'.$functionname.':';
		else if(strlen($functionname)>0)
			$message .= $functionname.':';
		
		if(strlen($msg_detail)>0)
			$message .= ' '.$msg_detail;
		
		if(strlen($parameters)>0)
			$message .= ' ('.$parameters.')';
		
		if(strlen($err_details)>0)
			$message .= ' ['.$err_details.']';

		opendb_log($message);
	}
}

function opendb_log($message)
{
	// from config.php
	global $CONFIG_VARS;

	if($CONFIG_VARS['logging.enable']) // only log if enabled in config.php
	{
		$date = date("d/m/y H:i:s ");  // get time and date
		$ip = ifempty(get_http_env("REMOTE_ADDR"),"0.0.0.0");
		
		// Get rid of any tabs so we can use as delimiter in logfile.
		$message = str_replace("\t", "    ", $message);
		// Get rid of newlines as they will confuse the log parser.
		$message = str_replace("\n", " ", $message);
		
		$fileptr = @fopen($CONFIG_VARS['logging.file'], "a" ); // hide errors
		if( $fileptr )	// verify file was opened
		{
			// If the overall length of the entry is greater than 4000 characters,
			// then cut the $message variable down by how many characters over 
			// 4000 the $length comes out as!
			$length = strlen("$date\t$message\t$ip\n");
			if($length>4000)// The +3 on the next line is for the "..." characters.
				$message = substr($message,0,4000-($length+3))."...";// Not that the result of 4000-($length+3)
														//show be negative, as this is how I am using substr!!!
			fwrite( $fileptr, "$date\t$message\t$ip\n");
			fclose( $fileptr );
		}
	}
}
?>
