#
# Patch for 0.51 - system data only, no structural changes.
#

#
# Hide ID#
#
UPDATE s_attribute_type
SET display_type = 'hidden' 
WHERE s_attribute_type = 'S_ITEM_ID';

#
# BOOK - Update Category display type so that list-link's work.
#
UPDATE s_attribute_type
SET display_type = 'category(%display%, list-link)' 
WHERE s_attribute_type = 'BOOKGENRE';

#
# Update GAME system data
#
UPDATE s_item_attribute_type
SET s_attribute_type = 'NO_PLAYERS'
WHERE s_item_type = 'GAME' AND s_attribute_type = 'NBPLAYERS';

UPDATE s_attribute_type
SET input_type = 'value_select("1,2,3,4,5,6,7,8,9,10")' 
WHERE s_attribute_type = 'NO_PLAYERS';

#
# NO_DISCS patch
#
DELETE from s_attribute_type_lookup WHERE s_attribute_type = 'NO_DISCS';
UPDATE s_attribute_type
SET input_type = 'value_select("1,2,3,4,5,6")', display_type = '%value%' 
WHERE s_attribute_type = 'NO_DISCS';

#
# DVD_REGION update
#
UPDATE s_attribute_type
SET input_type = 'checkbox_grid(%value% - %display%, 1)',
display_type = 'list(plain, " ", list-link)' 
WHERE s_attribute_type = 'DVD_REGION';

#
# DVD_EXTRAS update
#
UPDATE s_attribute_type
SET display_type = 'list(ticks)'
WHERE s_attribute_type = 'DVD_EXTRAS';

#
# ACTORS update
#
UPDATE s_attribute_type
SET display_type = 'list(plain, ",", list-link)'
WHERE s_attribute_type = 'ACTORS';

#
# DIRECTOR update
#
UPDATE s_attribute_type
SET display_type = 'list(plain, ",", list-link)'
WHERE s_attribute_type = 'DIRECTOR';

#
# RATIO update
#
UPDATE s_attribute_type
SET display_type = 'list(plain, " ", list-link)'
WHERE s_attribute_type = 'RATIO';

#
# ARTIST update
#
UPDATE s_attribute_type
SET display_type = 'list(plain, ",", list-link)'
WHERE s_attribute_type = 'ARTIST';

#
# S_DURATION update
#
UPDATE s_attribute_type
SET display_type = 'display(%display%)'
WHERE s_attribute_type = 'S_DURATION';

#
# Game image update
#
UPDATE s_attribute_type_lookup
SET img = 'gamecube.gif'
WHERE s_attribute_type = 'GAMESYSTEM' AND
value = 'GAMECUBE';

UPDATE s_attribute_type_lookup
SET img = 'xbox.gif'
WHERE s_attribute_type = 'GAMESYSTEM' AND
value = 'XBOX';

#
# Audio lang images
#
UPDATE s_attribute_type_lookup
SET img = 'dolby.gif'
WHERE s_attribute_type = 'AUDIO_LANG' AND
value = 'ENGLISH_5.1';

UPDATE s_attribute_type_lookup
SET img = 'dts.jpg'
WHERE s_attribute_type = 'AUDIO_LANG' AND
value = 'ENGLISH_DTS';

#
# Grammar updates.
#
UPDATE s_attribute_type_lookup
SET display = 'Director\'s Commentary'
WHERE s_attribute_type = 'AUDIO_LANG' AND
value = 'DIR_COMMENT';

UPDATE s_attribute_type_lookup
SET display = 'People\'s Republic of China'
WHERE s_attribute_type = 'DVD_REGION' AND
value = '6';

# Support for efficiently refreshing items via freedb.org, can only work if both the freedb_id and cddbgenre are set.
# NOT SUPPORTED IN CURRENT VERSION OF OPENDB.  PROVIDED FOR FUTURE FUNCTIONALITY!!!
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'CDDBGENRE', '0', NULL, NULL, NULL);
INSERT INTO s_item_attribute_type (s_item_type, s_attribute_type, order_no, prompt, s_field_type, compulsory_ind) VALUES ( 'CD', 'IMAGEURL', '0', NULL, 'IMAGE', NULL);

#
# Need to increase size of language and theme columns in database
# as there are already themes which have exceeded the previous
# 10 character limit.
#
ALTER TABLE user CHANGE language language varchar(20);
ALTER TABLE user CHANGE theme theme varchar(20);