/*
  File autogenerated by gengetopt version 2.8
  generated with the following command:
  gengetopt --conf-parser 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
/* Check for configure's getopt check result.  */
#ifndef HAVE_GETOPT_LONG
#include "getopt.h"
#else
#include <getopt.h>
#endif

#ifndef HAVE_STRDUP
#define strdup gengetopt_strdup
#endif /* HAVE_STRDUP */

#include "cmdline.h"


void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", PACKAGE, VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Usage: %s [OPTIONS]...\n", PACKAGE);
  printf("   -h         --help             Print help and exit\n");
  printf("   -V         --version          Print version and exit\n");
  printf("   -d         --debug            Run in debug mode (default=off)\n");
  printf("   -cSTRING   --conf=STRING      Read configuration file\n");
  printf("              --pidfile=STRING   Filename of process id file (default='./sgsnemu.pid')\n");
  printf("              --statedir=STRING  Directory of nonvolatile data (default='./')\n");
  printf("              --dns=STRING       DNS Server to use\n");
  printf("   -lSTRING   --listen=STRING    Local interface\n");
  printf("   -rSTRING   --remote=STRING    Remote host\n");
  printf("              --contexts=INT     Number of contexts (default='1')\n");
  printf("              --timelimit=INT    Exit after timelimit seconds (default='0')\n");
  printf("              --gtpversion=INT   GTP version to use (default='1')\n");
  printf("   -aSTRING   --apn=STRING       Access point name (default='internet')\n");
  printf("              --selmode=INT      Selection mode (default='0x01')\n");
  printf("   -iSTRING   --imsi=STRING      IMSI (default='240010123456789')\n");
  printf("              --nsapi=INT        NSAPI (default='0')\n");
  printf("   -mSTRING   --msisdn=STRING    Mobile Station ISDN number (default='46702123456')\n");
  printf("   -qINT      --qos=INT          Requested quality of service (default='0x0b921f')\n");
  printf("              --charging=INT     Charging characteristics (default='0x0800')\n");
  printf("   -uSTRING   --uid=STRING       Login user ID (default='mig')\n");
  printf("   -pSTRING   --pwd=STRING       Login password (default='hemmelig')\n");
  printf("              --createif         Create local network interface (default=off)\n");
  printf("   -nSTRING   --net=STRING       Network address for local interface\n");
  printf("              --defaultroute     Create default route (default=off)\n");
  printf("              --ipup=STRING      Script to run after link-up\n");
  printf("              --ipdown=STRING    Script to run after link-down\n");
  printf("              --pinghost=STRING  Ping remote host\n");
  printf("              --pingrate=INT     Number of ping req per second (default='1')\n");
  printf("              --pingsize=INT     Number of ping data bytes (default='56')\n");
  printf("              --pingcount=INT    Number of ping req to send (default='0')\n");
  printf("              --pingquiet        Do not print ping packet info (default=off)\n");
}


#ifndef HAVE_STRDUP
/* gengetopt_strdup(): automatically generated from strdup.c. */
/* strdup.c replacement of strdup, which is not standard */
static char *
gengetopt_strdup (const char *s)
{
  char *result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}
#endif /* HAVE_STRDUP */

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->debug_given = 0 ;
  args_info->conf_given = 0 ;
  args_info->pidfile_given = 0 ;
  args_info->statedir_given = 0 ;
  args_info->dns_given = 0 ;
  args_info->listen_given = 0 ;
  args_info->remote_given = 0 ;
  args_info->contexts_given = 0 ;
  args_info->timelimit_given = 0 ;
  args_info->gtpversion_given = 0 ;
  args_info->apn_given = 0 ;
  args_info->selmode_given = 0 ;
  args_info->imsi_given = 0 ;
  args_info->nsapi_given = 0 ;
  args_info->msisdn_given = 0 ;
  args_info->qos_given = 0 ;
  args_info->charging_given = 0 ;
  args_info->uid_given = 0 ;
  args_info->pwd_given = 0 ;
  args_info->createif_given = 0 ;
  args_info->net_given = 0 ;
  args_info->defaultroute_given = 0 ;
  args_info->ipup_given = 0 ;
  args_info->ipdown_given = 0 ;
  args_info->pinghost_given = 0 ;
  args_info->pingrate_given = 0 ;
  args_info->pingsize_given = 0 ;
  args_info->pingcount_given = 0 ;
  args_info->pingquiet_given = 0 ;
#define clear_args() { \
  args_info->debug_flag = 0;\
  args_info->conf_arg = NULL; \
  args_info->pidfile_arg = strdup("./sgsnemu.pid") ;\
  args_info->statedir_arg = strdup("./") ;\
  args_info->dns_arg = NULL; \
  args_info->listen_arg = NULL; \
  args_info->remote_arg = NULL; \
  args_info->contexts_arg = 1 ;\
  args_info->timelimit_arg = 0 ;\
  args_info->gtpversion_arg = 1 ;\
  args_info->apn_arg = strdup("internet") ;\
  args_info->selmode_arg = 0x01 ;\
  args_info->imsi_arg = strdup("240010123456789") ;\
  args_info->nsapi_arg = 0 ;\
  args_info->msisdn_arg = strdup("46702123456") ;\
  args_info->qos_arg = 0x0b921f ;\
  args_info->charging_arg = 0x0800 ;\
  args_info->uid_arg = strdup("mig") ;\
  args_info->pwd_arg = strdup("hemmelig") ;\
  args_info->createif_flag = 0;\
  args_info->net_arg = NULL; \
  args_info->defaultroute_flag = 0;\
  args_info->ipup_arg = NULL; \
  args_info->ipdown_arg = NULL; \
  args_info->pinghost_arg = NULL; \
  args_info->pingrate_arg = 1 ;\
  args_info->pingsize_arg = 56 ;\
  args_info->pingcount_arg = 0 ;\
  args_info->pingquiet_flag = 0;\
}

  clear_args();

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;
      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "debug",	0, NULL, 'd' },
        { "conf",	1, NULL, 'c' },
        { "pidfile",	1, NULL, 0 },
        { "statedir",	1, NULL, 0 },
        { "dns",	1, NULL, 0 },
        { "listen",	1, NULL, 'l' },
        { "remote",	1, NULL, 'r' },
        { "contexts",	1, NULL, 0 },
        { "timelimit",	1, NULL, 0 },
        { "gtpversion",	1, NULL, 0 },
        { "apn",	1, NULL, 'a' },
        { "selmode",	1, NULL, 0 },
        { "imsi",	1, NULL, 'i' },
        { "nsapi",	1, NULL, 0 },
        { "msisdn",	1, NULL, 'm' },
        { "qos",	1, NULL, 'q' },
        { "charging",	1, NULL, 0 },
        { "uid",	1, NULL, 'u' },
        { "pwd",	1, NULL, 'p' },
        { "createif",	0, NULL, 0 },
        { "net",	1, NULL, 'n' },
        { "defaultroute",	0, NULL, 0 },
        { "ipup",	1, NULL, 0 },
        { "ipdown",	1, NULL, 0 },
        { "pinghost",	1, NULL, 0 },
        { "pingrate",	1, NULL, 0 },
        { "pingsize",	1, NULL, 0 },
        { "pingcount",	1, NULL, 0 },
        { "pingquiet",	0, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      c = getopt_long (argc, argv, "hVdc:l:r:a:i:m:q:u:p:n:", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'd':	/* Run in debug mode.  */
          if (args_info->debug_given)
            {
              fprintf (stderr, "%s: `--debug' (`-d') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->debug_given = 1;
          args_info->debug_flag = !(args_info->debug_flag);
          break;

        case 'c':	/* Read configuration file.  */
          if (args_info->conf_given)
            {
              fprintf (stderr, "%s: `--conf' (`-c') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->conf_given = 1;
          args_info->conf_arg = strdup (optarg);
          break;

        case 'l':	/* Local interface.  */
          if (args_info->listen_given)
            {
              fprintf (stderr, "%s: `--listen' (`-l') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->listen_given = 1;
          args_info->listen_arg = strdup (optarg);
          break;

        case 'r':	/* Remote host.  */
          if (args_info->remote_given)
            {
              fprintf (stderr, "%s: `--remote' (`-r') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->remote_given = 1;
          args_info->remote_arg = strdup (optarg);
          break;

        case 'a':	/* Access point name.  */
          if (args_info->apn_given)
            {
              fprintf (stderr, "%s: `--apn' (`-a') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->apn_given = 1;
          args_info->apn_arg = strdup (optarg);
          break;

        case 'i':	/* IMSI.  */
          if (args_info->imsi_given)
            {
              fprintf (stderr, "%s: `--imsi' (`-i') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->imsi_given = 1;
          args_info->imsi_arg = strdup (optarg);
          break;

        case 'm':	/* Mobile Station ISDN number.  */
          if (args_info->msisdn_given)
            {
              fprintf (stderr, "%s: `--msisdn' (`-m') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->msisdn_given = 1;
          args_info->msisdn_arg = strdup (optarg);
          break;

        case 'q':	/* Requested quality of service.  */
          if (args_info->qos_given)
            {
              fprintf (stderr, "%s: `--qos' (`-q') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->qos_given = 1;
          args_info->qos_arg = strtol (optarg,&stop_char,0);
          break;

        case 'u':	/* Login user ID.  */
          if (args_info->uid_given)
            {
              fprintf (stderr, "%s: `--uid' (`-u') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->uid_given = 1;
          args_info->uid_arg = strdup (optarg);
          break;

        case 'p':	/* Login password.  */
          if (args_info->pwd_given)
            {
              fprintf (stderr, "%s: `--pwd' (`-p') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->pwd_given = 1;
          args_info->pwd_arg = strdup (optarg);
          break;

        case 'n':	/* Network address for local interface.  */
          if (args_info->net_given)
            {
              fprintf (stderr, "%s: `--net' (`-n') option given more than once\n", PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->net_given = 1;
          args_info->net_arg = strdup (optarg);
          break;


        case 0:	/* Long option with no short option */
          /* Filename of process id file.  */
          if (strcmp (long_options[option_index].name, "pidfile") == 0)
          {
            if (args_info->pidfile_given)
              {
                fprintf (stderr, "%s: `--pidfile' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->pidfile_given = 1;
            args_info->pidfile_arg = strdup (optarg);
            break;
          }
          /* Directory of nonvolatile data.  */
          else if (strcmp (long_options[option_index].name, "statedir") == 0)
          {
            if (args_info->statedir_given)
              {
                fprintf (stderr, "%s: `--statedir' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->statedir_given = 1;
            args_info->statedir_arg = strdup (optarg);
            break;
          }
          /* DNS Server to use.  */
          else if (strcmp (long_options[option_index].name, "dns") == 0)
          {
            if (args_info->dns_given)
              {
                fprintf (stderr, "%s: `--dns' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->dns_given = 1;
            args_info->dns_arg = strdup (optarg);
            break;
          }
          /* Number of contexts.  */
          else if (strcmp (long_options[option_index].name, "contexts") == 0)
          {
            if (args_info->contexts_given)
              {
                fprintf (stderr, "%s: `--contexts' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->contexts_given = 1;
            args_info->contexts_arg = strtol (optarg,&stop_char,0);
            break;
          }
          /* Exit after timelimit seconds.  */
          else if (strcmp (long_options[option_index].name, "timelimit") == 0)
          {
            if (args_info->timelimit_given)
              {
                fprintf (stderr, "%s: `--timelimit' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->timelimit_given = 1;
            args_info->timelimit_arg = strtol (optarg,&stop_char,0);
            break;
          }
          /* GTP version to use.  */
          else if (strcmp (long_options[option_index].name, "gtpversion") == 0)
          {
            if (args_info->gtpversion_given)
              {
                fprintf (stderr, "%s: `--gtpversion' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->gtpversion_given = 1;
            args_info->gtpversion_arg = strtol (optarg,&stop_char,0);
            break;
          }
          /* Selection mode.  */
          else if (strcmp (long_options[option_index].name, "selmode") == 0)
          {
            if (args_info->selmode_given)
              {
                fprintf (stderr, "%s: `--selmode' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->selmode_given = 1;
            args_info->selmode_arg = strtol (optarg,&stop_char,0);
            break;
          }
          /* NSAPI.  */
          else if (strcmp (long_options[option_index].name, "nsapi") == 0)
          {
            if (args_info->nsapi_given)
              {
                fprintf (stderr, "%s: `--nsapi' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->nsapi_given = 1;
            args_info->nsapi_arg = strtol (optarg,&stop_char,0);
            break;
          }
          /* Charging characteristics.  */
          else if (strcmp (long_options[option_index].name, "charging") == 0)
          {
            if (args_info->charging_given)
              {
                fprintf (stderr, "%s: `--charging' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->charging_given = 1;
            args_info->charging_arg = strtol (optarg,&stop_char,0);
            break;
          }
          /* Create local network interface.  */
          else if (strcmp (long_options[option_index].name, "createif") == 0)
          {
            if (args_info->createif_given)
              {
                fprintf (stderr, "%s: `--createif' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->createif_given = 1;
            args_info->createif_flag = !(args_info->createif_flag);
            break;
          }
          /* Create default route.  */
          else if (strcmp (long_options[option_index].name, "defaultroute") == 0)
          {
            if (args_info->defaultroute_given)
              {
                fprintf (stderr, "%s: `--defaultroute' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->defaultroute_given = 1;
            args_info->defaultroute_flag = !(args_info->defaultroute_flag);
            break;
          }
          /* Script to run after link-up.  */
          else if (strcmp (long_options[option_index].name, "ipup") == 0)
          {
            if (args_info->ipup_given)
              {
                fprintf (stderr, "%s: `--ipup' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->ipup_given = 1;
            args_info->ipup_arg = strdup (optarg);
            break;
          }
          /* Script to run after link-down.  */
          else if (strcmp (long_options[option_index].name, "ipdown") == 0)
          {
            if (args_info->ipdown_given)
              {
                fprintf (stderr, "%s: `--ipdown' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->ipdown_given = 1;
            args_info->ipdown_arg = strdup (optarg);
            break;
          }
          /* Ping remote host.  */
          else if (strcmp (long_options[option_index].name, "pinghost") == 0)
          {
            if (args_info->pinghost_given)
              {
                fprintf (stderr, "%s: `--pinghost' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->pinghost_given = 1;
            args_info->pinghost_arg = strdup (optarg);
            break;
          }
          /* Number of ping req per second.  */
          else if (strcmp (long_options[option_index].name, "pingrate") == 0)
          {
            if (args_info->pingrate_given)
              {
                fprintf (stderr, "%s: `--pingrate' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->pingrate_given = 1;
            args_info->pingrate_arg = strtol (optarg,&stop_char,0);
            break;
          }
          /* Number of ping data bytes.  */
          else if (strcmp (long_options[option_index].name, "pingsize") == 0)
          {
            if (args_info->pingsize_given)
              {
                fprintf (stderr, "%s: `--pingsize' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->pingsize_given = 1;
            args_info->pingsize_arg = strtol (optarg,&stop_char,0);
            break;
          }
          /* Number of ping req to send.  */
          else if (strcmp (long_options[option_index].name, "pingcount") == 0)
          {
            if (args_info->pingcount_given)
              {
                fprintf (stderr, "%s: `--pingcount' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->pingcount_given = 1;
            args_info->pingcount_arg = strtol (optarg,&stop_char,0);
            break;
          }
          /* Do not print ping packet info.  */
          else if (strcmp (long_options[option_index].name, "pingquiet") == 0)
          {
            if (args_info->pingquiet_given)
              {
                fprintf (stderr, "%s: `--pingquiet' option given more than once\n", PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->pingquiet_given = 1;
            args_info->pingquiet_flag = !(args_info->pingquiet_flag);
            break;
          }

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */


  if ( missing_required_options )
    exit (EXIT_FAILURE);

  return 0;
}

#define CONFIGPARSERBUFSIZE 1024

int
cmdline_parser_configfile (char * const filename, struct gengetopt_args_info *args_info, int override)
{
  FILE* file;
  char linebuf[CONFIGPARSERBUFSIZE];
  int line_num = 0;
  int len;
  int fnum;
  char fopt[CONFIGPARSERBUFSIZE], farg[CONFIGPARSERBUFSIZE];
  char *stop_char;

  if ((file = fopen(filename, "r")) == NULL)
    {
      fprintf (stderr, "%s: Error opening configuration file '%s'\n",
               PACKAGE, filename);
      exit (EXIT_FAILURE);
    }

  while ((fgets(linebuf, CONFIGPARSERBUFSIZE, file)) != NULL)
    {
      ++line_num;
      len = strlen(linebuf);
      if (len == CONFIGPARSERBUFSIZE-1)
        {
          fprintf (stderr, "%s: Line longer than %d characters found in configuration file '%s'\n",
                   PACKAGE, CONFIGPARSERBUFSIZE, filename);
          exit (EXIT_FAILURE);
        }

      if (linebuf[0] == '#')
        continue; /* Line was a comment */
    
      /* Get the option */
      if ((fnum = sscanf(linebuf, "%s %s", fopt, farg)) > 0)
        {
          if (!strcmp(fopt, "help"))
            {
              if (override || !args_info->help_given)
                {
                  args_info->help_given = 1;
                  
                }
              continue;
            }
          if (!strcmp(fopt, "version"))
            {
              if (override || !args_info->version_given)
                {
                  args_info->version_given = 1;
                  
                }
              continue;
            }
          if (!strcmp(fopt, "debug"))
            {
              if (override || !args_info->debug_given)
                {
                  args_info->debug_given = 1;
                  args_info->debug_flag = !(args_info->debug_flag);
                }
              continue;
            }
          if (!strcmp(fopt, "conf"))
            {
              if (override || !args_info->conf_given)
                {
                  args_info->conf_given = 1;
                  if (fnum == 2)
                    args_info->conf_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "pidfile"))
            {
              if (override || !args_info->pidfile_given)
                {
                  args_info->pidfile_given = 1;
                  if (fnum == 2)
                    args_info->pidfile_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "statedir"))
            {
              if (override || !args_info->statedir_given)
                {
                  args_info->statedir_given = 1;
                  if (fnum == 2)
                    args_info->statedir_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "dns"))
            {
              if (override || !args_info->dns_given)
                {
                  args_info->dns_given = 1;
                  if (fnum == 2)
                    args_info->dns_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "listen"))
            {
              if (override || !args_info->listen_given)
                {
                  args_info->listen_given = 1;
                  if (fnum == 2)
                    args_info->listen_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "remote"))
            {
              if (override || !args_info->remote_given)
                {
                  args_info->remote_given = 1;
                  if (fnum == 2)
                    args_info->remote_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "contexts"))
            {
              if (override || !args_info->contexts_given)
                {
                  args_info->contexts_given = 1;
                  if (fnum == 2)
                    args_info->contexts_arg = strtol (farg,&stop_char,0);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "timelimit"))
            {
              if (override || !args_info->timelimit_given)
                {
                  args_info->timelimit_given = 1;
                  if (fnum == 2)
                    args_info->timelimit_arg = strtol (farg,&stop_char,0);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "gtpversion"))
            {
              if (override || !args_info->gtpversion_given)
                {
                  args_info->gtpversion_given = 1;
                  if (fnum == 2)
                    args_info->gtpversion_arg = strtol (farg,&stop_char,0);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "apn"))
            {
              if (override || !args_info->apn_given)
                {
                  args_info->apn_given = 1;
                  if (fnum == 2)
                    args_info->apn_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "selmode"))
            {
              if (override || !args_info->selmode_given)
                {
                  args_info->selmode_given = 1;
                  if (fnum == 2)
                    args_info->selmode_arg = strtol (farg,&stop_char,0);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "imsi"))
            {
              if (override || !args_info->imsi_given)
                {
                  args_info->imsi_given = 1;
                  if (fnum == 2)
                    args_info->imsi_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "nsapi"))
            {
              if (override || !args_info->nsapi_given)
                {
                  args_info->nsapi_given = 1;
                  if (fnum == 2)
                    args_info->nsapi_arg = strtol (farg,&stop_char,0);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "msisdn"))
            {
              if (override || !args_info->msisdn_given)
                {
                  args_info->msisdn_given = 1;
                  if (fnum == 2)
                    args_info->msisdn_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "qos"))
            {
              if (override || !args_info->qos_given)
                {
                  args_info->qos_given = 1;
                  if (fnum == 2)
                    args_info->qos_arg = strtol (farg,&stop_char,0);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "charging"))
            {
              if (override || !args_info->charging_given)
                {
                  args_info->charging_given = 1;
                  if (fnum == 2)
                    args_info->charging_arg = strtol (farg,&stop_char,0);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "uid"))
            {
              if (override || !args_info->uid_given)
                {
                  args_info->uid_given = 1;
                  if (fnum == 2)
                    args_info->uid_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "pwd"))
            {
              if (override || !args_info->pwd_given)
                {
                  args_info->pwd_given = 1;
                  if (fnum == 2)
                    args_info->pwd_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "createif"))
            {
              if (override || !args_info->createif_given)
                {
                  args_info->createif_given = 1;
                  args_info->createif_flag = !(args_info->createif_flag);
                }
              continue;
            }
          if (!strcmp(fopt, "net"))
            {
              if (override || !args_info->net_given)
                {
                  args_info->net_given = 1;
                  if (fnum == 2)
                    args_info->net_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "defaultroute"))
            {
              if (override || !args_info->defaultroute_given)
                {
                  args_info->defaultroute_given = 1;
                  args_info->defaultroute_flag = !(args_info->defaultroute_flag);
                }
              continue;
            }
          if (!strcmp(fopt, "ipup"))
            {
              if (override || !args_info->ipup_given)
                {
                  args_info->ipup_given = 1;
                  if (fnum == 2)
                    args_info->ipup_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "ipdown"))
            {
              if (override || !args_info->ipdown_given)
                {
                  args_info->ipdown_given = 1;
                  if (fnum == 2)
                    args_info->ipdown_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "pinghost"))
            {
              if (override || !args_info->pinghost_given)
                {
                  args_info->pinghost_given = 1;
                  if (fnum == 2)
                    args_info->pinghost_arg = strdup (farg);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "pingrate"))
            {
              if (override || !args_info->pingrate_given)
                {
                  args_info->pingrate_given = 1;
                  if (fnum == 2)
                    args_info->pingrate_arg = strtol (farg,&stop_char,0);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "pingsize"))
            {
              if (override || !args_info->pingsize_given)
                {
                  args_info->pingsize_given = 1;
                  if (fnum == 2)
                    args_info->pingsize_arg = strtol (farg,&stop_char,0);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "pingcount"))
            {
              if (override || !args_info->pingcount_given)
                {
                  args_info->pingcount_given = 1;
                  if (fnum == 2)
                    args_info->pingcount_arg = strtol (farg,&stop_char,0);
                  else
                    {
                      fprintf (stderr, "%s:%d: required <option_name> <option_val>\n",
                               filename, line_num);
                      exit (EXIT_FAILURE);
                    }
                }
              continue;
            }
          if (!strcmp(fopt, "pingquiet"))
            {
              if (override || !args_info->pingquiet_given)
                {
                  args_info->pingquiet_given = 1;
                  args_info->pingquiet_flag = !(args_info->pingquiet_flag);
                }
              continue;
            }
          

          /* Tried all known options. This one is unknown! */
          fprintf (stderr, "%s: Unknown option '%s' found in %s\n",
                   PACKAGE, fopt, filename);
          exit (EXIT_FAILURE);
        }
    } /* while */
  fclose(file); /* No error checking on close */

  return 0;
}
