PROGRAM_NAME='405amx2.axs'
(*   DATE:11/26/00    TIME:09:32:14    *)
(*                                     *)
(***********************************************************)
(*          DEVICE NUMBER DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_DEVICE
COMPUTER  = 1    (* AXC-232 .. COMPUTER IN RACK 38.4K      *)
MATRIX    = 2    (* AXC-232 .. AUTOPATCH 1YDM 9600,8,N,1   *)
RECEIVER  = 3    (* AXC-IRE .. PIONEER VSX-7300            *)
VPROJ     = 4    (* AXC-IRE .. SONY PC-1270                *)
LIGHTS    = 5    (* AXC-IR/S .. LUTRON                     *)
VCR       = 6    (* AXC-IR/S .. AG-1970                    *)
LIFT      = 7    (* AXC-REL8 .. PJ LIFT                    *)
SLIDE_L   = 8    (* AXC-SLD                                *)
SLIDE_R   = 9    (* AXC-SLD                                *)
ELMO      = 10   (* AXC-REL8 .. ELMO                       *)
ON_AIR    = 10   (* AXC-REL8 .. ON_AIR control             *)
VCR_F     = 11   (* AXC-IR/S .. PLAY VCR GO-Video          *)
YEM       = 12   (* AXC-232 .. YEM CONVERTER               *)
MIXER     = 13   (* AXC-232 .. IVIE 884PW                  *)
VCC3      = 14   (* AXC-IR/S .. CANON VC-C3 CAMERA         *)
VCC3_B    = 15   (* AXC-IR/S .. CANON VC-C3 CAMERA IN BACK *)

RADIO     = 128  (* TX 32/ RC = 8 *)
TP        = 129  (* TOUCH PANEL *)
#DEFINE MASTER_BELOW_V330
(***********************************************************)
(*               CONSTANT DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_CONSTANT

(*SHARP XGE3500U*)
VP_ON = 27
VP_OFF = 28
VP_VIDEO1 = 31
VP_VIDEO2 = 32
VP_DATA1 = 34
VP_DATA2 = 35
VP_BLACK_SCREEN = 44

(* LIFT *)
LIFT_UP = 1
LIFT_DN = 2
RSCRN_UP = 3
RSCRN_DN = 4
LSCRN_UP = 5
LSCRN_DN = 6

(* LIGHTS *)
FULL_ON = 9
OVERLAY = 43
SLIDE   = 44
THEATER = 45
FULL_OFF= 55

(* VOLUME *)
VOL_UP = 24
VOL_DN = 25
VOL_MT = 26

(* RECEIVER *)
PRESET_1 = 11
PRESET_2 = 12
PRESET_3 = 13
PRESET_4 = 14
PRESET_5 = 15
PRESET_6 = 16
PRESET_7 = 17
PRESET_8 = 18
PRESET_9 = 19
PRESET_10 = 10
SOURCE_VDP = 31
SOURCE_VCR = 34
SOURCE_T2MON = 35
SOURCE_CD = 36
SOURCE_TUNER = 37
SOURCE_PHONO = 38
ENTER_TUNER_CH = 58
PRESET_UP = 59
PRESET_DOWN = 60
TOGGLE_AMFM = 61
TUNE_UP = 63
TUNE_DOWN = 64
SCAN_UP = 65
VIDEO_SRC_TOGGLE = 67
SYNTH_STEREO_TOGGLE = 68
SLEEP_TIMER = 69
TOGGLE_SURROUND = 70
REAR_LEVEL_DN = 71
REAR_LEVEL_UP = 72
REAR_DELAY_UP = 73
VIDEO_SOURCE_OFF = 74
RECEIVER_POWER = 75

(* VCR *)
VCR_PLAY = 1
VCR_STOP = 2
VCR_PAUSE = 3
VCR_FFWD = 4
VCR_REW = 5
VCR_REC = 8
VCR_POWER = 9

(* ELMO *)
ELMO_FOCUS_FAR = 1
ELMO_FOCUS_NEAR = 2
ELMO_ZOOM_WIDE = 3
ELMO_ZOOM_TELE = 4
ELMO_AUTOFOCUS = 6
ELMO_ZOOM_PRESET = 4
ELMO_SIZE_MOVE = 3
ELMO_BASELIGHT_TOGGLE = 1
ELMO_UPPERLIGHT_TOGGLE = 2
ELMO_INPUT_SELECT = 6
ELMO_COMMON = 7

(* ON_AIR *)
ON_AIR_TOGGLE = 8

(* CANON VC_C3 *)
CAM_POWER = 9
CAM_AUTO_FOCUS = 43
CAM_MANUAL_FOCUS = 44
CAM_NEAR_FOCUS = 45
CAM_FAR_FOCUS = 46
CAM_WIDE_ZOOM = 47
CAM_TELE_ZOOM = 48
CAM_HOME = 51
CAM_TILT_UP = 52
CAM_TILT_DOWN = 53
CAM_PAN_RIGHT = 54
CAM_PAN_LEFT = 55

(***********************************************************)
(*               VARIABLE DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_VARIABLE
INPUT[10]
MIXER_IN[150]
LEVEL[20]
RANGE[30]
PAGEFLIP[20]  (* SETS UP BUFFER TO RECEIVE PAGE TEXT STRINGS *)
X               (* INDEX *)
DECK
STATUS
V_IN
V_OUT
LEVEL1
LEVEL2
LEVEL3
LEVEL4
LEVEL5
LEVEL6
LEVEL7
LEVEL8
(****************SAVE[10]****************)
(******************CHAR******************)
POSITION
(****************FUNC_NUM****************)
PROJECTOR_STATE
RECEIVER_STATE
CURRENT_SELECTION
VCR_STATE
PROJ_STATUS
ELMO_STATUS
VCR_F_STATE
RANGE_ADJ
LEVEL_ADJ
TRIM_ADJ
ON_AIR_STATUS
VIDEO_BLACK
A_MUTE
A_STATUS
UNAUDIO
AUDIO_ROUTE
IR_STATUS
VCR_F_ON
TIMESON
TYPE
VCC3_F              (* 1/13/99 *)
(***********************************************************)
(*                    DEFINE_COMBINE                       *)
(***********************************************************)
(***********************************************************)
(*               LATCHING DEFINITIONS GO BELOW             *)
(***********************************************************)
DEFINE_LATCHING
[ON_AIR, ON_AIR_TOGGLE]
(***********************************************************)
(*       MUTUALLY EXCLUSIVE DEFINITIONS GO BELOW           *)
(***********************************************************)
DEFINE_MUTUALLY_EXCLUSIVE
([LIFT,LIFT_UP],[LIFT,LIFT_DN])
([TP,3]..[TP,56],[TP,101]..[TP,109],[TP,198]..[TP,204])
([TP,94]..[TP,100])
([TP,58]..[TP,81])
([TP,173]..[TP,175])
(***********************************************************)
(*                  SUBROUTINES GO BELOW                   *)
(***********************************************************)
DEFINE_CALL 'CLEAR_AUTOPATCH'
{
  SEND_STRING MATRIX,"'DL1I1 2 3 4 5 6 7 8O1T'"
  SEND_STRING MATRIX,"'DL2I1 2 3 4 5 6 7 8O8T'"
  SEND_STRING MATRIX,"'DL3I1 2 3 4 5 6 7 8O8T'"
}
DEFINE_CALL 'PJ_ON'
{
  PROJ_STATUS=1
  CALL 'CLEAR_AUTOPATCH'
  DO_PUSH(RADIO,137)
  ON[LIFT,RSCRN_DN]
  WAIT 15 OFF[LIFT,RSCRN_DN]
  ON[LIFT,LIFT_DN]
  WAIT 300 'LIFT-DOWN'
  {
     OFF[LIFT,LIFT_DN]
     PULSE [VPROJ,VP_ON]
  }
  WAIT 355
  PULSE [VPROJ,VP_DATA2]
}
DEFINE_CALL 'PJ_OFF'
{
  PROJ_STATUS=0
  PULSE[VPROJ,VP_OFF]
  WAIT 10
  PULSE[VPROJ,VP_OFF]  (*CONFIRM *)
  ON[LIFT,RSCRN_UP]
  WAIT 15 OFF[LIFT,RSCRN_UP]
  WAIT 1000 ON[LIFT,LIFT_UP]
  WAIT 1300 OFF[LIFT,LIFT_UP]
  SELECT
  {
     ACTIVE(VCR_F_STATE = 1) :
     {
        PULSE [VCR_F,VCR_POWER]
        VCR_F_STATE = 0
     }
     ACTIVE(VCR_STATE = 1) :
     {
        PULSE [VCR,VCR_POWER]
        VCR_STATE = 0
     }
  }
}
DEFINE_CALL 'DISPLAY' (IN,INPUT_L)
{
  IF(IN>9)
    SEND_LEVEL TP,IN-4,INPUT_L  (* FOR LEVEL#>8, RESET TO LAST 4*)
  ELSE
    SEND_LEVEL TP,IN,INPUT_L
}
DEFINE_CALL 'GET_LEVEL_STATE'
{
  SEND_STRING MIXER, "$2A,'@',$59,$0D,$0A"  (* GLOBAL OFFLINE FOR IVIE *)
  SEND_STRING MIXER, "'*1Y',$0D,$0A"  (* PLACE UNIT ON LINE *)
  SEND_STRING MIXER,"$2A,$31,$3F,$55,$0D,$0A"   (* QUERY MIXER *)
  SEND_STRING 0,"MIXER_IN"
  LEVEL=REMOVE_STRING (MIXER_IN,"'#1L'", 1)  (* SIFT THRU TO RANGE *)
  X=1
  WHILE (X<=12)
  {
    LEVEL[X]=GET_BUFFER_CHAR(MIXER_IN)
    CALL 'DISPLAY' (X, (LEVEL[X]-30)*11)
      SEND_STRING 0,"'LEVEL ',ITOA(X),' IS ', ITOA(LEVEL[X]-30),'.',$0D,$0A"
    X=X+1
  }
  SEND_STRING MIXER, "'*1Z',$0D,$0A"  (* PLACE UNIT OFF LINE *)
}
DEFINE_CALL 'GET_TRIM_STATE'
{
  SEND_STRING MIXER, "'*@Z',$0D,$0A"  (* GLOBAL OFFLINE FOR IVIE *)
  SEND_STRING MIXER, "'*1Y',$0D,$0A"  (* PLACE UNIT ON LINE *)
  SEND_STRING MIXER,"$2A,$31,$3F,$55,$0D,$0A"   (* QUERY MIXER *)
  SEND_STRING 0,"MIXER_IN"
  LEVEL=REMOVE_STRING (MIXER_IN,"'#1G'", 1)  (* SIFT THRU TO RANGE *)
  X=1
  WHILE (X<=12)
  {
    LEVEL[X]=GET_BUFFER_CHAR(MIXER_IN)
    CALL 'DISPLAY' (X, (LEVEL[X]-30)*11)
      SEND_STRING 0,"'TRIM ',ITOA(X),' IS ', ITOA(LEVEL[X]-30),'.',$0D,$0A"
    X=X+1
  }
  SEND_STRING MIXER, "'*1Z',$0D,$0A"  (* PLACE UNIT OFF LINE *)
}
DEFINE_CALL 'GET_RANGE_STATE'
{
  SEND_STRING MIXER, "$2A,'@',$59,$0D,$0A"  (* GLOBAL OFFLINE FOR IVIE *)
  SEND_STRING MIXER, "'*1Y',$0D,$0A"  (* PLACE UNIT ON LINE *)
  SEND_STRING MIXER,"$2A,$30,$3F,$55,$0D,$0A"  (* QUERY MIXER *)
  SEND_STRING 0,"MIXER_IN"
  RANGE=REMOVE_STRING (MIXER_IN,"'#1R'",1)  (* SIFT THRU TO RANGE *)
  X=1
  WHILE (X<=24)
  {
    RANGE[X]=GET_BUFFER_CHAR(MIXER_IN)
    IF ((X%2)=0)
      {
      CALL 'DISPLAY' (X/2, (RANGE[X/2]-30)*11)
      SEND_STRING 0,"'RANGE ',ITOA(X),' IS ', ITOA(RANGE[X/2]),'.',$0D,$0A"
      }
    X=X+1
  }
  SEND_STRING MIXER, "'*1Z',$0D,$0A"  (* PLACE UNIT OFF LINE *)
}
DEFINE_CALL 'ASSIGN_MBONE'
{
  SEND_STRING MATRIX,"'CL3I6O1T'"       (* FULL MIX - VCR *)
  SEND_STRING MATRIX,"'CL3I6O2T'"       (* FULL MIX - CAMERA *)
  SEND_STRING MATRIX,"'CL3I6O7T'"       (* FULL MIX - CAPTURE PC *)
  SEND_STRING MATRIX,"'CL3I7O8T'"       (* MIX-MIC - RECEIVER *)
  SEND_STRING MATRIX,"'CL3I8O3T'"       (* MBONE PC - MIXER MBONE *)
  SEND_STRING MIXER, "'*@Z',$0D,$0A"  (* GLOBAL OFFLINE FOR IVIE *)
  SEND_STRING MIXER, "$2A,$31,$41,$39,$30,$39,$30,$39,$30,$39,$30"
  SEND_STRING MIXER, "$39,$30,$45,$30,$44,$30,$42,$30,$0D,$0A"
  SEND_STRING MATRIX,"'CL2I6O3T'"       (* MAIN CAMERA - MBONE PC *)
  SEND_STRING MATRIX,"'CL2I5O7T'"       (* VC-C3 - CAPTURE PC *)
}
DEFINE_CALL 'SWITCH_MATRIX' (VS, IN, OUT)
{
  IF (VS=3 && OUT=8)
  {
     PULSE[RECEIVER,SOURCE_CD]
  }
  IF (VS=2 && OUT=8)
  {
     PULSE[VPROJ, VP_VIDEO1]
  }
  IF (VS=1 && OUT=1)
  {
     PULSE[VPROJ, VP_DATA2]
  }
  SEND_STRING MATRIX,"'CL',ITOA(VS),'I',ITOA(IN),'O',ITOA(OUT),'T'"
}
DEFINE_CALL 'AUDIO_TOGGLE' (IN,OUT,BUTTON) (* 8/19/98 *)
{
IF (UNAUDIO=0)
  {
  SEND_STRING MATRIX,"'CL3I',ITOA(IN),'O',ITOA(OUT),'T'"
  [TP,BUTTON]=1
  }
ELSE
  {
  SEND_STRING MATRIX,"'DL3I',ITOA(IN),'O',ITOA(OUT),'T'"
  UNAUDIO=0
  [TP,121]=UNAUDIO
  [TP,BUTTON]=0
  }
}
(***********************************************************)
(*                STARTUP CODE GOES BELOW                  *)
(***********************************************************)
DEFINE_START
CREATE_LEVEL TP,1,LEVEL1
CREATE_LEVEL TP,2,LEVEL2
CREATE_LEVEL TP,3,LEVEL3
CREATE_LEVEL TP,4,LEVEL4
CREATE_LEVEL TP,5,LEVEL5
CREATE_LEVEL TP,6,LEVEL6
CREATE_LEVEL TP,7,LEVEL7
CREATE_LEVEL TP,8,LEVEL8
CREATE_BUFFER TP, PAGEFLIP
CREATE_BUFFER MIXER, MIXER_IN
CREATE_BUFFER COMPUTER, INPUT
POSITION = 0
EXTERNAL_CONTROL(COMPUTER)

VCR_F_ON = 0
VCR_STATE = 0
RECEIVER_STATE = 0
PROJECTOR_STATE = 0
CURRENT_SELECTION = 0
VCR_F_STATE = 0
RANGE_ADJ = 0
LEVEL_ADJ = 0
TRIM_ADJ = 0
ON_AIR_STATUS=0
IR_STATUS = 0
VIDEO_BLACK = 0
A_MUTE = 0
A_STATUS = 0
UNAUDIO = 0
AUDIO_ROUTE = 0
SET_PULSE_TIME (1)
TIMESON=1
VCC3_F=1
(***********************************************************)
(*            THE ACTUAL PROGRAM GOES BELOW                *)
(***********************************************************)
DEFINE_PROGRAM

(* SLIDES -- COMMENTED OUT 8/23/95 BECAUSE OF LACK OF SLID10.LIB *)
SYSTEM_CALL 'SLD1'(SLIDE_L,RADIO,144,145,146,147,148,0,0)
SYSTEM_CALL 'SLD1'(SLIDE_L,TP,144,145,146,147,148,0,0)
SYSTEM_CALL 'SLD1'(SLIDE_R,RADIO,152,153,154,155,156,0,0)
SYSTEM_CALL 'SLD1'(SLIDE_R,TP,152,153,154,155,156,0,0)

RELEASE[RADIO,136]          (* ADDED 8-4-95 TO FIX VOLUME UP PROBLEM *)
  {                         (* BUTTON 142 WOULD SOMETIMES DECODE AS  *)
     CANCEL_WAIT '142FIX'   (* BUTTON 136 AND CHANGE THE VIDEO INPUT *)
  }                         (* THE LINE BELOW PUTS IN A 1 SECOND WAIT*)

(* SELECTS *)
IF (136 <= PUSH_CHANNEL && PUSH_CHANNEL <= 140)
  {
  CURRENT_SELECTION = PUSH_CHANNEL - 136
  SELECT
  {
     ACTIVE(CURRENT_SELECTION=0) :  (* PC *)
     {
        WAIT 3 '142FIX'             (*  ADDED 8-4-95 TO FIX VOL UP PROBLEM *)
        {
           IF (ELMO_STATUS=1)
           {
              DO_PUSH(TP,111)
              ELMO_STATUS=0
           }
           IF(PROJ_STATUS=0)
           {
              CALL 'PJ_ON'
           }
           PULSE[RECEIVER,SOURCE_CD]
           SEND_STRING MATRIX,"'CL1I3O1T'"
           SEND_STRING MATRIX,"'CL1I3O3T'"  (* output to FB Front *)
           SEND_STRING MATRIX,"'CL3I3O4T'"
           SEND_STRING MATRIX,"'CL3I7O8T'"
           WAIT 5
           PULSE[VPROJ,VP_DATA2]
        }
     }
     ACTIVE(CURRENT_SELECTION=1) :      (* VCR FRONT *)
     {
        IF(PROJ_STATUS=0)
        {
           CALL 'PJ_ON'
        }
        IF(VCR_F_STATE=0)
        {
           PULSE [VCR_F,VCR_POWER]
           VCR_F_STATE=1
        }
        IF (ELMO_STATUS=1)
        {
           DO_PUSH(TP,111)
           ELMO_STATUS=0
        }
        PULSE[RECEIVER,SOURCE_CD]
        SEND_STRING MATRIX,"'CL2I2O8T'"
        SEND_STRING MATRIX,"'CL3I2O4T'" (* REROUTE TO LOCAL AUDIO 8/19/98 *)
        SEND_STRING MATRIX,"'CL3I7O8T'"
        WAIT 5
        PULSE[VPROJ,VP_VIDEO1]
     }
     ACTIVE(CURRENT_SELECTION=2) :  (* ELMO *)
     {
        IF(PROJ_STATUS=0)
        {
           CALL 'PJ_ON'
        }
        DO_PUSH(TP,111)            (* TURN ON BASELIGHT *)
        ELMO_STATUS = 1
        SEND_STRING MATRIX,"'DL3I2O4T'"   (* CANCEL VCR *)
        SEND_STRING MATRIX,"'CL2I8O8T'"
        WAIT 5
        PULSE[VPROJ,VP_VIDEO1]
     }
     ACTIVE(CURRENT_SELECTION=3) :    (* LAPTOP *)
     {
        IF(PROJ_STATUS=0)
        {
           CALL 'PJ_ON'
        }
        IF (ELMO_STATUS=1)
        {
           DO_PUSH(TP,111)
           ELMO_STATUS=0
        }
        PULSE[RECEIVER,SOURCE_CD]
        SEND_STRING MATRIX,"'CL1I7O1T'"      (* RGBS *)
        SEND_STRING MATRIX,"'CL3I4O4T'"     (* AUDIO *)
        SEND_STRING MATRIX,"'CL3I7O8T'"
        WAIT 5
        PULSE[VPROJ,VP_DATA2]
     }
     ACTIVE(CURRENT_SELECTION=4) :  (* SGI *)
     {
        IF(PROJ_STATUS=0)
        {
           CALL 'PJ_ON'
        }
        IF (ELMO_STATUS=1)
        {
           DO_PUSH(TP,111)
           ELMO_STATUS=0
        }
        PULSE[RECEIVER,SOURCE_CD]
        SEND_STRING MATRIX,"'CL1I2O1T'"
        WAIT 5
        PULSE[VPROJ,VP_DATA2]
     }
  }
}
PUSH[TP,150]
{
  CALL 'PJ_ON'
}
PUSH[RADIO,150]  (* VPROJ ON *)
{
  CALL 'PJ_ON'
}
PUSH[TP,151]
{
  CALL 'PJ_OFF'
}
PUSH[RADIO,151]  (* VPROJ OFF *)
{
  CALL 'PJ_OFF'
}

(* LIGHTS *)
PUSH[RADIO,133] TO [LIGHTS,FULL_ON] (* ON *)
PUSH[RADIO,134] TO [LIGHTS,OVERLAY] (* DIM *)
PUSH[RADIO,135] TO [LIGHTS,SLIDE] (* OFF *)
PUSH[TP,133] TO [LIGHTS,FULL_ON]
PUSH[TP,134] TO [LIGHTS,OVERLAY]
PUSH[TP,135] TO [LIGHTS,SLIDE]
PUSH[TP,122] TO [LIGHTS,FULL_OFF]
PUSH[TP,126] TO [LIGHTS,THEATER]

(* RECEIVER *)

SELECT
{
  ACTIVE(PUSH_CHANNEL=141):
  {
     A_MUTE = !A_MUTE
     [TP,141] = A_MUTE
     PULSE[RECEIVER,VOL_MT]
  }
  ACTIVE(PUSH_CHANNEL=142):
  {
     PULSE[RECEIVER,VOL_UP]
  }
  ACTIVE(PUSH_CHANNEL=143):
  {
     PULSE[RECEIVER,VOL_DN]
  }
}
(* CONTROLS *)
PUSH[RADIO,128] TO [VCR_F,VCR_PLAY]
PUSH[RADIO,129] TO [VCR_F,VCR_STOP]
PUSH[RADIO,130] TO [VCR_F,VCR_PAUSE]
PUSH[RADIO,131] TO [VCR_F,VCR_FFWD]
PUSH[RADIO,132] TO [VCR_F,VCR_REW]
PUSH[TP,128] TO [VCR_F, VCR_PLAY]
PUSH[TP,129] TO [VCR_F, VCR_STOP]
PUSH[TP,130] TO [VCR_F, VCR_PAUSE]
PUSH[TP,131] TO [VCR_F, VCR_FFWD]
PUSH[TP,132] TO [VCR_F, VCR_REW]

PUSH[TP,1]
{
  IF(ON_AIR_STATUS=0)
  {
    ON[ON_AIR, ON_AIR_TOGGLE]  (* TURN ON ON AIR SIGN *)
    ON_AIR_STATUS=1
    [TP,1]=ON_AIR_STATUS
  }
  ELSE
  {
    OFF[ON_AIR, ON_AIR_TOGGLE]  (* TURN OFF ON AIR SIGN *)
    ON_AIR_STATUS=0
    [TP,1]=ON_AIR_STATUS
  }
}
(* 7/28 - VIDEO BLACK *)
IF(PUSH_CHANNEL=159)
{
  IF(VIDEO_BLACK=0)
  {
     PULSE[VPROJ,VP_BLACK_SCREEN]
     VIDEO_BLACK=1
     [TP,159]=VIDEO_BLACK
  }
  ELSE
  {
     PULSE[VPROJ,VP_BLACK_SCREEN]
     VIDEO_BLACK=0
     [TP,159]=VIDEO_BLACK
  }
}
(* TEST MATRIX *)
PUSH[TP,127]
{
  IF(AUDIO_ROUTE=0)
  {
     AUDIO_ROUTE=1
     [TP,127]=1
     SEND_COMMAND TP, "'TEXT1-AudioRouting ON'"
  }
  ELSE
  {
     AUDIO_ROUTE=0
     [TP,127]=0
     SEND_COMMAND TP, "'TEXT1-AudioRouting OFF'"
  }
}
IF((PUSH_CHANNEL>=3 && PUSH_CHANNEL<=56) || (PUSH_CHANNEL>=101 && PUSH_CHANNEL<=109) || (PUSH_CHANNEL>=198) && (PUSH_CHANNEL<=204))
  STATUS = 1
ELSE
  STATUS = 0

PUSH[TP,3]      (* VC-C3 TO PROJECTOR *)
{
  VCC3_F=1
  [TP,3]=STATUS
  CALL 'SWITCH_MATRIX' (2,5,8)
}
PUSH[TP,4]      (* VC-C3 TO CAPTURE PC *)
{
  VCC3_F=1
  [TP,4]=STATUS
  CALL 'SWITCH_MATRIX' (2,5,7)
}
PUSH[TP,5]      (* VC-C3 TO MBONE PC *)
{
  VCC3_F=1
  [TP,5]=STATUS
  CALL 'SWITCH_MATRIX' (2,5,3)
}
PUSH[TP,6]      (* VC-C3 TO MONITOR *)
{
  VCC3_F=1
  [TP,6]=STATUS
  CALL 'SWITCH_MATRIX' (2,5,6)
}
PUSH[TP,7]      (* VC-C3 TO LIVEBOARD *)
{
  VCC3_F=1
  [TP,7]=STATUS
  CALL 'SWITCH_MATRIX' (2,5,5)
}
PUSH[TP,101]     (* VC-C3 TO RACK VCR *)
{
  VCC3_F=1
  VCR_F_ON=0
  [TP,101]=STATUS
  CALL 'SWITCH_MATRIX' (2,5,1)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,6,1)
}
PUSH[TP,198]      (* BACK VC-C3 TO PROJECTOR *)
{
  VCC3_F=0
  [TP,198]=STATUS
  CALL 'SWITCH_MATRIX' (2,3,8)
}
PUSH[TP,199]      (* BACK VC-C3 TO CAPTURE PC *)
{
  VCC3_F=0
  [TP,199]=STATUS
  CALL 'SWITCH_MATRIX' (2,3,7)
}
PUSH[TP,200]      (* BACK VC-C3 TO MBONE PC *)
{
  VCC3_F=0
  [TP,200]=STATUS
  CALL 'SWITCH_MATRIX' (2,3,3)
}
PUSH[TP,201]      (* BACK VC-C3 TO MONITOR *)
{
  VCC3_F=0
  [TP,201]=STATUS
  CALL 'SWITCH_MATRIX' (2,3,6)
}
PUSH[TP,202]      (* BACK VC-C3 TO LIVEBOARD *)
{
  VCC3_F=0
  [TP,202]=STATUS
  CALL 'SWITCH_MATRIX' (2,3,5)
}
PUSH[TP,204]     (* BACK VC-C3 TO RACK VCR *)
{
  VCC3_F=0
  VCR_F_ON=0
  [TP,204]=STATUS
  CALL 'SWITCH_MATRIX' (2,3,1)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,6,1)
}
PUSH[TP,9]      (* ELMO TO PROJECTOR -RGBS CHANGED TO VC 1/15/99*)
{
  V_IN=5
  V_OUT=1
  [TP,9]=STATUS
  CALL 'SWITCH_MATRIX' (2,8,8)
}
PUSH[TP,10]     (* ELMO TO CAPTURE PC -RGBS *)
{
  CALL 'SWITCH_MATRIX' (2,8,7)
  [TP,10]=STATUS
}
PUSH[TP,11]     (* ELMO TO MBONE PC -RGBS*)
{
  CALL 'SWITCH_MATRIX' (2,8,3)
  [TP,11]=STATUS
}
PUSH[TP,12]     (* ELMO TO MONITOR -RGBS*)
{
  CALL 'SWITCH_MATRIX' (2,8,6)
  [TP,12]=STATUS
}
PUSH[TP,13]     (* ELMO TO LIVEBOARD -RGBS*)
{
  CALL 'SWITCH_MATRIX' (2,8,5)
  [TP,13]=STATUS
}
PUSH[TP,14]     (* ELMO TO FRONT MONITOR -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,5,3)
  [TP,14]=STATUS
}
PUSH[TP,102]  (* ELMO TO RACK VCR *)
{
  VCR_F_ON=0
  [TP,102]=STATUS
  CALL 'SWITCH_MATRIX' (2,8,1)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,8,1)
}
PUSH[TP,15]     (* CAMERA TO PROJECTOR *)
{
  V_IN=6
  V_OUT=8
  [TP,15]=STATUS
  CALL 'SWITCH_MATRIX' (2,6,8)
}
PUSH[TP,16]     (* CAMERA TO CAPTURE PC *)
{
  V_IN=6
  V_OUT=7
  [TP,16]=STATUS
  CALL 'SWITCH_MATRIX' (2,6,7)
}
PUSH[TP,17]     (* CAMERA TO MBONE PC *)
{
  V_IN=6
  V_OUT=3
  [TP,17]=STATUS
  CALL 'SWITCH_MATRIX' (2,6,3)
}
PUSH[TP,18]     (* CAMERA TO MONITOR *)
{
  V_IN=6
  V_OUT=6
  [TP,18]=STATUS
  CALL 'SWITCH_MATRIX' (2,6,6)
}
PUSH[TP,19]     (* CAMERA TO LIVEBOARD *)
{
  V_IN=6
  V_OUT=5
  [TP,19]=STATUS
  CALL 'SWITCH_MATRIX' (2,6,5)
}
PUSH[TP,103]     (* CAMERA TO RACK VCR *)
{
  VCR_F_ON=0
  [TP,103]=STATUS
  CALL 'SWITCH_MATRIX' (2,6,1)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,6,1)
}
PUSH[TP,21]     (* FRONT PC TO PROJECTOR -RGBS*)
{
  [TP,21]=STATUS
  CALL 'SWITCH_MATRIX' (1,3,1)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,3,8)  (* AUDIO *)
}
PUSH[TP,22]     (* FRONT PC TO CAPTURE PC -RGBS *)
{
  CALL 'SWITCH_MATRIX' (1,3,2)  (* SCAN CONVERTER *)
  CALL 'SWITCH_MATRIX' (2,7,7)
  [TP,22]=STATUS
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,3,7)   (* AUDIO *)
  SEND_STRING YEM, "'MEMORY 1,0',$0D"
}
PUSH[TP,23]     (* FRONT PC TO MBONE PC -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,3,2)  (* SCAN CONVERTER *)
  [TP,23]=STATUS
  CALL 'SWITCH_MATRIX' (2,7,3)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,3,3)   (* AUDIO *)
  SEND_STRING YEM, "'MEMORY 3,0',$0D"
}
PUSH[TP,24]     (* FRONT PC TO MONITOR -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,3,2)  (* SCAN CONVERTER *)
  [TP,24]=STATUS
  CALL 'SWITCH_MATRIX' (2,7,6)
  IF (AUDIO_ROUTE=1)
     CALL 'SWITCH_MATRIX' (3,3,6)   (* AUDIO *)
  SEND_STRING YEM, "'MEMORY 3,0',$0D"
}
PUSH[TP,25]     (* FRONT PC TO LIVEBOARD -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,3,2)  (* SCAN CONVERTER *)
  [TP,25]=STATUS
  CALL 'SWITCH_MATRIX' (2,7,5)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,3,5)   (* AUDIO *)
  SEND_STRING YEM, "'MEMORY 3,0',$0D"
}
PUSH[TP,26]     (* FRONT PC TO FRONT MONITOR -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,3,3)
  [TP,26]=STATUS
}
PUSH[TP,104]     (* FRONT PC TO RACK VCR *)
{
  VCR_F_ON=0
  [TP,104]=STATUS
  CALL 'SWITCH_MATRIX' (1,3,2)
  CALL 'SWITCH_MATRIX' (2,7,1)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,3,1)
  SEND_STRING YEM, "'MEMORY 3,0',$0D"
}
PUSH[TP,27]     (* LAPTOP TO PROJECTOR -RGBS*)
{
  [TP,27]=STATUS
  CALL 'SWITCH_MATRIX' (1,7,1)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,4,8)  (* AUDIO *)
}
PUSH[TP,28]     (* LAPTOP TO CAPTURE PC -RGBS *)
{
  CALL 'SWITCH_MATRIX' (1,7,2)  (* SCAN CONVERTER *)
  [TP,28]=STATUS
  CALL 'SWITCH_MATRIX' (2,7,7)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,4,7)  (* AUDIO *)
}
PUSH[TP,29]     (* LAPTOP TO MBONE PC -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,7,2)  (* SCAN CONVERTER *)
  [TP,29]=STATUS
  CALL 'SWITCH_MATRIX' (2,7,3)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,4,3)   (* AUDIO *)
}
PUSH[TP,30]     (* LAPTOP TO MONITOR -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,7,2)  (* SCAN CONVERTER *)
  [TP,30]=STATUS
  CALL 'SWITCH_MATRIX' (2,7,6)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,4,6)   (* AUDIO *)
}
PUSH[TP,31]     (* LAPTOP TO LIVEBOARD -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,7,2)  (* SCAN CONVERTER *)
  [TP,31]=STATUS
  CALL 'SWITCH_MATRIX' (2,7,5)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,4,5)   (* AUDIO *)
}
PUSH[TP,32]     (* LAPTOP TO FRONT MONITOR -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,7,3)
  [TP,32]=STATUS
}
PUSH[TP,105]     (* LAPTOP TO RACK VCR *)
{
  VCR_F_ON=0
  [TP,105]=STATUS
  CALL 'SWITCH_MATRIX' (1,7,2)
  CALL 'SWITCH_MATRIX' (2,7,1)
  IF (AUDIO_ROUTE=1)
     CALL 'SWITCH_MATRIX' (3,4,1)
}
PUSH[TP,33]     (* FRONT VCR TO PROJECTOR *)
{
  [TP,33]=STATUS
  VCR_F_ON=1
  CALL 'SWITCH_MATRIX' (2,2,8)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,2,8)   (* AUDIO *)
}
PUSH[TP,34]     (* FRONT VCR TO CAPTURE PC *)
{
  [TP,34]=STATUS
  VCR_F_ON=1
  CALL 'SWITCH_MATRIX' (2,2,7)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,2,7)   (* AUDIO *)
}
PUSH[TP,35]     (* FRONT VCR TO MBONE PC *)
{
  [TP,35]=STATUS
  VCR_F_ON=1
  CALL 'SWITCH_MATRIX' (2,2,3)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,2,3)   (* AUDIO *)
}
PUSH[TP,36]     (* FRONT VCR TO MONITOR *)
{
  [TP,36]=STATUS
  VCR_F_ON=1
  CALL 'SWITCH_MATRIX' (2,2,6)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,2,6)   (* AUDIO *)
}
PUSH[TP,37]     (* FRONT VCR TO LIVEBOARD *)
{
  [TP,37]=STATUS
  VCR_F_ON=1
  CALL 'SWITCH_MATRIX' (2,2,5)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,2,5)   (* AUDIO *)
}
PUSH[TP,106]     (* FRONT VCR TO RACK VCR *)
{
  [TP,106]=STATUS
  VCR_F_ON=1
  CALL 'SWITCH_MATRIX' (2,2,1)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,2,1)
}
PUSH[TP,39]     (* RACK VCR TO PROJECTOR *)
{
  [TP,39]=STATUS
  VCR_F_ON=0
  CALL 'SWITCH_MATRIX' (2,1,8)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,1,8)   (* AUDIO *)
}
PUSH[TP,40]     (* RACK VCR TO CAPTURE PC *)
{
  [TP,40]=STATUS
  VCR_F_ON=0
  CALL 'SWITCH_MATRIX' (2,1,7)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,1,7)   (* AUDIO *)
}
PUSH[TP,41]     (* RACK VCR TO MBONE PC *)
{
  [TP,41]=STATUS
  VCR_F_ON=0
  CALL 'SWITCH_MATRIX' (2,1,3)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,1,3)   (* AUDIO *)
}
PUSH[TP,42]     (* RACK VCR TO MONITOR *)
{
  [TP,42]=STATUS
  VCR_F_ON=0
  CALL 'SWITCH_MATRIX' (2,1,6)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,1,6)   (* AUDIO *)
}
PUSH[TP,43]     (* RACK VCR TO LIVEBOARD *)
{
  [TP,43]=STATUS
  VCR_F_ON=0
  CALL 'SWITCH_MATRIX' (2,1,5)
  IF (AUDIO_ROUTE=1)
     CALL 'SWITCH_MATRIX' (3,1,5)   (* AUDIO *)
}
PUSH[TP,45]     (* SGI TO PROJECTOR -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,2,1)
  [TP,45]=STATUS
}
PUSH[TP,46]     (* SGI TO CAPTURE PC -RGBS *)
{
  CALL 'SWITCH_MATRIX' (1,2,2)
  V_IN=7         (* SCAN CONVERTER *)
  V_OUT=7
  CALL 'SWITCH_MATRIX' (2,7,7)
  [TP,46]=STATUS
  SEND_STRING YEM, "'MEMORY 4,0',$0D"
}
PUSH[TP,47]     (* SGI TO MBONE PC -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,2,2)
  V_IN=7         (* SCAN CONVERTER *)
  V_OUT=3
  CALL 'SWITCH_MATRIX' (2,7,3)
  [TP,47]=STATUS
  SEND_STRING YEM, "'MEMORY 4,0',$0D"
}
PUSH[TP,48]     (* SGI TO MONITOR -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,2,2)
  V_IN=7         (* SCAN CONVERTER *)
  V_OUT=6
  CALL 'SWITCH_MATRIX' (2,7,6)
  [TP,48]=STATUS
  SEND_STRING YEM, "'MEMORY 4,0',$0D"
}
PUSH[TP,49]     (* SGI TO LIVEBOARD -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,2,2)
  V_IN=7         (* SCAN CONVERTER *)
  V_OUT=5
  CALL 'SWITCH_MATRIX' (2,7,5)
  [TP,49]=STATUS
  SEND_STRING YEM, "'MEMORY 4,0',$0D"
}
PUSH[TP,50]     (* SGI TO FRONT MONITOR -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,2,3)
  [TP,50]=STATUS
}
PUSH[TP,108]     (* SGI TO RACK VCR *)
{
  [TP,108]=STATUS
  VCR_F_ON=0
  CALL 'SWITCH_MATRIX' (1,2,2)
  CALL 'SWITCH_MATRIX' (2,7,1)
  SEND_STRING YEM, "'MEMORY 4,0',$0D"
}
PUSH[TP,51]     (* MBONE PC TO PROJECTOR -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,1,1)
  [TP,51]=STATUS
  CALL 'SWITCH_MATRIX' (3,8,8)   (* AUDIO *)
}
PUSH[TP,52]     (* MBONE PC TO CAPTURE PC -RGBS *)
{
  CALL 'SWITCH_MATRIX' (1,1,2)
  V_IN=7         (* SCAN CONVERTER *)
  V_OUT=7
  CALL 'SWITCH_MATRIX' (2,7,7)
  [TP,52]=STATUS
  CALL 'SWITCH_MATRIX' (3,8,7)   (* AUDIO *)
  SEND_STRING YEM, "'MEMORY 3,0',$0D"
}
PUSH[TP,53]     (* MBONE PC TO MBONE PC -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,1,2)
  V_IN=7         (* SCAN CONVERTER *)
  V_OUT=3
  CALL 'SWITCH_MATRIX' (2,7,3)
  [TP,53]=STATUS
  (* AUDIO ROUTED FROM MIXER *)
  SEND_STRING YEM, "'MEMORY 3,0',$0D"
}
PUSH[TP,54]     (* MBONE PC TO MONITOR -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,1,2)
  V_IN=7         (* SCAN CONVERTER *)
  V_OUT=6
  CALL 'SWITCH_MATRIX' (2,7,6)
  [TP,54]=STATUS
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,8,6)   (* AUDIO *)
  SEND_STRING YEM, "'MEMORY 3,0',$0D"
}
PUSH[TP,55]     (* MBONE PC TO LIVEBOARD -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,1,2)
  V_IN=7         (* SCAN CONVERTER *)
  V_OUT=5
  CALL 'SWITCH_MATRIX' (2,7,5)
  [TP,55]=STATUS
  IF (AUDIO_ROUTE=1)
     CALL 'SWITCH_MATRIX' (3,8,5)   (* AUDIO *)
  SEND_STRING YEM, "'MEMORY 3,0',$0D"
}

PUSH[TP,56]     (* MBONE PC TO FRONT MONITOR -RGBS*)
{
  CALL 'SWITCH_MATRIX' (1,1,3)
  [TP,56]=STATUS
}
PUSH[TP,109]     (* MBONE PC TO RACK VCR *)
{
  VCR_F_ON=0
  [TP,109]=STATUS
  CALL 'SWITCH_MATRIX' (1,1,2)
  CALL 'SWITCH_MATRIX' (2,7,1)
  IF (AUDIO_ROUTE=1)
    CALL 'SWITCH_MATRIX' (3,8,1)  (* AUDIO *)
  SEND_STRING YEM, "'MEMORY 3,0',$0D"
}

(* MIXER *)

PUSH[TP,180]
{
  LEVEL_ADJ=1-LEVEL_ADJ
  [TP,180]=LEVEL_ADJ
}
PUSH[TP,181]
{
  RANGE_ADJ=1-RANGE_ADJ
  [TP,181]=RANGE_ADJ
}
PUSH[TP,182]
{
  TRIM_ADJ=1-TRIM_ADJ
  [TP,182]=TRIM_ADJ
}
IF (PUSH_CHANNEL>=58 && PUSH_CHANNEL <=93)  (* MIXER SCREEN *)
{
  IF (LEVEL_ADJ=1)
  {
    TYPE='L'
    CALL 'GET_LEVEL_STATE'
  }
  ELSE
    IF (RANGE_ADJ=1)
    {
       TYPE='R'
       CALL 'GET_RANGE_STATE'
    }
    ELSE
    {
       TYPE='G'
       CALL 'GET_TRIM_STATE'
    }
}
(* ELMO *)
PUSH[TP,110] TO [ELMO,ELMO_AUTOFOCUS]
PUSH[TP,111]
{
  PULSE[ELMO,ELMO_COMMON]
  PULSE[ELMO,ELMO_BASELIGHT_TOGGLE]
}
PUSH[TP,112]
{
  PULSE[ELMO,ELMO_COMMON]
  PULSE[ELMO,ELMO_UPPERLIGHT_TOGGLE]
}
PUSH[TP,113]
{
  PULSE[ELMO,ELMO_COMMON]
  PULSE[ELMO,ELMO_INPUT_SELECT]
}
PUSH[TP,114] TO [ELMO,ELMO_ZOOM_WIDE]
PUSH[TP,115] TO [ELMO,ELMO_ZOOM_TELE]
PUSH[TP,116] TO [ELMO,ELMO_FOCUS_FAR]
PUSH[TP,117] TO [ELMO,ELMO_FOCUS_NEAR]
PUSH[TP,118]
{
  PULSE[ELMO,ELMO_COMMON]
  PULSE[ELMO,ELMO_ZOOM_PRESET]
}
PUSH[TP,119]
{
  PULSE[ELMO,ELMO_COMMON]
  PULSE[ELMO,ELMO_SIZE_MOVE]
}
(* RACK VCR *)
IF(VCR_F_ON=1)
  DECK=VCR_F
ELSE
  DECK=VCR
PUSH[TP,94]
{
  PULSE [DECK,VCR_POWER]
  IF(VCR_STATE=0 && VCR_F_ON=0)
     VCR_STATE=1
  ELSE
     VCR_STATE=0
}
PUSH[TP,95]
{
  PULSE [DECK,VCR_REC]
}
PUSH[TP,96]
{
  PULSE [DECK,VCR_PLAY]
}
PUSH[TP,97]
{
  PULSE [DECK,VCR_STOP]
}
PUSH[TP,98]
{
  PULSE [DECK,VCR_PAUSE]
}
PUSH[TP,99]
{
  PULSE [DECK,VCR_REW]
}
PUSH[TP,100]
{
  PULSE [DECK,VCR_FFWD]
}
PUSH[TP,2]
{
  CALL 'ASSIGN_MBONE'
  IF(TIMESON=1)
  {
  SEND_STRING MIXER, "'?U',$0D,$0A"  (* QUERY POLL MESSAGE *)
  X=LENGTH_STRING(MIXER_IN)
  WHILE(X<=0)
  {
  SEND_STRING 0,ITOA(GET_BUFFER_CHAR(MIXER_IN))
  X=X-1
  }
  TIMESON=0
  }
}

(* VC-C3 *)
PUSH[TP,206]
IF (VCC3_F=1)
{
  VCC3_F=0
  SEND_COMMAND TP, "'TEXT2 - INSTRUCTOR VC-C3 MENU'"
  }
ELSE
  {
  VCC3_F=1
  SEND_COMMAND TP, "'TEXT2 - AUDIENCE VC-C3 MENU'"
}
PUSH[TP,205]
IF (VCC3_F=1)
  SEND_COMMAND TP, "'TEXT2 - AUDIENCE VC-C3 MENU'"
ELSE
  SEND_COMMAND TP, "'TEXT2 - INSTRUCTOR VC-C3 MENU'"
PUSH[TP,161]
  IF (VCC3_F=1)
     PULSE[VCC3,CAM_POWER]
  ELSE
     PULSE[VCC3_B,CAM_POWER]
PUSH[TP,162]
  IF (VCC3_F=1)
     PULSE[VCC3,CAM_HOME]
  ELSE
     PULSE[VCC3_B,CAM_HOME]
PUSH[TP,163]
  IF (VCC3_F=1)
     PULSE[VCC3,CAM_AUTO_FOCUS]
  ELSE
     PULSE[VCC3_B,CAM_AUTO_FOCUS]
PUSH[TP,164]
  IF (VCC3_F=1)
     PULSE[VCC3,CAM_MANUAL_FOCUS]
  ELSE
     PULSE[VCC3_B,CAM_MANUAL_FOCUS]
PUSH[TP,165]
  IF (VCC3_F=1)
     PULSE[VCC3,CAM_NEAR_FOCUS]
  ELSE
     PULSE[VCC3_B,CAM_NEAR_FOCUS]
PUSH[TP,166]
  IF (VCC3_F=1)
     PULSE[VCC3,CAM_FAR_FOCUS]
  ELSE
     PULSE[VCC3_B,CAM_FAR_FOCUS]
PUSH[TP,167]
  IF (VCC3_F=1)
     PULSE[VCC3,CAM_WIDE_ZOOM]
  ELSE
     PULSE[VCC3_B,CAM_WIDE_ZOOM]
PUSH[TP,168]
  IF (VCC3_F=1)
     PULSE[VCC3,CAM_TELE_ZOOM]
  ELSE
     PULSE[VCC3_B,CAM_TELE_ZOOM]
PUSH[TP,169]
  IF (VCC3_F=1)
     PULSE[VCC3,CAM_TILT_UP]
  ELSE
     PULSE[VCC3_B,CAM_TILT_UP]
PUSH[TP,170]
  IF (VCC3_F=1)
     PULSE[VCC3,CAM_TILT_DOWN]
  ELSE
     PULSE[VCC3_B,CAM_TILT_DOWN]
PUSH[TP,171]
  IF (VCC3_F=1)
     PULSE[VCC3,CAM_PAN_RIGHT]
  ELSE
     PULSE[VCC3_B,CAM_PAN_RIGHT]
PUSH[TP,172]
  IF (VCC3_F=1)
     PULSE[VCC3,CAM_PAN_LEFT]
  ELSE
     PULSE[VCC3_B,CAM_PAN_LEFT]
(* AUDIO *)
PUSH[TP,120]  (* CLEAR AUDIO SOURCES *)
{
  SEND_STRING MATRIX,"'DL3I1 2 3 4 5 6 7 8O1 2 3 4 5 6 7 8T'"
  A_STATUS=0
}
PUSH[TP,121]  (* UNROUTE AUDIO SETTING *)
{
  UNAUDIO=1
  [TP,121]=UNAUDIO
}
PUSH[TP,176]  (* SEND FROM VCR *)
  CALL 'AUDIO_TOGGLE'(2,4,176)
PUSH[TP,177]  (* SEND FROM FRONT PC*)
  CALL 'AUDIO_TOGGLE'(3,4,177)
PUSH[TP,178]  (* SEND FROM LAPTOP *)
  CALL 'AUDIO_TOGGLE'(4,4,178)
PUSH[TP,179]  (* FM - CAMERA *)
  CALL 'AUDIO_TOGGLE'(6,2,179)
PUSH[TP,180]  (* Mix-Mic - CAMERA *)
  CALL 'AUDIO_TOGGLE'(7,2,180)
PUSH[TP,181]  (* MBONE - CAMERA *)
  CALL 'AUDIO_TOGGLE'(8,2,181)
PUSH[TP,182]  (* FM - RACK MONITOR *)
  CALL 'AUDIO_TOGGLE'(6,6,182)
PUSH[TP,183]  (* Mix-Mic - RACK MONITOR *)
  CALL 'AUDIO_TOGGLE'(7,6,183)
PUSH[TP,184]  (* MBONE - RACK MONITOR *)
  CALL 'AUDIO_TOGGLE'(8,6,184)
PUSH[TP,185]  (* FM - SPEAKER *)
  CALL 'AUDIO_TOGGLE'(6,8,185)
PUSH[TP,186]  (* Mix-Mic - SPEAKER *)
  CALL 'AUDIO_TOGGLE'(7,8,186)
PUSH[TP,187]  (* MBONE - SPEAKER *)
  CALL 'AUDIO_TOGGLE'(8,8,187)
PUSH[TP,188]  (* FM - Rack VCR *)
  CALL 'AUDIO_TOGGLE'(6,1,188)
PUSH[TP,189]  (* MIX-MIC - Rack VCR *)
  CALL 'AUDIO_TOGGLE'(7,1,189)
PUSH[TP,190]  (* MBONE - Rack VCR *)
  CALL 'AUDIO_TOGGLE'(8,1,190)
(*SCAN CONVERTER *)
PUSH[TP,125]  (* MEMORY SELECTION 800X600 *)
  SEND_STRING YEM,"'MEMORY 1,0',$0D"
PUSH[TP,126]  (* MEMORY SELECTION 640X480 *)
  SEND_STRING YEM,"'MEMORY 2,0',$0D"
PUSH[TP,149]  (* MEMORY SELECTION 1024X768 *)
  SEND_STRING YEM,"'MEMORY 3,0',$0D"
PUSH[TP,157]  (* MEMORY SELECTION SGI *)
  SEND_STRING YEM,"'MEMORY 4,0',$0D"
PUSH[TP,160]  (* SIZE UP *)
  SEND_STRING YEM,"'SIZE +0,+-1',$0D"
PUSH[TP,191]  (* SIZE DOWN *)
  SEND_STRING YEM,"'SIZE +0,+1',$0D"
PUSH[TP,192]  (* SIZE RIGHT *)
  SEND_STRING YEM,"'SIZE +-1,+0',$0D"
PUSH[TP,193]  (* SIZE LEFT *)
  SEND_STRING YEM,"'SIZE +1,+0',$0D"
PUSH[TP,194]  (* POSITION UP *)
  SEND_STRING YEM,"'POSITION +0,+-1',$0D"
PUSH[TP,195]  (* POSITION DOWN *)
  SEND_STRING YEM,"'POSITION +0,+1',$0D"
PUSH[TP,196]  (* POSITION RIGHT *)
  SEND_STRING YEM,"'POSITION +-1,+0',$0D"
PUSH[TP,197]  (* POSITION LEFT *)
  SEND_STRING YEM,"'POSITION +1,+0',$0D"

(***********************************************************)
(*                     END OF PROGRAM                      *)
(*        DO NOT PUT ANY CODE BELOW THIS COMMENT           *)
(***********************************************************)

