@echo off

rem build.bat --
rem
rem     This script compiles Mash and all of the libraries it needs.
rem
rem Copyright (c) 2001-2002 The Regents of the University of California.
rem All rights reserved.
rem
rem Redistribution and use in source and binary forms, with or without
rem modification, are permitted provided that the following conditions are met:
rem
rem A. Redistributions of source code must retain the above copyright notice,
rem    this list of conditions and the following disclaimer.
rem B. Redistributions in binary form must reproduce the above copyright
rem    notice, this list of conditions and the following disclaimer in the
rem    documentation and/or other materials provided with the distribution.
rem C. Neither the names of the copyright holders nor the names of its
rem    contributors may be used to endorse or promote products derived from
rem    this software without specific prior written permission.
rem
rem THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
rem IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
rem THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
rem PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
rem LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
rem CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
rem SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
rem INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
rem CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
rem ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
rem POSSIBILITY OF SUCH DAMAGE.

rem Process command-line arguments.

set build_name=%0
set build_all=
set build_tcl=
set build_tk=
set build_otcl=
set build_tclcl=
set build_gsm=
set build_mash=
set build_mashbin=
if "%1"=="" goto noargs
:nextarg
    if "%1"=="/?"      goto usage
    if "%1"=="-h"      goto usage
    if "%1"=="--help"  goto usage
    if "%1"=="all"     set build_all=1
    if "%1"=="tcl"     set build_tcl=1
    if "%1"=="tcl8.3"  set build_tcl=1
    if "%1"=="tk"      set build_tk=1
    if "%1"=="tk8.3"   set build_tk=1
    if "%1"=="otcl"    set build_otcl=1
    if "%1"=="tclcl"   set build_tclcl=1
    if "%1"=="gsm"     set build_gsm=1
    if "%1"=="mash"    set build_mash=1
    if "%1"=="mashbin" set build_mash=1
    if "%1"=="mashbin" set build_mashbin=1
    shift
if "%1"=="" goto endargs
goto nextarg
:noargs
    set build_all=1
:endargs

rem Build Tcl.

if "%build_all%%build_tcl%"=="" goto endtcl
    echo.
    echo.
    echo Building tcl8.3\win...
    echo.
    cd tcl8.3\win
    nmake -f makefile.vc -nologo -s clean > nul
    nmake -f makefile.vc -nologo -s
    if errorlevel 1 goto die
    cd ..\..
:endtcl

rem Build Tk.

if "%build_all%%build_tk%"=="" goto endtk
    echo.
    echo.
    echo Building tk8.3\win...
    echo.
    cd tk8.3\win
    nmake -f makefile.vc -nologo -s clean > nul
    nmake -f makefile.vc -nologo -s
    if errorlevel 1 goto die
    cd ..\..
:endtk

rem Build OTcl.

if "%build_all%%build_otcl%"=="" goto endotcl
    echo.
    echo.
    echo Building otcl...
    echo.
    cd otcl
    nmake -f makefile.vc -nologo -s clean > nul
    nmake -f makefile.vc -nologo -s
    if errorlevel 1 goto die
    cd ..
:endotcl

rem Build TclCL.

if "%build_all%%build_tclcl%"=="" goto endtclcl
    echo.
    echo.
    echo Building tclcl...
    echo.
    cd tclcl
    nmake -f makefile.vc -nologo -s clean > nul
    nmake -f makefile.vc -nologo -s
    if errorlevel 1 goto die
    cd ..
:endtclcl

rem Build GSM.

if "%build_all%%build_gsm%"=="" goto endgsm
    echo.
    echo.
    echo Building gsm...
    echo.
    cd gsm
    nmake -f makefile.vc -nologo -s clean > nul
    nmake -f makefile.vc -nologo -s
    if errorlevel 1 goto die
    cd ..
:endgsm

rem Build Mash.

if "%build_all%%build_mash%"=="" goto endmash
    cd mash

    echo.
    echo.
    echo Building mash...
    echo.
    nmake -f makefile.vc -nologo -s realclean > nul
    nmake -f makefile.vc -nologo -s
    if errorlevel 1 goto die

    echo.
    echo.
    echo Building smash...
    echo.
    nmake -f makefile.vc -nologo -s smash
    if errorlevel 1 goto die

    echo.
    echo.
    echo Building import...
    echo.
    nmake -f makefile.vc -nologo -s import
    if errorlevel 1 goto die

    echo.
    echo.
    echo Building megatools...
    echo.
    nmake -f makefile.vc -nologo -s megatools
    if errorlevel 1 goto die

    if "%build_mashbin%"=="" goto endmashbin
        echo.
        echo.
        echo Building mashbin...
        echo.
        nmake -f makefile.vc -nologo -s mashbin
        if errorlevel 1 goto die
    :endmashbin

    cd ..
:endmash

goto end


rem usage --
rem
rem       Print brief description of command-line syntax and exit batch file.

:usage
echo Compiles Mash and all of the libraries it needs.
echo.
echo %build_name% [targets]
echo.
echo   targets    Specifies targets to compile.  Default is all.
echo              all    otcl     mash
echo              tcl    tclcl    mashbin
echo              tk     gsm
goto end


rem die --
rem
rem       Print error message and exit batch file.

:die
echo %build_name%: nmake failed


:end
set build_name=
set build_all=
set build_tcl=
set build_tk=
set build_otcl=
set build_tclcl=
set build_gsm=
set build_mash=
set build_mashbin=
