/*
 * transmogrify.cc --
 *
 *      RTP Edit, Transmogrify
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <tclcl.h>
#include "archive/transmogrify.h"
#include "archive/archive-file.h"
#include "misc/mtrace.h"
#include "misc/nethost.h"



DEFINE_OTCL_CLASS(EditRTP, "Edit/RTP") {
	INSTPROC(datafile);
	INSTPROC(indexfile);
	INSTPROC(outdata);
	INSTPROC(outindex);
	INSTPROC(go);
	INSTPROC(find_cut);
}


EditRTP::EditRTP()
{
	bufpool_ = new BufferPool;
}



int
EditRTP::datafile(int argc, const char * const *argv)
{

	TclObject *file;

	BEGIN_PARSE_ARGS(argc, argv);
	ARG(file);
	END_PARSE_ARGS;
	DataFile_((DataFile*)file);
	return TCL_OK;
}

int
EditRTP::indexfile(int argc, const char * const *argv)
{

	TclObject *ifile;

	BEGIN_PARSE_ARGS(argc, argv);
	ARG(ifile);
	END_PARSE_ARGS;
	IndexFile_((IndexFile*)ifile);
	return TCL_OK;
}

int
EditRTP::outdata(int argc, const char * const *argv)
{

	TclObject *odfile;

	BEGIN_PARSE_ARGS(argc, argv);
	ARG(odfile);
	END_PARSE_ARGS;
	OutDataFile_((DataFile*)odfile);
	return TCL_OK;
}

int
EditRTP::outindex(int argc, const char * const *argv)
{

	TclObject *oifile;

	BEGIN_PARSE_ARGS(argc, argv);
	ARG(oifile);
	END_PARSE_ARGS;
	OutIndexFile_((IndexFile*)oifile);
	return TCL_OK;
}

int
EditRTP::find_cut(int argc, const char * const *argv)
{
	const char *array;
	Tcl &tcl = Tcl::instance();

	BEGIN_PARSE_ARGS(argc, argv);
	ARG(array);
	END_PARSE_ARGS;

	IndexFile* ifile;
	DataFile* dfile;
	ArchiveFile* afile;

	int x=0;
	char time[32];

	FileHeader read_hdrNet, read_hdrHost, read_ihdrNet, read_ihdrHost;
	RTPprivatehdr read_phdrNet, read_phdrHost;

	u_int32_t last_sent, new_scale_, rtptime;

	double adjust;

	last_sent=0;

	int curpos, endpos;

	timeval new_sent;

	IndexRecord iNet, iHost;


	RTPPacket* pb;  // Fix

	pb = new RTPPacket;
	pb->buf=bufpool_->alloc();


	ifile = IndexFile_();
	dfile = DataFile_();

	afile=ifile;


	//Read and Write Headers here
	// get ref times, scale

	dfile->Read(&read_hdrNet, (Byte *)&read_phdrNet, sizeof(RTPprivatehdr));

	if (dfile->Seek(dfile->getHeaderSize(), SEEK_SET)==TCL_ERROR)
			return TCL_ERROR;

	net2host(read_hdrNet, read_hdrHost);
	net2host(read_phdrNet, read_phdrHost);


	printf("Name=%s\n",read_hdrHost.cname);
	scale_=read_phdrHost.scale;
	ref_rtp_ = read_phdrHost.ref_rtp;
	ref_tv_sec_ = read_phdrHost.ref_tv_sec;
	ref_tv_usec_ = read_phdrHost.ref_tv_usec;
	//adjust_ = 0;
        //int orig_sent = (logical2rtp(sent, scale_, new_ref, new_ref_sec, new_ref_usec));
        //u_int32_t sent_time = (adjust_logical2rtp(sent.tv_sec, sent.tv_usec, scale_, ref_rtp_, ref_tv_sec_, ref_tv_usec_, adjust_));



	if (ifile->Seek(0, SEEK_END)==TCL_ERROR)
		return TCL_ERROR;
	int actual_end = ifile->Tell();
	endpos = actual_end;
	// This is only necessary in pathological cases, where the disk filled up, etc
	int modend = ((endpos - sizeof(FileHeader)) % sizeof(IndexRecord));
	if (modend != 0) {
		MTrace(trcArchive, ("Wrong Size, truncing"));
		endpos = endpos - modend;
	}

	// Calculate scale
	if (ifile->Seek((endpos-sizeof(IndexRecord)), SEEK_SET)==TCL_ERROR)  {
		return TCL_ERROR;
	}
	if (ifile->Read(&iNet)==TCL_ERROR) {
			return TCL_ERROR;
	}
	net2host(iNet, iHost);

	double last_rtp = logical2rtp(iHost.sentTS_sec, iHost.sentTS_usec, scale_, ref_rtp_,
			       ref_tv_sec_, ref_tv_usec_);
	double last_recv = iHost.recvTS_sec + iHost.recvTS_usec/1000000.0;
	double first_recv = ref_tv_sec_ + ref_tv_usec_/1000000.0;
	double new_scale = (last_rtp - ref_rtp_) / (last_recv - first_recv);
	printf("New Scale = %g\n", new_scale);
	new_scale_ = (int) new_scale;
	//

	afile->Read(&read_ihdrNet, NULL, 0);
	net2host(read_ihdrNet, read_ihdrHost);

	// Check that end timestamp is current in header, rewrite if ness.
	if (read_hdrHost.end_sec < iHost.recvTS_sec) {
		read_hdrHost.end_sec = iHost.recvTS_sec;
		read_hdrHost.end_usec = iHost.recvTS_usec;
		read_ihdrHost.end_sec = iHost.recvTS_sec;
		read_ihdrHost.end_usec = iHost.recvTS_usec;
		host2net(read_hdrHost, read_hdrNet);
		host2net(read_ihdrHost, read_ihdrNet);
	}

	read_phdrHost.scale = new_scale_;

	host2net(read_phdrHost, read_phdrNet);


	if (ifile->Seek(0, SEEK_END)==TCL_ERROR) {
		return TCL_ERROR;
	}
	endpos=ifile->Tell();
	if (ifile->Seek(sizeof(FileHeader), SEEK_SET)==TCL_ERROR)  {
		return TCL_ERROR;
	}
	curpos=ifile->Tell();


	while (curpos < endpos) {

		if (ifile->Read(&iNet)==TCL_ERROR) {
			return TCL_ERROR;
		}
		curpos=ifile->Tell();

		net2host(iNet, iHost);

		struct recordhdr rech;
		struct recordhdr newhdr;

		if (dfile->Read((unsigned char*)&rech, sizeof(recordhdr))==0) {
			return TCL_ERROR;
		}

		int len = net2host(rech.len);

		if (dfile->Read((u_char*) pb->buf->data, len) == 0) {
			return TCL_ERROR;
		}
		struct rtphdr *rh = (struct rtphdr *)pb->buf->data;




		timeval sent, recv;

		sent.tv_sec=iHost.sentTS_sec;
		sent.tv_usec = iHost.sentTS_usec;
		recv.tv_sec=iHost.recvTS_sec;
		recv.tv_usec=iHost.recvTS_usec;

		u_int32_t rtp_time = net2host(rh->rh_ts);

		//int orig_sent = (logical2rtp(sent, scale_, ref_rtp_, ref_tv_sec_, ref_tv_usec_));

		if ((rtp_time  - last_sent) > 50000) {  // ???
			timeval new_log_sent = (rtp2logical(rtp_time, new_scale_, ref_rtp_, ref_tv_sec_, ref_tv_usec_));
			double recv_log = iHost.recvTS_sec + iHost.recvTS_usec/1000000.0;
			double sent_log = new_log_sent.tv_sec + new_log_sent.tv_usec/1000000.0;
			adjust = (recv_log - sent_log) * scale_;
			rtptime = (u_int32_t) ((int)rtp_time + (int)adjust);

			new_sent = rtp2logical(rtptime, new_scale_, ref_rtp_, ref_tv_sec_, ref_tv_usec_);
			sprintf(time, "%ld", new_sent.tv_sec);
			//printf("Gap at %ld\n", new_sent.tv_sec);
			if (Tcl_SetVar2(tcl.interp(), (char*)array, time,
					read_hdrHost.name, TCL_LEAVE_ERR_MSG)==NULL) {
				tcl.resultf("\nwhile writing to array '%s'", array);

			}
			//times[x]=new_sent;
			x++;
		}
		else {

			rtptime= (u_int32_t) ((int)rtp_time + (int)adjust);
			new_sent = rtp2logical(rtptime, new_scale_, ref_rtp_, ref_tv_sec_, ref_tv_usec_);

		}






		iHost.sentTS_sec = new_sent.tv_sec;
		iHost.sentTS_usec = new_sent.tv_usec;



		host2net(iHost,iNet);




		newhdr.len = host2net(len);
		newhdr.type = rech.type;
		newhdr.d2 = rech.d2;



		//printf("old ts= %u new=%u adjust=%g %ld %ld %ld %ld\n", net2host(rh->rh_ts), rtptime, adjust, new_sent.tv_sec, new_sent.tv_usec,sent.tv_sec, sent.tv_usec );

		last_sent = net2host(rh->rh_ts);
		rh->rh_ts = host2net(rtptime);



	}



	fflush(0);

	return TCL_OK;
}


int
EditRTP::go(int argc, const char * const *argv)
{

	BEGIN_PARSE_ARGS(argc, argv);
	END_PARSE_ARGS;

	IndexFile* ifile;
	IndexFile* oifile;
	DataFile* dfile;
	DataFile* odfile;

	FileHeader read_hdrNet, read_hdrHost, read_ihdrNet, read_ihdrHost;
	RTPprivatehdr read_phdrNet, read_phdrHost;

	u_int32_t last_sent, new_scale_, rtptime;

	double adjust;

	last_sent=0;

	int curpos, endpos, datapoint;

	timeval new_sent;

	IndexRecord iNet, iHost;

	ArchiveFile* afile;
	ArchiveFile* oafile;

	RTPPacket* pb;  // Fix

	pb = new RTPPacket;
	pb->buf=bufpool_->alloc();


	ifile = IndexFile_();
	dfile = DataFile_();

	afile=ifile;

	oifile = OutIndexFile_();
	odfile = OutDataFile_();

	oafile=oifile;

	//Read and Write Headers here
	// get ref times, scale

	dfile->Read(&read_hdrNet, (Byte *)&read_phdrNet, sizeof(RTPprivatehdr));

	if (dfile->Seek(dfile->getHeaderSize(), SEEK_SET)==TCL_ERROR)
			return TCL_ERROR;

	net2host(read_hdrNet, read_hdrHost);
	net2host(read_phdrNet, read_phdrHost);

	scale_=read_phdrHost.scale;
	ref_rtp_ = read_phdrHost.ref_rtp;
	ref_tv_sec_ = read_phdrHost.ref_tv_sec;
	ref_tv_usec_ = read_phdrHost.ref_tv_usec;
	//adjust_ = 0;
        //int orig_sent = (logical2rtp(sent, scale_, new_ref, new_ref_sec, new_ref_usec));
        //u_int32_t sent_time = (adjust_logical2rtp(sent.tv_sec, sent.tv_usec, scale_, ref_rtp_, ref_tv_sec_, ref_tv_usec_, adjust_));



	if (ifile->Seek(0, SEEK_END)==TCL_ERROR)
		return TCL_ERROR;
	int actual_end = ifile->Tell();
	endpos = actual_end;
	// This is only necessary in pathological cases, where the disk filled up, etc
	int modend = ((endpos - sizeof(FileHeader)) % sizeof(IndexRecord));
	if (modend != 0) {
		MTrace(trcArchive, ("Wrong Size, truncing"));
		endpos = endpos - modend;
	}

	// Calculate scale
	if (ifile->Seek((endpos-sizeof(IndexRecord)), SEEK_SET)==TCL_ERROR)  {
		return TCL_ERROR;
	}
	if (ifile->Read(&iNet)==TCL_ERROR) {
			return TCL_ERROR;
	}
	net2host(iNet, iHost);

	double last_rtp = logical2rtp(iHost.sentTS_sec, iHost.sentTS_usec, scale_, ref_rtp_,
			       ref_tv_sec_, ref_tv_usec_);
	double last_recv = iHost.recvTS_sec + iHost.recvTS_usec/1000000.0;
	double first_recv = ref_tv_sec_ + ref_tv_usec_/1000000.0;
	double new_scale = (last_rtp - ref_rtp_) / (last_recv - first_recv);
	printf("New Scale = %g\n", new_scale);
	new_scale_ = (int) new_scale;
	//

	afile->Read(&read_ihdrNet, NULL, 0);
	net2host(read_ihdrNet, read_ihdrHost);

	// Check that end timestamp is current in header, rewrite if ness.
	if (read_hdrHost.end_sec < iHost.recvTS_sec) {
		read_hdrHost.end_sec = iHost.recvTS_sec;
		read_hdrHost.end_usec = iHost.recvTS_usec;
		read_ihdrHost.end_sec = iHost.recvTS_sec;
		read_ihdrHost.end_usec = iHost.recvTS_usec;
		host2net(read_hdrHost, read_hdrNet);
		host2net(read_ihdrHost, read_ihdrNet);
	}

	read_phdrHost.scale = new_scale_;

	host2net(read_phdrHost, read_phdrNet);

	odfile->Write(&read_hdrNet, (Byte*)&read_phdrNet);

	oafile->Write(&read_ihdrNet);

	if (odfile->Seek(odfile->getHeaderSize(), SEEK_SET)==TCL_ERROR)
			return TCL_ERROR;

	if (oafile->Seek(oafile->getHeaderSize(), SEEK_SET)==TCL_ERROR)
			return TCL_ERROR;

	if (ifile->Seek(0, SEEK_END)==TCL_ERROR) {
		return TCL_ERROR;
	}
	endpos=ifile->Tell();
	if (ifile->Seek(sizeof(FileHeader), SEEK_SET)==TCL_ERROR)  {
		return TCL_ERROR;
	}
	curpos=ifile->Tell();


	while (curpos < endpos) {

		if (ifile->Read(&iNet)==TCL_ERROR) {
			return TCL_ERROR;
		}
		curpos=ifile->Tell();

		net2host(iNet, iHost);

		struct recordhdr rech;
		struct recordhdr newhdr;

		if (dfile->Read((unsigned char*)&rech, sizeof(recordhdr))==0) {
			return TCL_ERROR;
		}

		int len = net2host(rech.len);

		if (dfile->Read((u_char*) pb->buf->data, len) == 0) {
			return TCL_ERROR;
		}
		struct rtphdr *rh = (struct rtphdr *)pb->buf->data;




		timeval sent, recv;

		sent.tv_sec=iHost.sentTS_sec;
		sent.tv_usec = iHost.sentTS_usec;
		recv.tv_sec=iHost.recvTS_sec;
		recv.tv_usec=iHost.recvTS_usec;

		u_int32_t rtp_time = net2host(rh->rh_ts);

		//int orig_sent = (logical2rtp(sent, scale_, ref_rtp_, ref_tv_sec_, ref_tv_usec_));

		if ((rtp_time  - last_sent) > 100000) {  // ???
			timeval new_log_sent = (rtp2logical(rtp_time, new_scale_, ref_rtp_, ref_tv_sec_, ref_tv_usec_));
			double recv_log = iHost.recvTS_sec + iHost.recvTS_usec/1000000.0;
			double sent_log = new_log_sent.tv_sec + new_log_sent.tv_usec/1000000.0;
			adjust = (recv_log - sent_log) * scale_;
			rtptime = (u_int32_t) ((int)rtp_time + (int)adjust);

			new_sent = rtp2logical(rtptime, new_scale_, ref_rtp_, ref_tv_sec_, ref_tv_usec_);

		}
		else {

			rtptime= (u_int32_t) ((int)rtp_time + (int)adjust);
			new_sent = rtp2logical(rtptime, new_scale_, ref_rtp_, ref_tv_sec_, ref_tv_usec_);

		}





		datapoint = odfile->Tell();

		iHost.sentTS_sec = new_sent.tv_sec;
		iHost.sentTS_usec = new_sent.tv_usec;


		iHost.filePointer = datapoint;

		host2net(iHost,iNet);

		if (oifile->Write(&iNet) < 0) {
			MTrace(trcArchive, ("Error writing to index file"));
			return FALSE;
		}



		newhdr.len = host2net(len);
		newhdr.type = rech.type;
		newhdr.d2 = rech.d2;

		if (odfile->Write((u_char *)&newhdr, sizeof(recordhdr)) < 0) {
			MTrace(trcArchive, ("Error writing pkt header to data file"));
			return TCL_ERROR;
		}


		//printf("old ts= %u new=%u adjust=%g %u %u %u %u\n", net2host(rh->rh_ts), rtptime, adjust, new_sent.tv_sec, new_sent.tv_usec,sent.tv_sec, sent.tv_usec );

		last_sent = net2host(rh->rh_ts);
		rh->rh_ts = host2net(rtptime);

		if (odfile->Write(pb->buf->data, len) < 0) {
			MTrace(trcArchive, ("Error writing packet to data file"));
			return FALSE;
		}

		datapoint = odfile->Tell();

	}



	fflush(0);

	return TCL_OK;
}
