/*
 * controller.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1991-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/audio/controller.h,v 1.18 2002/02/03 03:10:46 lim Exp $
 */

#ifndef mash_controller_h
#define mash_controller_h

class Audio;
class Site;
class SiteBox;
class SampleStream;
class Transducer;
class PCM_Encoder;

#include "observe.h"
#include "audio.h"
#include "timer.h"
#include "inet.h"
#include "tclcl.h"
#include "media-timer.h"

#define TALK_LEAD (4)		// number of audio frames sent before a
				// silence-to-talk transition
#define TALK_TAIL (32)		// number of audio frames sent after a
				// talk-to-silence transition

class Controller : public TclObject, public Observer, public MediaTimer,
			public AudioHandler, public Timer {
public:
	Controller();
	virtual void update(Observable*);
	int active() const;
	void mix_from_net(int del, const u_int8_t* frame, int len);
	virtual int command(int argc, const char*const* argv);
	inline int maxdel() const { return (as_->MaxSamp()); }
	u_int32_t media_ts();
	u_int32_t ref_ts();
    protected:
	virtual void timeout();
	virtual void audio_handle();
	void Activate();
	void DoAudio();
	void DoTimer();
	void mixaudio(SampleStream& ss);
	int sending() const;
	int Output();
	void send_block(u_int32_t ts, u_int8_t* blk, int len);

	int frame_time;	/* the time it takes to play/record one frame of audio */

        Audio* audio_; /* the actual audio device */

	SampleStream* as_;	/* audio stream to/from local device */
	SampleStream* ns_;	/* audio stream to/from network */

	u_int lastnetout_;	/* timestamp of last block of audio sent to network */
	u_int lastaudout_;	/* timestamp of last block of audio sent to sound card */
	u_int timer_interval_;	
	u_long tsec_, tusec_;	

	int ostate_;

	int loopback_;		/* true to loopback samples in software */
	int test_tone_;		/* true to play test tone (and which) */

	Transducer* pmeter_;	/* playback meter */
	Transducer* rmeter_;	/* record meter */

	int talk_thresh_;	/* threshhold at which you cross from speech to silence */
	int echo_thresh_;
	int max_playout_; 
	u_int echo_suppress_time_; /* max time that a sound can still be considered an echo */
	int meter_update_;	/* interval at which we update the meters */
	int active_;		/* set to 1 whenever audio or net written */

	u_int32_t last_mts_;	/* media timestamp of last block sent */
	timeval last_uts_;	/* unix timestamp associated with last_mts */

	/* FIXME eventually want to handle other types of encoders */
	PCM_Encoder* encoder_;

	/*
	 * Output buffering state needed to coalesce several sample
	 * blocks from the audio hardware into a single chunk to
	 * be handed to the encoder.
	 */
	int outmax_;		/* size of chunk handed to encoder */
	int outlen_;		/* current size of chunk being built */
	u_int32_t out_ts_;	/* timestamp of head of current chunk */
	u_int8_t* out_;		/* pointer to chunk is sample-stream */
	u_int8_t overflow_[1024]; /* bounce buffer in case chunk wraps */
	int audio_sps; 		/* samples per second */
};

inline int Controller::sending() const
{
	return (ostate_ < TALK_TAIL+TALK_LEAD || out_);
}

inline int Controller::active() const
{
	return (audio_->haveaudio());
}

#endif
