class H263Encoder : public EncoderModule {
 public:
  H263Encoder();
  ~H263Encoder();
  void setq(int q);
  void size(int w, int h);
  void recv(Buffer* bp);
  virtual int encode(const VideoFrame*);
  virtual int encodeframe(int rate, int codingTime, int t, int gfid,
			   Picture *pict, Picture *decPict, Bitstr *bs,
			  int *mbInd, int *mbQuant, MVField *mvField);
  virtual int command(int argc,const char *const *argv);
 protected:
  Picture oldpic_;	/* previous coded frame */
  Picture oldorigpic_;	/* previous original frame */
  Picture decpict_;	/* current decoded frame */
  Bitstr bitstr_;	/* bitstream */
  MVField mvfield_;	/* MotionVectorfield */
  int *mbind_;	/* MacroBlock startindizes */
  int *mbquant_;	/* MacroBlock Quantiser */
  u_int maxrate_;	/* maximum bitrate per frame */
  u_int lastw_,lasth_;	/* last imagesize of frame */
  u_int nexttype_;	/* next frametype */
  int maycheck_;	/* nr of frames since last timecheck */
  int codingtime_;	/* current codingtime */
  int q_;		/* current quantiser */
  int last_iframe;      /* ts value for the last I frame */
};

/*  H263EncoderMatcher, creates H263Encoder on request by Tcl */
static class H263EncoderClass : public TclClass {
public:
  H263EncoderClass() : TclClass("Module/VideoEncoder/Pixel/H263") {}
  TclObject* create(int, const char*const*) {
    return (new H263Encoder);
  }
} h263_encoder_class;
