#include "h263+coder.h"

struct ENCODER_STATE * h263_init_encoder() {
  struct ENCODER_STATE *s;

  s = malloc(sizeof(struct ENCODER_STATE));
  memset(s, 0, sizeof(struct ENCODER_STATE));

  s->pic = (Pict *) malloc(sizeof(Pict));

  s->pic->source_format = 2;
  s->pic->PB = 0;
  s->pic->TR = 0;

  data = (MB_Structure *)malloc(sizeof(MB_Structure));
  
  return s;
}

void h263_cleanup(struct ENCODER_STATE *s) {
  free(s->pic);
  free(s->curr_recon);
  free(s->prev_recon);
  free(s);
  free(data);
}


void FillLumBlock( int x, int y, PictImage *image, MB_Structure *data)
{
  int n;
  register int m;

  for (n = 0; n < MB_SIZE; n++)
    for (m = 0; m < MB_SIZE; m++)
      data->lum[n][m] = 
        (int)(*(image->lum + x+m + (y+n)*pels));
  return;
}

void FillChromBlock(int x_curr, int y_curr, PictImage *image,
            MB_Structure *data)
{
  int n;
  register int m;

  int x, y;

  x = x_curr>>1;
  y = y_curr>>1;

  for (n = 0; n < (MB_SIZE>>1); n++)
    for (m = 0; m < (MB_SIZE>>1); m++) {
      data->Cr[n][m] = 
        (int)(*(image->Cr +x+m + (y+n)*cpels));
      data->Cb[n][m] = 
        (int)(*(image->Cb +x+m + (y+n)*cpels));
    }
  return;
}


void CodeOneIntra(PictImage *curr, Pict *pic) {
  int i, j, k;

  for ( j = 0; j < lines/MB_SIZE; j++) {
    for ( i = 0; i < pels/MB_SIZE; i++) {
      FillLumBlock(i*MB_SIZE, j*MB_SIZE, curr, data);
      FillChromBlock(i*MB_SIZE, j*MB_SIZE, curr, data);
      coeff = MB_Encode(data);


void h263_encode_one_frame(struct ENCODER_STATE *s, int i, int tr) {
  if (i == 0) {
    /* Intra */
    s->pic->picture_coding_type = 0;
  }

  s->pic->TR = tr;

  CodeOneIntra(s->curr_image, s->pic);

}

PictImage *
 InitImage (int size)
{
  PictImage *new;

  if ((new = (PictImage *) malloc (sizeof (PictImage))) == NULL)
  {
    fprintf (stderr, "Couldn't allocate (PictImage *)\n");
    exit (-1);
  }
  if ((new->lum = (unsigned char *) malloc (sizeof (char) * size)) == NULL)
  {
    fprintf (stderr, "Couldn't allocate memory for luminance\n");
    exit (-1);
  }
  if ((new->Cr = (unsigned char *) malloc (sizeof (char) * size / 4)) == NULL)
  {
    fprintf (stderr, "Couldn't allocate memory for Cr\n");
    exit (-1);
  }
  if ((new->Cb = (unsigned char *) malloc (sizeof (char) * size / 4)) == NULL)
  {
    fprintf (stderr, "Couldn't allocate memory for Cb\n");
    exit (-1);
  }
  return (new);
}
