/*
 * fca-mgr.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * fca-mgr.cc   -- Helen J. Wang
 * Edited by Yatin Chawathe:  04/29/97
 */

#include "fc.h"
#include "fca-mgr.h"
#include "fca-pkt.h"
#include tclcl.h>



static class FCAMgrClass : public TclClass {
public:
    FCAMgrClass() : TclClass("SRMAppMgr/FCA") {
        //printf("Created FCAMgr class: %s\n", classname_);
    }
    TclObject* create (int /*argc*/, const char*const* /*argv*/) {
	return (new FCAMgr());
    }
} fcamgr;



FCARcvr *
FCAMgr::DefineRcvr(const srm_src &sid, int islocal)
{
    Tcl::instance().evalf("%s define_rcvr %s %d", this->name(), (char*)sid,
			  islocal);
//    Debug(dbgFCA, ("define_rcvr: %s", Tcl::instance().result()));
    return ((FCARcvr*) TclObject::lookup(Tcl::instance().result()));
}


SRM_PacketHandler *
FCAMgr::new_source(const srm_src &sid, int islocal)
{
    return DefineRcvr(sid, islocal);
}


void
FCAMgr::handle_request(const srm_src &sid, u_char *pb, int len)
{
    Debug(dbgFCA, ("\nFCAMgr::handle_request: len = %d, %x@%x\n",
		   len, sid.ss_uid, sid.ss_addr));

    FCARcvr *pRcvr = DefineRcvr(sid, 0);
    if (pRcvr==NULL) {
      Debug(dbgFCA, ("handle_request, cannot get a receiver"));
      return;
    }
    FCA_Packet *pkt = FCA_Packet::New();
    if (pkt->Extract(pb, len)==FALSE) {
      Debug(dbgFCA, ("handle_request, cannot extract the packet"));
      FCA_Packet::Delete(pkt);
      return;
    }
    Debug(dbgFCA, ("FCAMgr::handle_request, rcvrObj = %s", pRcvr->name()));
    Tcl::instance().evalf("%s handle_request %s", pRcvr->name(), pkt->name());
    FCA_Packet::Delete(pkt);
    Debug(dbgFCA, ("after calling Otcl handle_request"));
}


void
FCAMgr::handle_reply(const srm_src &sid, u_char *pb, int len)
{
    Debug(dbgFCA, ("FCAMgr::handle_reply: len = %d, %x@%x", len,
		   sid.ss_uid, sid.ss_addr));

    FCARcvr *pRcvr = DefineRcvr(sid, 0);
    Debug(dbgFCA, ("FCAMgr::handle_reply, after getting rcvr"));
    if (pRcvr==NULL) {
      Debug(dbgFCA, ("FCAMgr::handle_reply: no rcvr can be found."));
      return;
    }
    Debug(dbgFCA, ("FCAMgr::handle_reply, right before extracting reply"));
    FCA_Packet *pkt = FCA_Packet::New();
    if (pkt->Extract(pb, len)==FALSE) {
      Debug (dbgFCA,
	     ("FCAMgr::handle_reply, unable to extract the repair reply"));
      FCA_Packet::Delete(pkt);
      return;
    }
    Debug(dbgFCA, ("Before calling OTcl handle_reply"));
    Tcl::instance().evalf("%s handle_reply %s", pRcvr->name(), pkt->name());
    Debug(dbgFCA, ("After calling OTcl handle_reply"));
    FCA_Packet::Delete(pkt);
}


void
FCAMgr::handle_SA(const srm_src &sid, u_char *pb, int len)
{
    Debug(dbgFCA, ("FCAMgr::handle_SA: len = %d", len));

    FCARcvr *pRcvr = DefineRcvr(sid, 0);
    if (pRcvr==NULL) {
      Debug(dbgFCA, ("FCAMgr::handle_SA: canNOT find a receiver to handle SA"));
      return;
    }
    FCA_Packet *pkt = FCA_Packet::New();
    if (pkt->Extract(pb, len)==FALSE) {
      FCA_Packet::Delete(pkt);
      return;
    }
    Tcl::instance().evalf("%s handle_SA %s", pRcvr->name(), pkt->name());
    FCA_Packet::Delete(pkt);
}


int
FCAMgr::periodic_update(u_char *pb)
{
    int len = SRM_MTU;
    //Debug(dbgFCA, ("FCAMgr::periodic_update: len = %d", len));

    SRM_PacketHandler *local =
	pSession_->source_manager()->first_local_source()->handler();
    if (local==NULL) {
	Debug(dbgFCA, ("No local source defined for FCAMgr"));
	return 0;
    }
    FCA_Packet *pkt = FCA_Packet::New();
    Tcl::instance().evalf("%s create_sa %s", local->name(), pkt->name());
    if (pkt->Packetize(pb, len)==FALSE) {
      FCA_Packet::Delete(pkt);
      return 0;
    }
    FCA_Packet::Delete(pkt);
    //Debug(dbgFCA, ("periodic_update contains %d bytes", len));
    return len;
}


int
FCAMgr::next_ADU(u_char *pb, int len, srm_src &/*id*/, int &/*pkt_type*/,
		 int &next)
{
    Debug(dbgFCA, ("FCAMgr::next_ADU: len = %d", len));

    SRM_PacketHandler *local =
	pSession_->source_manager()->first_local_source()->handler();
    if (local==NULL) {
	Debug(dbgFCA, ("No local source defined for FCAMgr"));
	return 0;
    }
    Tcl::instance().evalf("%s next_ADU", local->name());

    char *result = Tcl::instance().result();
    if (strcmp(result, "")==0) return 0;

    FCA_Packet *pkt = (FCA_Packet*) Tcl::instance().lookup(result);
    if (pkt->Packetize(pb, len)==FALSE) {
      FCA_Packet::Delete(pkt);
      return 0;
    }
    FCA_Packet::Delete(pkt);	// I am supposed to delete the packet, although
				// it was created by Tcl
    Debug(dbgFCA, ("next_ADU contains %d bytes:", len));
    static char buffer[10000];
    *buffer = '\0';
    for (int i=0; i<len; i++) {
	sprintf(buffer, "%s%02x ", buffer, pb[i]);
    }
    Debug(dbgFCA, ("%s", buffer));

    Tcl::instance().evalf("%s more_ADU", local->name());
    int more = atoi(Tcl::instance().result());
    if (more!=0) next = 1;
    return len;
}


int
FCAMgr::command(int argc, const char*const* argv)
{
    if (argc==3) {
	if (!strcmp(argv[1], "attach_session")) {
	    pSession_ = (SRM_Session*)TclObject::lookup(argv[2]);
	    if (!pSession_) {
		Tcl::instance().
		    result("FCAMgr::command, Couldn't find session");
		return TCL_ERROR;
	    }
	    return TCL_OK;
	}
	if (!strcmp(argv[1], "request_send")) {
	    //FCA_Packet *pkt = (FCA_Packet*)TclObject::lookup(argv[2]);
	    // ignore the packet for now; jsut call begin_xmit with a large
	    // value
	    pSession_->begin_xmit(SRM_MTU);
	    return TCL_OK;
	}
    }
    if (!strcmp(argv[1], "sched_request")) {
      Debug (dbgFCA, ("handing sched_request\n"));
      SrcId sid;
      char* rqtclobj = (char*) argv[2];
      sid = argv[3];
      Debug (dbgFCA, ("sched_request, rqtclobj = %s", rqtclobj));
      FCARepairRequest *rqst =
	(FCARepairRequest* ) TclObject::lookup(rqtclobj);
      if (!rqst) {
	Tcl::instance().result("C++ rqst obj doesn't exist");
	Debug (dbgFCA, ("sched_request, rqst obj not found\n"));
	return TCL_ERROR;
      }
      Debug (dbgFCA, ("sched_request, about to schedule the repair request\n"));
      this->sched_request (rqst, sid);
      return TCL_OK;
    }

    if (!strcmp(argv[1], "sched_reply")) {
      Debug (dbgFCA, ("handing sched_reply\n"));
      SrcId sid;
      char* rpytclobj = (char*) argv[2];
      sid = argv[3];
      Debug (dbgFCA, ("sched_reply, replytclobj = %s", rpytclobj));
      FCARepairReply *reply =
	(FCARepairReply* ) TclObject::lookup(rpytclobj);
      if (!reply) {
	Tcl::instance().result("C++ reply obj doesn't exist");
	Debug (dbgFCA, ("sched_reply, reply obj not found\n"));
	return TCL_ERROR;
      }
      Debug (dbgFCA, ("sched_reply, about to schedule the repair reply\n"));
      this->sched_reply (reply, sid);
      return TCL_OK;
    }

    return SRM_AppMgr::command(argc, argv);
}





#if OLD

SrcId FCAMgr::getSrcId () {
    SrcId sid;
    sid.ss_uid = getuid();
    sid.ss_addr = LookupLocalAddr();
    return sid;
}

/* ignore pu_mod */
#DEFINE FLSTLEN 2   /* level 1 split */
#DEFINE FLEN 5      /* level 2 split */
#DEFINE HLDRLEN 2   /* level 3 split */
#DEFINE RQLEN 3     /* level 3 split */
/*
  { numfls { {f1} {f2} ..} }
  {f1} = { fid numhldrs { {h1} {h2} ... } numrqs { {rq1} {rq2} }}
  {h1} = { uid addr }
  {rq1} = { uid addr cmt }
*/
/* fill in moderator periodic update */
/* <--: indicates packet filling activities */
int FCAMgr::pu_mod (u_char *buf) {
    int returnval = 0;
    Tcl& interp = Tcl::instance():
	Tcl::instance().evalf ("%s pu_flstatus");
    char* list = interp.result();
#ifdef FCDBG
    fprintf (stderr, "FCAMgr::pu_mod: flstat list = %s \n", list);
#endif
    Pkt_SA_2 *psa2 = new Pkt_SA_2;
    /* level 1 split -- original list */
    int cnt1;       /* number of items in the list */
    char** elts1;   /* list elements */
    Tcl_SplitList (interp, list, &cnt1, &elts1);
    if (cnt1 != FLSTLEN)
	fprintf (stderr,
		 "FCAMgr::pu_mod: list length mismatch at L1 split, cntr1 (%d)\n",
		 cnt1);
    Pkt_SA_1 *ps = (Pkt_SA_1 *) buf;         /* <-- */
    u_int32_t numFls = strtoul(elts[0]);
    ps->ps_numFls = host2net(numFls);        /* <-- */

    /* level 2 split -- floor list */
    int flcnt;
    char** fllist;
    Tcl_SplitList (interp, elts1[1], &flcnt, &fllist);
    if (flcnt != numFls)
	fprintf (stderr, "FCAMgr::pu_mod, actual flcnt (%d) != numfls (%d) \n",
		 flcnt, numFls);

    buf += sizeof (u_int32_t);              /* <-- */
    for (int i=0; i<flcnt; i++) {
	/* for each floor list */
	int numflfields;
	char** flfields;
	Tcl_SplitList(interp, fllist[i], &numflfields, &flfields);
	if (numflfields != FLEN)
	    fprintf (stderr, "FCAMgr::pu_mod, wrong syntax from OTcl side\n");

	Byte fid= atoi(flfields[0]);
	(ps->aFlStatus[i]).ph_fid = fid;                 /* <-- */
	(psa2->aFlRqs[i]).pf_fid = fid;                  /* <-- */
	Byte numhldrs = atoi(fllist[1]);
	(ps->aFlStatus[i]).ph_numHolders = numhldrs;     /* <-- */
	int holdercnt;
	char** holderlist;
	Tcl_SplitList(interp, flfields[2], &holdercnt, &holderlist);
	if (holdercnt != numhldrs )
	    fprintf (stderr,
		     "FCAMgr::pu_mod, mismatch btwn actual holdercnt(%d) & numhldrs(%d) \n", holdercnt, numhldrs);

	buf += sizeof (Pkt_FlStatus) - sizeof (SrcId);
	for (int j=0; j<holdercnt; j++) {
	    /* level 3 split -- split each holder */
	    int numhldrfields;
	    char** holder;
	    Tcl_SplitList (interp, holderlist[j], &numhldrfields, &holder);
	    if (numhldrfields != 2)
		fprintf (stderr,
			 "FCAMgr::pu_mod, holder contains %d fields instead of 2 (uid, addr)\n", numhldrfields);
	    SrcId sid;
	    unsigned long sid.ss_uid = strtoul(holder[0]);
	    unsigned long sid.ss_addr = strtoul(holder[1]);
	    host2net(sid, (ps->aFlStatus[i]).pf_holderids[j]);  /* <-- */
	    buf += sizeof(SrcId);
	}

	u_int16_t numrqs = atoi(flfields[3]);
	(psa2->aFlRqs[i]).pf_numRqsts = host2net(numrqs);     /* <-- */
	int psa2size = sizeof (Pkt_FlRqs) - sizeof (SrcId);
	int rqcnt;
	char** rqlist;
	Tcl_SplitList(interp, flfields[4], &rqcnt, &rqlist);
	if (rqcnt != numrqs )
	    fprintf (stderr,
		     "FCAMgr::pu_mod, mismatch btwn actual rqcnt(%d) & numrqs(%d) \n", rqcnt, numrqs);
	for (int j=0; j<rqcnt; j++) {
	    /* level 3 split -- split each rqholder */
	    int numrqhldrfields;
	    char** rqholder;
	    Tcl_SplitList (interp, rqlist[j], &numrqhldrfields, &rqholder);
	    if (numrqhldrfields != 2)
		fprintf (stderr,
			 "FCAMgr::pu_mod, holder contains %d fields instead of 2 (uid, addr)\n", numhldrfields);
	    SrcId sid;
	    unsigned long sid.ss_uid = strtoul(rqholder[0]);
	    unsigned long sid.ss_addr = strtoul(rqholder[1]);
	    host2net(sid, (psa2->aFlRqs[i]).pf_rqsids[j]);  /* <-- */
	    psa2size += sizeof(SrcId);
	}
    }
    memcpy (buf, psa2, psa2size);       /* <-- */
}

/* fill in participant periodic update */
/*
  int FCAMgr::pu_part (u_char *buf) {
  int returnlen = 0;
  Pkt_PSA *pp = (Pkt_PSA *) buf;
  SrcId sid = this->getSrcId ();
  host2net (sid, pp->prs_sid);
  Tcl::instance().evalf("%s pu_topSeq", this->name);
  unsigned long topseq = strtoul(Tcl::instance().result());
  pp->prs_maxSn = host2net (topseq);
  return (returnlen = sizeof (Pkt_PSA));
  }
  */
/* send out a periodicUpdate for SRM */
int FCAMgr::periodicUpdate(u_char *buf) {

    Pkt_Hdr *ph = (Pkt_Hdr *) buf;
    SrcId sid = this->getSrcId();
    n_long ts = this->CurrTime();
    host2net (sid, ph->srcid);
    ph->ph_ts = host2net(ts);
    ph->ph_version = host2net(0.1);

    Pkt_SA *ps = (Pkt_SA *) (buf + sizeof(Pkt_Hdr));
    Tcl::instance().evalf("%s pu_topSeq", this->name);
    unsigned long topseq = strtoul(Tcl::instance().result());
    /*
      Tcl::instance().evalf("%s pu_topGrantSeq", this->name);
      unsigned long topGrantSeq = strtoul(Tcl::instance().result());
      */
    Tcl::instance().evalf("%s pu_rqQsize", this->name);
    unsigned long rqQsize = strtoul(Tcl::instance().result());
#ifdef FCDBG
    fprintf (stderr, "FCAMgr::PeriodicUpdate, topseq (%lu), topgrantseq (%lu), rqQsize(%lu) \n", topseq, topGrantSeq, rqQsize);
#endif
    ps->topSeq = host2net (topseq);
    /*  ps->topGrantSeq = host2net (topGrantSeq); */
    ps->rqQsize = host2net (rqQsize);

}

int FCAMgr::command(int argc, const char*const* argv)
{
    if (!strcmp(argv[1], "local_uid"))
	Tcl::instance().resultf("%x", getuid());

    if (!strcmp(argv[1], "local_addr")) {
	Tcl::instance().resultf("%x", LookupLocalAddr());
    }

    if (!strcmp(argv[1],"attach_session")) {
	SRM_Session* pSession = (SRM_Session*)TclObject::lookup(argv[2]);
	if (!pSession) {
	    Tcl::instance().result("FCAMgr::command, Couldn't find session");
	    return TCL_ERROR;
	}
	SetSession(pSession);
    }

    if (!strcmp(argv[1], "sched_request")) {
      Debug (dbgFCA, ("handing sched_request\n"));
      SrcId sid;
      sid = argv[2];
      char* rqtclobj = argv[3];
      FCARepairRequest *rqst =
	(FCARepairRequest* ) TclObject::lookup(rqtclobj);
      if (!rqst) {
	Tcl::instance.resultf("C++ rqst obj doesn't exist");
	Debug (dbgFCA, ("sched_request, rqst obj not found\n"));
      }
	Debug (dbgFCA, ("sched_request, about to schedule the repair request\n"));
	this->sched_request (rqst, sid);
    }

    if (!strcmp(argv[1], "sched_reply")) {
	if (argc != 5)
	    Tcl::instance.resultf ("syntax error: $mgr sched_reply $uid $addr $rpy");
	SrcId sid;
	sid.ss_uid = strtoul (argv[2]);
	sid.ss_addr = strtoul (argv[3]);
	char* rpytclobj = argv[4];
	FCARqst *rpy = (FCAReply* ) TclObject::lookup(rpytclobj);
	if (!rpy) {
	    Tcl::instance.resultf("C++ rqst obj doesn't exist");
	    fprintf (stderr, "FCAMgr::command - sched_reply, rpy obj not found\n");
	}
	this->sched_reply (rqst, sid);
    }

    return TCL_OK;
}

#endif
