/*
 * fca-rreq.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * fca-rreq.h  -- Helen J. Wang
 */

#ifndef mash_fca_rreq_h
#define mash_fca_rreq_h

#include "fc.h"
#include "srm/session-srm.h"
#include "fca-pkt.h"
#include <tclcl.h>

class FCARepairReply;

class FCARepairRequest : public SRM_Request, public FCA_Packet {
public:
  FCARepairRequest() {}
  virtual ~FCARepairRequest() {}
  virtual int fill_ADU() {
    /* REVIEW: get the len right! */
    return fill_ADU(pb_->data+sizeof(srmhdr), SRM_MTU);
  }
  int fill_ADU(Byte* pb, int len);
  int command(int argc, const char*const* argv);
};


class FCARepairReply : public SRM_Reply, public FCA_Packet {
public:
  FCARepairReply() {};
  virtual ~FCARepairReply() {};
  /* REVIEW: get the len right! */
  virtual int fill_ADU() {
    return fill_ADU(pb_->data+sizeof(srmhdr), SRM_MTU);
  }
  /* fills as much as possible, shrunk itself after that */
  int fill_ADU(Byte* pb, int len);
  int command(int argc, const char*const* argv);
};


#endif /* #ifndef mash_fca_rreq_h */
