/*
 * edge-detect.cc --
 *
 *      An edge detection effect
 *
 * Copyright (c) 1993-2001 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

/* @(#) $Header: /usr/mash/src/repository/mash/mash-1/fx/effects/edge-detect.cc,v 1.1 2002/02/07 04:18:19 chema Exp $ */


#include <dvmbasic.h>
#include <dvmvision.h>

#include "edge-detect.h"



EdgeDetectEffect::EdgeDetectEffect(int decimation) 
	: EffectModule(1, decimation)
{
	// create the temporal frame
	temp_ = new Uncompressed;

	return;
}



int EdgeDetectEffect::command(int argc, const char*const* argv)
{
	return (EffectModule::command(argc, argv));
}



void EdgeDetectEffect::trigger_effect (Uncompressed* input)
{
	//printf ("w(%dx%d) ", input->w_, input->h_); fflush (stdout); // XXX

	// temp_ has to be the same size than the input
	if (!temp_->samesize(input)) {
		temp_->init (input, csss_, VIDREP_ALLOC_MEMORY);
	}

	// step 1: temp luma = smooth (input luma)
	ByteImage *in_l = input->lum_;
	ByteImage *temp_l = temp_->lum_;
	ByteSmooth(in_l, temp_l, 2);

	// step 2: output luma = Canny Edge Detection Algorithm (temp luma)
	ByteImage *out_l = output_->lum_;
	ByteEdgeDetectCanny(temp_l, out_l, 5, 10);

	// step 3: output chromas = 0x80
	ByteImage *out_cr = output_->cr_;
	ByteSet (out_cr, 128);
	ByteImage *out_cb = output_->cb_;
	ByteSet (out_cb, 128);

	// deliver the output frame
	deliver_frame();

	return;
}

