/*
 * mash-run.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1999-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <tcl.h>
#include "mash-event.h"
#ifdef __PSVP_ENABLED__
#   include "vidreps.h"
#endif

/*
 * This is a version of "vwait forever" that handle Mash/Degas Events.
 * Based on Tcl_VwaitCmd in tclEvent.c
 */

int Mash_DoOneEvent();

#define TCL_WFT_EVENTS TCL_WINDOW_EVENTS | TCL_FILE_EVENTS | TCL_TIMER_EVENTS

int
Mash_RunCmd (ClientData cd, Tcl_Interp *interp, int argc, char *argv[])
{
    int foundEvent;

    if (argc != 1) {
        Tcl_AppendResult(interp, "wrong # args: should be \"",argv[0], " \"",
            (char *)NULL);
        return TCL_ERROR;
    }
    foundEvent = 0;
    while (1) {
	if (!foundEvent) {
	    Tcl_DoOneEvent ( TCL_ALL_EVENTS );
	} else {
	    Tcl_DoOneEvent ( TCL_WFT_EVENTS | TCL_DONT_WAIT);
	}
	foundEvent = Mash_DoOneEvent();
    }
    return TCL_OK;
}

int
Mash_DoOneEvent()
{
    Mash_QueueEvent *event;
    event = Mash_RemoveFromEventQueue ();
    if (event) {
#ifdef __PSVP_ENABLED__
	fprintf(stderr, "%s\n", ((Uncompressed *)(event->buffer))->source_id_);
        (event->obj)->recv(event->buffer);
#endif
	return 1;
    } else {
	return 0;
    }
}
