/*
 * array.h --
 *
 *      Dynamic array
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * $Header: /usr/mash/src/repository/mash/mash-1/mb/array.h,v 1.5 2002/02/03 03:16:30 lim Exp $
 */

#ifndef ARRAY_H
#define ARRAY_H

//
// generic dynamic array of T items
//     grow if accessed pass the limit
//     all unassigned elements are set to NULL
// Note: all elemen
//
template<class T>
class MBArray {
public:
    MBArray(int stepSize) : step_size_(stepSize) {
        pT_=new T[step_size_];
        memset((char*)pT_, 0, sizeof(T)*step_size_ );
        array_size_ = step_size_;
    }
    ~MBArray() {
        delete[] pT_;
    }

    T& operator[](ulong index) {
        if (index >= array_size_)
            Grow(index);
        return pT_[index];
    }

    void Grow(ulong index) {
        while (array_size_ + step_size_ <= index) {
            step_size_ <<= 1;
        }
        T* pNewT = new T[step_size_ + array_size_];
        memcpy(pNewT, pT_, array_size_*sizeof(T));
        memset((char*)(pNewT+array_size_),
               0, (step_size_)*sizeof(T));
#ifdef MB_DEBUG
        for (ulong i=array_size_; i<array_size_+step_size_; i++) {
            assert(pNewT[i]==NULL);
        }
#endif
        delete[] pT_ ;
        pT_ = pNewT;
        array_size_ += step_size_;
        if (step_size_ <= array_size_) {
            step_size_ <<= 1;               // double the increase for next time
        }
    }
    ulong GetSize() { return array_size_; }

private:
    ulong step_size_;
    ulong array_size_;
    T *pT_;
};


#endif /* #ifdef ARRAY_H */
