/*
 * linkedlist.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __LINKEDLIST_H__
#define __LINKEDLIST_H__

#include "misc/all-types.h"
typedef void *ListIndex;


template <class T>
class List {

public:
	List() : head(NULL), tail(NULL), count(0) { };
	~List() { RemoveAll(); };

	Bool IsEmpty() {
		return ((head==NULL) && (tail==NULL)) ? TRUE:FALSE;
	}
	int getSize() {
		int returnValue;
		returnValue = count;
		return returnValue;
	};


	ListIndex getFirst() const;
	ListIndex getLast () const;
	ListIndex getNext (ListIndex idx) const;
	ListIndex getPrev (ListIndex idx) const;
	T*        getData (ListIndex idx) const;
	Bool      IsDone  (ListIndex idx) const;
	Bool      InsertAfter(ListIndex idx, T *data);
	Bool      InsertBefore(ListIndex idx, T *data);
	void      Remove(ListIndex idx);
	void      RoundRobin();

	/* insertion and removal functions */
	Bool InsertAtHead(T *data) {
		return InsertAfter_WithNULL(NULL, data);
	}
	Bool InsertAtTail(T *data) {
		return InsertAfter_WithNULL( (ListIndex) tail, data);
	}
	T*   RemoveFromHead();
	T*   RemoveFromTail();
	void Remove(T *data);
	T*   PeekAtHead() const {
		return ((head==NULL) ? ((T*)NULL) : head->data);
	}
	T*   PeekAtTail() const {
		return ((tail==NULL) ? ((T*)NULL) : tail->data);
	}

protected:
	Bool InsertAfter_WithNULL(ListIndex idx, T *data);
	void Remove_(ListIndex idx);
	void RemoveAll();

	struct ListNode {
		ListNode(T *d=NULL, ListNode *n=NULL, ListNode *p=NULL)
			: data(d), next(n), prev(p) { };
		T        *data;
		ListNode *next;
		ListNode *prev;
	};

private:
	ListNode *head;
	ListNode *tail;
	int      count;
};


template <class T>
ListIndex
List<T>::getFirst() const
{
	return head;
}


template <class T>
ListIndex
List<T>::getLast() const
{
	return tail;
}


template <class T>
ListIndex
List<T>::getNext(ListIndex idx) const
{
	if (idx==NULL) return NULL;
	else return ((ListNode*)idx)->next;
}


template <class T>
ListIndex
List<T>::getPrev(ListIndex idx) const
{
	if (idx==NULL) return NULL;
	else return ((ListNode*)idx)->prev;
}


template <class T>
T*
List<T>::getData(ListIndex idx) const
{
	if (idx==NULL) return NULL;
	else return ((ListNode*)idx)->data;
}


template <class T>
Bool
List<T>::IsDone(ListIndex idx) const
{
	return ((idx==NULL) ? TRUE:FALSE);
}


template <class T>
Bool
List<T>::InsertAfter(ListIndex idx, T *data)
{
	if (idx==NULL) return FALSE;
	return InsertAfter_WithNULL(idx, data);
}


template <class T>
Bool
List<T>::InsertBefore(ListIndex idx, T *data)
{
	if (idx==NULL) return FALSE;
	return InsertAfter_WithNULL(getPrev(idx), data);
}


template <class T>
void
List<T>::Remove(ListIndex idx)
{
	if (idx!=NULL) Remove_(idx);
}


template <class T>
T*
List<T>::RemoveFromHead()
{
	T *data;
	if (head==NULL) return NULL;
	else {
		data = head->data;
		Remove_((ListIndex)head);
		return data;
	}
}


template <class T>
T*
List<T>::RemoveFromTail()
{
	T *data;
	if (tail==NULL) return NULL;
	else {
		data = tail->data;
		Remove_((ListIndex)tail);
		return data;
	}
}


template <class T>
void
List<T>::Remove(T *data)
{
	ListNode *node;

	for (node=head; node!=NULL; node=node->next) {
		if (node->data==data) {
			Remove_((ListIndex)node);
			break;
		}
	}
}


template <class T>
Bool
List<T>::InsertAfter_WithNULL(ListIndex idx, T *data)
{
	ListNode *node = (ListNode *) idx;
	ListNode *newNode = new ListNode(data);
	if (newNode==NULL) return FALSE;

	if (node==NULL) {
		newNode->next = head;
		if (head!=NULL) head->prev = newNode;
		head = newNode;

		if (tail==NULL) tail = newNode;
	}
	else {
		ListNode *nextNode = node->next;
		// must add newNode between node and nextNode!

		node   ->next = newNode;
		newNode->next = nextNode;
		newNode->prev = node;

		if (nextNode==NULL) tail = newNode;
		else nextNode->prev = newNode;
	}

	count++;
	return TRUE;
}


template <class T>
void
List<T>::Remove_(ListIndex idx)
{
	ListNode *node = (ListNode*) idx, *prevNode, *nextNode;

	if (node==NULL || (head==NULL && tail==NULL)) return;

	prevNode = node->prev;
	nextNode = node->next;

	if (prevNode!=NULL) prevNode->next = nextNode;
	else head = nextNode;
	if (nextNode!=NULL) nextNode->prev = prevNode;
	else tail = prevNode;

	delete node;
	count--;
}


template <class T>
void
List<T>::RoundRobin()
{
	if (head==NULL || head==tail) return;
	ListNode *node = head;
	head = head->next;
	head->prev = NULL;
	node->next = NULL;

	tail->next = node;
	node->prev = tail;
	tail = node;
}


template <class T>
void
List<T>::RemoveAll()
{
	while (IsEmpty()==FALSE) RemoveFromHead();
}

#endif // __LINKEDLIST_H__
