/*
 * mplug-compat.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *  @(#) $Header: /usr/mash/src/repository/mash/mash-1/mplug/mplug-compat.h,v 1.10 2002/02/03 04:13:23 lim Exp $
 */

#ifndef MASH_MPLUG_COMPAT_H
#define MASH_MPLUG_COMPAT_H

#include "cc-api/np-os.h"


#if defined(XP_UNIX)

#include <sys/time.h>
#include <unistd.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define MPlug_IsReadable(filename)   (access(filename, R_OK)==0)
#define SOCKET int
#define SOCKET_ERROR -1
#define INVALID_SOCKET -1
#define SOCK_IS_INTR (errno==EINTR)
#define closesocket close

#define DEFAULT_MASH_HOME "/usr/local"
#define DEFAULT_HOME "/"

#elif defined(XP_WIN)

#include <sys/timeb.h>
#include <winsock.h>
#include <io.h>

#define MPlug_IsReadable(filename)   (_access(filename, 04)==0)
#define SOCK_IS_INTR (WSAGetLastError()==WSAEINTR)


#define DEFAULT_MASH_HOME "C:\\Program Files\\mash"
#define DEFAULT_HOME "C:\\"

#else
#error "MPlug can be compiled only under UNIX or Windows"
#endif



char *MPlug_JoinFilename(const char *dir, const char *suffix);
				// returns the joined pathname
				// child is expected to delete the string
				// returned by this function
void MPlug_GetCurrentTime(struct timeval *tp);
void MPlug_Output(const char *format, ...);
void MPlug_Log(const char *format, ...);


#define LOG(x) MPlug_Log x
//#define LOG(x)


#endif /* #ifdef MPLUG_COMPAT_H */
