/*
 * otcl-mplug.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "otcl-mplug.h"


MPlugClient *MPlugClient::instance_=NULL;


DEFINE_OTCL_CLASS(MPlugClient, "MPlugClient")
{
	INSTPROC(dispatch);
	PROC(object);
}


MPlugClient::MPlugClient()
	: mplug_(NULL)
{
	instance_ = this;

	Tcl &tcl = Tcl::instance();
	if (Tcl_Eval(tcl.interp(), "new MPlug")==TCL_OK) {
		mplug_ = tcl.objResult();
		Tcl_IncrRefCount(mplug_);
	}

	bytesExpected_ = 4;
	numElems_ = 0;
	gotElems_ = 0;
	state_ = mpcNumElems;
	buf_ptr_ = buf_;
	objv_ = NULL;
}



MPlugClient::~MPlugClient()
{
	if (mplug_) Tcl_DecrRefCount(mplug_);
}


void
MPlugClient::object(const char *name)
{
	if (mplug_) Tcl_DecrRefCount(mplug_);
	mplug_ = Tcl_NewStringObj((char*)name, -1);
	Tcl_IncrRefCount(mplug_);
}


int
MPlugClient::object(int argc, const char * const *argv)
{
	const char *name;
	BEGIN_PARSE_ARGS(argc, argv);
	ARG_DEFAULT(name, "");
	END_PARSE_ARGS;

	if (name && *name!='\0') instance_->object(name);
	else {
		if (instance_->mplug_)
			Tcl::instance().result(instance_->mplug_);
		else
			Tcl::instance().result("");
	}

	return TCL_OK;
}


#if 0
int
MPlugClient::dispatch(int argc, const char * const *argv)
{
	const char *channelName;
	Tcl_Channel channel;
	Tcl &tcl = Tcl::instance();
	int mode, r;

	BEGIN_PARSE_ARGS(argc, argv);
	ARG(channelName);
	END_PARSE_ARGS;

	channel = Tcl_GetChannel(tcl.interp(), (char*)channelName, &mode);
	if (!channel) {
		// an error occurred;
		// if this happens we can no longer communicate
		// with the plugin, so die
		tcl.eval("MPlug die {Could not find plugin communication "
			 "channel}");
		exit(-1);
	}

	u_int32_t numElems, len;
	int got;
	const int MAX_BUF_SIZE=256;
	char buf[MAX_BUF_SIZE];
	Tcl_Obj **objv;

	if ((r = Tcl_Read(channel, (char*)&numElems, sizeof(u_int32_t)))
	    != sizeof(u_int32_t)) {
		// an error occurred;
		// if this happens we can no longer communicate
		// with the plugin, so die
		tcl.eval("MPlug die {Communication with plugin was cut off}");
		exit(-1);
	}

	objv = new Tcl_Obj* [numElems+1];

	for (int i=0; i < (int)numElems; i++) {
		int r;
		if ((r = Tcl_Read(channel, (char*)&len,
				  sizeof(u_int32_t))) != sizeof(u_int32_t)) {
			// an error occurred;
			// if this happens we can no longer communicate
			// with the plugin, so die
			tcl.eval("MPlug die {Communication with plugin was "
				 "cut off}");
			exit(-1);
		}

		objv[i+1] = Tcl_NewStringObj("", 0);

		while (len > 0) {
			got = Tcl_Read(channel, (char*)buf,
				       (( len < sizeof(buf_))
					? len : sizeof(buf_)));
			if (got <= 0) {
				// an error occurred;
				// if this happens we can no longer communicate
				// with the plugin, so die
				tcl.eval("MPlug die {Communication with plugin"
					 " was cut off}");
				exit(-1);
			}

			Tcl_AppendToObj(objv[i+1], buf, got);
			len -= got;
		}
	}

	// check if we have the mplug_ object yet
	if (mplug_) {
		objv[0] = mplug_;
		Tcl::instance().evalObjs(numElems+1, objv);
	}

	delete [] objv;
	return TCL_OK;
}
#endif


//#define P(s) printf("**** %s\n", s); fflush(stdout);
int
MPlugClient::dispatch(int argc, const char * const *argv)
{
	const char *channelName;
	Tcl_Channel channel;
	Tcl &tcl = Tcl::instance();
	int mode, got;

	BEGIN_PARSE_ARGS(argc, argv);
	ARG(channelName);
	END_PARSE_ARGS;

	channel = Tcl_GetChannel(tcl.interp(), (char*)channelName, &mode);
	if (!channel) {
		// an error occurred;
		// if this happens we can no longer communicate
		// with the plugin, so die
		tcl.eval("MPlug die {Could not find plugin communication "
			 "channel}");
		exit(-1);
	}

	while (bytesExpected_ > 0) {
		if (Tcl_Eof(channel)) {
			// an error occurred;
			// if this happens we can no longer communicate
			// with the plugin, so die
			tcl.eval("MPlug die {Communication with plugin was "
				 "cut off}");
			exit(-1);
		}

		/*if (Tcl_InputBlocked(channel)) {
			return TCL_OK;
		}*/

		got = Tcl_Read(channel, buf_ptr_,
			       (( bytesExpected_ < sizeof(buf_))
				? bytesExpected_ : sizeof(buf_)));

		if (got <= 0) {
			if (Tcl_Eof(channel)) {
				// an error occurred;
				// if this happens we can no longer communicate
				// with the plugin, so die
				tcl.eval("MPlug die {Communication with plugin"
					 " was cut off}");
				exit(-1);
			}
			if (Tcl_InputBlocked(channel)) {
				return TCL_OK;
			}
			tcl.result("unknown error occurred in "
				   "MPlugClient::dispatch");
			return TCL_ERROR;
		}

		if (state_==mpcString) {
			Tcl_AppendToObj(objv_[gotElems_+1], buf_ptr_, got);
			buf_ptr_ = buf_;
		} else {
			buf_ptr_ += got;
		}

		bytesExpected_ -= got;

		if (bytesExpected_ <= 0) {
			/*
			 * we got a chunk of stuff; do something with it
			 */

			switch (state_) {
			case mpcNumElems:
				numElems_ = *((u_int32_t*)buf_);
				gotElems_ = 0;
				state_ = mpcLen;
				bytesExpected_ = 4;
				buf_ptr_ = buf_;
				objv_ = new Tcl_Obj *[numElems_+1];
				break;
			case mpcLen:
				bytesExpected_ = *((u_int32_t*)buf_);
				state_ = mpcString;
				buf_ptr_ = buf_;
				objv_[gotElems_+1] = Tcl_NewStringObj("", 0);
				break;
			case mpcString:
				bytesExpected_ = 4;
				buf_ptr_ = buf_;
				gotElems_++;

				if (gotElems_ < numElems_) {
					state_ = mpcLen;
				} else {
					// check if we have the mplug_
					// object yet
					if (mplug_) {
						objv_[0] = mplug_;
						Tcl::instance().
							evalObjs(numElems_+1,
								 objv_);
					}
					delete [] objv_;
					objv_ = NULL;
					state_ = mpcNumElems;
					numElems_ = 0;
					gotElems_ = 0;
				}
				break;
			}
		}
	}

	return TCL_OK;
}


int
MPlugClient::Init(Tcl_Interp *interp)
{
	extern EmbeddedTcl et_mplug;

	// load the plugin tcl code into the interpreter
	et_mplug.load();

	Tcl_Obj *name = Tcl_NewStringObj("argv", -1);
	Tcl_IncrRefCount(name);
	Tcl_Obj *argv = Tcl_ObjGetVar2(interp, name, NULL, TCL_GLOBAL_ONLY);
	Tcl_DecrRefCount(name);
	if (argv==NULL) return TCL_OK;

	char *pluginArg = "-plugin";
	Tcl_Obj **objv;
	int objc, serverPort;

	if (Tcl_ListObjGetElements(interp, argv, &objc, &objv) != TCL_OK) {
		return TCL_ERROR;
	}

	// search for pluginArg
	for (int i=0; i<objc; i++) {
		if (strcmp(Tcl_GetStringFromObj(objv[i], NULL), pluginArg)==0){
			// found the plugin argument

			if (++i >= objc) {
				Tcl_SetResult(interp, "missing argument to "
					      "-plugin", TCL_STATIC);
				return TCL_ERROR;
			}

			// extract the server port from the argument array
			if (Tcl_GetIntFromObj(interp, objv[i],
					      &serverPort) != TCL_OK) {
				return TCL_ERROR;
			}

			if (serverPort <= 0) {
				Tcl_SetResult(interp, "invalid argument to "
					      "-plugin", TCL_STATIC);
				return TCL_ERROR;
			}

			char buf[80];
			sprintf(buf, "new MPlugClient %d", serverPort);
			if (Tcl_Eval(interp, buf)!=TCL_OK) {
				// FIXME: TkMain does not abort if error occurs
				// in AppInitProc

				fprintf(stderr, "%s\n",
					Tcl_GetVar(interp, "errorInfo",
						   TCL_GLOBAL_ONLY));
				return TCL_ERROR;
			}

			// set the mash environ element to mplug
			Tcl_SetVar2(interp, "mash", "environ", "mplug",
				    TCL_GLOBAL_ONLY);

			// remove the -plugin argument from argv
			return Tcl_ListObjReplace(interp, argv, i-1, 2,0,NULL);
		}
	}

	return TCL_OK;
}
