/*
 * tcpchan.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1997-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] = "$Header: /usr/mash/src/repository/mash/mash-1/net/tcpchan.cc,v 1.17 2002/02/03 04:13:45 lim Exp $ (UCB)";
#endif

#include "tclcl.h"
#include "config.h"
#include "net.h"
#include "tcpchan.h"

#ifndef WIN32
#   include <sys/ioctl.h>
#   include <sys/socket.h>
#else
#   include <io.h>
#endif
#include <errno.h>
#include <string.h>

#include "inet.h"

#ifdef sgi
#include <stdio.h>
#endif

static class TCPClientHandlerClass : public TclClass {
    public:
	TCPClientHandlerClass() : TclClass("TCPClientHandler") {}
	TclObject* create(int, const char*const*) {
		return (new TCPClientHandler);
	}
} client_handler_class;

static class TCPServerHandlerClass : public TclClass {
    public:
	TCPServerHandlerClass() : TclClass("TCPServerHandler") {}
	TclObject* create(int, const char*const*) {
		return (new TCPServerHandler);
	}
} server_handler_class;

static class TCPServerChannelClass : public TclClass {
    public:
	TCPServerChannelClass() : TclClass("TCPServerChannel") {}
	TclObject* create(int, const char*const*) {
		return (new TCPServerChannel);
	}
} tcp_server_class;

static class TCPClientChannelClass : public TclClass {
    public:
	TCPClientChannelClass() : TclClass("TCPClientChannel") {}
	TclObject* create(int, const char*const*) {
		return (new TCPClientChannel);
	}
} tcp_client_class;

TCPServerChannel::TCPServerChannel()
	   :connsock_(-1), sock_(-1), concurrent_(0)
{}

int TCPServerChannel::command(int argc, const char*const* argv)
{
	if (argc == 3) {
		if (strcmp(argv[1], "open") == 0) {
			u_int16_t port = htons(atoi(argv[2]));
			sock_ = opensock(port);
			return (TCL_OK);
		}
		if (strcmp(argv[1], "concurrent") == 0) {
			concurrent_ = atoi(argv[2]);
			return (TCL_OK);
		}
	}

	return (TclObject::command(argc, argv));
}


TCPServerChannel::~TCPServerChannel()
{
	handler_->unlink();
	if (sock_ > 0)
		close(sock_);
	if (connsock_ > 0)
		close(connsock_);
}


void TCPServerChannel::reset(void)
{
	if (concurrent_ && !parent_)
		exit(0);
	close(connsock_);
	connsock_ = -1;
}

int TCPServerChannel::opensock(u_int16_t port) const
{
	int fd;
	struct sockaddr_in sin;

	fd = socket(AF_INET, SOCK_STREAM, 0);
	if (fd < 0) {
		perror("socket");
		exit(1);
	}

	memset((char *)&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_port = port;
	sin.sin_addr.s_addr = INADDR_ANY;
	if (::bind(fd, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
		perror("bind");
		exit(1);
	}

	if (listen(fd, 5) < 0) {
		perror("listen");
		exit(1);
	}

	return (fd);
}

int TCPServerChannel::recv(u_char* buf, int len, u_int32_t& from, u_int16_t& port)
{
	sockaddr_in sfrom;
	socklen_t fromlen = sizeof(sfrom);
	if (connsock_ < 0) {
		connsock_ = accept(sock_, (sockaddr*)&sfrom, &fromlen);
		if (connsock_ < 0) {
			perror("accept");
			return (-1);
		}
		handler_->unlink();
		handler_->link(connsock_, TCL_READABLE);
		fromaddr_ = sfrom.sin_addr.s_addr;
		fromport_ = sfrom.sin_port;

		/* FIXME this is close but not quite work yet... */
		if (concurrent_) {
#ifndef WIN32 /* the mechanisms are quite diff. */
			if ((parent_ = fork()) < 0) {
				perror("fork");
				exit(1);
			} else if (parent_ != 0) {
				/* parent */
				reset();
				return (0);
			} else {
				/* child */
				close(sock_);
				sock_ = -1;
			}
#endif
		}
	}
	int cc = ::recv(connsock_, (char*)buf, len, 0);
	if (cc < 0) {
		if (errno != EWOULDBLOCK)
			perror("recv");
		return (-1);
	}
	from = fromaddr_;
	port = fromport_;
	return (cc);
}

void TCPServerChannel::send(const u_char* buf, int len)
{
	if (connsock_ < 0)
		return;
	if (::send(connsock_, (const char*)buf, len, 0) < 0) {
		perror("send");
	}
}

TCPClientChannel::TCPClientChannel()
	 :sock_(-1)
{
}

void
TCPClientChannel::closesock()
{
	handler_->unlink();
	if (sock_ > 0)
		close(sock_);
	sock_ = -1;
	return;
}

int TCPClientChannel::command(int argc, const char*const* argv)
{
	if (argc == 2) {
		if (strcmp(argv[1], "close") == 0) {
			handler_->unlink();
			if (sock_ > 0)
				close(sock_);
			sock_ = -1;
			return (TCL_OK);
		}
	} else if (argc == 4) {
		if (strcmp(argv[1], "open") == 0) {
			u_int32_t addr = LookupHostAddr(argv[2]);
			u_int16_t port = htons(atoi(argv[3]));
			sock_ = opensock(addr, port);
			return (TCL_OK);
		}
	}

	return (TclObject::command(argc, argv));
}

TCPClientChannel::~TCPClientChannel()
{
	handler_->unlink();
	if (sock_ > 0)
		close(sock_);
	sock_ = -1;
}


int TCPClientChannel::opensock(u_int32_t addr, u_int16_t port) const
{
	int fd = socket(AF_INET, SOCK_STREAM, 0);
	if (fd < 0) {
		perror("socket");
		exit(1);
	}

	struct sockaddr_in sin;
	memset((char *)&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_port = port;
	sin.sin_addr.s_addr = addr;
	if (connect(fd, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
		perror("connect");
		exit(1);
	}

	return (fd);
}

int TCPClientChannel::recv(u_char* buf, int len)
{
	int cc = ::recv(sock_, (char*)buf, len, 0);
	if (cc < 0) {
		if (errno != EWOULDBLOCK)
			perror("recv");
		return (-1);
	}
	return (cc);
}

void TCPClientChannel::send(const u_char* buf, int len)
{
	if (::send(sock_, (const char*)buf, len, 0) < 0)
		perror("send");
}

int TCPClientHandler::command(int argc, const char*const* argv)
{
	Tcl& tcl = Tcl::instance();
	if (argc == 2) {
		if (strcmp(argv[1], "reset") == 0) {
			reset();
			return (TCL_OK);
		}
		if (strcmp(argv[1], "channel") == 0) {
			tcl.resultf("%s", chan_->name());
			return (TCL_OK);
		}
	} else if (argc == 3) {
		if (strcmp(argv[1], "channel") == 0) {
			TCPClientChannel* c =
				(TCPClientChannel*)TclObject::lookup(argv[2]);
			chan(c);
			return (TCL_OK);
		}
	}
	return (TclObject::command(argc, argv));
}

int TCPServerHandler::command(int argc, const char*const* argv)
{
	Tcl& tcl = Tcl::instance();
	if (argc == 2) {
		if (strcmp(argv[1], "reset") == 0) {
			reset();
			return (TCL_OK);
		}
		if (strcmp(argv[1], "channel") == 0) {
			tcl.resultf("%s", chan_->name());
			return (TCL_OK);
		}
	} else if (argc == 3) {
		if (strcmp(argv[1], "channel") == 0) {
			TCPServerChannel* c =
				(TCPServerChannel*)TclObject::lookup(argv[2]);
			chan(c);
			return (TCL_OK);
		}
	}
	return (TclObject::command(argc, argv));
}

