/*
 * transmitter.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1993-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/net/transmitter.h,v 1.15 2002/02/03 04:13:45 lim Exp $
 */

#ifndef mash_transmitter_h
#define mash_transmitter_h

#ifdef WIN32
#include <winsock.h>
#else
#include <sys/param.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/uio.h>
#endif
#include "config.h"
#include "tclcl.h"
#include "timer.h"
#include "inet.h"
#include "pktbuf.h"

/*FIXME*/
#define MAXHDR 128

/*
 * The base object for performing the outbound path of
 * the application level protocol.
 */
class Transmitter : public PacketModule, public Timer {
    public:
	Transmitter();
	virtual int command(int argc, const char*const* argv);
	virtual void timeout();

	static void dump(int fd);
	inline void bps(int b) { bps_ = b; }
	inline int bps() { return(bps_); }
	inline int mtu() const { return (mtu_); }
	void flush();
	virtual void recv(pktbuf* pb);
    protected:
	virtual void loopback(pktbuf*);
        virtual void update_stats(pktbuf*);

	void update(int nbytes);
	void dump(int fd, const pktbuf*) const;
	void output(pktbuf* pb);
	virtual void transmit(pktbuf* pb) = 0;

	double gettimeofday() const;
	double txtime(pktbuf* pb);

	int mtu_;		/* mtu of wire (as seen by application) */

	int nb_;		/* number of bytes sent */
	int nf_;		/* number of frames sent */
	int np_;		/* number of packets sent */

	int bps_;		/* bit-rate for interpkt spacing */
	double nextpkttime_;

	/* packet transmission queue */
	int busy_;
	pktbuf* head_;
	pktbuf* tail_;
	virtual void idle();

	int loopback_;		/* true to loopback data packets */
	int loop_layer_;	/* # of layers to loop back (for testing) */
	static int dumpfd_;	/* fd to dump packet stream to */
};

#endif
