# ui-minimize.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/collaborator/ui-minimize.tcl,v 1.4 2002/02/03 04:21:46 lim Exp $


import WidgetClass


Class UIMinimize
WidgetClass UIMinimizeSimpleFrame
WidgetClass UIMinimizeFrame


UIMinimize public init { minimize_path } {
	$self next
	$self set minimize_path_ $minimize_path
}


UIMinimize public create_frame { path tip { minimize_image horizontal } \
		{ restore_image vertical } \
		{ pack {-fill both -expand 1 -side bottom} } \
		{ pack_tab {-side top -anchor nw} } \
		{ pack_minimize {-side bottom -anchor s} } } {

	$self instvar minimize_path_
	set frame [UIMinimizeFrame ${path}_encloser]
	$frame really_build_widget $path $tip $minimize_path_ $minimize_image \
			$restore_image $pack $pack_tab $pack_minimize
	return $frame
}


UIMinimizeSimpleFrame public build_widget { path } {
	set f [frame $path.dummy]
	pack $f
}


UIMinimizeSimpleFrame public should_check { w } {
	if [catch {set cl [$w cget -class]}] { return 0 }
	if { $cl == "UIMinimizeSimpleFrame" } { return 1 }
	if { [WidgetClass info instances $cl] != $cl } { return 0 }
	if { [$cl info heritage UIMinimizeSimpleFrame] != {} } { return 1 }
	return 0
}


UIMinimizeSimpleFrame public pack { path args } {
	$self instvar pack_
	set w [$self info path]
	if { [string index $path 0] == "." } {
		eval pack $path $args -in $w
	} else { eval pack $path $args }

	set slaves [pack slaves $w]
	if { [llength $slaves] <= 1 } {
		set flag 1
	} else {
		set flag 1
		foreach s $slaves {
			if [string match "*dummy" $s] continue
			if { ![$self should_check $s] || \
					[llength [pack slaves $s]] > 1 } {
				puts "flag was set to 0 for $s ($self)"
				set flag 0
				break
			}
		}
	}

	if $flag {
		puts "flag was set to 1 ($self)"
		set p [pack info $w]
		set fill [lsearch $p "-fill"]
		set expand [lsearch $p "-expand"]
		set pack_(encloser) "-fill [lindex $p [expr $fill + 1]] \
				-expand [lindex $p [expr $expand + 1]]"
		pack configure $w -fill none -expand 0
	} elseif [info exists pack_(encloser)] {
		eval pack configure $w $pack_(encloser)
	}
}


UIMinimizeFrame public really_build_widget { path tip minimize_path \
		minimize_image restore_image pack pack_tab pack_minimize } {
	$self instvar widget_ minimize_ restore_ pack_ tip_
	set tip_ $tip
	set widget_(main) $path
	set widget_(minimize) $minimize_path
	set minimize_ $minimize_image
	set restore_ $restore_image
	set pack_(main) $pack
	set pack_(tab) $pack_tab
	set pack_(minimize) $pack_minimize

	set w [$self info path]
	raise $path $w
	set b ${path}_minimize
	set widget_(tab) $b
	button $b -bd 1 -highlightthickness 0 \
			-image CollaboratorIcons($minimize_image) -command \
			[list $self minimize] -bg \#c0c0c0 \
			-activebackground \#c0c0c0
	bind $b <Enter> "$b configure -bg \#9898f8 -activebackground \#9898f8 \
			-image CollaboratorIcons(${minimize_}_sel)"
	bind $b <Leave> "$b configure -bg \#c0c0c0 -activebackground \#c0c0c0 \
			-image CollaboratorIcons(${minimize_})"

	set f [frame $w.dummy]
	pack $f

	eval pack $b $pack_(tab) -in $w
	eval pack $path $pack_(main) -in $w
}


UIMinimizeFrame private minimize { } {
	$self instvar widget_ minimize_ restore_ pack_ tip_
	pack forget $widget_(main)
	pack forget $widget_(tab)

	set b $widget_(tab)
	$b configure -image CollaboratorIcons($restore_) -command \
			"$self restore" -tip $tip_
	bind $b <Enter> "$b configure -bg \#9898f8 -activebackground \#9898f8 \
			-image CollaboratorIcons(${restore_}_sel)"
	bind $b <Leave> "$b configure -bg \#c0c0c0 -activebackground \#c0c0c0 \
			-image CollaboratorIcons(${restore_})"
	eval pack $widget_(tab) $pack_(minimize) -in $widget_(minimize)

	set w [$self info path]
	set p [pack info $w]
	set fill [lsearch $p "-fill"]
	set expand [lsearch $p "-expand"]
	set pack_(encloser) "-fill [lindex $p [expr $fill + 1]] \
			-expand [lindex $p [expr $expand + 1]]"
	pack configure $w -fill none -expand 0

	$self instvar callback_
	if { [info exists callback_] && $callback_!={} } {
		eval $callback_ minimize
	}
}


UIMinimizeFrame private restore { } {
	$self instvar widget_ minimize_ restore_ pack_ tip_
	pack forget $widget_(tab)

	set b $widget_(tab)
	$b configure -image CollaboratorIcons($minimize_) -command \
			"$self minimize" -tip {}
	bind $b <Enter> "$b configure -bg \#9898f8 -activebackground \#9898f8 \
			-image CollaboratorIcons(${minimize_}_sel)"
	bind $b <Leave> "$b configure -bg \#c0c0c0 -activebackground \#c0c0c0 \
			-image CollaboratorIcons(${minimize_})"

	set w [$self info path]
	eval pack $b $pack_(tab) -in $w
	eval pack $widget_(main) $pack_(main) -in $w
	eval pack configure $w $pack_(encloser)

	$self instvar callback_
	if { [info exists callback_] && $callback_!={} } {
		eval $callback_ restore
	}
}


UIMinimizeFrame public callback { c } {
	$self set callback_ $c
}
