# player.tcl --
#
#       Record and playback urls for tracing purposes. Based on the
#       mb TCL_Recorder / TCL_Player objects.
#
# Copyright (c) 1998-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#  $Header: /usr/mash/src/repository/mash/mash-1/tcl/cache/player.tcl,v 1.4 2002/02/03 04:25:37 lim Exp $


Class WC_Recorder

WC_Recorder instproc init { logfname } {
	$self instvar logf_ st_

	set st_ [gettimeofday]
	set logf_ [open $logfname "w+"]
}

WC_Recorder public record { url } {
	$self instvar st_ logf_

	puts $logf_ "[expr [gettimeofday] - $st_] $url"
	flush $logf_
}

Class WC_Player

WC_Player instproc init { logfname target rt } {
        $self instvar logf_ tgt_ isRealTime_
        set logf_ [open $logfname "r+"]
        set tgt_ $target
	set isRealTime_ $rt
}

WC_Player instproc start {} {
        $self instvar st_ now_ nextCmd_ nextURL_
        set now_ 0
        set nextURL_ ""
        $self run_next
}

WC_Player instproc run_next { } {
	$self instvar logf_ tgt_ nextURL_ now_ isRealTime_

	# get the current URL
        if { $nextURL_ != "" } {
                $tgt_ get $nextURL_
        }

	# find the next URL to play
        set u [gets $logf_ line]
        if { $u == -1 } {
                close $logf_
                delete $self
                return
        }
        set nextURL_ [lindex $line 1]

	# schedule the next call to $tgt get
        if $isRealTime_ {
                set currTime $now_
                set nexttime [expr int ([lindex $line 0] * 1000)]
                set now_ $nexttime
                after [expr $nexttime - $currTime] "$self run_next"
        } else {
                after idle "$self run_next"
        }
}

