# dc-videowidget.tcl --
#
#       A subclass of VideoWidget, customized for the special situation
#       in DC where the data-handler of a source is not a decoder, but
#       is a splitter.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import VideoWidget
Class DcVideoWidget -superclass VideoWidget

#-
# Method:
#   DcVideoWidget detach-decoder
# Description:
#   This override the detach-decoder in VideoWidget.  The main difference
#   is how we obtain the decoder.  Here we access the "decoder_" member
#   directly instead of calling [$src data-handler].
#-
DcVideoWidget instproc detach-decoder  {src} {
    $self instvar target_
    set d [$src set decoder_]
    if {$target_ != ""} {
	$d detach $target_
	delete $target_
	unset target_
    }
}


#-
# Method:
#   DcVideoWidget attach-decoder
# Description:
#   This override the attach-decoder in VideoWidget.  The main difference
#   is how we obtain the decoder.  Here we access the "decoder_" member
#   directly, instead of calling [$src data-handler].
#-
DcVideoWidget instproc attach-decoder { src colorModel useHW {useHeuristics 0} } {
    set d [$src set decoder_]
    if {$d==""} {
        global src_nickname
        if ![info exists src_nickname($src)] {
            set name [$src sdes cname]
        } else {
            set name $src_nickname($src)
        }
        puts stderr "can't attach-decoder: no handler for src $name;\
                     format is [$src format_name]"
        return
    }
    $self instvar window_ target_ is_slow_
    set target_ ""
    if { $useHW } {
        set fmt [$src format_name]
        if { $fmt == "jpeg" } {
            set fmt $fmt/[$d decimation]
        }
        if ![catch "new assistor/$fmt" v] {
            set target_ $v
            $target_ window $window_
        }
    }
    if { $target_ == "" } {
        set target_ [$colorModel alloc-renderer $window_ [$d decimation] $useHeuristics]
    }
    if $is_slow_ {
        $target_ update-interval [$self get_option stampInterval]
    }
    $window_ adjust-voff $d
    $d attach $target_
}
