# application-specialfxproxy.tcl --
#
#       Created by specialFX app when director activates special FX.  Talks
#       to special FX system and provides UI to the DC video window
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import Application
import SSAC_Client
import CServiceManager
import CService
source [glob ~kpatel/mash-code/mash/tcl/psvp/fx_service/fx_client.tcl]

Class CSpecialFxProxyApplication -superclass Application

##############################################################################
#
# CSpecialFxProxyApplication instproc InitArgs { options } {
#
# Input:
# options - the options object
#
# Output:
# none
#
# Description:
# Registers all options before the command line argument is parsed
#
##############################################################################
CSpecialFxProxyApplication instproc InitArgs { options } {
    $options register_option -ComPort optComPort
}

##############################################################################
#
# CSpecialFxProxyApplication instproc InitResources { options } {
#
# Input:
# options - the options object
#
# Output:
# none
#
# Description:
# Gives defaults for options
#
##############################################################################
CSpecialFxProxyApplication instproc InitResources { options } {
    $options add_default optComPort 0
}


##############################################################################
#
# CSpecialFxProxyApplication instproc init { argv } {
#
# Input:
# argv - command line input
#
# Output:
# none
#
# Description:
# Constructor for the object.
#
##############################################################################
CSpecialFxProxyApplication instproc init { argv } {
    $self next SpecialFxProxy

    # initialize some variables
    $self instvar m_inetMStudioAddr
    $self instvar m_iMStudioPort
    $self instvar m_inetClientAddr
    $self instvar m_iClientPort

    $self instvar m_specialFx_name
    $self instvar m_specialFx_source1
    $self instvar m_specialFx_source2
    $self instvar m_specialFx_liSourceId
    $self instvar m_i1
    $self instvar m_i2
    $self instvar m_o1
    $self instvar m_latency
    $self instvar m_text
    $self instvar m_font
    $self instvar m_point_size
    $self instvar m_xpos
    $self instvar m_ypos
    $self instvar m_text_color
    $self instvar m_back_color
    $self instvar m_master_alpha
    $self instvar m_back_alpha
    $self instvar m_factor
    $self instvar m_specialfx_cntrl


puts "got here"

    # Initiailization of options
    set options [$self options]
    $self InitArgs $options
    $self InitResources $options
    $options load_preferences "SpecialFxProxy"
    set argv [$options parse_args $argv]

    # parse out the arguments
    set m_inetMStudioAddr [lindex $argv 0]
    set m_iMStudioPort [lindex $argv 1]

    set m_inetClientAddr [lindex $argv 2]
    set m_iClientPort [lindex $argv 3]

    set m_specialFx_name [lindex $argv 4]
puts "name is $m_specialFx_name \n"

    set m_specialFx_source1 [lindex $argv 5]
puts "source1 is $m_specialFx_source1"
    set m_specialFx_source2 [lindex $argv 6]
puts "source2 is $m_specialFx_source2"
    set m_specialFx_liSourceId [lindex $argv 7]
puts "liSourceId is $m_specialFx_liSourceId"


    # setup the service manager stuff
    $self instvar m_serviceManager
    $self instvar m_lService

    set iPort [$options get_option optComPort]
    set m_serviceManager [new CServiceManager "ServiceApp" "SpecialFxProxy" \
	    $iPort]
    $m_serviceManager Attach $self

    set m_service ""

flush stdout

    $self StartFx $argv
}


##############################################################################
#
# CSpecialFxProxyApplication instproc destroy { }
#
# Input:
# none
#
# Output:
# none
#
# Description:
# destructor
#
##############################################################################
CSpecialFxProxyApplication instproc destroy { } {
    $self instvar m_timer

    if { m_timer != "" } {
	after cancel $m_timer
    }
}



##############################################################################
#
# CSpecialFxProxyApplication instproc NewConnection { service }
#
# Input:
# service - the new service that got connected
#
# Output:
# 1 - if handling this service
# 0 - otherwise
#
# Description:
# A call back function for the service manager.  This function will be called
# when a new connection has just been noticed by the service manager
#
##############################################################################
CSpecialFxProxyApplication instproc NewConnection { service } {
    # this member should never be called.
    puts "Replay Proxy got a new connection: exiting"
    exit

    return 0
}


##############################################################################
#
# CSpecialFxProxyApplication public StartFx { arguments } {
#
# Input:
# arguments - the arguments that are sent by the client.  It should hold
#   the address and port of the remote client as well as all the information
#   to start a new replay
#
# Output:
# none
#
# Description:
#
##############################################################################
CSpecialFxProxyApplication public StartFx { arguments } {
    $self instvar m_specialFx_name
    $self instvar m_specialFx_source1
    $self instvar m_specialFx_source2
    $self instvar m_specialFx_liSourceId
    $self instvar m_i1
    $self instvar m_i2
    $self instvar m_o1
    $self instvar m_latency
    $self instvar m_text
    $self instvar m_font
    $self instvar m_point_size
    $self instvar m_xpos
    $self instvar m_ypos
    $self instvar m_text_color
    $self instvar m_back_color
    $self instvar m_master_alpha
    $self instvar m_back_alpha
    $self instvar m_factor




    puts "start replay - $arguments"

################################
# irene - talk to ketan at this point.  set up args
################################
    $self instvar m_specialfx_cntrl
    set m_specialfx_cntrl [fx_create $m_specialFx_name]
puts "handler is $m_specialfx_cntrl"

    set m_i1 0
    set m_i2 0
    set m_o1 0
    set m_latency 0
    set m_text 0
    set m_font 0
    set m_point_size 0
    set m_xpos 0
    set m_ypos 0
    set m_text_color 0
    set m_back_color 0
    set m_master_alpha 0
    set m_back_alpha 0
    set m_factor 0


    fx_set_input_callback $m_specialfx_cntrl "$self ActivateUI "
    fx_set_output_callback $m_specialfx_cntrl "$self ActivateUI "
    fx_set_parameter_callback $m_specialfx_cntrl "$self ActivateUI "

puts "at the end of startfx "

}



##############################################################################
#
# CSpecialFxProxyApplication private GetUIControl { service arguments }
#
# Input:
# service - the service that called this function
# arguments - the ui commands that will be evaluated to update the ui
#
# Output:
# none
#
# Description:
# send the control ui commands back to the client
#
##############################################################################
CSpecialFxProxyApplication private GetUIControl { service arguments } {
    $self instvar m_szPlayPauseState
    $self instvar m_iOffset
    $self instvar m_tmStart
    $self instvar m_tmEnd
    $self instvar m_specialFx_name
    $self instvar m_specialFx_source1
    $self instvar m_specialFx_source2
    $self instvar m_specialFx_liSourceId
    $self instvar m_specialfx_cntrl

    set cmd ""

    # for unique variable names
    append cmd "regsub -all -- {\\\.} \$winFrame {_} __name \n"

    if {$m_specialFx_name == "H261TitleSubprogram"} {
	# Tab Buttons
	append cmd "frame \$winFrame.tab \n"

	# Inputs Button
	append cmd "button \$winFrame.tab.inputs -text \"Inputs\" \
		-command \"pack forget \$winFrame.inputs; \
		pack forget \$winFrame.text; pack forget \$winFrame.color; \
		pack forget \$winFrame.transperancy; \$winFrame.tab.inputs configure -fg black;\
		\$winFrame.tab.text configure -fg grey; \
		\$winFrame.tab.color configure -fg grey; \
		\$winFrame.tab.transperancy configure -fg grey; \
		pack \$winFrame.inputs -side top -expand 1 -fill both\" \n"
	append cmd "pack \$winFrame.tab.inputs -side left \n"

	# Text Button
	append cmd "button \$winFrame.tab.text -text \"Text\" \
		-command \"pack forget \$winFrame.inputs; \
		pack forget \$winFrame.text; pack forget \$winFrame.color; \
		pack forget \$winFrame.transperancy; \$winFrame.tab.inputs configure -fg grey;\
		\$winFrame.tab.text configure -fg black; \
		\$winFrame.tab.color configure -fg grey; \
		\$winFrame.tab.transperancy configure -fg grey; \
		pack \$winFrame.text -side top -expand 1 -fill both\" \n"
	append cmd "pack \$winFrame.tab.text -side left \n"

	# Color Button
	append cmd "button \$winFrame.tab.color -text \"Color\" \
		-command \"pack forget \$winFrame.inputs; \
		pack forget \$winFrame.text; pack forget \$winFrame.color; \
		pack forget \$winFrame.transperancy; \$winFrame.tab.inputs configure -fg grey;\
		\$winFrame.tab.text configure -fg grey; \
		\$winFrame.tab.color configure -fg black; \
		\$winFrame.tab.transperancy configure -fg grey; \
		pack \$winFrame.color -side top -expand 1 -fill both\" \n"
	append cmd "pack \$winFrame.tab.color -side left \n"

	# Transperancy Button
	append cmd "button \$winFrame.tab.transperancy -text \"Transperancy\" \
		-command \"pack forget \$winFrame.inputs; \
         	pack forget \$winFrame.text; pack forget \$winFrame.color; \
		pack forget \$winFrame.transperancy; \$winFrame.tab.inputs configure -fg grey;\
		\$winFrame.tab.text configure -fg grey; \
		\$winFrame.tab.color configure -fg grey; \
		\$winFrame.tab.transperancy configure -fg black; \
		pack \$winFrame.transperancy -side top -expand 1 -fill both\" \n"
	append cmd "pack \$winFrame.tab.transperancy -side left \n"

	# Inputs Frame
	append cmd "frame \$winFrame.inputs \n"

	# i1
	append cmd "frame \$winFrame.inputs.1 \n"
	append cmd "global __i1 \n"
	#      append cmd "set i1\$__name \[lindex \$liSourceId 0\] \n"
	append cmd "if {!\[info exist __i1\]} {set __i1 $m_specialFx_source1} \n"
	append cmd "frame \$winFrame.inputs.1.i1 \n"
	append cmd "label \$winFrame.inputs.1.i1.label -text \"i1\" \n"
	append cmd "menubutton \$winFrame.inputs.1.i1.entry -textvariable __i1 \
		-menu \$winFrame.inputs.1.i1.entry.menu -relief raised \n"
	append cmd "menu \$winFrame.inputs.1.i1.entry.menu \n"
	append cmd "pack \$winFrame.inputs.1.i1.label -side left \n"
	append cmd "pack \$winFrame.inputs.1.i1.entry -side right -expand 1 -fill x \n"
	append cmd "pack \$winFrame.inputs.1.i1 -side top -expand 1 -fill both \n"
	append cmd "pack \$winFrame.inputs.1 -side left -expand 1 -fill both \n"

	append cmd "foreach item \" $m_specialFx_liSourceId \" { \
		\$winFrame.inputs.1.i1.entry.menu add radio \
		-label \$item -variable __i1 \
		-command \"global __i1; \
		\$service Send UPDATE_I1_CONTROL \\\$__i1 \" \
	    } \n"

	# latency
	append cmd "frame \$winFrame.inputs.2 \n"
	append cmd "frame \$winFrame.inputs.2.latency \n"
	append cmd "label \$winFrame.inputs.2.latency.label -text \"latency\" \n"
	append cmd "scale \$winFrame.inputs.2.latency.entry -orient horizontal \
		-from 0.0 -to 1.0 -resolution \[expr (0.0-1.0) / 100.0\] \
		-command \" \
		\$service Send UPDATE_LATENCY_CONTROL \" \n"
	append cmd "pack \$winFrame.inputs.2.latency.label -side left \n"
	append cmd "pack \$winFrame.inputs.2.latency.entry -side right \
		-expand 1 -fill both \n"
	append cmd "pack \$winFrame.inputs.2.latency -side top -expand 1 \n"
	append cmd "pack \$winFrame.inputs.2 -side right -expand 1 -fill both \n"

	# Text Frame
	append cmd "frame \$winFrame.text \n"

	# text
	append cmd "global __text \n"
	append cmd "if {!\[info exist __text\]} {set __text Test} \n"

        append cmd "global value \n"
	append cmd "frame \$winFrame.text.text \n"
	append cmd "label \$winFrame.text.text.label -text \"text\" \n"
	append cmd "entry \$winFrame.text.text.entry -relief sunken \
		-textvariable __text \n"
	append cmd "button \$winFrame.text.text.button -text \"Set\" \
		-command \"global __text;
		\$service Send UPDATE_TEXT_CONTROL \\\" \\\$__text \\\" \" \n"
	append cmd "pack \$winFrame.text.text.label -side left \n"
	append cmd "pack \$winFrame.text.text.button -side right \n"
	append cmd "pack \$winFrame.text.text.entry -side right -fill both -expand 1 \n"
	append cmd "pack \$winFrame.text.text -side top -expand 1 -fill both \n"

	# font
	append cmd "frame \$winFrame.text.1 \n"
	append cmd "global __font \n"
	append cmd "global __fonts \n"
	append cmd "set __fonts {Times-Roman Times-Bold Times-Italic \
		Hevetica Hevetica-Narrow Hevetica-Bold} \n"
	append cmd "set __font \[lindex \$__fonts 0\] \n"
	append cmd "frame \$winFrame.text.1.font \n"
	append cmd "label \$winFrame.text.1.font.label -text \"font\" \n"
	append cmd "menubutton \$winFrame.text.1.font.entry \
		-textvariable __font -menu \$winFrame.text.1.font.entry.menu \
		-relief raised \n"
	append cmd "menu \$winFrame.text.1.font.entry.menu  \n"
	append cmd "pack \$winFrame.text.1.font.label -side left \n"
	append cmd "pack \$winFrame.text.1.font.entry -side right -expand 1 -fill both \n"
	append cmd "pack \$winFrame.text.1.font -side left -expand 1 -fill x \n"

	append cmd "foreach item \$__fonts { \
		\$winFrame.text.1.font.entry.menu add radio -label \$item \
		-variable __font \
		-command \"global __font; puts \\\"font is \\\$__font \n\\\"; \
		\$service Send UPDATE_FONT_CONTROL \\\$__font\" \
	    } \n"

	# point_size
	append cmd "frame \$winFrame.text.1.point_size \n"
	append cmd "label \$winFrame.text.1.point_size.label -text \"point_size\" \n"

	append cmd "global __pointsize \n"
	append cmd "if {!\[info exist __pointsize\]} {set __pointsize 20} \n"

	append cmd "scale \$winFrame.text.1.point_size.entry -orient horizontal \
		-variable __pointsize \
		-from 5 -to 40 -command \" \
		\$service Send UPDATE_POINT_SIZE_CONTROL \" \n"
	append cmd "pack \$winFrame.text.1.point_size.label -side left \n"
	append cmd "pack \$winFrame.text.1.point_size.entry -side right \
		-expand 1 -fill both \n"
	append cmd "pack \$winFrame.text.1.point_size -side right -expand 1 \n"
	append cmd "pack \$winFrame.text.1 -side top -expand 1 -fill both \n"

	# xpos
	append cmd "global __xpos \n"
	append cmd "if {!\[info exist __xpos\]} {set __xpos 0.2} \n"

	append cmd "frame \$winFrame.text.2 \n"
	append cmd "frame \$winFrame.text.2.xpos \n"
	append cmd "label \$winFrame.text.2.xpos.label -text \"xpos\" \n"
	append cmd "scale \$winFrame.text.2.xpos.entry -orient horizontal \
		-from 0.0 -to 1.0 -resolution \[expr (0.0-1.0) / 100.0\] \
		-variable __xpos \
		-command \" \
		\$service Send UPDATE_XPOS_CONTROL \" \n"
	append cmd "pack \$winFrame.text.2 -side top -expand 1 -fill both \n"
	append cmd "pack \$winFrame.text.2.xpos -side right -expand 1 \n"
	append cmd "pack \$winFrame.text.2.xpos.label -side left \n"
	append cmd "pack \$winFrame.text.2.xpos.entry -side right -expand 1 -fill both \n"
	append cmd "pack \$winFrame.text.2.xpos -side left -expand 1  \n"

	# ypos
	append cmd "global __ypos \n"
	append cmd "if {!\[info exist __ypos\]} {set __ypos 0.2} \n"

	append cmd "frame \$winFrame.text.2.ypos \n"
	append cmd "label \$winFrame.text.2.ypos.label -text \"ypos\" \n"
	append cmd "scale \$winFrame.text.2.ypos.entry -orient horizontal \
		-from 0.0 -to 1.0 -resolution \[expr (0.0-1.0) / 100.0\] \
		-variable __ypos \
		-command \" \
		\$service Send UPDATE_YPOS_CONTROL \" \n"
	append cmd "pack \$winFrame.text.2.ypos.label -side left \n"
	append cmd "pack \$winFrame.text.2.ypos.entry -side right -expand 1 -fill both \n"
	append cmd "pack \$winFrame.text.2.ypos -side left -expand 1  \n"

	# Color
	append cmd "frame \$winFrame.color \n"

	# text_color
	append cmd "frame \$winFrame.color.text_color \n"
	append cmd "label \$winFrame.color.text_color.label -text \"text_color\" \n"
	append cmd "frame \$winFrame.color.text_color.entry \n"
	append cmd "frame \$winFrame.color.text_color.entry.r \n"
	append cmd "label \$winFrame.color.text_color.entry.r.label -text \"r\" \n"
	append cmd "scale \$winFrame.color.text_color.entry.r.entry \
		-orient horizontal -from 0 -to 255 \
		-command \" \
                global __valuer; global __valueg; global __valueb; global __value; \
		set __valuer \\\[\$winFrame.color.text_color.entry.r.entry get\\\]; \
		set __valueg \\\[\$winFrame.color.text_color.entry.g.entry get\\\]; \
		set __valueb \\\[\$winFrame.color.text_color.entry.b.entry get\\\]; \
		set __value \\\"\\\$__valuer \\\$__valueg \\\$__valueb\\\"; \
                \$service Send UPDATE_TEXT_COLOR_CONTROL \\\$__value ;# \" \n"
	append cmd "pack \$winFrame.color.text_color.entry.r.label -side left \n"
	append cmd "pack \$winFrame.color.text_color.entry.r.entry -side right \
		-expand 1 -fill both \n"

	append cmd "frame \$winFrame.color.text_color.entry.g \n"
	append cmd "label \$winFrame.color.text_color.entry.g.label -text \"g\" \n"
	append cmd "scale \$winFrame.color.text_color.entry.g.entry \
		-orient horizontal -from 0 -to 255 \
		-command \" \
                global __valuer; global __valueg; global __valueb; global __value; \
		set __valuer \\\[\$winFrame.color.text_color.entry.r.entry get\\\]; \
		set __valueg \\\[\$winFrame.color.text_color.entry.g.entry get\\\]; \
		set __valueb \\\[\$winFrame.color.text_color.entry.b.entry get\\\]; \
                set __value \\\"\\\$__valuer \\\$__valueg \\\$__valueb\\\"; \
                \$service Send UPDATE_TEXT_COLOR_CONTROL \\\$__value ;# \" \n"
	append cmd "pack \$winFrame.color.text_color.entry.g.label -side left \n"
	append cmd "pack \$winFrame.color.text_color.entry.g.entry -side right \
		-expand 1 -fill both \n"
	append cmd "frame \$winFrame.color.text_color.entry.b \n"
	append cmd "label \$winFrame.color.text_color.entry.b.label -text \"b\" \n"
	append cmd "scale \$winFrame.color.text_color.entry.b.entry \
		-orient horizontal -from 0 -to 255 \
		-command \" \
                global __valuer; global __valueg; global __valueb; global __value; \
		set __valuer \\\[\$winFrame.color.text_color.entry.r.entry get\\\]; \
		set __valueg \\\[\$winFrame.color.text_color.entry.g.entry get\\\]; \
		set __valueb \\\[\$winFrame.color.text_color.entry.b.entry get\\\]; \
                set __value \\\"\\\$__valuer \\\$__valueg \\\$__valueb\\\"; \
                \$service Send UPDATE_TEXT_COLOR_CONTROL \\\$__value ;# \" \n"
	append cmd "pack \$winFrame.color.text_color.entry.b.label -side left \n"
	append cmd "pack \$winFrame.color.text_color.entry.b.entry -side right \
		-expand 1 -fill both \n"

	append cmd "pack \$winFrame.color.text_color.entry.r -side left \n"
	append cmd "pack \$winFrame.color.text_color.entry.g -side left \n"
	append cmd "pack \$winFrame.color.text_color.entry.b -side left \n"
	append cmd "pack \$winFrame.color.text_color.label -side top \n"
	append cmd "pack \$winFrame.color.text_color.entry -side top  \
		-expand 1 -fill both \n"
	append cmd "pack \$winFrame.color.text_color -side top -expand 1 -fill both \n"

	# back_color
	append cmd "frame \$winFrame.color.back_color \n"
	append cmd "label \$winFrame.color.back_color.label -text \"back_color\" \n"
	append cmd "frame \$winFrame.color.back_color.entry \n"
	append cmd "frame \$winFrame.color.back_color.entry.r \n"
	append cmd "label \$winFrame.color.back_color.entry.r.label -text \"r\" \n"
	append cmd "scale \$winFrame.color.back_color.entry.r.entry \
		-orient horizontal -from 0 -to 255 \
		-command \" \
                global __valuer; global __valueg; global __valueb; global __value; \
		set __valuer \\\[\$winFrame.color.back_color.entry.r.entry get\\\]; \
		set __valueb \\\[\$winFrame.color.back_color.entry.b.entry get\\\]; \
		set __valueg \\\[\$winFrame.color.back_color.entry.g.entry get\\\]; \
                set __value \\\"\\\$__valuer \\\$__valueg \\\$__valueb\\\"; \
                \$service Send UPDATE_BACK_COLOR_CONTROL \\\$__value ;# \" \n"
	append cmd "pack \$winFrame.color.back_color.entry.r.label -side left \n"
	append cmd "pack \$winFrame.color.back_color.entry.r.entry -side right \
		-expand 1 -fill both \n"

	append cmd "frame \$winFrame.color.back_color.entry.g \n"
	append cmd "label \$winFrame.color.back_color.entry.g.label -text \"g\" \n"
	append cmd "scale \$winFrame.color.back_color.entry.g.entry \
		-orient horizontal -from 0 -to 255 \
		-command \" \
                global __valuer; global __valueg; global __valueb; global __value; \
		set __valuer \\\[\$winFrame.color.back_color.entry.r.entry get\\\]; \
		set __valueb \\\[\$winFrame.color.back_color.entry.b.entry get\\\]; \
		set __valueg \\\[\$winFrame.color.back_color.entry.g.entry get\\\]; \
                set __value \\\"\\\$__valuer \\\$__valueg \\\$__valueb\\\"; \
                \$service Send UPDATE_BACK_COLOR_CONTROL \\\$__value ;# \" \n"
	append cmd "pack \$winFrame.color.back_color.entry.g.label -side left \n"
	append cmd "pack \$winFrame.color.back_color.entry.g.entry -side right \
		-expand 1 -fill both \n"
	append cmd "frame \$winFrame.color.back_color.entry.b \n"
	append cmd "label \$winFrame.color.back_color.entry.b.label -text \"b\" \n"
	append cmd "scale \$winFrame.color.back_color.entry.b.entry \
		-orient horizontal -from 0 -to 255 \
		-command \" \
                global __valuer; global __valueg; global __valueb; global __value; \
		set __valuer \\\[\$winFrame.color.back_color.entry.r.entry get\\\]; \
		set __valueb \\\[\$winFrame.color.back_color.entry.b.entry get\\\]; \
		set __valueg \\\[\$winFrame.color.back_color.entry.g.entry get\\\]; \
                set __value \\\"\\\$__valuer \\\$__valueg \\\$__valueb\\\"; \
                \$service Send UPDATE_BACK_COLOR_CONTROL \\\$__value ;# \" \n"
	append cmd "pack \$winFrame.color.back_color.entry.b.label -side left \n"
	append cmd "pack \$winFrame.color.back_color.entry.b.entry -side right \
		-expand 1 -fill both \n"

	append cmd "pack \$winFrame.color.back_color.entry.r -side left \n"
	append cmd "pack \$winFrame.color.back_color.entry.g -side left \n"
	append cmd "pack \$winFrame.color.back_color.entry.b -side left \n"
	append cmd "pack \$winFrame.color.back_color.label -side top \n"
	append cmd "pack \$winFrame.color.back_color.entry -side top  \
		-expand 1 -fill both \n"
	append cmd "pack \$winFrame.color.back_color -side top -expand 1 -fill both \n"

	# Trancperancy
	append cmd "frame \$winFrame.transperancy \n"

	# master_alpha
	append cmd "global __master_alpha \n"
	append cmd "if {!\[info exist __master_alpha\]} {set __master_alpha 1.0} \n"

	append cmd "frame \$winFrame.transperancy.master_alpha \n"
	append cmd "label \$winFrame.transperancy.master_alpha.label \
		-text \"master_alpha\" \n"
	append cmd "scale \$winFrame.transperancy.master_alpha.entry -orient horizontal \
		-variable __master_alpha \
		-from 0.0 -to 1.0 -resolution \[expr (0.0-1.0) / 100.0\] -command \" \
		\$service Send UPDATE_MASTER_ALPHA_CONTROL \" \n"
	append cmd "pack \$winFrame.transperancy.master_alpha.label \
		-side left -anchor n \n"
	append cmd "pack \$winFrame.transperancy.master_alpha.entry -side right \
		-expand 1 -fill both \n"
	append cmd "pack \$winFrame.transperancy.master_alpha -side top \
		-expand 1 -fill both \n"

	# back_alpha
	append cmd "global __back_alpha \n"
	append cmd "if {!\[info exist __back_alpha\]} {set __back_alpha 0.0} \n"

	append cmd "frame \$winFrame.transperancy.back_alpha \n"
	append cmd "label \$winFrame.transperancy.back_alpha.label \
		-text \"back_alpha\" \n"
	append cmd "scale \$winFrame.transperancy.back_alpha.entry -orient horizontal \
		-variable __back_alpha \
		-from 0.0 -to 1.0 -resolution \[expr (0.0-1.0) / 100.0\] -command \"\
		\$service Send UPDATE_BACK_ALPHA_CONTROL \" \n"
	append cmd "pack \$winFrame.transperancy.back_alpha.label \
		-side left -anchor n \n"
	append cmd "pack \$winFrame.transperancy.back_alpha.entry -side right \
		-expand 1 -fill both \n"
	append cmd "pack \$winFrame.transperancy.back_alpha -side top \
		-expand 1 -fill both \n"

	append cmd "pack \$winFrame.tab -side top -expand 1 -fill both \n"
	append cmd "pack \$winFrame.inputs -side top -expand 1 -fill both \n"



    } elseif {$m_specialFx_name ==  "H261FadeSubprogram"} {
	# Tab Buttons
	append cmd "frame \$winFrame.tab \n"

	# Inputs Button
	append cmd "button \$winFrame.tab.inputs -text \"Inputs\" \
		-command \"pack forget \$winFrame.inputs; pack  forget \$winFrame.factor; \
		\$winFrame.tab.inputs configure -fg black; \
		\$winFrame.tab.factor configure -fg grey; \
		pack \$winFrame.inputs -side top -expand 1 -fill both\" \n"
	append cmd "pack \$winFrame.tab.inputs -side left \n"

	# Factor Button
	append cmd "button \$winFrame.tab.factor -text \"Factor\" \
		-command \"pack forget \$winFrame.inputs; pack  forget \$winFrame.factor; \
		\$winFrame.tab.inputs configure -fg grey; \
		\$winFrame.tab.factor configure -fg black; \
		pack \$winFrame.factor -side top -expand 1 -fill both\" \n"
	append cmd "pack \$winFrame.tab.factor -side left \n"

	# Inputs
	append cmd "frame \$winFrame.inputs \n"

	# i1
	append cmd "frame \$winFrame.inputs.1 \n"
	append cmd "global __i1 \n"
	#      append cmd "set __i1 \[lindex \$liSourceId 0\] \n"
	append cmd "global __i1 \n"
	append cmd "set __i1 $m_specialFx_source1 \n"
	append cmd "frame \$winFrame.inputs.1.i1 \n"
	append cmd "label \$winFrame.inputs.1.i1.label -text \"i1\" \n"
	append cmd "menubutton \$winFrame.inputs.1.i1.entry -textvariable __i1 \
		-menu \$winFrame.inputs.1.i1.entry.menu -relief raised \n"
	append cmd "menu \$winFrame.inputs.1.i1.entry.menu \n"
	append cmd "pack \$winFrame.inputs.1.i1.label -side left \n"
	append cmd "pack \$winFrame.inputs.1.i1.entry -side right \
		-expand 1 -fill both \n"
	append cmd "pack \$winFrame.inputs.1.i1 -side left -expand 1 -fill both \n"

	append cmd "foreach item \" $m_specialFx_liSourceId \"  { \
		\$winFrame.inputs.1.i1.entry.menu add radio -label \$item \
		-variable __i1 -command \"global __i1; puts \\\"i1 is \\\$__i1 \n\\\"; \
		\$service Send UPDATE_I1_CONTROL \\\$__i1 \" \
	    } \n"

	# i2
	append cmd "global __i2 \n"
	#      append cmd "set __i2 \[lindex \$liSourceId 0\] \n"
	append cmd "global __i2 \n"
	append cmd "set __i2 $m_specialFx_source2 \n"
	append cmd "frame \$winFrame.inputs.1.i2 \n"
	append cmd "label \$winFrame.inputs.1.i2.label -text \"i2\" \n"
	append cmd "menubutton \$winFrame.inputs.1.i2.entry -textvariable __i2 \
 		-menu \$winFrame.inputs.1.i2.entry.menu -relief raised \n"
	append cmd "menu \$winFrame.inputs.1.i2.entry.menu \n"
	append cmd "pack \$winFrame.inputs.1.i2.label -side left \n"
	append cmd "pack \$winFrame.inputs.1.i2.entry -side right \
		-expand 1 -fill both \n"
	append cmd "pack \$winFrame.inputs.1.i2 -side left -expand 1 -fill both \n"
	append cmd "pack \$winFrame.inputs.1 -side top -expand 1 -fill both \n"

	append cmd "foreach item \" $m_specialFx_liSourceId \"  { \
		\$winFrame.inputs.1.i2.entry.menu add radio -label \$item \
		-variable __i2 -command \"global __i2; puts \\\"i2 is \\\$__i2\n\\\"; \
		\$service Send UPDATE_I2_CONTROL \\\$__i2 \" \
	    } \n"


	# latency
	append cmd "frame \$winFrame.inputs.2 \n"
	append cmd "frame \$winFrame.inputs.2.latency \n"
	append cmd "label \$winFrame.inputs.2.latency.label -text \"latency\" \n"
	append cmd "scale \$winFrame.inputs.2.latency.entry -orient horizontal \
		-from 0.0 -to 1.0 -resolution \[expr (0.0-1.0) / 100.0\] \
		-command \"\$service Send UPDATE_LATENCY_CONTROL \" \n"
	append cmd "pack \$winFrame.inputs.2.latency.label -side left \n"
	append cmd "pack \$winFrame.inputs.2.latency.entry -side right \
		-expand 1 -fill both \n"
	append cmd "pack \$winFrame.inputs.2.latency -side left -expand 1 -fill both \n"
	append cmd "pack \$winFrame.inputs.2 -side top -expand 1 -fill both \n"

	# Factor
	append cmd "frame \$winFrame.factor \n"

	# factor
	append cmd "frame \$winFrame.factor.factor \n"
	append cmd "scale \$winFrame.factor.factor.entry -orient horizontal \
		-from 0.0 -to 1.0 -resolution \[expr (0.0-1.0) / 100.0\] \
		-command \"\$service Send UPDATE_FACTOR_CONTROL \" \n"
	append cmd "label \$winFrame.factor.factor.label -text \"factor\" \n"
	append cmd "pack \$winFrame.factor.factor.label -side left \n"
	append cmd "pack \$winFrame.factor.factor.entry -side right \
		-expand 1 -fill both \n"
	append cmd "pack \$winFrame.factor.factor -side top -expand 1 -fill both \n"


	append cmd "pack \$winFrame.tab -side top -expand 1 -fill both \n"
	append cmd "pack \$winFrame.inputs -side top -expand 1 -fill both \n"
    }


    # the play/pause button
    #    append cmd "global playPause\$__name \n"
    #    append cmd "set playPause\$__name $m_szPlayPauseState \n"
    #    append cmd "button \$winFrame.playPauseButton \
	    #	    -textvariable playPause\$__name  \
	    #	    -command \"\$service Send PLAY_PAUSE \\\"\\\" \" \n"
    #
    #    append cmd "pack \$winFrame.playPauseButton -fill y -side right \n"
    #
    #    # the progress slider
    #    append cmd "global slider\$__name \n"
    #    append cmd "set slider\$__name [expr int($m_iOffset)] \n"
    #    append cmd "scale \$winFrame.slider -orient horizontal \
	    #	    -from 0 -to [expr int($m_tmEnd - $m_tmStart)] \
	    #	    -tickinterval [expr int(0.49 * ($m_tmEnd - $m_tmStart))] \
	    #	    -showvalue true \
	    #	    -variable slider\$__name \
	    #	    -command \"\$service Send MOVE_SLIDER\" \n"
    #    append cmd "pack \$winFrame.slider -side left -fill y -expand 1 \n"

#DEBUG
#    return $cmd

    $service Send CONTROL_UI $cmd
}

##############################################################################
#
# CSpecialFxProxyApplication private ActivateUI { arguments }
#
# Input:
# service - the service that called this function
# arguments - the ui commands that will be evaluated to update the ui
#
# Output:
# none
#
# Description:
#
##############################################################################
CSpecialFxProxyApplication public ActivateUI { arguments } {
    $self instvar m_szPlayPauseState
    $self instvar m_iOffset
    $self instvar m_specialfx_cntrl
    $self instvar m_i1
    $self instvar m_i2
    $self instvar m_o1
    $self instvar m_latency
    $self instvar m_text
    $self instvar m_font
    $self instvar m_point_size
    $self instvar m_xpos
    $self instvar m_ypos
    $self instvar m_text_color
    $self instvar m_back_color
    $self instvar m_master_alpha
    $self instvar m_back_alpha
    $self instvar m_factor
    $self instvar m_specialFx_source1
    $self instvar m_specialFx_source2
    $self instvar m_specialFx_name
    $self instvar m_inetMStudioAddr
    $self instvar m_iMStudioPort


    set varname [lindex $arguments 0]
    puts "in Activate UI"
    puts "varname is $varname"
    flush stdout

    if {$varname == "i1"} {
	if {$m_i1 == 0} {
	    puts "i1 now activated with value $m_inetMStudioAddr/$m_iMStudioPort/$m_specialFx_source1 \n"
	    fx_set_input_spec $m_specialfx_cntrl i1 $m_inetMStudioAddr/$m_iMStudioPort/$m_specialFx_source1
	    set m_i1 1
	}
    } elseif {$varname == "i2"} {
	if {$m_i2 == 0} {
	    puts "i2 now activated with value $m_inetMStudioAddr/$m_iMStudioPort/$m_specialFx_source2 \n"
	    fx_set_input_spec $m_specialfx_cntrl i2 $m_inetMStudioAddr/$m_iMStudioPort/$m_specialFx_source2
	    set m_i2 1
	}
    } elseif {$varname == "o1"} {
	if {$m_o1 == 0} {
	    puts "output is $m_inetMStudioAddr/$m_iMStudioPort \n"
	    fx_set_output_spec $m_specialfx_cntrl o1 $m_inetMStudioAddr/$m_iMStudioPort
	    set m_o1 1
	}
    } elseif {$varname == "latency"} {
	if {$m_latency == 0} {
	    puts "latency now activated with value 0.0 \n"
	    fx_set_parameter_value $m_specialfx_cntrl latency 0.0
	    set m_latency 1
	}
    } elseif {$varname == "text"} {
	if {$m_text == 0} {
	    puts "text now activated with value \"\"  \n"
	    fx_set_parameter_value $m_specialfx_cntrl text "Test"
	    set m_text 1
	}
    } elseif {$varname == "font"} {
	if {$m_font == 0} {
	    puts "font now activated with value Times-Roman \n"
	    fx_set_parameter_value $m_specialfx_cntrl font Times-Roman
	    set m_font 1
	}
    } elseif {$varname == "point_size"} {
	if {$m_point_size == 0} {
	    puts "point_size now activated with value 5  \n"
	    fx_set_parameter_value $m_specialfx_cntrl point_size 20
	    set m_point_size 1
	}
    } elseif {$varname == "xpos"} {
	if {$m_xpos == 0} {
	    puts "xpos now activated with value 0.0  \n"
	    fx_set_parameter_value $m_specialfx_cntrl xpos 0.2
	    set m_xpos 1
	}
    } elseif {$varname == "ypos"} {
	if {$m_ypos == 0} {
	    puts "ypos now activated with value 0.0  \n"
	    fx_set_parameter_value $m_specialfx_cntrl ypos 0.75
	    set m_ypos 1
	}
    } elseif {$varname == "text_color"} {
	if {$m_text_color == 0} {
	    puts "text_color r is now activated with value 0  \n"
	    puts "text_color g is now activated with value 0  \n"
	    puts "text_color b is now activated with value 0  \n"
	    fx_set_parameter_value $m_specialfx_cntrl text_color {235 0 128}
	    set m_text_color 1
	}
    } elseif {$varname == "back_color"} {
	if {$m_back_color == 0} {
	    puts "back_color r is now activated with value 0  \n"
	    puts "back_color g is now activated with value 0  \n"
	    puts "back_color b is now activated with value 0  \n"
	    fx_set_parameter_value $m_specialfx_cntrl back_color {16 0 128}
	    set m_back_color 1
	}
    } elseif {$varname == "master_alpha"} {
	if {$m_master_alpha == 0} {
	    puts "master_alpha now activated with value 0.0  \n"
	    fx_set_parameter_value $m_specialfx_cntrl master_alpha 1
	    set m_master_alpha 1
	}
    } elseif {$varname == "back_alpha"} {
	if {$m_back_alpha == 0} {
	    puts "back_alpha now activated with value 0.0  \n"
	    fx_set_parameter_value $m_specialfx_cntrl back_alpha 0.0
	    set m_back_alpha 1
	}
    } elseif {$varname == "factor"} {
	if {$m_factor == 0} {
	    puts "factor now activated with value 0.0  \n"
	    fx_set_parameter_value $m_specialfx_cntrl factor 0.0
	    set m_factor 1
	}
    }

    puts " got here; $m_specialFx_name"
    flush stdout

    if {$m_specialFx_name == "H261TitleSubprogram" } {
	if {$m_o1 == 1 && \
		$m_i1 == 1 && \
		$m_latency == 1 && \
		$m_text == 1 && \
		$m_font == 1 && \
		$m_point_size == 1 && \
		$m_xpos == 1 && \
		$m_ypos == 1 && \
		$m_text_color == 1 && \
		$m_back_color == 1 && \
		$m_master_alpha == 1 && \
		$m_back_alpha == 1} {
	    fx_set_output_srcid_cb $m_specialfx_cntrl o1 "$self GetServiceId "
	    fx_status $m_specialfx_cntrl on
	}
    } elseif {$m_specialFx_name == "H261FadeSubprogram"} {
	if {$m_o1 == 1 && \
		$m_i1 == 1 && \
		$m_i2 == 1 && \
		$m_latency == 1 &&\
		$m_factor == 1} {
	    fx_set_output_srcid_cb $m_specialfx_cntrl o1 "$self GetServiceId "
	    fx_status $m_specialfx_cntrl on
	}
    }

}



##############################################################################
#
# CSpecialFxProxyApplication private GetServiceId { service arguments }
#
# Input:
# service - the service that called this function
# arguments - the ui commands that will be evaluated to update the ui
#
# Output:
# none
#
# Description:
#
##############################################################################
CSpecialFxProxyApplication private GetServiceId { arguments } {
    # start the service

   $self instvar m_serviceManager
   $self instvar m_service
   $self instvar m_inetClientAddr
   $self instvar m_iClientPort


    puts " got here GetServiceId Ouptut"


    set iSourceId [lindex $arguments 0]


    set m_service [$m_serviceManager NewService $m_inetClientAddr \
           $m_iClientPort "VideoService" $iSourceId]

    # start special effect right now
    # do the message mapping between com messages and member functions
    $m_service MapMessage "GET_UI_CONTROL" $self "GetUIControl"
    $m_service MapMessage "UPDATE_I1_CONTROL " $self "UpdateI1Control"
    $m_service MapMessage "UPDATE_I2_CONTROL" $self "UpdateI2Control"
    $m_service MapMessage "UPDATE_LATENCY_CONTROL" $self "UpdateLatencyControl"
    $m_service MapMessage "UPDATE_TEXT_CONTROL" $self "UpdateTextControl"
    $m_service MapMessage "UPDATE_FONT_CONTROL" $self "UpdateFontControl"
    $m_service MapMessage "UPDATE_POINT_SIZE_CONTROL" $self "UpdatePointSizeControl"
    $m_service MapMessage "UPDATE_XPOS_CONTROL" $self "UpdateXposControl"
    $m_service MapMessage "UPDATE_YPOS_CONTROL" $self "UpdateYposControl"
    $m_service MapMessage "UPDATE_TEXT_COLOR_CONTROL" $self "UpdateTextColorControl"
    $m_service MapMessage "UPDATE_BACK_COLOR_CONTROL" $self "UpdateBackColorControl"
    $m_service MapMessage "UPDATE_MASTER_ALPHA_CONTROL" $self "UpdateMasterAlphaControl"
    $m_service MapMessage "UPDATE_BACK_ALPHA_CONTROL" $self "UpdateBackAlphaControl"
    $m_service MapMessage "UPDATE_FACTOR_CONTROL" $self "UpdateFactorControl"
    $m_service MapMessage "CLOSE_LINK" $self "CloseService"

}


##############################################################################
#
# CSpecialFxProxyApplication private UpdateI1Control { service arguments }
#
# Input:
# service - the service that called this function
# arguments - the value that i1 needs to be updated to
#
# Output:
# none
#
# Description:
#
##############################################################################
CSpecialFxProxyApplication private UpdateI1Control { service arguments } {
    $self instvar m_specialfx_cntrl
    $self instvar m_inetClientAddr
    $self instvar m_iClientPort

    set $__source [lindex $arguments 0]
    set $__source1 "$m_inetClientAddr/$m_iClientPort/$__source"
    puts "source1 is $__source1"

    fx_set_input_spec $m_specialfx_cntrl i1 $__source1

}


##############################################################################
#
# CSpecialFxProxyApplication private UpdateI2Control { service arguments }
#
# Input:
# service - the service that called this function
# arguments - the value that i2 needs to be updated to
#
# Output:
# none
#
# Description:
#
##############################################################################
CSpecialFxProxyApplication private UpdateI2Control { service arguments } {
    $self instvar m_specialfx_cntrl
    $self instvar m_inetClientAddr
    $self instvar m_iClientPort

    set __source [lindex $arguments 0]
    set __source2 "$m_inetClientAddr/$m_iClientPort/$__source"
    puts "source2 is $__source2"

    fx_set_input_spec $m_specialfx_cntrl i2 $__source2

}


##############################################################################
#
# CSpecialFxProxyApplication private UpdateLatencyControl { service arguments }
#
# Input:
# service - the service that called this function
# arguments - the value that latency needs to be updated to
#
# Output:
# none
#
# Description:
#
##############################################################################
CSpecialFxProxyApplication private UpdateLatencyControl { service arguments } {
    $self instvar m_specialfx_cntrl

    set __value [lindex $arguments 0]
    puts "latency is $__value"

    fx_set_parameter_value $m_specialfx_cntrl latency $__value

}


##############################################################################
#
# CSpecialFxProxyApplication private UpdateTextControl { service arguments }
#
# Input:
# service - the service that called this function
# arguments - the value that text needs to be updated to
#
# Output:
# none
#
# Description:
#
##############################################################################
CSpecialFxProxyApplication private UpdateTextControl { service arguments } {
    $self instvar m_specialfx_cntrl

    set __value $arguments
    puts "text is $__value"

    fx_set_parameter_value $m_specialfx_cntrl text $__value

}


##############################################################################
#
# CSpecialFxProxyApplication private UpdateFontControl { service arguments }
#
# Input:
# service - the service that called this function
# arguments - the value that font needs to be updated to
#
# Output:
# none
#
# Description:
#
##############################################################################
CSpecialFxProxyApplication private UpdateFontControl { service arguments } {
    $self instvar m_specialfx_cntrl

    set __value [lindex $arguments 0]
    puts "font is $__value"

    fx_set_parameter_value $m_specialfx_cntrl font $__value

}


##############################################################################
#
# CSpecialFxProxyApplication private UpdatePointSizeControl { service arguments }
#
# Input:
# service - the service that called this function
# arguments - the value that latency needs to be updated to
#
# Output:
# none
#
# Description:
#
##############################################################################
CSpecialFxProxyApplication private UpdatePointSizeControl { service arguments } {
    $self instvar m_specialfx_cntrl

    set __value [lindex $arguments 0]
    puts "point_size is $__value"

    fx_set_parameter_value $m_specialfx_cntrl point_size $__value

}


##############################################################################
#
# CSpecialFxProxyApplication private UpdateXposControl { service arguments }
#
# Input:
# service - the service that called this function
# arguments - the value that xpos needs to be updated to
#
# Output:
# none
#
# Description:
#
##############################################################################
CSpecialFxProxyApplication private UpdateXposControl { service arguments } {
    $self instvar m_specialfx_cntrl

    set __value [lindex $arguments 0]
    puts "xpos is $__value"

    fx_set_parameter_value $m_specialfx_cntrl xpos $__value

}



##############################################################################
#
# CSpecialFxProxyApplication private UpdateYposControl { service arguments }
#
# Input:
# service - the service that called this function
# arguments - the value that ypos needs to be updated to
#
# Output:
# none
#
# Description:
#
##############################################################################
CSpecialFxProxyApplication private UpdateYposControl { service arguments } {
    $self instvar m_specialfx_cntrl

    set __value [lindex $arguments 0]
    puts "ypos is $__value"

    fx_set_parameter_value $m_specialfx_cntrl ypos $__value

}


##############################################################################
#
# CSpecialFxProxyApplication private UpdateTextColorControl { service arguments }
#
# Input:
# service - the service that called this function
# arguments - the value that text_color needs to be updated to
#
# Output:
# none
#
# Description:
#
##############################################################################
CSpecialFxProxyApplication private UpdateTextColorControl { service arguments } {
    $self instvar m_specialfx_cntrl

    set __valuer [lindex $arguments 0]
    set __valueg [lindex $arguments 1]
    set __valueb [lindex $arguments 2]

    set __valuey [expr int((.257 * $__valuer) + (.504 * $__valueg) + (.098 * $__valueb) + 16 )]
    if {$__valuey < 0} {
       set __valuey 0
    }
    if {$__valuey > 255} {
       set __valuey 255
    }
    set __valueu [expr int((.439 * $__valuer) - (.368 * $__valueg) - (.071 * $__valueb) + 128)]
    if {$__valueu < 0} {
       set __valueu 0
    }
    if {$__valueu > 255} {
       set __valueu 255
    }
    set __valuev [expr int((-.148 * $__valuer) - (.291 * $__valueg) + (.439 * $__valueb) + 128)]
    if {$__valuev < 0} {
       set __valuev 0
    }
    if {$__valuev > 255} {
       set __valuev 255
    }

    set __value "$__valuey $__valueu $__valuev"
    puts "text_color is $__value"

    fx_set_parameter_value $m_specialfx_cntrl text_color $__value

}



##############################################################################
#
# CSpecialFxProxyApplication private UpdateBackColorControl { service arguments }
#
# Input:
# service - the service that called this function
# arguments - the value that back_color needs to be updated to
#
# Output:
# none
#
# Description:
#
##############################################################################
CSpecialFxProxyApplication private UpdateBackColorControl { service arguments } {
    $self instvar m_specialfx_cntrl

    set __valuer [lindex $arguments 0]
    set __valueg [lindex $arguments 1]
    set __valueb [lindex $arguments 2]

    set __valuey [expr int((.257 * $__valuer) + (.504 * $__valueg) + (.098 * $__valueb) + 16 )]
    if {$__valuey < 0} {
       set __valuey 0
    }
    if {$__valuey > 255} {
       set __valuey 255
    }
    set __valueu [expr int((.439 * $__valuer) - (.368 * $__valueg) - (.071 * $__valueb) + 128)]
    if {$__valueu < 0} {
       set __valueu 0
    }
    if {$__valueu > 255} {
       set __valueu 255
    }
    set __valuev [expr int((-.148 * $__valuer) - (.291 * $__valueg) + (.439 * $__valueb) + 128)]
    if {$__valuev < 0} {
       set __valuev 0
    }
    if {$__valuev > 255} {
       set __valuev 255
    }

    set __value "$__valuey $__valueu $__valuev"
    puts "back_color is $__value"

    fx_set_parameter_value $m_specialfx_cntrl back_color $__value

}


##############################################################################
#
# CSpecialFxProxyApplication private UpdateMasterAlphaControl { service arguments }
#
# Input:
# service - the service that called this function
# arguments - the value that master_alpha needs to be updated to
#
# Output:
# none
#
# Description:
#
##############################################################################
CSpecialFxProxyApplication private UpdateMasterAlphaControl { service arguments } {
    $self instvar m_specialfx_cntrl

    set __value [lindex $arguments 0]
    puts "master_alpha is $__value"

    fx_set_parameter_value $m_specialfx_cntrl master_alpha $__value

}


##############################################################################
#
# CSpecialFxProxyApplication private UpdateBackAlphaControl { service arguments }
#
# Input:
# service - the service that called this function
# arguments - the value that back_alpha needs to be updated to
#
# Output:
# none
#
# Description:
#
##############################################################################
CSpecialFxProxyApplication private UpdateBackAlphaControl { service arguments } {
    $self instvar m_specialfx_cntrl

    set __value [lindex $arguments 0]
    puts "back_alpha is $__value"

    fx_set_parameter_value $m_specialfx_cntrl back_alpha $__value

}


##############################################################################
#
# CSpecialFxProxyApplication private UpdateFactorControl { service arguments }
#
# Input:
# service - the service that called this function
# arguments - the value that factor needs to be updated to
#
# Output:
# none
#
# Description:
#
##############################################################################
CSpecialFxProxyApplication private UpdateFactorControl { service arguments } {
    $self instvar m_specialfx_cntrl

    set __value [lindex $arguments 0]
    puts "factor is $__value"

    fx_set_parameter_value $m_specialfx_cntrl factor $__value

}


##############################################################################
#
# CSpecialFxProxyApplication public CloseService { service arguments } {
#
# Input:
# service - the service that called this function
# arguments - the arguments associated with this call
#
# Output:
# none
#
# Description:
# This is called by the remote service client closes the service link.
#
##############################################################################
CSpecialFxProxyApplication public CloseService { service arguments } {
    exit
}

